/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.SS;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.VoxWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CountryPathFinder {
    private Map distanceMapLand = new HashMap();
    private Map distanceMapAir = new HashMap();

    public static boolean canUnitReachLand(UnitStack us, Country from, Country to) {
        ArrayList<Country> seenCountries = new ArrayList<Country>();
        seenCountries.add(from);
        int distanceSoFar = 1;
        ArrayList<Country> expandOn = new ArrayList<Country>();
        expandOn.add(from);
        ArrayList<Country> expandOnNextSet = new ArrayList<Country>();
        while (distanceSoFar <= us.getUnit().getMovement()) {
            Country next;
            if (expandOn.size() == 0) {
                if (expandOnNextSet.size() == 0) {
                    return false;
                }
                ++distanceSoFar;
                expandOn = expandOnNextSet;
                expandOnNextSet = new ArrayList();
            }
            if (!(next = (Country)expandOn.remove(0)).isEmpty() && !next.getTeam().equals(us.getTeam())) continue;
            List adjoining = next.getAdjoiningList();
            for (int i = 0; i < adjoining.size(); ++i) {
                Country check = (Country)adjoining.get(i);
                if (seenCountries.contains(check)) continue;
                if (check.equals(to)) {
                    return distanceSoFar <= us.getUnit().getMovement();
                }
                seenCountries.add(check);
                expandOnNextSet.add(check);
            }
        }
        return false;
    }

    public static int distanceToEnemy(Country from) {
        ArrayList<Country> seenCountries = new ArrayList<Country>();
        seenCountries.add(from);
        int distanceSoFar = 0;
        ArrayList<Country> expandOn = new ArrayList<Country>();
        expandOn.add(from);
        ArrayList<Country> expandOnNextSet = new ArrayList<Country>();
        while (true) {
            Country next = (Country)expandOn.remove(0);
            List adjoining = next.getAdjoiningList();
            for (int i = 0; i < adjoining.size(); ++i) {
                Country check = (Country)adjoining.get(i);
                if (seenCountries.contains(check)) continue;
                if (!check.getTeam().equals(from.getTeam())) {
                    return distanceSoFar + 1;
                }
                seenCountries.add(check);
                expandOnNextSet.add(check);
            }
            if (expandOn.size() != 0) continue;
            if (expandOnNextSet.size() == 0) {
                SS.debug("Failed to find any path for distanceToEnemy(" + from);
                return 1000000;
            }
            ++distanceSoFar;
            expandOn = expandOnNextSet;
            expandOnNextSet = new ArrayList();
        }
    }

    public static Country getMostValuableEnemyBorder(Country from, int range, VoxWorld world) {
        float choiceValue = -1000.0f;
        Country choiceBorder = null;
        ArrayList<Country> seenCountries = new ArrayList<Country>();
        seenCountries.add(from);
        int distanceSoFar = 1;
        ArrayList<Country> expandOn = new ArrayList<Country>();
        expandOn.add(from);
        ArrayList<Country> expandOnNextSet = new ArrayList<Country>();
        while (true) {
            Country next = (Country)expandOn.remove(0);
            List adjoining = next.getAdjoiningList();
            for (int i = 0; i < adjoining.size(); ++i) {
                Country check = (Country)adjoining.get(i);
                if (seenCountries.contains(check)) continue;
                seenCountries.add(check);
                if (!check.getTeam().equals(from.getTeam()) && ((float)check.getBonus() + check.getContinentBonusPartial(world) > choiceValue || (float)check.getBonus() + check.getContinentBonusPartial(world) == choiceValue && SS.rand.nextInt(2) == 1)) {
                    choiceValue = (float)check.getBonus() + check.getContinentBonusPartial(world);
                    choiceBorder = check;
                }
                if (!check.isEmpty() && !check.getTeam().equals(from.getTeam())) continue;
                expandOnNextSet.add(check);
            }
            if (expandOn.size() != 0) continue;
            if (expandOnNextSet.size() == 0) {
                SS.debug("Failed to find any path for distanceToEnemy(" + from);
                return null;
            }
            if (++distanceSoFar > range) {
                return choiceBorder;
            }
            expandOn = expandOnNextSet;
            expandOnNextSet = new ArrayList();
        }
    }

    public int distanceBetweenLand(Country from, Country to) {
        Integer savedDist = (Integer)this.distanceMapLand.get(from.getID() + "-" + to.getID());
        if (savedDist == null) {
            savedDist = new Integer(this.calculateDistanceBetweenLand(from, to));
            this.distanceMapLand.put(from.getID() + "-" + to.getID(), savedDist);
        }
        return savedDist;
    }

    private int calculateDistanceBetweenLand(Country from, Country to) {
        ArrayList<Country> seenCountries = new ArrayList<Country>();
        seenCountries.add(from);
        int distanceSoFar = 1;
        ArrayList<Country> expandOn = new ArrayList<Country>();
        expandOn.add(from);
        ArrayList<Country> expandOnNextSet = new ArrayList<Country>();
        block0: while (true) {
            if (expandOn.size() == 0) {
                if (expandOnNextSet.size() == 0) {
                    return 1000000;
                }
                ++distanceSoFar;
                expandOn = expandOnNextSet;
                expandOnNextSet = new ArrayList();
            }
            Country next = (Country)expandOn.remove(0);
            List adjoining = next.getAdjoiningList();
            int i = 0;
            while (true) {
                if (i >= adjoining.size()) continue block0;
                Country check = (Country)adjoining.get(i);
                if (!seenCountries.contains(check)) {
                    if (check.equals(to)) {
                        return distanceSoFar;
                    }
                    seenCountries.add(check);
                    expandOnNextSet.add(check);
                }
                ++i;
            }
            break;
        }
    }
}

