/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.ArrayTool;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.RangeIterator;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.XMLSerializable;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.IDable;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitPack;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.vox.VoxWorld;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;

public class Country
implements XMLSerializable,
IDable {
    private int ID;
    private String name;
    private int bonus;
    private int continentID;
    private List adjoiningCountries = new Vector();
    private UnitStackGroup unitStacks = new UnitStackGroup();
    private List usedArea;
    private Player owner;
    private boolean isWater = false;
    public boolean flashing;
    private GeneralPath shape;
    private Point center;
    private Point labelLocation;
    private List voxPoints;
    private String initialAdjoiningListString;
    private GeneralPath shapeOriginal;
    private Point labelLocationOriginal;
    private List voxPointsOriginal;

    public String toStringXML() {
        StringBuffer voxPointsString = new StringBuffer();
        for (int i = 0; i < this.voxPoints.size(); ++i) {
            Point vp = (Point)this.voxPoints.get(i);
            voxPointsString.append(vp.x);
            voxPointsString.append(",");
            voxPointsString.append(vp.y);
            if (i + 1 >= this.voxPoints.size()) continue;
            voxPointsString.append(" ");
        }
        StringBuffer adjoiningString = new StringBuffer();
        for (int i = 0; i < this.adjoiningCountries.size(); ++i) {
            Country vp = (Country)this.adjoiningCountries.get(i);
            adjoiningString.append(vp.getID());
            if (i + 1 >= this.adjoiningCountries.size()) continue;
            adjoiningString.append(",");
        }
        return "<country id=\"" + this.ID + "\" name=\"" + this.name + "\" bonus=\"" + this.bonus + "\" labelLocation=\"" + GraphicsTool.stringFromPoint(this.labelLocation) + "\" owner=\"" + this.owner.getID() + "\" shape=\"" + GraphicsTool.stringFromGeneralPath(this.shape) + "\" voxPoints=\"" + voxPointsString + "\" adjoiningIDs=\"" + adjoiningString + "\" continentID=\"" + this.continentID + "\" >" + this.unitStacks.toStringXML() + "</country>";
    }

    public Country(String XML, VoxClient master) {
        try {
            this.isWater = Boolean.parseBoolean(XMLTool.extractAttribute("isWater", XML));
            this.ID = Integer.parseInt(XMLTool.extractAttribute("id", XML));
            this.bonus = Integer.parseInt(XMLTool.extractAttribute("bonus", XML));
            this.continentID = Integer.parseInt(XMLTool.extractAttribute("continentID", XML));
            this.owner = master.getPlayer(Integer.parseInt(XMLTool.extractAttribute("owner", XML)));
            this.name = XMLTool.extractAttribute("name", XML);
            if ("null".equals(this.name)) {
                this.name = "";
            }
            this.setLabelLocation(XMLTool.extractAttribute("labelLocation", XML));
            ArrayList<UnitStack> list = new ArrayList<UnitStack>();
            String item = XMLTool.extract("vunits", XML);
            int h = 1;
            while (item != null) {
                UnitStack object = new UnitStack(item, master);
                list.add(object);
                item = XMLTool.extract("vunits", XML, h);
                ++h;
            }
            this.unitStacks = new UnitStackGroup(list);
            this.setVoxPoints(XMLTool.extractAttribute("voxPoints", XML));
            this.setShape(GraphicsTool.generalPathFromString(XMLTool.extractAttribute("shape", XML)));
            this.setAdjoiningList(XMLTool.extractAttribute("adjoiningIDs", XML));
        }
        catch (Exception e) {
            SS.debug("Error creating country from XML: " + XML);
            e.printStackTrace();
        }
    }

    public Country() {
    }

    public Country(Attributes att) {
        String bonusString = att.getValue("bonus");
        this.isWater = Boolean.valueOf(att.getValue("water"));
        try {
            this.ID = att.getValue("id") != null ? Integer.parseInt(att.getValue("id")) : -1;
            this.bonus = this.isWater ? 0 : (bonusString == null ? 0 : Integer.parseInt(bonusString));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Country ID '" + att.getValue("id") + "' or bonus value '" + bonusString + "' is not an integer.");
        }
    }

    public Rectangle getBounds() {
        return this.shape.getBounds();
    }

    public void setID(String ID) {
        try {
            this.ID = Integer.parseInt(ID);
        }
        catch (Exception e) {
            throw new RuntimeException(this + " Bad country ID '" + ID + "' is not an integer.");
        }
    }

    protected void setContinentID(int ID) {
        this.continentID = ID;
    }

    public int getContinentID() {
        return this.continentID;
    }

    public Point getCenter() {
        return this.center;
    }

    protected void setWater(boolean w) {
        this.isWater = w;
        if (this.isWater) {
            this.bonus = 0;
        }
    }

    protected void setVoxPoints(String pointString) {
        if (pointString != null) {
            StringTokenizer tok = new StringTokenizer(pointString, " ,");
            while (tok.hasMoreTokens()) {
                this.addVoxPoint(tok.nextToken(), tok.nextToken());
            }
        }
    }

    protected void addVoxPoint(String x, String y) {
        try {
            this.addVoxPoint(Integer.parseInt(x), Integer.parseInt(y));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addVoxPoint(int x, int y) {
        if (this.voxPoints == null) {
            this.voxPoints = new ArrayList();
        }
        this.voxPoints.add(new Point(x, y));
    }

    protected void setBonus(String b) {
        try {
            this.bonus = Integer.parseInt(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isWater() {
        return this.isWater;
    }

    public int getID() {
        return this.ID;
    }

    protected void setShape(GeneralPath shape) {
        this.shape = shape;
        this.center = GraphicsTool.getCenterOfGeneralPath(shape);
        this.setupDrawArea();
    }

    protected void addPolygon(String polygonXML, int height) {
        if (this.shape != null) {
            SS.debug("Countries can only handle one polygon right now. XXXX height=" + height);
            return;
        }
        this.shape = GraphicsTool.flipY(GraphicsTool.getGeneralPathFromXML(polygonXML), height);
        this.center = GraphicsTool.getCenterOfGeneralPath(this.shape);
        this.setupDrawArea();
    }

    protected void setOwner(Player newOwner) {
        if (newOwner == null) {
            SS.debug("Ignore setting country owner to null (from 0 units remaining battle probably)");
            return;
        }
        this.owner = newOwner;
    }

    public Player getOwner() {
        if (this.isWater) {
            return Player.WATER;
        }
        if (this.owner == null) {
            SS.debug("XXXX null owner in " + this);
            throw new RuntimeException("null owner in " + this);
        }
        return this.owner;
    }

    public Team getTeam() {
        if (!this.isWater()) {
            return this.owner.getTeam();
        }
        if (this.unitStacks.size() > 0) {
            return this.unitStacks.getDominantOwner().getTeam();
        }
        return Player.WATER.getTeam();
    }

    public boolean isEmpty() {
        return this.unitStacks.getTotalUnitCount() == 0;
    }

    protected void addAdjoining(Country other) {
        if (!this.adjoiningCountries.contains(other) && other != this) {
            this.adjoiningCountries.add(other);
        }
    }

    public List getAdjoiningList() {
        return this.adjoiningCountries;
    }

    protected void setAdjoiningList(String adlist) {
        this.initialAdjoiningListString = adlist;
    }

    protected void resolveAdjoiningList(List countries) {
        StringTokenizer tok = new StringTokenizer(this.initialAdjoiningListString, ",");
        int[] ids = new int[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            ids[i] = Integer.parseInt(tok.nextToken());
            ++i;
        }
        for (i = 0; i < countries.size(); ++i) {
            Country c = (Country)countries.get(i);
            if (!ArrayTool.arrayContains(ids, c.ID)) continue;
            this.addAdjoining(c);
        }
    }

    public boolean contains(Point p) {
        return this.shape.contains(p);
    }

    public int getUnitCosts(int ownerID) {
        int costs = 0;
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            if (group.getOwner().getID() != ownerID) continue;
            costs += group.getCount() * group.getUnit().getCost();
        }
        return costs;
    }

    public UnitStack getUnitStackAtPoint(Point p) {
        return this.getUnitStackAtPoint(p, null);
    }

    public UnitStack getUnitStackAtPoint(Point p, Player owner) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            if (owner != null && !group.getOwner().equals(owner) || !new Rectangle(group.getDrawPoint(), group.getDimension()).contains(p)) continue;
            return group;
        }
        return null;
    }

    public UnitStack getUnitStackMatching(UnitStack matcher) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            if (!matcher.equalsIgnoringOriginalCountry(group)) continue;
            return group;
        }
        throw new IllegalArgumentException(this + " with units " + this.unitStacks + " getUnitStackMatching(" + matcher + ") found nothing");
    }

    protected void addUnits(Unit unit, int numberOfUnits) {
        UnitStack newGroup = new UnitStack(unit, numberOfUnits);
        this.unitStacks.add(newGroup);
        if (this.shape != null) {
            this.setupDrawArea();
        }
    }

    protected void unloadAirTransports() {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack us = this.unitStacks.get(i);
            if (!us.isAir() || us.getCarriedUnitCount() <= 0) continue;
            UnitStackGroup carried = us.getCarriedUnits();
            us.removeCarry();
            this.addUnitStack(carried);
        }
    }

    public void addUnitStack(UnitStack units) {
        this.unitStacks.add(units);
        this.setupDrawArea();
    }

    public void addUnitStack(UnitStackGroup unitgroup) {
        this.unitStacks.add(unitgroup);
        this.setupDrawArea();
    }

    protected void removeUnits(UnitStackGroup units) {
        for (int i = 0; i < units.size(); ++i) {
            this.removeUnits(units.get(i));
        }
    }

    public UnitStack removeUnits(UnitStack group) {
        int c;
        UnitStackGroup ugs;
        int j;
        for (j = 0; j < this.unitStacks.size(); ++j) {
            if (!group.equalsIgnoringOriginalCountry(this.unitStacks.get(j))) continue;
            UnitStack matched = this.unitStacks.get(j);
            UnitStack result = matched.splitOffGroup(group.getCount());
            if (matched.getCount() == 0) {
                this.unitStacks.remove(matched);
            }
            return result;
        }
        for (j = 0; j < this.unitStacks.size(); ++j) {
            if (this.unitStacks.get(j).getCarriedUnitCountAir() <= 0) continue;
            ugs = this.unitStacks.get(j).getCarriedUnitsAir();
            for (c = 0; c < ugs.size(); ++c) {
                if (!group.equalsIgnoringOriginalCountry(ugs.get(c))) continue;
                UnitStack matched = ugs.get(c);
                UnitStack result = matched.splitOffGroup(group.getCount());
                if (matched.getCount() == 0) {
                    ugs.remove(matched);
                }
                return result;
            }
        }
        for (j = 0; j < this.unitStacks.size(); ++j) {
            if (this.unitStacks.get(j).getCarriedUnitCountMissiles() <= 0) continue;
            ugs = this.unitStacks.get(j).getCarriedUnitsMissiles();
            for (c = 0; c < ugs.size(); ++c) {
                if (!group.equalsIgnoringOriginalCountry(ugs.get(c))) continue;
                UnitStack matched = ugs.get(c);
                UnitStack result = matched.splitOffGroup(group.getCount());
                if (matched.getCount() == 0) {
                    ugs.remove(matched);
                }
                return result;
            }
        }
        throw new RuntimeException(this + " removeUnits(" + group + ") did not find a matching group to remove from. Contains units: " + this.unitStacks);
    }

    protected UnitStack removeUnitsFromGroup(UnitStack ug, int numberToRemove) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            if (!ug.equalsIgnoringOriginalCountry(this.unitStacks.get(i))) continue;
            UnitStack group = this.unitStacks.get(i);
            UnitStack removedGroup = group.splitOffGroup(numberToRemove);
            if (group.getCount() == 0) {
                this.unitStacks.remove(group);
            }
            return removedGroup;
        }
        throw new RuntimeException(this + " removeUnitsFromGroup did not find a group to remove from");
    }

    public void drawCountry(Graphics2D g) {
        if (this.isWater) {
            g.setColor(Color.CYAN);
            g.fill(this.shape);
        } else {
            g.setColor(this.owner.getColor());
        }
        g.draw(this.shape);
    }

    public void drawUnitsExcept(Graphics2D g, UnitStack notDrawUnits, String theme) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            if (group.equals(notDrawUnits)) continue;
            group.draw(g, theme);
        }
    }

    public void drawUnits(Graphics2D g, String theme) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            group.draw(g, theme);
        }
    }

    public void drawMovingUnitsExcept(Graphics2D g, UnitStack notDrawUnits, String theme) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            if (group.equals(notDrawUnits) || group.getUnit().isCastle()) continue;
            group.draw(g, theme);
        }
    }

    public void drawMovingUnits(Graphics2D g, String theme) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            if (group.getUnit().isCastle()) continue;
            group.draw(g, theme);
        }
    }

    public void drawUnitBubblesExcept(Graphics2D g, UnitStack notDrawUnits, String theme) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            if (group.equals(notDrawUnits) || group.getUnit().isCastle()) continue;
            group.drawBubbleNumber(g);
        }
    }

    public void drawUnitBubbles(Graphics2D g, String theme) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            if (group.getUnit().isCastle()) continue;
            group.drawBubbleNumber(g);
        }
    }

    public void drawCastles(Graphics2D g, String theme) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            if (!group.getUnit().isCastle()) continue;
            group.draw(g, theme);
        }
    }

    public Point getContainedPointAlongLine(Point from, Point to) {
        double aDir = Math.atan2(to.x - from.x, to.y - from.y);
        for (int distance = 1; distance < 5000; ++distance) {
            Point checkPoint = new Point(from.x + GraphicsTool.xCor(distance, aDir), from.y + GraphicsTool.yCor(distance, aDir));
            if (!this.shape.contains(checkPoint)) continue;
            return checkPoint;
        }
        SS.debug("Country.getContainedPointAlongLine(" + from + ", " + to + ") shape=" + GraphicsTool.stringFromGeneralPath(this.shape) + " FAILED to find desired point!");
        return to;
    }

    public Point getOutsidePointAlongLine(Point from, Point to) {
        double aDir = Math.atan2(from.x - to.x, from.y - to.y);
        int distance = 1;
        Point checkPoint;
        while (this.shape.contains(checkPoint = new Point(to.x + GraphicsTool.xCor(distance, aDir), to.y + GraphicsTool.yCor(distance, aDir)))) {
            ++distance;
        }
        return checkPoint;
    }

    private Point takeOpenLocationNear(int x, int y, int width, int height) {
        Point result = this.getOpenAreaNear(x, y, width, height);
        this.usedArea.add(new Rectangle(result.x, result.y, width, height));
        return result;
    }

    private Point getOpenAreaNear(int x, int y, int width, int height) {
        int maxRange = 30;
        int overlapAllowed = 100;
        while (true) {
            if (maxRange > 60) {
                maxRange = 15;
                overlapAllowed += 50;
            }
            RangeIterator xiter = new RangeIterator(-maxRange, maxRange, 5, 5);
            RangeIterator yiter = new RangeIterator(-maxRange, maxRange, 5, 5);
            while (xiter.hasNext()) {
                int xcheck = x + (int)xiter.next();
                while (yiter.hasNext()) {
                    int ycheck = y + (int)yiter.next();
                    if (!this.canFitAreaAt(xcheck, ycheck, width, height, overlapAllowed)) continue;
                    return new Point(xcheck, ycheck);
                }
            }
            maxRange += 5;
        }
    }

    private boolean canFitAreaAt(int x, int y, int width, int height, int overlapAllowed) {
        if (x + width < 0 || y + height < 0) {
            return false;
        }
        if (overlapAllowed == 0) {
            Rectangle rect = new Rectangle(x, y, width, height);
            if (!this.shape.contains(rect)) {
                return false;
            }
            for (int i = 0; i < this.usedArea.size(); ++i) {
                if (!rect.intersects((Rectangle)this.usedArea.get(i))) continue;
                return false;
            }
            return true;
        }
        int root = (int)Math.sqrt(overlapAllowed);
        Rectangle smallerRect = new Rectangle(x + root, y + root, width - 2 * root, height - 2 * root);
        if (!this.shape.contains(smallerRect)) {
            return false;
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        for (int i = 0; i < this.usedArea.size(); ++i) {
            Rectangle intersection = rect.intersection((Rectangle)this.usedArea.get(i));
            if (Math.abs(intersection.width * intersection.height) <= overlapAllowed) continue;
            return false;
        }
        return true;
    }

    public UnitStackGroup getUnitStackGroup() {
        return this.unitStacks;
    }

    public void setupDrawArea() {
        this.usedArea = new Vector();
        if (this.voxPoints == null) {
            this.voxPoints = new ArrayList();
        }
        boolean[] usedVoxPoints = new boolean[this.voxPoints.size()];
        Point p = null;
        int offsetUsedCount1 = 1;
        int offsetUsedCount2 = 1;
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            int unitCode = this.unitStacks.get(i).getUnit().getType();
            if (!usedVoxPoints[unitCode]) {
                usedVoxPoints[unitCode] = true;
                p = (Point)this.voxPoints.get(unitCode);
            } else if (!usedVoxPoints[1] && this.unitStacks.size() < 4) {
                unitCode = 1;
                usedVoxPoints[unitCode] = true;
                p = (Point)this.voxPoints.get(unitCode);
            } else if (!usedVoxPoints[2] && this.unitStacks.size() < 4) {
                unitCode = 2;
                usedVoxPoints[unitCode] = true;
                p = (Point)this.voxPoints.get(unitCode);
            } else if (!usedVoxPoints[0] && this.unitStacks.size() < 4) {
                unitCode = 0;
                usedVoxPoints[unitCode] = true;
                p = (Point)this.voxPoints.get(unitCode);
            } else {
                int mult;
                p = (Point)this.voxPoints.get(unitCode);
                int n = mult = unitCode == 1 ? offsetUsedCount1 : offsetUsedCount2;
                if (unitCode == 1) {
                    ++offsetUsedCount1;
                } else {
                    ++offsetUsedCount2;
                }
                p = new Point(p.x + 20 * mult, p.y + 6 * mult);
            }
            this.unitStacks.get(i).setDrawPoint(p);
        }
    }

    public void pushToBack(UnitStack ug) {
        this.unitStacks.pushToBack(ug);
    }

    public void pushToFront(UnitStack ug) {
        this.unitStacks.pushToFront(ug);
    }

    public String toString() {
        return "<Country " + this.ID + ": " + this.name + ">";
    }

    public String toStringWithUnits() {
        StringBuffer buf = new StringBuffer("<Country " + this.ID + ": " + this.name + " with units: ");
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            buf.append(this.unitStacks.get(i));
            buf.append(", ");
        }
        buf.append("> ");
        return buf.toString();
    }

    public boolean hasFort() {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            if (!this.unitStacks.get(i).getUnit().isFort()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCastle() {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            if (!this.unitStacks.get(i).getUnit().isCastle()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCastle(Player owner) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            if (!this.unitStacks.get(i).getUnit().isCastle() || !this.unitStacks.get(i).getOwner().equals(owner)) continue;
            return true;
        }
        return false;
    }

    public UnitStack getCastle() {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            if (!this.unitStacks.get(i).getUnit().isCastle()) continue;
            return this.unitStacks.get(i);
        }
        return null;
    }

    protected void setName(String name) {
        this.name = null == name || "null".equals(name) ? "" : name;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public int getBonus() {
        return this.bonus;
    }

    public float getContinentBonusPartial(VoxWorld world) {
        return 1.0f / (float)world.getContinentSize(this.continentID) * (float)world.getContinent(this.continentID).getBonus();
    }

    public GeneralPath getShape() {
        return this.shape;
    }

    protected void setNewUnits(UnitStackGroup ugl) {
        ugl.consolidateUnits();
        ugl.orderUnits();
        this.unitStacks = ugl;
        this.unitStacks.setOriginalCountry(null);
        this.setupDrawArea();
    }

    protected void setUnitOriginalCountries() {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            this.unitStacks.get(i).setOriginalCountry(this);
        }
    }

    protected void replacePlayerUnitTypes(Player p, String oldType, String newType) {
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack us = this.unitStacks.get(i);
            if (!us.getOwner().equals(p) || !us.getUnit().getShortString().equalsIgnoreCase(oldType)) continue;
            this.unitStacks.remove(us);
            --i;
            UnitStack newStack = new UnitStack(UnitPack.createUnitSafe(newType, p), us.getCount(), us.getOriginalCountryID(), us.getCarriedUnits(), us.getCarriedUnitsAir(), us.getCarriedUnitsMissiles());
            this.unitStacks.add(newStack);
            this.setupDrawArea();
        }
    }

    public void consolidateUnits() {
        this.unitStacks.consolidateUnits();
    }

    public List getMatchingBorders() {
        ArrayList<Country> result = new ArrayList<Country>();
        for (int i = 0; i < this.adjoiningCountries.size(); ++i) {
            Country c = (Country)this.adjoiningCountries.get(i);
            if (c.isWater() != this.isWater()) continue;
            result.add(c);
        }
        return result;
    }

    public List getWaterBorders() {
        ArrayList<Country> result = new ArrayList<Country>();
        for (int i = 0; i < this.adjoiningCountries.size(); ++i) {
            Country c = (Country)this.adjoiningCountries.get(i);
            if (!c.isWater()) continue;
            result.add(c);
        }
        return result;
    }

    public static List getWaterBorders(List countries) {
        ArrayList<Country> result = new ArrayList<Country>();
        for (int co = 0; co < countries.size(); ++co) {
            Country lookat = (Country)countries.get(co);
            for (int i = 0; i < lookat.adjoiningCountries.size(); ++i) {
                Country c = (Country)lookat.adjoiningCountries.get(i);
                if (!c.isWater() || result.contains(c)) continue;
                result.add(c);
            }
        }
        return result;
    }

    public boolean canBuildUnits(UnitStack us) {
        return this.canBuildUnits(us, new StringBuffer());
    }

    public boolean canBuildUnits(UnitStack us, StringBuffer errorMessage) {
        if (this.isWater) {
            if (!us.getUnit().isWater()) {
                errorMessage.append("You cannot build land units on water");
                return false;
            }
            for (int i = 0; i < this.adjoiningCountries.size(); ++i) {
                Country c = (Country)this.adjoiningCountries.get(i);
                if (!c.hasCastle(us.getOwner()) || !us.getTeam().equals(c.getTeam())) continue;
                return true;
            }
            errorMessage.append("You can only build boats \noffshore of a Castle");
            return false;
        }
        if (us.getUnit().isCastle()) {
            int ownerLandUnits = 0;
            for (int i = 0; i < this.unitStacks.size(); ++i) {
                UnitStack test = this.unitStacks.get(i);
                if (!test.getOwner().equals(us.getOwner()) || test.isAir()) continue;
                ownerLandUnits += test.getCount();
            }
            if (!us.getTeam().equals(this.getTeam())) {
                errorMessage.append("You can only build a Castle \nin countries that you own");
                return false;
            }
            if (this.hasCastle()) {
                errorMessage.append("You cannot build a Castle \nin a country that already has one");
                return false;
            }
            if (ownerLandUnits < 5) {
                errorMessage.append("You need 5 units here \n to build a " + us.getUnit().getShortString() + " here");
                return false;
            }
            return true;
        }
        if (us.getUnit().isFort()) {
            int ownerLandUnits = 0;
            for (int i = 0; i < this.unitStacks.size(); ++i) {
                UnitStack test = this.unitStacks.get(i);
                if (!test.getOwner().equals(us.getOwner()) || test.isAir()) continue;
                ownerLandUnits += test.getCount();
            }
            if (!us.getTeam().equals(this.getTeam())) {
                errorMessage.append("You cannot build units \nin enemy countries");
                return false;
            }
            if (this.hasFort()) {
                errorMessage.append("You cannot build another Base \nin a country that already has one");
                return false;
            }
            if (ownerLandUnits < 5) {
                errorMessage.append("You need 5 land units in a \ncountry to build a " + us.getUnit().getShortString());
                return false;
            }
            return true;
        }
        if (!this.hasCastle(us.getOwner())) {
            errorMessage.append("You can only recruit units \nwhere you have a Castle");
            return false;
        }
        if (us.getUnit().isWater()) {
            errorMessage.append("You cannot build boats on land");
            return false;
        }
        return true;
    }

    protected Object clone() {
        try {
            Country clone = new Country();
            clone.ID = this.ID;
            clone.name = this.name;
            clone.bonus = this.bonus;
            clone.flashing = this.flashing;
            clone.continentID = this.continentID;
            clone.adjoiningCountries = new Vector();
            for (int i = 0; i < this.adjoiningCountries.size(); ++i) {
                Country c = (Country)this.adjoiningCountries.get(i);
                clone.adjoiningCountries.add(c);
            }
            clone.voxPoints = this.voxPoints;
            clone.unitStacks = (UnitStackGroup)this.unitStacks.clone();
            clone.usedArea = this.usedArea;
            clone.owner = this.owner;
            clone.isWater = this.isWater;
            clone.shape = this.shape;
            clone.center = new Point(this.center.x, this.center.y);
            clone.labelLocation = this.labelLocation;
            return clone;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Country) {
            Country c = (Country)other;
            return c.ID == this.ID && (c.name == null && this.name == null || c.name.equals(this.name));
        }
        return false;
    }

    public void setFlashing(boolean flash) {
        this.flashing = flash;
    }

    protected void setLabelLocation(String data) {
        this.labelLocation = GraphicsTool.pointFromString(data);
    }

    public Point getLabelLocation() {
        return this.labelLocation;
    }

    public void initialUnitSanityCheck() {
        this.unitStacks.orderUnits();
    }

    public void resize(double resizePercent) {
        Point vp;
        int i;
        if (this.shapeOriginal == null) {
            this.shapeOriginal = this.shape;
            this.labelLocationOriginal = new Point(this.labelLocation.x, this.labelLocation.y);
            this.voxPointsOriginal = new ArrayList(3);
            for (i = 0; i < this.voxPoints.size(); ++i) {
                vp = (Point)this.voxPoints.get(i);
                this.voxPointsOriginal.add(new Point(vp.x, vp.y));
            }
        }
        this.shape = GraphicsTool.resizeShape(this.shapeOriginal, resizePercent);
        this.center = GraphicsTool.getCenterOfGeneralPath(this.shape);
        this.labelLocation.setLocation((double)this.labelLocationOriginal.x * resizePercent, (double)this.labelLocationOriginal.y * resizePercent);
        for (i = 0; i < this.voxPoints.size(); ++i) {
            vp = (Point)this.voxPoints.get(i);
            Point vpo = (Point)this.voxPointsOriginal.get(i);
            vp.setLocation((double)vpo.x * resizePercent, (double)vpo.y * resizePercent);
        }
        this.setupDrawArea();
    }

    public String getAdjoiningListString() {
        StringBuffer adjoiningString = new StringBuffer();
        for (int i = 0; i < this.adjoiningCountries.size(); ++i) {
            Country vp = (Country)this.adjoiningCountries.get(i);
            adjoiningString.append(vp.getID());
            if (i + 1 >= this.adjoiningCountries.size()) continue;
            adjoiningString.append(",");
        }
        return adjoiningString.toString();
    }

    public String getVoxPointsString() {
        String result = "";
        for (int i = 0; i < this.voxPoints.size(); ++i) {
            Point vp = (Point)this.voxPoints.get(i);
            result = result + vp.x + "," + vp.y + " ";
        }
        return result;
    }

    public String getUnitXML() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.unitStacks.size(); ++i) {
            UnitStack group = this.unitStacks.get(i);
            result.append("\t\t<unit type=\"" + group.getUnit() + "\" owner=\"" + group.getOwner().getID() + "\" number=\"" + group.getCount() + "\" />\n");
        }
        return result.toString();
    }
}

