/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.XMLSerializable;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Team;
import java.awt.Color;
import java.awt.Point;
import java.util.List;
import org.xml.sax.Attributes;

public class Continent
implements XMLSerializable {
    private int ID;
    private String name;
    private int bonus;
    private Point labelLocation;
    private Color color;
    public boolean flashing;
    private Point labelLocationOriginal;

    public String toStringXML() {
        return "<continent id=\"" + this.ID + "\" name=\"" + this.name + "\" bonus=\"" + this.bonus + "\" color=\"" + GraphicsTool.stringFromColor(this.color) + "\" labelLocation=\"" + GraphicsTool.stringFromPoint(this.labelLocation) + "\" />";
    }

    protected Continent() {
    }

    protected Continent(Attributes att) {
        try {
            this.ID = att.getValue("id") != null ? Integer.parseInt(att.getValue("id")) : -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Continent ID '" + att.getValue("id") + "' or bonus value is not an integer.");
        }
    }

    protected Continent(String XML) {
        try {
            this.ID = Integer.parseInt(XMLTool.extractAttribute("id", XML));
            this.bonus = Integer.parseInt(XMLTool.extractAttribute("bonus", XML));
            this.name = XMLTool.extractAttribute("name", XML);
            this.labelLocation = GraphicsTool.pointFromString(XMLTool.extractAttribute("labelLocation", XML));
            this.color = GraphicsTool.colorFromString(XMLTool.extractAttribute("color", XML));
            if (this.color == null) {
                SS.debug("null color cont");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setID(int ID) {
        this.ID = ID;
    }

    protected void setID(String ID) {
        try {
            this.ID = Integer.parseInt(ID);
        }
        catch (Exception e) {
            throw new RuntimeException(this + " Bad continent ID '" + ID + "' is not an integer.");
        }
    }

    protected void setLabelLocation(String value) {
        this.labelLocation = GraphicsTool.pointFromString(value);
    }

    protected void setColor(String value) {
        this.color = GraphicsTool.colorFromString(value);
    }

    protected void setBonus(String b) {
        try {
            this.bonus = Integer.parseInt(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getID() {
        return this.ID;
    }

    public Point getLabelLocation() {
        return this.labelLocation;
    }

    public String toString() {
        return "<Continent: " + this.name + " bonus:" + this.bonus + ">";
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getBonus() {
        return this.bonus;
    }

    public Color getColor() {
        return this.color;
    }

    protected Object clone() {
        try {
            Continent clone = new Continent();
            clone.ID = this.ID;
            clone.name = this.name;
            clone.bonus = this.bonus;
            clone.flashing = this.flashing;
            return clone;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Continent) {
            Continent c = (Continent)other;
            return c.name.equals(this.name) && c.ID == this.ID;
        }
        return false;
    }

    protected void setFlashing(boolean flash) {
        this.flashing = flash;
    }

    public Team getTeamOwner(List countries) {
        Team ownerTeam = null;
        for (int i = 0; i < countries.size(); ++i) {
            Country c = (Country)countries.get(i);
            if (c.getContinentID() != this.ID) continue;
            if (ownerTeam == null) {
                ownerTeam = c.getTeam();
                continue;
            }
            if (ownerTeam.equals(c.getTeam())) continue;
            return null;
        }
        return ownerTeam;
    }

    public void resize(double resizePercent) {
        if (this.labelLocationOriginal == null) {
            if (this.labelLocation == null) {
                return;
            }
            this.labelLocationOriginal = new Point(this.labelLocation.x, this.labelLocation.y);
        }
        this.labelLocation.setLocation((double)this.labelLocationOriginal.x * resizePercent, (double)this.labelLocationOriginal.y * resizePercent);
    }
}

