/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.VoxWorld;
import java.util.List;

public class Board {
    private Country[] countries;
    private String[] contNames;
    private VoxWorld world;
    private boolean finished = false;

    public Board(VoxWorld newWorld) {
        this.world = newWorld;
    }

    public VoxWorld getWorld() {
        return this.world;
    }

    void setCountries(List newCountries) {
        if (!this.finished) {
            this.countries = new Country[newCountries.size()];
            for (int i = 0; i < this.countries.length; ++i) {
                this.countries[i] = (Country)newCountries.get(i);
            }
        }
    }

    public Team getTeam(int ID) {
        return this.world.getTeam(ID);
    }

    public void setContinentNames(String[] contNames) {
        if (!this.finished) {
            this.contNames = contNames;
        }
    }

    public void finished() {
        this.finished = true;
    }

    public Country[] getCountries() {
        Country[] dupe = new Country[this.countries.length];
        for (int i = 0; i < this.countries.length; ++i) {
            dupe[i] = this.countries[i];
        }
        return dupe;
    }

    public int getNumberOfCountries() {
        return this.countries.length;
    }

    public String getContinentName(int cont) {
        return this.contNames[cont];
    }

    public int getNumberOfPlayers() {
        return 5;
    }

    public int getPlayerIncome(int player) {
        return 10;
    }

    public String getPlayerName(int player) {
        return "foo";
    }

    public Player getPlayer(int player) {
        return this.world.getPlayer(player);
    }

    public List getCastleCountriesOwnedBy(int ID) {
        return this.world.getCastleCountriesOwnedBy(ID);
    }
}

