/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.GraphicsTool;
import java.awt.Dimension;
import java.awt.Image;

public class AnimationLoaderVox
implements Runnable {
    private static Thread loadThread;
    private static boolean doneLoading;
    private static int[] animationFrameNumber;
    private static Dimension[] animationFrameSize;
    private static Image[][] explosionFramesArrays;

    public static void loadAnimationsInBackground() {
        if (doneLoading) {
            return;
        }
        loadThread = new Thread((Runnable)new AnimationLoaderVox(), "AnimationLoaderVox");
        loadThread.start();
    }

    public void run() {
        System.out.println("AnimationLoaderVox: Starting background load");
        String[] animationNames = new String[]{"nuke", "ex1", "ex2", "ex3"};
        animationFrameNumber = new int[]{84, 27, 27, 27};
        Dimension size128 = new Dimension(128, 128);
        Dimension size240 = new Dimension(240, 240);
        animationFrameSize = new Dimension[]{size240, size128, size128, size128};
        doneLoading = true;
        System.out.println("AnimationLoaderVox: Finished background loading");
    }

    private Image[] loadAnimation(String filebase, int numberOfFrames) {
        Image[] animation = new Image[numberOfFrames];
        for (int i = 0; i < numberOfFrames; ++i) {
            animation[i] = i < 10 && numberOfFrames < 100 ? GraphicsTool.getImageFromJAR(filebase + "_0" + i + ".png") : (numberOfFrames < 100 ? GraphicsTool.getImageFromJAR(filebase + "_" + i + ".png") : (i < 10 ? GraphicsTool.getImageFromJAR(filebase + "_00" + i + ".png") : (i < 100 ? GraphicsTool.getImageFromJAR(filebase + "_0" + i + ".png") : GraphicsTool.getImageFromJAR(filebase + "_" + i + ".png"))));
        }
        return animation;
    }

    public static int[] getFrameCounts() {
        return animationFrameNumber;
    }

    public static Dimension[] getFrameDimensions() {
        return animationFrameSize;
    }

    public static Image[][] getFrameImages() {
        return explosionFramesArrays;
    }

    public static void tidy() {
        animationFrameNumber = null;
        animationFrameSize = null;
        explosionFramesArrays = null;
    }

    public static void blockTillLoaded() {
        if (loadThread == null) {
            System.out.println("AnimationLoaderVox was not pre started. Starting now");
            AnimationLoaderVox.loadAnimationsInBackground();
        }
        try {
            loadThread.join();
        }
        catch (InterruptedException ie) {
            System.out.println("AnimationLoaderVox.blockTillLoaded() was Interrupted!");
        }
    }

    static {
        doneLoading = false;
    }
}

