/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.vox.Vox;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSLinkingTextPane;
import com.sillysoft.widgets.TexturedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class Achievements {
    private SSFrame window = new SSFrame("Castle Vox " + Translator.getString("Achievements"));
    private JTextPane infoText;
    private JScrollPane scrollpane;
    JLabel rankImage;
    JLabel rankName;
    private static Achievements singleton;

    public static void show() {
        if (singleton == null) {
            singleton = new Achievements();
        }
        singleton.update();
        Achievements.singleton.window.show();
    }

    private Achievements() {
        this.window.setLocationID("achievements");
        TexturedPanel rootPane = new TexturedPanel("Vox_Interface_background.png", true, false, new BorderLayout());
        int off = 20;
        rootPane.setBorder(BorderFactory.createEmptyBorder(off, off, off, off));
        JPanel westPanel = new JPanel();
        westPanel.setOpaque(false);
        westPanel.setLayout(new BoxLayout(westPanel, 1));
        westPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        JLabel label = new JLabel(Translator.getString("RankAchieved") + ":");
        label.setOpaque(false);
        label.setFont(new Font("Verdana", 1, 18));
        label.setAlignmentX(0.5f);
        westPanel.add(label);
        this.rankName = new JLabel(this.rankName(this.rankID()));
        this.rankName.setOpaque(false);
        this.rankName.setFont(new Font("Verdana", 1, 24));
        this.rankName.setAlignmentX(0.5f);
        westPanel.add(this.rankName);
        this.rankImage = new JLabel();
        this.rankImage.setOpaque(false);
        this.rankImage.setIcon(new ImageIcon(GraphicsTool.getImageFromJAR("rank0.png")));
        this.rankImage.setHorizontalAlignment(0);
        this.rankImage.setAlignmentX(0.5f);
        this.rankImage.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        westPanel.add(this.rankImage);
        JPanel centerPanel = new JPanel();
        centerPanel.setOpaque(false);
        this.infoText = new SSLinkingTextPane();
        this.infoText.setOpaque(false);
        this.infoText.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.infoText.setEditable(false);
        if (!SS.isMacintosh) {
            this.infoText.setFont(GraphicsTool.getDejaFontSized(12));
        }
        this.scrollpane = new JScrollPane(this.infoText);
        this.scrollpane.setOpaque(false);
        this.scrollpane.setPreferredSize(new Dimension(440, 400));
        this.scrollpane.setMaximumSize(new Dimension(6000, 2000));
        centerPanel.add(this.scrollpane);
        rootPane.add((Component)westPanel, "West");
        rootPane.add((Component)centerPanel, "Center");
        this.window.setContentPane(rootPane);
        this.window.setResizable(false);
        this.window.setJMenuBar(SSApp.getInstance().makeCommonMenuBar(this.window));
        this.window.pack();
    }

    protected void update() {
        Preferences astats = Vox.getStatsPrefs();
        String display = Translator.getString("GamesStarted") + ": " + astats.getInt("gamesPlayed", 0);
        display = display + "\n" + Translator.getString("GamesWon") + ": " + astats.getInt("gamesWon", 0);
        if (astats.getInt("gamesWon", 0) > 0) {
            display = display + "\n\n" + Translator.getString("FastestWin") + ": " + astats.getInt("fastestWin", 0) + " rounds (" + astats.get("fastestWinDetails", "") + ")";
            display = display + "\n" + Translator.getString("LongestWin") + ": " + astats.getInt("slowestWin", 0) + " rounds (" + astats.get("slowestWinDetails", "") + ")";
            display = display + "\n\n" + Translator.getString("Mapsyouhavewon") + ": " + Achievements.beatenMapCount(1) + "\n" + Translator.getString("Playerswonwith") + ": " + Achievements.beatenPositionCount(1);
            if (Achievements.beatenAllPositionCount(1) > 0) {
                display = display + "\n" + Translator.getString("mapsdominated") + ": " + Achievements.beatenAllPositionCount(1);
            }
            display = display + "\n\n" + Translator.getString("MediumDifficulty") + ":";
            display = display + "\n" + Translator.getString("Mapsyouhavewon") + ": " + Achievements.beatenMapCount(2) + "\n" + Translator.getString("Playerswonwith") + ": " + Achievements.beatenPositionCount(2);
            if (Achievements.beatenAllPositionCount(2) > 0) {
                display = display + "\n" + Translator.getString("mapsdominated") + ": " + Achievements.beatenAllPositionCount(2);
            }
            display = display + "\n\n" + Translator.getString("HardDifficulty") + ":";
            display = display + "\n" + Translator.getString("Mapsyouhavewon") + ": " + Achievements.beatenMapCount(3) + "\n" + Translator.getString("Playerswonwith") + ": " + Achievements.beatenPositionCount(3);
            if (Achievements.beatenAllPositionCount(3) > 0) {
                display = display + "\n" + Translator.getString("mapsdominated") + ": " + Achievements.beatenAllPositionCount(3);
            }
            display = display + "\n\n\u265c " + Translator.getString("iconsshow") + "\n" + "\u2606" + " " + Translator.getString("starsshow") + "\n" + "\u2605" + " " + Translator.getString("starsshow2") + "\n" + "\u265c" + "\u265c" + "\u265c" + " " + Translator.getString("moreicons");
        } else {
            display = display + "\n\n" + Translator.getString("nowinsyet");
        }
        int rankID = this.rankID();
        this.infoText.setText(display);
        this.rankName.setText(this.rankName(rankID));
        this.rankImage.setIcon(new ImageIcon(GraphicsTool.getImageFromJAR("rank" + rankID + ".png")));
        this.window.pack();
    }

    public static int beatenMapCount(int diff) {
        int count = 0;
        Preferences astats = Vox.getStatsPrefs();
        try {
            String[] keys = astats.keys();
            for (int j = 0; j < keys.length; ++j) {
                int beatenDiff;
                if (!keys[j].startsWith("wonMap_") || (beatenDiff = astats.getInt(keys[j], 0)) < diff) continue;
                ++count;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static int beatenPositionCount(int diff) {
        int count = 0;
        Preferences astats = Vox.getStatsPrefs();
        try {
            String[] keys = astats.keys();
            for (int j = 0; j < keys.length; ++j) {
                int beatenDiff;
                if (!keys[j].startsWith("wonPos_") || (beatenDiff = astats.getInt(keys[j], 0)) < diff) continue;
                ++count;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public static int beatenAllPositionCount(int diff) {
        int count = 0;
        Preferences astats = Vox.getStatsPrefs();
        try {
            String[] keys = astats.keys();
            for (int j = 0; j < keys.length; ++j) {
                int beatenDiff;
                if (!keys[j].startsWith("wonAll_") || (beatenDiff = astats.getInt(keys[j], 0)) < diff) continue;
                ++count;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public int rankID() {
        int mapsWon = Achievements.beatenMapCount(1);
        if (mapsWon == 0) {
            return 0;
        }
        if (mapsWon == 1) {
            return 1;
        }
        if (mapsWon == 2) {
            return 2;
        }
        if (mapsWon == 3) {
            return 3;
        }
        mapsWon = Achievements.beatenMapCount(2);
        if (mapsWon == 0) {
            return 4;
        }
        mapsWon = Achievements.beatenMapCount(3);
        if (mapsWon == 0) {
            return 5;
        }
        if (mapsWon < 3) {
            return 6;
        }
        if (mapsWon < 6) {
            return 7;
        }
        if (mapsWon < 10) {
            return 8;
        }
        if (mapsWon < 15) {
            return 9;
        }
        if (mapsWon < 20) {
            return 10;
        }
        int mapsDominated = Achievements.beatenAllPositionCount(1);
        if (mapsDominated == 0) {
            return 11;
        }
        if (mapsDominated == 1) {
            return 12;
        }
        if (mapsDominated == 2) {
            return 13;
        }
        if (mapsDominated == 3) {
            return 14;
        }
        if (mapsDominated < 8) {
            return 15;
        }
        if (mapsDominated < 14) {
            return 16;
        }
        if (mapsDominated < 20) {
            return 17;
        }
        int mapsDominatedHard = Achievements.beatenAllPositionCount(3);
        if (mapsDominatedHard == 0) {
            return 18;
        }
        if (mapsDominatedHard == 1) {
            return 19;
        }
        if (mapsDominatedHard == 2) {
            return 20;
        }
        if (mapsDominatedHard == 3) {
            return 21;
        }
        if (mapsDominatedHard < 8) {
            return 22;
        }
        if (mapsDominatedHard < 14) {
            return 23;
        }
        if (mapsDominatedHard < 20) {
            return 24;
        }
        return 25;
    }

    public String rankName(int ID) {
        if (ID == 0) {
            return "Pawn of the Empire";
        }
        if (ID == 1) {
            return "Newb Warrior";
        }
        if (ID == 2) {
            return "Soldier of Fortune";
        }
        if (ID == 3) {
            return "Sergeant at Arms";
        }
        if (ID == 4) {
            return "Brawny Berserker";
        }
        if (ID == 5) {
            return "Spearhand of Justice";
        }
        if (ID == 6) {
            return "Beacon of Light";
        }
        if (ID == 7) {
            return "Legion Commander";
        }
        if (ID == 8) {
            return "Honor Guard";
        }
        if (ID == 9) {
            return "Epic Explorer";
        }
        if (ID == 10) {
            return "Master Cartographer";
        }
        if (ID == 11) {
            return "Conquerer of Nations";
        }
        if (ID == 12) {
            return "Knight of the Realm";
        }
        if (ID == 13) {
            return "Purse of Plenty";
        }
        if (ID == 14) {
            return "Knight of the Garter";
        }
        if (ID == 15) {
            return "Solid Gold";
        }
        if (ID == 16) {
            return "Director of Operations";
        }
        if (ID == 17) {
            return "Alchemist of Empires";
        }
        if (ID == 18) {
            return "Chancellor of War";
        }
        if (ID == 19) {
            return "Esteemed Mandarin";
        }
        if (ID == 20) {
            return "Badass Baron";
        }
        if (ID == 21) {
            return "Lord of the Manor";
        }
        if (ID == 22) {
            return "Duke of Earl";
        }
        if (ID == 23) {
            return "King of the World";
        }
        if (ID == 24) {
            return "Shadow Sorcerer";
        }
        if (ID == 25) {
            return "Emperor of the Universe";
        }
        return "Shadow";
    }
}

