/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSLinkingTextPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutWindowVox {
    private static AboutWindowVox instance = null;
    private SSFrame theFrame;
    private static float luxVersion;
    private static SSApplicationGUI luxconBridge;

    public AboutWindowVox() {
        this.initGUI();
    }

    private void initGUI() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        SSLinkingTextPane infoText = new SSLinkingTextPane();
        infoText.setForeground(Color.BLACK);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        infoText.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        if (!SS.isMacintosh) {
            infoText.setFont(SwingTool.getGlobalFont());
        }
        infoText.setEditable(false);
        infoText.setText("``vox/`Castle Vox` is a next-generation strategy game!\n\nCreated by the small and fuzzy ``/`Sillysoft Games`.\nJoin the discussions in the ``forums/`User Forums`.\nIf you need help go to our ``contact/?game=vox`Tech Support`.\n\n" + Translator.getString("Version") + " " + SSApp.version() + " " + Translator.getString("releasedon") + " " + "February 25th, 2011" + ".");
        JLabel imageLabel = new JLabel(new ImageIcon(GraphicsTool.getImageFromJAR("globe64.png")));
        imageLabel.setBackground(Color.WHITE);
        contentPanel.setBackground(Color.WHITE);
        contentPanel.add((Component)imageLabel, "West");
        contentPanel.add((Component)infoText, "East");
        this.theFrame = new SSFrame(Translator.getString("About") + " Castle Vox");
        this.theFrame.setLocationID("About");
        this.theFrame.setContentPane(contentPanel);
        this.theFrame.setDefaultCloseOperation(2);
        this.theFrame.setResizable(false);
        if (SS.isMacintosh) {
            this.theFrame.setJMenuBar(luxconBridge.makeCommonMenuBar(this.theFrame));
        }
    }

    public void showFrame() {
        this.theFrame.pack();
        this.theFrame.show();
    }

    public static void show(SSApplicationGUI luxconBridge_set) {
        luxconBridge = luxconBridge_set;
        if (instance == null) {
            instance = new AboutWindowVox();
        }
        instance.showFrame();
    }
}

