/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.SS;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipTool {
    private static String dataheader = "\u201a\u00e2\u2020\u221a\u00df,\u221a\u00d1$5\u0011QU\u201a\u00d1\u00a2\u00d4\u00a8\u00c5:\u201a\u00f3\u00e4";

    public static String ungzip(String path) throws Exception {
        int len;
        InputStream in;
        String destinationPath = null;
        try {
            in = new GZIPInputStream(new FileInputStream(path));
        }
        catch (IOException ioex) {
            SS.debug(ioex + " trying to open GZIP file. Attempting regular file read");
            in = new FileInputStream(path);
        }
        if (!path.toLowerCase().endsWith(".gz")) {
            throw new Exception("ZipTool.ungzip() called on a file not ending with .gz");
        }
        destinationPath = path.substring(0, path.length() - 3);
        destinationPath = URLDecoder.decode(destinationPath);
        FileOutputStream out = new FileOutputStream(destinationPath);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
        return destinationPath;
    }

    public static boolean writeStringToDataFile(String contents, String path) {
        try {
            FileOutputStream fout = new FileOutputStream(path);
            fout.write(dataheader.getBytes("UTF-8"));
            GZIPOutputStream gout = new GZIPOutputStream(fout);
            gout.write(contents.getBytes("UTF-8"));
            gout.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getContentsOfDataFile(String path) {
        StringBuffer contents = new StringBuffer();
        try {
            int bytesRead;
            byte[] buf = new byte[512];
            FileInputStream fin = new FileInputStream(path);
            int headerLength = dataheader.getBytes("UTF-8").length;
            fin.read(buf, 0, headerLength);
            GZIPInputStream gin = new GZIPInputStream(fin);
            while ((bytesRead = gin.read(buf, 0, 512)) > 0) {
                contents.append(new String(buf, 0, bytesRead, "UTF-8"));
            }
            gin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents.toString();
    }

    public static void unzip(String path) throws Exception {
        ZipEntry e;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
        ZipInputStream zin = new ZipInputStream(in);
        while ((e = zin.getNextEntry()) != null) {
            ZipTool.unzip(zin, e.getName());
        }
        zin.close();
    }

    public static void unzip(ZipInputStream zin, String s) throws IOException {
        System.out.println("unzipping " + s);
        FileOutputStream out = new FileOutputStream(s);
        byte[] b = new byte[512];
        int len = 0;
        while ((len = zin.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.close();
    }
}

