/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.SS;
import com.sillysoft.tools.XMLSerializable;
import java.util.List;

public class XMLTool {
    public static String extract(String key, String contents) {
        return XMLTool.extract(key, contents, 0);
    }

    public static String extract(String key, String contents, int number) {
        int fromPlace = 0;
        for (int i = 0; i < number; ++i) {
            fromPlace = contents.indexOf("<" + key + ">", fromPlace) + 1;
        }
        int start = contents.indexOf("<" + key + ">", fromPlace);
        int end = contents.indexOf("</" + key + ">", start);
        if (start == -1 || end == -1) {
            return null;
        }
        return contents.substring(start += key.length() + 2, end);
    }

    public static int count(String key, String contents) {
        int fromPlace = 0;
        int count = 0;
        do {
            fromPlace = contents.indexOf("<" + key + ">", fromPlace) + 1;
            ++count;
        } while (fromPlace != 0);
        return --count;
    }

    public static int countSolo(String key, String contents) {
        int fromPlace = 0;
        int count = 0;
        do {
            fromPlace = contents.indexOf("<" + key + " ", fromPlace) + 1;
            ++count;
        } while (fromPlace != 0);
        return --count;
    }

    public static int extractInt(String key, String contents) {
        String stringValue = XMLTool.extract(key, contents, 0);
        if (stringValue == null) {
            return 0;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String extractAttribute(String key, String contents) {
        if (contents == null) {
            throw new NullPointerException("XMLTool.extractAttribute(" + key + ") called with a null contents");
        }
        int start = contents.indexOf(" " + key + "=\"");
        if (start == -1) {
            return null;
        }
        int end = contents.indexOf("\"", start += key.length() + 3);
        if (start == -1 || end == -1) {
            return null;
        }
        return contents.substring(start, end);
    }

    public static void main(String args) {
        String test = "<CardSequence code=\"3.55\" nextValue=\"6\" counter=\"-2\" peaked=\"false\">";
        SS.debug(XMLTool.extractAttribute("code", test));
        SS.debug(XMLTool.extractAttribute("nextValue", test));
        SS.debug(XMLTool.extractAttribute("counter", test));
        SS.debug(XMLTool.extractAttribute("peaked", test));
    }

    public static String extractContained(String key, String contents, int number) {
        int fromPlace = 0;
        for (int i = 0; i < number; ++i) {
            fromPlace = contents.indexOf("<" + key + " ", fromPlace) + 1;
        }
        int start = contents.indexOf("<" + key + " ", fromPlace);
        int end = contents.indexOf("/>", start);
        if (start == -1 || end == -1) {
            return null;
        }
        return contents.substring(start, end + 2);
    }

    public static String extractFull(String key, String contents, int number) {
        int fromPlace = 0;
        for (int i = 0; i < number; ++i) {
            fromPlace = contents.indexOf("<" + key + " ", fromPlace) + 1;
        }
        int start = contents.indexOf("<" + key + " ", fromPlace);
        int end = contents.indexOf("</" + key + ">", start);
        if (start == -1 || end == -1) {
            return null;
        }
        return contents.substring(start, end + 3 + key.length());
    }

    public static String getListXML(List list, String itemName) {
        StringBuffer buf = new StringBuffer("<" + itemName + "list>");
        for (int i = 0; i < list.size(); ++i) {
            XMLSerializable ob = (XMLSerializable)list.get(i);
            buf.append("<" + itemName + ">");
            buf.append(ob.toStringXML());
            buf.append("</" + itemName + ">");
        }
        buf.append("</" + itemName + "list>");
        return buf.toString();
    }
}

