/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.ProgressListener;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URLTool {
    private static String userAgent;

    public static void setUserAgent(String newUserAgent) {
        userAgent = newUserAgent;
    }

    public static String getURL(String urlString) throws MalformedURLException, IOException {
        return URLTool.getURL(urlString, "UTF-8");
    }

    public static String getURL(String urlString, String charsetName) throws MalformedURLException, IOException {
        String input;
        if (userAgent == null) {
            throw new NullPointerException("URLTool must have it's userAgent set before being used.");
        }
        URLConnection conn = new URL(urlString).openConnection();
        conn.setRequestProperty("User-agent", userAgent);
        conn.connect();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), charsetName));
        StringBuffer contents = new StringBuffer();
        while ((input = in.readLine()) != null) {
            contents.append(input + "\n");
        }
        in.close();
        return contents.toString();
    }

    public static String downloadURLtoFile(String urlString, String folderPath) throws MalformedURLException, IOException {
        return URLTool.downloadURLtoFile(urlString, folderPath, null);
    }

    public static String downloadURLtoFile(String urlString, String folderPath, ProgressListener listener) throws MalformedURLException, IOException {
        if (userAgent == null) {
            throw new RuntimeException("URLTool must have it's userAgent set before being used.");
        }
        String filename = urlString.substring(urlString.lastIndexOf(47) + 1);
        String destinationPath = folderPath + File.separator + filename;
        URLConnection conn = new URL(urlString).openConnection();
        conn.setRequestProperty("User-agent", userAgent);
        conn.connect();
        int fileSize = conn.getContentLength();
        InputStream in = conn.getInputStream();
        FileOutputStream out = new FileOutputStream(destinationPath);
        int totalRead = 0;
        byte[] buf = new byte[65536];
        int numRead = in.read(buf);
        while (numRead > 0) {
            out.write(buf, 0, numRead);
            numRead = in.read(buf);
            totalRead += numRead;
            if (listener == null) continue;
            listener.progress(totalRead / 1024, fileSize / 1024, null);
        }
        in.close();
        out.flush();
        out.close();
        return destinationPath;
    }

    public static String postToURL(String urlstring, String postData) throws MalformedURLException, IOException {
        String input;
        if (userAgent == null) {
            throw new NullPointerException("URLTool must have it's userAgent set before being used.");
        }
        URL url = new URL(urlstring);
        URLConnection conn = url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("User-agent", userAgent);
        conn.connect();
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        out.writeBytes(postData);
        out.flush();
        out.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuffer contents = new StringBuffer();
        while ((input = in.readLine()) != null) {
            contents.append(input);
        }
        try {
            in.close();
        }
        catch (Exception e) {
            System.out.println(e + "982137");
        }
        try {
            out.close();
        }
        catch (Exception e) {
            System.out.println(e + "1928356756");
        }
        return contents.toString();
    }

    public static String postToURL(String urlstring, String postData, String charsetName) throws MalformedURLException, IOException {
        return URLTool.postToURL(urlstring, postData, charsetName, 0);
    }

    public static String postToURL(String urlstring, String postData, String charsetName, int timeout) throws MalformedURLException, IOException {
        String input;
        if (userAgent == null) {
            throw new NullPointerException("URLTool must have it's userAgent set before being used.");
        }
        URL url = new URL(urlstring);
        URLConnection conn = url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        if (timeout != 0) {
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
        }
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("User-agent", userAgent);
        conn.connect();
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        out.writeBytes(postData);
        out.flush();
        out.close();
        conn.getOutputStream().close();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), charsetName));
        StringBuffer contents = new StringBuffer();
        while ((input = in.readLine()) != null) {
            contents.append(input);
        }
        try {
            in.close();
        }
        catch (Exception e) {
            System.out.println(e + "982137");
        }
        try {
            conn.getInputStream().close();
        }
        catch (Exception e) {
            System.out.println(e + "982137222");
        }
        return contents.toString();
    }
}

