/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.widgets.SSOptionPane;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Translator {
    private static ResourceBundle messages;
    private static ResourceBundle englishMessages;
    private static Locale loadedLocale;
    private static String bundleName;
    private static String[] ignoreKeys;
    private static ResourceBundle messagesEditor;
    private static ResourceBundle englishMessagesEditor;

    public static void loadBundle(String bundleNameToLoad) {
        bundleName = bundleNameToLoad;
        Translator.setLocale(Prefs.get("locale", null));
    }

    public static void setLocale(String localeString) {
        if (localeString == null) {
            Translator.setLocale(Locale.getDefault());
            return;
        }
        int underscorePosition = localeString.indexOf(95);
        if (underscorePosition == -1) {
            Translator.setLocale(new Locale(localeString));
        } else {
            Translator.setLocale(new Locale(localeString.substring(0, underscorePosition), localeString.substring(underscorePosition + 1)));
        }
    }

    public static void setLocale(Locale locale) {
        System.out.println("Translator: Loading locale: " + locale);
        try {
            messages = Translator.getBundle(bundleName, locale);
            loadedLocale = locale;
            if (locale.equals(Locale.ENGLISH)) {
                englishMessages = messages;
            }
            try {
                Locale.setDefault(locale);
            }
            catch (Exception e) {
                System.out.println("  -> failed to set the default system locale");
            }
        }
        catch (Exception e) {
            if (locale.equals(Locale.ENGLISH)) {
                SSOptionPane.showMessageDialog("ERROR: Could not load the ResourceBundle.\n\nIf the application is being run from inside a folder with an exclamation mark (!) in its name then please move it and try again.");
                System.out.println("  -> locale failed: " + e);
                Thread.dumpStack();
                System.exit(0);
                return;
            }
            System.out.println("  -> locale failed: " + e);
            Translator.setLocale(Locale.ENGLISH);
        }
    }

    public static String getString(String key, String inLocale) {
        try {
            int underscorePosition = inLocale.indexOf(95);
            Locale desiredLocale = underscorePosition == -1 ? new Locale(inLocale) : new Locale(inLocale.substring(0, underscorePosition), inLocale.substring(underscorePosition + 1));
            ResourceBundle desiredBundle = Translator.getBundle(bundleName, desiredLocale);
            return desiredBundle.getString(key);
        }
        catch (Exception e) {
            return Translator.getString(key);
        }
    }

    public static String getString(String key) {
        return Translator.getString(key, messages);
    }

    public static String getString(String key, ResourceBundle bundle) {
        try {
            return bundle.getString(key);
        }
        catch (Exception e) {
            if ("".equals(key)) {
                return "";
            }
            if (key.endsWith(":")) {
                return Translator.getString(StringTool.stripLastChar(key), bundle) + ":";
            }
            if (key.endsWith(".")) {
                return Translator.getString(StringTool.stripLastChar(key), bundle) + ".";
            }
            try {
                float foo = Float.parseFloat(key);
                return key;
            }
            catch (Exception f) {
                for (int i = 0; i < ignoreKeys.length; ++i) {
                    if (!key.equals(ignoreKeys[i])) continue;
                    System.out.println("IgnoreKey: " + key);
                    return key;
                }
                System.out.println("Translator: no match for key: " + key);
                if (englishMessages == null) {
                    englishMessages = Translator.getBundle(bundleName, Locale.ENGLISH);
                }
                try {
                    return englishMessages.getString(key);
                }
                catch (Exception g) {
                    return key;
                }
            }
        }
    }

    public static Locale getLocale() {
        return loadedLocale;
    }

    public static String getEditorString(String key) {
        if (messagesEditor == null) {
            try {
                messagesEditor = Translator.getBundle("MapEditorBundle", Translator.getLocale());
            }
            catch (MissingResourceException e) {
                System.out.println("No translated MapEditor strings found for locale " + Translator.getLocale() + ". Will use English instead.");
                messagesEditor = Translator.getBundle("MapEditorBundle", Locale.ENGLISH);
            }
        }
        return Translator.getString(key, messagesEditor);
    }

    public static String translateTokens(String input) {
        StringBuffer result = new StringBuffer(input.length());
        int positionCount = 0;
        int nextPosition = 0;
        while (positionCount < input.length()) {
            nextPosition = input.indexOf(58, positionCount);
            int endPosition = input.indexOf(58, nextPosition + 1);
            if (nextPosition == -1 || endPosition == -1) {
                result.append(input.substring(positionCount));
                positionCount = input.length();
                continue;
            }
            int spacePosition = input.indexOf(32, nextPosition);
            if (spacePosition != -1 && spacePosition < endPosition) {
                result.append(input.substring(positionCount, nextPosition + 1));
                positionCount = nextPosition + 1;
                continue;
            }
            result.append(input.substring(positionCount, nextPosition));
            result.append(Translator.getString(input.substring(nextPosition + 1, endPosition)));
            positionCount = endPosition + 1;
        }
        return result.toString();
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale) {
        File file = new File(DesktopTool.modernResourcesLocation() + "Locales" + File.separator + bundleName + "_" + locale + ".properties");
        if (file.exists()) {
            return Translator.getBundleFromFile(file);
        }
        file = new File(DesktopTool.modernResourcesLocation() + "Locales" + File.separator + bundleName + "_" + locale.getLanguage() + ".properties");
        if (file.exists()) {
            return Translator.getBundleFromFile(file);
        }
        return ResourceBundle.getBundle(bundleName, locale);
    }

    public static ResourceBundle getBundleFromFile(File file) {
        try {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            return new PropertyResourceBundle(fis);
        }
        catch (Exception e) {
            SS.debug("Translator.getBundleFromFile(" + file + ") FAILED");
            return null;
        }
    }

    static {
        bundleName = "LuxBundle";
        ignoreKeys = new String[]{"5,5,5", "5,5,5...", "Item"};
    }
}

