/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.SS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.CaretListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class SwingTool {
    public static final int windowBorder = 10;
    public static final int WINDOW_VERTICAL_PADDING;
    public static final int WINDOW_HORIZONTAL_PADDING;
    public static final int SCROLLBAR_SIZE;
    public static final int TABLE_HEADER_HEIGHT;
    private static Font defaultFont;

    public static void destroyMenu(JMenuBar menubar) {
        if (menubar == null) {
            return;
        }
        while (menubar.getMenuCount() > 0) {
            JMenu menu = menubar.getMenu(0);
            SwingTool.destroyMenu(menu);
            menubar.remove(0);
        }
    }

    public static void destroyMenu(JMenu menu) {
        if (menu == null) {
            return;
        }
        while (menu.getItemCount() > 0) {
            JMenuItem menuItem = menu.getItem(0);
            if (menuItem != null) {
                SwingTool.removeActionListeners(menuItem);
                menuItem.setAction(null);
                if (menuItem instanceof JMenu) {
                    SwingTool.destroyMenu((JMenu)menuItem);
                }
            }
            menu.remove(0);
        }
    }

    public static void removeKeyListeners(JTextField component) {
        if (component == null) {
            return;
        }
        KeyListener[] keyListeners = component.getKeyListeners();
        for (int i = 0; i < keyListeners.length; ++i) {
            component.removeKeyListener(keyListeners[i]);
        }
    }

    public static void removeActionListeners(JTextField component) {
        if (component == null) {
            return;
        }
        ActionListener[] actionListeners = component.getActionListeners();
        for (int i = 0; i < actionListeners.length; ++i) {
            component.removeActionListener(actionListeners[i]);
        }
    }

    public static void removeActionListeners(JComboBox component) {
        if (component == null) {
            return;
        }
        ActionListener[] actionListeners = component.getActionListeners();
        for (int i = 0; i < actionListeners.length; ++i) {
            component.removeActionListener(actionListeners[i]);
        }
    }

    public static void removeActionListeners(AbstractButton component) {
        if (component == null) {
            return;
        }
        ActionListener[] actionListeners = component.getActionListeners();
        for (int i = 0; i < actionListeners.length; ++i) {
            component.removeActionListener(actionListeners[i]);
        }
    }

    public static void removeCaretListeners(JTextComponent component) {
        if (component == null) {
            return;
        }
        CaretListener[] caretListeners = component.getCaretListeners();
        for (int i = 0; i < caretListeners.length; ++i) {
            component.removeCaretListener(caretListeners[i]);
        }
    }

    public static Border getBorderForText(String text) {
        return BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(100, 112, 164)), text, 4, 0, new Font("Helvetica Neue", 1, 18), new Color(19, 23, 70)), BorderFactory.createEmptyBorder(1, 5, 3, 5));
    }

    public static Rectangle getUsableRect() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    }

    public static Dimension getUsableDimension() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().getSize();
    }

    public static Font getGlobalFont() {
        if (defaultFont == null) {
            defaultFont = SS.isMacintosh ? new Font("Lucida Grande", 0, 13) : (SS.isWindows ? new Font("SansSerif", 0, 12) : new Font("Arial", 0, 12));
        }
        return defaultFont;
    }

    public static void fixTableHeader(JTable table) {
        JTableHeader header = table.getTableHeader();
        if (header != null) {
            header.setDefaultRenderer(new CustomTableCellRenderer(header.getDefaultRenderer()));
        }
    }

    static {
        if (SS.isMacintosh) {
            SCROLLBAR_SIZE = 15;
            WINDOW_HORIZONTAL_PADDING = 0;
            WINDOW_VERTICAL_PADDING = 22;
            TABLE_HEADER_HEIGHT = 20;
        } else if (SS.isWindows) {
            SCROLLBAR_SIZE = 25;
            if (SS.isVista) {
                WINDOW_HORIZONTAL_PADDING = 16;
                WINDOW_VERTICAL_PADDING = 74;
                TABLE_HEADER_HEIGHT = 30;
            } else {
                WINDOW_HORIZONTAL_PADDING = 8;
                WINDOW_VERTICAL_PADDING = 55;
                TABLE_HEADER_HEIGHT = 23;
            }
        } else {
            SCROLLBAR_SIZE = 25;
            WINDOW_HORIZONTAL_PADDING = 16;
            WINDOW_VERTICAL_PADDING = 34;
            TABLE_HEADER_HEIGHT = 28;
        }
    }

    private static class CustomTableCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer orig;
        private final Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);

        private CustomTableCellRenderer(TableCellRenderer orig) {
            this.orig = orig;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent component = (JComponent)this.orig.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setBorder(this.border);
            return component;
        }
    }
}

