/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.StringTokenizer;

public class StringTool {
    public static int countLines(String text) {
        if (text == null) {
            return 0;
        }
        int lines = 1;
        for (int i = 0; i < text.length() && (i = text.indexOf(10, i)) != -1; ++i) {
            ++lines;
        }
        return lines;
    }

    public static String stripTrailingDots(String inputString) {
        while (inputString.endsWith(".")) {
            inputString = inputString.substring(0, inputString.length() - 1);
        }
        return inputString;
    }

    public static String stripTrailingNumbers(String inputString) {
        while (inputString.endsWith("0") || inputString.endsWith("1") || inputString.endsWith("2") || inputString.endsWith("3") || inputString.endsWith("4") || inputString.endsWith("5") || inputString.endsWith("6") || inputString.endsWith("7") || inputString.endsWith("8") || inputString.endsWith("9")) {
            inputString = inputString.substring(0, inputString.length() - 1);
        }
        return inputString;
    }

    public static int captureTrailingNumbers(String inputString) {
        String output = "";
        while (inputString.endsWith("0") || inputString.endsWith("1") || inputString.endsWith("2") || inputString.endsWith("3") || inputString.endsWith("4") || inputString.endsWith("5") || inputString.endsWith("6") || inputString.endsWith("7") || inputString.endsWith("8") || inputString.endsWith("9")) {
            output = inputString.charAt(inputString.length() - 1) + output;
            inputString = inputString.substring(0, inputString.length() - 1);
        }
        if ("".equals(output)) {
            throw new NumberFormatException("captureTrailingNumbers no trailing numbers found: " + inputString);
        }
        return Integer.parseInt(output);
    }

    public static String stripLastChar(String inputString) {
        return inputString.substring(0, inputString.length() - 1);
    }

    public static String stripLastWord(String inputString) {
        int spacePos = inputString.lastIndexOf(32);
        if (spacePos == -1) {
            return inputString;
        }
        if (spacePos == 0) {
            return "";
        }
        return inputString.substring(0, spacePos);
    }

    public static String stripLastDotWord(String inputString) {
        int dotPos = inputString.lastIndexOf(46);
        if (dotPos == -1) {
            return inputString;
        }
        if (dotPos == 0) {
            return "";
        }
        return inputString.substring(0, dotPos);
    }

    public static String stripGzip(String inputString) {
        if (inputString.endsWith(".gz")) {
            return inputString.substring(0, inputString.length() - 3);
        }
        return inputString;
    }

    public static String stripSpaces(String inputString) {
        if (inputString.indexOf(32) != -1) {
            StringBuffer sb = new StringBuffer();
            StringTokenizer tok = new StringTokenizer(inputString, " ");
            while (tok.hasMoreTokens()) {
                sb.append(tok.nextToken());
            }
            return sb.toString();
        }
        return inputString;
    }

    public static String getDirectoryFromPath(String path) {
        return path.substring(0, path.lastIndexOf(File.separator));
    }

    public static String getFilenameFromPath(String path) {
        path = path.substring(path.lastIndexOf(47) + 1);
        path = path.substring(path.lastIndexOf(92) + 1);
        return path;
    }

    public static String encodeSpaces(String s) {
        return s.replaceAll(" ", "%20");
    }

    public static String wrapLines(Object message, int lineSize) {
        return StringTool.wrapLines(message.toString(), lineSize);
    }

    public static String wrapLines(String message, int lineSize) {
        return StringTool.wrapLines(message, lineSize, false);
    }

    public static String wrapLines(String message, int lineSize, boolean htmlResult) {
        try {
            StringBuffer result = new StringBuffer();
            if (htmlResult) {
                result.append("<html>");
            }
            int pos = 0;
            boolean done = false;
            while (!done) {
                String line;
                int breakPos = message.indexOf(10, pos);
                if (breakPos == -1) {
                    line = message.substring(pos);
                    done = true;
                } else {
                    line = message.substring(pos, breakPos);
                }
                pos += line.length() + 1;
                int lineLengthSoFar = 0;
                StringTokenizer tok = new StringTokenizer(line, " ");
                while (tok.hasMoreTokens()) {
                    String word = tok.nextToken();
                    if (lineLengthSoFar + word.length() > lineSize) {
                        if (lineLengthSoFar != 0) {
                            result.append(htmlResult ? "<br>" : "\n");
                        }
                        result.append(word);
                        result.append(" ");
                        lineLengthSoFar = word.length() + 1;
                        continue;
                    }
                    result.append(word);
                    result.append(" ");
                    lineLengthSoFar += word.length() + 1;
                }
                if (done) continue;
                result.append(htmlResult ? "<br>" : "\n");
            }
            if (htmlResult) {
                result.append("</html>");
            }
            return result.toString();
        }
        catch (Throwable t) {
            return message;
        }
    }

    public static String getCommonStart(String s1, String s2) {
        int positionCount;
        for (positionCount = 0; positionCount < s1.length() && positionCount < s2.length(); ++positionCount) {
            if (Character.toLowerCase(s1.charAt(positionCount)) == Character.toLowerCase(s2.charAt(positionCount))) {
                continue;
            }
            return s1.substring(0, positionCount);
        }
        return s1.substring(0, positionCount);
    }

    public static String getCommonStart(List stringList) {
        if (stringList.size() == 0) {
            return "";
        }
        if (stringList.size() == 1) {
            return (String)stringList.get(0);
        }
        if (stringList.size() == 2) {
            return StringTool.getCommonStart((String)stringList.get(0), (String)stringList.get(1));
        }
        String commonStart = StringTool.getCommonStart((String)stringList.get(0), (String)stringList.get(1));
        for (int i = 2; i < stringList.size(); ++i) {
            commonStart = StringTool.getCommonStart(commonStart, (String)stringList.get(i));
        }
        return commonStart;
    }

    public static String[] tokenize(String contents, String delim) {
        StringTokenizer tok = new StringTokenizer(contents, delim);
        int tokenCount = tok.countTokens();
        if (tokenCount == 0) {
            return null;
        }
        String[] result = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            result[i] = tok.nextToken();
        }
        return result;
    }

    public static String underscoreToSpace(String input) {
        int underscorePos = input.indexOf(95);
        if (underscorePos < 0) {
            return input;
        }
        return StringTool.underscoreToSpace(input.substring(0, underscorePos) + " " + input.substring(underscorePos + 1));
    }

    public static String serialize(Serializable obj) {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bytesOut);
            oos.writeObject(obj);
            oos.close();
            bytesOut.close();
            return bytesOut.toString("UTF-8");
        }
        catch (Exception e) {
            SS.debug(e + " while serializing an obj: " + obj);
            return "";
        }
    }

    public static byte[] serializeToBytes(Serializable obj) {
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bytesOut);
            oos.writeObject(obj);
            oos.close();
            bytesOut.close();
            return bytesOut.toByteArray();
        }
        catch (Exception e) {
            SS.debug(e + " while serializing an obj: " + obj);
            return null;
        }
    }

    public static Object deserializeBytes(byte[] byteBuffer) {
        try {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(byteBuffer);
            ObjectInputStream ois = new ObjectInputStream(bytesIn);
            Object obj = ois.readObject();
            ois.close();
            bytesIn.close();
            return obj;
        }
        catch (Exception e) {
            SS.debug(e + " while deserializing bytes: " + byteBuffer);
            return null;
        }
    }

    public static Object deserialize(String objString) {
        try {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(objString.getBytes("UTF-8"));
            ObjectInputStream ois = new ObjectInputStream(bytesIn);
            Object obj = ois.readObject();
            ois.close();
            bytesIn.close();
            return obj;
        }
        catch (Exception e) {
            SS.debug(e + " while deserializing a string: " + objString);
            return null;
        }
    }

    public static boolean sameSubnetIP(String ip1, String ip2) {
        if (ip1 == null || ip2 == null) {
            return false;
        }
        return StringTool.stripLastDotWord(ip1).equals(StringTool.stripLastDotWord(ip2));
    }

    public static String fileToString(String path) {
        StringBuffer inputBuffer = new StringBuffer();
        try {
            String temp;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            while ((temp = in.readLine()) != null) {
                inputBuffer.append(temp);
                inputBuffer.append("\n");
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputBuffer.toString();
    }

    public static String timeFormat(long millis) {
        return StringTool.timeFormat(millis, 6);
    }

    public static String timeFormat(long millis, int showSecondsUnderTheseMinutes) {
        int days = (int)millis / 86400000;
        int hours = (int)(millis % 86400000L) / 3600000;
        int minutes = (int)(millis % 3600000L) / 60000;
        int seconds = (int)(millis % 60000L) / 1000;
        String result = "";
        if (days > 0) {
            result = days == 1 ? days + " " + Translator.getString("day") + ", " : days + " " + Translator.getString("days") + ", ";
        }
        if (hours > 0) {
            result = hours == 1 ? result + hours + " " + Translator.getString("hour") + ", " : result + hours + " " + Translator.getString("hours") + ", ";
        }
        if (minutes > 0) {
            result = minutes == 1 ? result + minutes + " " + Translator.getString("minute") : result + minutes + " " + Translator.getString("minutes");
        }
        if (days == 0 && hours == 0 && minutes < showSecondsUnderTheseMinutes) {
            result = (minutes > 0 ? result + ", " : "") + seconds + " " + Translator.getString("seconds");
        }
        return result;
    }

    public static String plural(int i) {
        if (i == 1) {
            return "";
        }
        return "s";
    }

    public static String xmlSafe(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("&", "&amp;");
    }

    public static String xmlSafeReverse(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("&amp;", "&");
    }

    public static int getNumerator(String fraction) {
        int pos = fraction.indexOf("/");
        if (pos == -1) {
            return 0;
        }
        return Integer.parseInt(fraction.substring(0, pos).trim());
    }

    public static int getDenominator(String fraction) {
        int pos = fraction.indexOf("/");
        String afterSlash = fraction.substring(pos + 1).trim();
        if ((pos = afterSlash.indexOf(" ")) != -1) {
            afterSlash = afterSlash.substring(0, pos);
        }
        return Integer.parseInt(afterSlash);
    }

    public static String alignSongSheet(String filePath) {
        String input = StringTool.fileToString(filePath);
        StringBuffer sb = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(input, "\n");
        while (tok.hasMoreTokens()) {
            int startLength;
            String A = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                sb.append(A);
                break;
            }
            String B = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                sb.append(A);
                sb.append(B);
                break;
            }
            String C = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                sb.append(A);
                sb.append(B);
                sb.append(C);
                break;
            }
            String D = tok.nextToken();
            sb.append(A);
            sb.append("  ");
            for (startLength = Math.max(A.length(), B.length()); A.length() < startLength; --startLength) {
                sb.append(" ");
            }
            sb.append(C);
            sb.append("\n");
            sb.append(B);
            sb.append("  ");
            while (B.length() < startLength) {
                sb.append(" ");
                --startLength;
            }
            sb.append(D);
            sb.append("\n");
        }
        return sb.toString();
    }
}

