/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.RemoteImageListener;
import com.sillysoft.tools.URLTool;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;

public class RemoteImageFetcher
implements Runnable {
    private String URL;
    private int row;
    private RemoteImageListener parent;

    public static void getImage(String URL2, int row, RemoteImageListener parent) {
        new RemoteImageFetcher(URL2, row, parent);
    }

    public RemoteImageFetcher(String URL2, int row, RemoteImageListener parent) {
        this.URL = URL2;
        this.row = row;
        this.parent = parent;
        new Thread((Runnable)this, "RemoteImageFetcher").start();
    }

    public void run() {
        String filename = this.URL.substring(this.URL.lastIndexOf(47) + 1);
        try {
            String imageCacheFolder = DesktopTool.supportFolderPath() + "Cache" + File.separator + "Images";
            String filepath = imageCacheFolder + File.separator + filename;
            File cached = new File(filepath);
            if (cached.exists()) {
                this.parent.imageReady(this.row, new ImageIcon(filepath));
            } else {
                System.out.println("RemoteImageFetcher: fetch and cache: " + filename);
                ImageIcon downloaded = new ImageIcon(new URL(this.URL));
                this.parent.imageReady(this.row, downloaded);
                new File(imageCacheFolder).mkdirs();
                URLTool.downloadURLtoFile(this.URL, imageCacheFolder);
            }
        }
        catch (Exception e) {
            System.out.println("RemoteImageFetcher: NOT FOUND: " + filename);
            this.parent.imageReady(this.row, new ImageIcon(GraphicsTool.getManagedImage("not_available.jpg")));
        }
    }
}

