/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.SS;
import java.util.Random;

public class RangeIterator {
    private Random randLocal;
    private int min;
    private int max;
    private int spotsPerInteger;
    private boolean[] used;

    public RangeIterator(int min, int max) {
        this(min, max, 1);
    }

    public RangeIterator(int min, int max, int spotsPerInteger) {
        if (max < min) {
            throw new RuntimeException("RangeIterator created with max < min");
        }
        this.min = min;
        this.max = max;
        this.spotsPerInteger = spotsPerInteger;
        this.used = new boolean[(max - min) * spotsPerInteger + 1];
    }

    public RangeIterator(int min, int max, int spotsPerInteger, int localRandSeed) {
        if (max < min) {
            throw new RuntimeException("RangeIterator created with max < min");
        }
        this.min = min;
        this.max = max;
        this.spotsPerInteger = spotsPerInteger;
        this.randLocal = new Random(localRandSeed);
        this.used = new boolean[(max - min) * spotsPerInteger + 1];
    }

    public double next() {
        int r;
        if (!this.hasNext()) {
            throw new RuntimeException("RangeIterator.next() called when hasNext() == false");
        }
        while (this.used[r = this.nextIntRand(this.used.length)]) {
        }
        this.used[r] = true;
        return (double)this.min + (double)r / (double)this.spotsPerInteger;
    }

    public boolean hasNext() {
        for (int i = 0; i < this.used.length; ++i) {
            if (this.used[i]) continue;
            return true;
        }
        return false;
    }

    private int nextIntRand(int max) {
        if (this.randLocal != null) {
            return this.randLocal.nextInt(max);
        }
        return SS.rand.nextInt(max);
    }

    public static void test() {
        RangeIterator r = new RangeIterator(0, 0);
        while (r.hasNext()) {
            System.out.println("RangeIterator(0,0) -> " + r.next());
        }
        System.out.println(" ");
        r = new RangeIterator(0, 0, 2);
        while (r.hasNext()) {
            System.out.println("RangeIterator(0,0,2) -> " + r.next());
        }
        System.out.println(" ");
        r = new RangeIterator(-1, 1);
        while (r.hasNext()) {
            System.out.println("RangeIterator(-1,1) -> " + r.next());
        }
        System.out.println(" ");
        r = new RangeIterator(-1, 1, 2);
        while (r.hasNext()) {
            System.out.println("RangeIterator(-1,1,2) -> " + r.next());
        }
        System.out.println(" ");
        r = new RangeIterator(-1, 1, 5);
        while (r.hasNext()) {
            System.out.println("RangeIterator(-1,1,5) -> " + r.next());
        }
    }
}

