/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.SS;
import com.sillysoft.widgets.SSApp;
import java.io.ByteArrayOutputStream;
import java.util.prefs.Preferences;

public class Prefs {
    public static Preferences prefs;

    public static void setPackageClassAndNode(Class aClass, String node) {
        prefs = Preferences.userNodeForPackage(aClass).node(node);
        if (prefs == null) {
            System.out.println("Prefs: could not load the desired preferences node");
        }
    }

    public static String get(String key) {
        return Prefs.get(key, null);
    }

    public static String get(String key, String def) {
        if (prefs == null) {
            return def;
        }
        return prefs.get(key, def);
    }

    public static boolean getBoolean(String key) {
        return Prefs.getBoolean(key, false);
    }

    public static boolean getBoolean(String key, boolean def) {
        if (prefs == null) {
            return def;
        }
        return prefs.getBoolean(key, def);
    }

    public static int getInt(String key) {
        return Prefs.getInt(key, 0);
    }

    public static int getInt(String key, int def) {
        if (prefs == null) {
            return def;
        }
        return prefs.getInt(key, def);
    }

    public static float getFloat(String key) {
        return Prefs.getFloat(key, 0.0f);
    }

    public static float getFloat(String key, float def) {
        if (prefs == null) {
            return def;
        }
        return prefs.getFloat(key, def);
    }

    public static long getLong(String key, long def) {
        if (prefs == null) {
            return def;
        }
        return prefs.getLong(key, def);
    }

    public static long getLong(String key) {
        return Prefs.getLong(key, 0L);
    }

    public static void put(String key, String value) {
        if (prefs == null) {
            return;
        }
        prefs.put(key, value);
    }

    public static void putBoolean(String key, boolean value) {
        if (prefs == null) {
            return;
        }
        prefs.putBoolean(key, value);
    }

    public static void putInt(String key, int value) {
        if (prefs == null) {
            return;
        }
        prefs.putInt(key, value);
    }

    public static void putFloat(String key, float value) {
        if (prefs == null) {
            return;
        }
        prefs.putFloat(key, value);
    }

    public static void putLong(String key, long value) {
        if (prefs == null) {
            return;
        }
        prefs.putLong(key, value);
    }

    public static void remove(String key) {
        if (prefs == null) {
            return;
        }
        prefs.remove(key);
    }

    public static String[] keys() {
        if (prefs == null) {
            return new String[0];
        }
        try {
            return prefs.keys();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public static void sync() {
        if (prefs == null) {
            return;
        }
        try {
            prefs.flush();
            prefs.sync();
        }
        catch (Throwable e) {
            System.out.println("Prefs -> Error synching the prefs");
            e.printStackTrace();
        }
    }

    public static String getUserKey() {
        if ("lux".equals(SSApp.shortNameLower())) {
            String code = Prefs.get("regCode", "").toUpperCase();
            if (code.startsWith("DE-") || code.startsWith("MG-") || code.startsWith("IM-") || code.startsWith("R4-") || code.startsWith("R5-") || code.startsWith("R6-") || code.startsWith("R7-") || code.startsWith("R8-") || code.startsWith("GG-") || code.startsWith("LD-")) {
                return code;
            }
            return Prefs.get("regName", "");
        }
        return Prefs.get("regCode", "");
    }

    public static void flush(Preferences p) {
        try {
            p.flush();
        }
        catch (Exception e) {
            SS.debug(e + " while flushing a preferences node: " + p);
        }
    }

    public static String exportSubtree() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            prefs.exportSubtree(out);
            byte[] charData = out.toByteArray();
            String str = new String(charData, "UTF-8");
            return str;
        }
        catch (Exception e) {
            return e.toString();
        }
    }
}

