/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.Prefs;
import java.io.FileNotFoundException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PreferencesTransferTool
extends DefaultHandler {
    boolean nextValueIsKey;
    String savedKey;
    StringBuffer buffer;
    private int indent = 0;

    public static void transferPreferencesForIdentifier(String id) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            PreferencesTransferTool handler = new PreferencesTransferTool();
            parser.setContentHandler(handler);
            parser.parse(System.getProperty("user.home") + "/Library/Preferences/" + id);
        }
        catch (FileNotFoundException e) {
            System.out.println(" -> There was no OSX prefs file found to import");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        PreferencesTransferTool.transferPreferencesForIdentifier("com.sillysoft.lux.plist");
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes att) throws SAXException {
        this.nextValueIsKey = "key".equals(qualifiedName);
        this.buffer = new StringBuffer();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length).trim();
        this.buffer.append(value);
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if (this.nextValueIsKey) {
            this.savedKey = this.buffer.toString();
        } else {
            Prefs.put(this.savedKey, this.buffer.toString());
        }
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            System.out.print("    ");
        }
    }
}

