/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.Prefs;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class LogFile
extends PrintStream {
    private PrintStream stdout;
    private PrintStream logFileOut;
    private String logFilePath;
    private int writeCount = 0;
    private static long maximumLogFileBytes = 1024000L;
    private boolean copyToStandardOut = !Prefs.getBoolean("blockConsoleOutput", false);

    public static void copySystemOutputToFile(String logFilePath) {
        try {
            new LogFile(logFilePath);
        }
        catch (Exception e) {
            System.out.println("Sillysoft LogFile -> Unable to redirect System.out and System.err");
            e.printStackTrace();
        }
    }

    private LogFile(String logFilePath) throws FileNotFoundException, UnsupportedEncodingException {
        super((OutputStream)System.out, false, "UTF-8");
        this.logFilePath = logFilePath;
        this.stdout = System.out;
        this.logFileOut = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(logFilePath)), true, "UTF-8");
        System.setOut(this);
        System.setErr(this);
    }

    public void println(String x) {
        if (this.copyToStandardOut) {
            this.stdout.println(x);
        }
        this.logFileOut.println(x);
        ++this.writeCount;
        if (this.writeCount > 1000) {
            this.writeCount = 0;
            File logFile = new File(this.logFilePath);
            if (logFile.length() > maximumLogFileBytes) {
                try {
                    this.logFileOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFilePath)), true);
                    this.println("Earlier parts of the log file were discarded because it was getting too big in filesize.");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void println(Object x) {
        if (this.copyToStandardOut) {
            this.stdout.println(x);
        }
        this.logFileOut.println(x);
    }

    public void print(String x) {
        if (this.copyToStandardOut) {
            this.stdout.print(x);
        }
        this.logFileOut.print(x);
    }

    public void print(Object x) {
        if (this.copyToStandardOut) {
            this.stdout.print(x);
        }
        this.logFileOut.print(x);
    }

    public String getLog() {
        return FileTool.fileToString(this.logFilePath);
    }
}

