/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.ExtraLine;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.XMLTool;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GraphicsTool {
    public static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color HALF_TRANSPARENT_WHITE = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    public static final Color THICK_ARROW_COLOR = Color.WHITE;
    private static String supportFolderPath;
    private static String modernResourcesLocation;
    private static int nextColorCounter;
    private static Hashtable managedImages;
    private static Hashtable managedImagesColored;
    private static Map fontCache;

    public static Color transparent(Color color, float alpha) {
        if (color == null) {
            return GraphicsTool.transparent(Color.WHITE, alpha);
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * alpha));
    }

    public static Color solid(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void initGraphicsTool(String supportFolderPath_set, String modernResourcesLocation_set) {
        supportFolderPath = supportFolderPath_set;
        modernResourcesLocation = modernResourcesLocation_set;
    }

    public static Image getImageFromJAR(String name) {
        Image i;
        if (supportFolderPath == null) {
            throw new NullPointerException("GraphicsTool.getImageFromJAR called before initGraphicsTool()");
        }
        String path = supportFolderPath + "Mods" + File.separator + name;
        if (name.startsWith("Themes/")) {
            path = supportFolderPath + name;
            name = name.substring(name.lastIndexOf("/") + 1);
        }
        if (new File(path).exists() && (i = new ImageIcon(path).getImage()) != null) {
            return i;
        }
        path = modernResourcesLocation + "Images" + File.separator + name;
        if (new File(path).exists() && (i = new ImageIcon(path).getImage()) != null) {
            return i;
        }
        try {
            i = new ImageIcon(GraphicsTool.class.getResource("/" + name)).getImage();
            return i;
        }
        catch (Exception e) {
            System.out.println("GraphicsTool.getImageFromJAR() -> error loading " + name);
            BufferedImage buff = GraphicsTool.createBufferedImage(50, 50, 3);
            Graphics2D imageG = buff.createGraphics();
            imageG.setColor(Color.BLACK);
            imageG.fillRect(0, 0, 50, 50);
            imageG.dispose();
            return buff;
        }
    }

    public static BufferedImage getBufferedImageFromJAR(String name) {
        try {
            String path = supportFolderPath + "Mods" + File.separator + name;
            File modFile = new File(path);
            if (modFile.exists()) {
                return ImageIO.read(modFile);
            }
            URL url = GraphicsTool.class.getResource("/" + name);
            return ImageIO.read(url);
        }
        catch (Exception e) {
            System.out.println("GraphicsTool.getBufferedImageFromJAR() -> error loading " + name);
            return null;
        }
    }

    public static ImageIcon getImageIconNamed(String name) {
        try {
            return new ImageIcon(GraphicsTool.class.getResource("/" + name));
        }
        catch (Exception e) {
            System.out.println("getImageIconNamed(" + name + ") failed");
            e.printStackTrace();
            return new ImageIcon();
        }
    }

    public static boolean arrangeRects(Rectangle[] rects, Rectangle bounds, int unit) {
        return GraphicsTool.arrangeRects(rects, bounds, unit, 0);
    }

    public static boolean arrangeRects(Rectangle[] r, Rectangle bounds, int unit, int bufferSize) {
        boolean movedSomething = false;
        int n = r.length;
        int negBufferSize = -1 * bufferSize;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j || !GraphicsTool.intersectsRectMoreThanBuffer(r[i], r[j], bufferSize)) continue;
                if (r[i].getCenterX() > r[j].getCenterX()) {
                    if (r[i].getMaxX() < bounds.getMaxX()) {
                        r[i].translate(unit, 0);
                    }
                    if (r[j].getX() > 0.0) {
                        r[j].translate(-unit, 0);
                    }
                } else {
                    if (r[i].getX() > 0.0) {
                        r[i].translate(-unit, 0);
                    }
                    if (r[j].getMaxX() < bounds.getMaxX()) {
                        r[j].translate(unit, 0);
                    }
                }
                if (r[i].getCenterY() > r[j].getCenterY()) {
                    if (r[i].getMaxY() < bounds.getMaxY()) {
                        r[i].translate(0, unit);
                    }
                    if (r[j].getY() > 0.0) {
                        r[j].translate(0, -unit);
                    }
                } else {
                    if (r[i].getY() > 0.0) {
                        r[i].translate(0, -unit);
                    }
                    if (r[j].getMaxY() < bounds.getMaxY()) {
                        r[j].translate(0, unit);
                    }
                }
                movedSomething = true;
            }
            if (r[i].getY() < (double)negBufferSize) {
                r[i].translate(0, unit);
                movedSomething = true;
            } else if (r[i].getMaxY() > bounds.getMaxY() + (double)bufferSize) {
                r[i].translate(0, -unit);
                movedSomething = true;
            }
            if (r[i].getX() < (double)negBufferSize) {
                r[i].translate(unit, 0);
                movedSomething = true;
                continue;
            }
            if (!(r[i].getMaxX() > bounds.getMaxX() + (double)bufferSize)) continue;
            r[i].translate(-unit, 0);
            movedSomething = true;
        }
        return movedSomething;
    }

    private static boolean intersectsRectMoreThanBuffer(Rectangle r1, Rectangle r2, int bufferSize) {
        if (bufferSize == 0) {
            return r1.intersects(r2);
        }
        Rectangle inter = r1.intersection(r2);
        return inter.getWidth() > (double)bufferSize && inter.getHeight() > (double)bufferSize;
    }

    public static void drawBoxedString(Graphics2D g, String text, int centeredAtX, int centeredAtY, int padding) {
        GraphicsTool.drawBoxedString(g, text, centeredAtX, centeredAtY, padding, Color.black, 1);
    }

    public static void drawBoxedString(Graphics2D g, String text, int centeredAtX, int centeredAtY, int padding, Color outlineColor, int outlineWidth) {
        GraphicsTool.drawBoxedString(g, text, centeredAtX, centeredAtY, padding, padding, GraphicsTool.transparent(Color.white, 0.75f), outlineColor, outlineWidth, Color.black);
    }

    public static void drawBoxedString(Graphics2D g, String text, int centeredAtX, int centeredAtY, int paddingX, int paddingY, Color boxColor, Color outlineColor, int outlineWidth) {
        GraphicsTool.drawBoxedString(g, text, centeredAtX, centeredAtY, paddingX, paddingY, GraphicsTool.transparent(Color.white, 0.75f), outlineColor, outlineWidth, Color.black);
    }

    public static void drawBoxedString(Graphics2D g, String text, int centeredAtX, int centeredAtY, int paddingX, int paddingY, Color boxColor, Color outlineColor, int outlineWidth, Color textColor) {
        FontMetrics fontMetrics = g.getFontMetrics();
        int fontHeight = fontMetrics.getHeight();
        String[] lines = new String[GraphicsTool.countLines(text)];
        int pos = 0;
        int boxWidth = 0;
        for (int i = 0; i < lines.length; ++i) {
            int end = text.indexOf(10, pos);
            lines[i] = end != -1 ? text.substring(pos, end) : text.substring(pos);
            pos += lines[i].length() + 1;
            boxWidth = i == 2 ? Math.max(boxWidth, fontMetrics.stringWidth(lines[i]) + 20) : Math.max(boxWidth, fontMetrics.stringWidth(lines[i]));
        }
        int boxHeight = fontHeight * lines.length + paddingY * 2;
        int originX = centeredAtX - (boxWidth += paddingX * 2 + 1) / 2;
        int originY = centeredAtY - boxHeight / 2;
        int arcwidth = 15;
        if (fontHeight < 17) {
            arcwidth = 8;
        }
        if (fontHeight < 20) {
            arcwidth = 12;
        }
        RoundRectangle2D.Float textBox = new RoundRectangle2D.Float(originX, originY, boxWidth, boxHeight, arcwidth, 15.0f);
        g.setColor(boxColor);
        g.fill(textBox);
        g.setStroke(new BasicStroke(outlineWidth, 1, 1));
        g.setColor(outlineColor);
        g.draw(textBox);
        g.setColor(textColor);
        int textStartingY = originY + boxHeight - (paddingY + fontMetrics.getDescent());
        if (fontHeight > 24) {
            ++textStartingY;
        }
        for (int i = 0; i < lines.length; ++i) {
            g.drawString(lines[i], originX + paddingX + 1, textStartingY - fontHeight * (lines.length - (i + 1)));
        }
    }

    public static Rectangle getBoxedStringRectangle(Font font, String text, int centeredAtX, int centeredAtY, int paddingX, int paddingY, Color boxColor, Color outlineColor, int outlineWidth, Color textColor) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        String[] lines = new String[GraphicsTool.countLines(text)];
        int pos = 0;
        int boxWidth = 0;
        for (int i = 0; i < lines.length; ++i) {
            int end = text.indexOf(10, pos);
            lines[i] = end != -1 ? text.substring(pos, end) : text.substring(pos);
            pos += lines[i].length() + 1;
            boxWidth = i == 2 ? Math.max(boxWidth, fontMetrics.stringWidth(lines[i]) + 20) : Math.max(boxWidth, fontMetrics.stringWidth(lines[i]));
        }
        int boxHeight = fontHeight * lines.length + paddingY * 2;
        int originX = centeredAtX - (boxWidth += paddingX * 2 + 1) / 2;
        int originY = centeredAtY - boxHeight / 2;
        Rectangle textBox = new Rectangle(originX, originY, boxWidth, boxHeight);
        return textBox;
    }

    public static void drawBoxedStringCorneredAt(Graphics2D g, String text, int originX, int originY, int paddingX, int paddingY, Color boxColor, Color outlineColor, int outlineWidth, Color textColor, boolean engraveText) {
        FontMetrics fontMetrics = g.getFontMetrics();
        int fontHeight = fontMetrics.getHeight();
        String[] lines = new String[GraphicsTool.countLines(text)];
        int pos = 0;
        int boxWidth = 0;
        for (int i = 0; i < lines.length; ++i) {
            int end = text.indexOf(10, pos);
            lines[i] = end != -1 ? text.substring(pos, end) : text.substring(pos);
            pos += lines[i].length() + 1;
            boxWidth = Math.max(boxWidth, fontMetrics.stringWidth(lines[i]));
        }
        int boxHeight = fontHeight * lines.length + paddingY * 2;
        RoundRectangle2D.Float textBox = new RoundRectangle2D.Float(originX, originY, boxWidth += paddingX * 2 + 1, boxHeight, 15.0f, 15.0f);
        g.setColor(boxColor);
        g.fill(textBox);
        g.setStroke(new BasicStroke(outlineWidth, 1, 1));
        g.setColor(outlineColor);
        g.draw(textBox);
        g.setColor(textColor);
        int textStartingY = originY + boxHeight + 1 - (paddingY + fontMetrics.getDescent());
        for (int i = 0; i < lines.length; ++i) {
            if (engraveText) {
                GraphicsTool.drawEngravedString(g, lines[i], originX + paddingX + 1, textStartingY - fontHeight * (lines.length - (i + 1)));
                continue;
            }
            g.drawString(lines[i], originX + paddingX + 1, textStartingY - fontHeight * (lines.length - (i + 1)));
        }
    }

    private static int countLines(String text) {
        if (text == null) {
            return 0;
        }
        int lines = 1;
        for (int i = 0; i < text.length() && (i = text.indexOf(10, i)) != -1; ++i) {
            ++lines;
        }
        return lines;
    }

    public static void saveComponentAsJPEG(Component myComponent, String filename, boolean thumbnail, int width, int height, boolean isVox) {
        BufferedImage myImage = new BufferedImage(width, height, 5);
        Graphics2D g2 = myImage.createGraphics();
        myComponent.paint(g2);
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)myImage, "jpg", new File(filename + ".jpg"));
            if (thumbnail) {
                int thumbHeight;
                if (!isVox) {
                    float thumbScale = Math.min(170.0f / (float)width, 140.0f / (float)height);
                    int thumbWidth = (int)((float)width * thumbScale);
                    int thumbHeight2 = (int)((float)height * thumbScale);
                    Image thumbnailImage = myImage.getScaledInstance(thumbWidth, thumbHeight2, 16);
                    ImageIO.write((RenderedImage)GraphicsTool.toBufferedImage(thumbnailImage, null), "jpg", new File(filename + "_thumb.jpg"));
                }
                if (width > 500) {
                    int thumbWidth = (int)((float)width * (500.0f / (float)width));
                    thumbHeight = (int)((float)height * (500.0f / (float)width));
                    Image thumbnailImage = myImage.getScaledInstance(thumbWidth, thumbHeight, 16);
                    ImageIO.write((RenderedImage)GraphicsTool.toBufferedImage(thumbnailImage, null), "jpg", new File(filename + "_thumb500.jpg"));
                }
                if (width > 800) {
                    int thumbWidth = (int)((float)width * (800.0f / (float)width));
                    thumbHeight = (int)((float)height * (800.0f / (float)width));
                    Image thumbnailImage = myImage.getScaledInstance(thumbWidth, thumbHeight, 16);
                    ImageIO.write((RenderedImage)GraphicsTool.toBufferedImage(thumbnailImage, null), "jpg", new File(filename + "_thumb800.jpg"));
                }
            }
        }
        catch (Exception e) {
            System.out.println("GraphicsTool.saveComponentAsJPEG: " + e);
        }
    }

    public static void saveComponentAsPNG(Component myComponent, String filename, boolean thumbnail, int width, int height) {
        BufferedImage myImage = new BufferedImage(width, height, 5);
        Graphics2D g2 = myImage.createGraphics();
        myComponent.paint(g2);
        g2.dispose();
        try {
            ImageIO.write((RenderedImage)myImage, "png", new File(filename + ".png"));
            if (thumbnail) {
                float thumbScaleWidth = 170.0f / (float)width;
                float thumbScaleHeight = 140.0f / (float)height;
                float thumbScale = Math.min(thumbScaleWidth, thumbScaleHeight);
                int thumbWidth = (int)((float)width * thumbScale);
                int thumbHeight = (int)((float)height * thumbScale);
                Image thumbnailImage = myImage.getScaledInstance(thumbWidth, thumbHeight, 16);
                ImageIO.write((RenderedImage)GraphicsTool.toBufferedImage(thumbnailImage, null), "png", new File(filename + "_thumb.png"));
            }
        }
        catch (Exception e) {
            System.out.println("GraphicsTool.saveComponentAsPNG: " + e);
        }
    }

    public static void saveComponentAsMiniPNG(Component myComponent, String filename, int width, int height) {
        BufferedImage myImage = new BufferedImage(width, height, 5);
        Graphics2D g2 = myImage.createGraphics();
        myComponent.paint(g2);
        g2.dispose();
        try {
            float thumbScaleWidth = 170.0f / (float)width;
            float thumbScaleHeight = 140.0f / (float)height;
            float thumbScale = Math.min(thumbScaleWidth, thumbScaleHeight);
            int thumbWidth = (int)((float)width * thumbScale);
            int thumbHeight = (int)((float)height * thumbScale);
            Image thumbnailImage = myImage.getScaledInstance(thumbWidth, thumbHeight, 16);
            ImageIO.write((RenderedImage)GraphicsTool.toBufferedImage(thumbnailImage, null), "png", new File(filename + "_thumb.png"));
        }
        catch (Exception e) {
            System.out.println("GraphicsTool.saveComponentAsMiniPNG: " + e);
        }
    }

    public static GeneralPath flipY(GeneralPath path, int height) {
        GeneralPath shape = new GeneralPath();
        PathIterator it = path.getPathIterator(new AffineTransform());
        float[] point = new float[2];
        while (!it.isDone()) {
            int segType = it.currentSegment(point);
            if (segType == 1) {
                shape.lineTo(point[0], (float)height - point[1]);
            } else if (segType == 0) {
                shape.moveTo(point[0], (float)height - point[1]);
            } else if (segType == 4) {
                shape.closePath();
            } else {
                System.out.println("GraphicsTool -> GraphicsTool.flipY() unknown segType: " + segType);
            }
            it.next();
        }
        return shape;
    }

    public static String flipPointStringY(String pointString, int height) {
        if (pointString == null) {
            return null;
        }
        int commaLoc = pointString.indexOf(",");
        StringBuffer result = new StringBuffer();
        result.append(pointString.substring(0, commaLoc + 1));
        result.append(height - Integer.parseInt(pointString.substring(commaLoc + 1)));
        return result.toString();
    }

    public static String getGeneralPathXML(GeneralPath path, int height) {
        StringBuffer result = new StringBuffer();
        PathIterator it = path.getPathIterator(new AffineTransform());
        float[] point = new float[2];
        boolean isOpen = false;
        while (!it.isDone()) {
            int segType = it.currentSegment(point);
            if (segType == 1) {
                result.append(" ");
                result.append((int)point[0]);
                result.append(",");
                result.append(height - (int)point[1]);
            } else if (segType == 0) {
                isOpen = true;
                result.append("\t\t<polygon>");
                result.append((int)point[0]);
                result.append(",");
                result.append(height - (int)point[1]);
            } else if (segType == 4) {
                if (isOpen) {
                    isOpen = false;
                    result.append("</polygon>\n");
                }
            } else {
                System.out.println("GraphicsTool -> GraphicsTool 23846 unknown segType: " + segType);
            }
            it.next();
        }
        if (isOpen) {
            result.append("</polygon>\n");
        }
        return result.toString();
    }

    public static double distanceFromPointToRect(Point2D p, Rectangle r) {
        if (r.contains(p)) {
            return 0.0;
        }
        int distance = 10000000;
        Line2D.Double line = new Line2D.Double(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMinY());
        distance = Math.min(distance, (int)Math.abs(line.ptLineDist(p)));
        line = new Line2D.Double(r.getMinX(), r.getMinY(), r.getMinX(), r.getMaxY());
        distance = Math.min(distance, (int)Math.abs(line.ptLineDist(p)));
        line = new Line2D.Double(r.getMinX(), r.getMaxY(), r.getMaxX(), r.getMaxY());
        distance = Math.min(distance, (int)Math.abs(line.ptLineDist(p)));
        line = new Line2D.Double(r.getMaxX(), r.getMinY(), r.getMaxX(), r.getMaxY());
        distance = Math.min(distance, (int)Math.abs(line.ptLineDist(p)));
        return distance;
    }

    public static double distanceFromPointToGeneralPath(Point p, GeneralPath path) {
        double closestSoFar = -1.0;
        PathIterator it = path.getPathIterator(new AffineTransform());
        float[] currentPoint = new float[2];
        float[] previousPoint = null;
        float[] firstPoint = new float[2];
        while (!it.isDone()) {
            int segType = it.currentSegment(currentPoint);
            if (segType == 0) {
                firstPoint[0] = currentPoint[0];
                firstPoint[1] = currentPoint[1];
                previousPoint = null;
            } else if (segType == 4) {
                currentPoint[0] = firstPoint[0];
                currentPoint[1] = firstPoint[1];
            } else if (segType != 1) {
                throw new RuntimeException("GraphicsTool.distanceFromPointToGeneralPath has not been implemented for all GeneralPaths segment types.");
            }
            if (previousPoint != null) {
                Line2D.Float segment = new Line2D.Float((float)previousPoint[0], previousPoint[1], currentPoint[0], currentPoint[1]);
                double distToSegment = segment.ptSegDist(p);
                if (closestSoFar == -1.0 || distToSegment < closestSoFar) {
                    closestSoFar = distToSegment;
                }
            }
            if (previousPoint == null) {
                previousPoint = new float[]{currentPoint[0], currentPoint[1]};
            }
            it.next();
        }
        return closestSoFar;
    }

    public static double distanceFromPointToGeneralPath(Point2D p, GeneralPath path) {
        double closestSoFar = -1.0;
        PathIterator it = path.getPathIterator(new AffineTransform());
        float[] currentPoint = new float[2];
        float[] previousPoint = null;
        float[] firstPoint = new float[2];
        while (!it.isDone()) {
            int segType = it.currentSegment(currentPoint);
            if (segType == 0) {
                firstPoint[0] = currentPoint[0];
                firstPoint[1] = currentPoint[1];
                previousPoint = null;
            } else if (segType == 4) {
                currentPoint[0] = firstPoint[0];
                currentPoint[1] = firstPoint[1];
            } else if (segType != 1) {
                throw new RuntimeException("GraphicsTool.distanceFromPointToGeneralPath has not been implemented for all GeneralPaths segment types.");
            }
            if (previousPoint != null) {
                Line2D.Float segment = new Line2D.Float((float)previousPoint[0], previousPoint[1], currentPoint[0], currentPoint[1]);
                double distToSegment = segment.ptSegDist(p);
                if (closestSoFar == -1.0 || distToSegment < closestSoFar) {
                    closestSoFar = distToSegment;
                }
            }
            if (previousPoint == null) {
                previousPoint = new float[]{currentPoint[0], currentPoint[1]};
            }
            it.next();
        }
        return closestSoFar;
    }

    public static String stringFromGeneralPath(GeneralPath path) {
        StringBuffer result = new StringBuffer();
        PathIterator it = path.getPathIterator(new AffineTransform());
        float[] point = new float[2];
        while (!it.isDone()) {
            int segType = it.currentSegment(point);
            if (segType == 1) {
                result.append(" ");
                result.append((int)point[0]);
                result.append(",");
                result.append((int)point[1]);
            } else if (segType == 0) {
                result.append((int)point[0]);
                result.append(",");
                result.append((int)point[1]);
            } else {
                if (segType == 4) {
                    return result.toString();
                }
                System.out.println("GraphicsTool -> GraphicsTool 23846 unknown segType: " + segType);
            }
            it.next();
        }
        return result.toString();
    }

    public static String stringFromGeneralPath(GeneralPath path, int height) {
        StringBuffer result = new StringBuffer();
        PathIterator it = path.getPathIterator(new AffineTransform());
        float[] point = new float[2];
        while (!it.isDone()) {
            int segType = it.currentSegment(point);
            if (segType == 1) {
                result.append(" ");
                result.append((int)point[0]);
                result.append(",");
                result.append(height - (int)point[1]);
            } else if (segType == 0) {
                result.append((int)point[0]);
                result.append(",");
                result.append(height - (int)point[1]);
            } else {
                if (segType == 4) {
                    return result.toString();
                }
                System.out.println("GraphicsTool -> GraphicsTool 23846 unknown segType: " + segType);
            }
            it.next();
        }
        return result.toString();
    }

    public static Color getNextColor() {
        Color[] possibleColors = new Color[]{new Color(0.0f, 0.0f, 0.5f, 0.77f), new Color(0.5f, 0.0f, 0.0f, 0.77f), new Color(0.0f, 0.5f, 0.0f, 0.77f), new Color(1.0f, 1.0f, 0.0f, 0.77f), new Color(1.0f, 0.0f, 0.75f, 0.77f), new Color(0.4f, 0.4f, 0.4f, 0.77f), new Color(1.0f, 0.5f, 0.0f, 0.77f), new Color(0.0f, 0.75f, 1.0f, 0.77f), new Color(0.5f, 0.0f, 0.5f, 0.77f), new Color(0.7f, 0.7f, 0.7f, 0.77f), new Color(1.0f, 0.0f, 0.0f, 0.77f), new Color(0.0f, 1.0f, 0.0f, 0.77f), new Color(0.0f, 0.0f, 0.0f, 0.77f)};
        Color next = possibleColors[nextColorCounter];
        nextColorCounter = (nextColorCounter + 1) % possibleColors.length;
        return next;
    }

    public static Color getContrastingBase(Color versus) {
        float brightness = Color.RGBtoHSB(versus.getRed(), versus.getGreen(), versus.getBlue(), null)[2];
        if ((double)brightness > 0.5) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public static Color getContrastingBase(Color versus, float brightnessForBlack) {
        if (versus == null) {
            return Color.BLACK;
        }
        float brightness = Color.RGBtoHSB(versus.getRed(), versus.getGreen(), versus.getBlue(), null)[2];
        if (brightness > brightnessForBlack) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public static Point getCenterOfShape(Shape shape) {
        Rectangle bounds = shape.getBounds();
        Point center = new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
        if (shape.contains(center)) {
            return center;
        }
        center = new Point(bounds.x + (int)(bounds.getWidth() / 4.0), (int)bounds.getCenterY());
        if (shape.contains(center)) {
            return center;
        }
        center = new Point(bounds.x + (int)(bounds.getWidth() * 3.0 / 4.0), (int)bounds.getCenterY());
        if (shape.contains(center)) {
            return center;
        }
        center = new Point((int)bounds.getCenterX(), bounds.y + (int)(bounds.getHeight() / 4.0));
        if (shape.contains(center)) {
            return center;
        }
        center = new Point((int)bounds.getCenterX(), bounds.y + (int)(bounds.getHeight() * 3.0 / 4.0));
        if (shape.contains(center)) {
            return center;
        }
        return new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
    }

    public static String stringFromColor(Color color) {
        if (color == null) {
            SS.debug("GraphicsTool.stringFromColor(null) !! Sending back BLACK");
            return GraphicsTool.stringFromColor(Color.BLACK);
        }
        return (double)color.getRed() / 255.0 + "/" + (double)color.getGreen() / 255.0 + "/" + (double)color.getBlue() / 255.0;
    }

    public static Color colorFromString(String defsString) {
        if (defsString == null) {
            return null;
        }
        try {
            StringTokenizer tok = new StringTokenizer(defsString, "/");
            return new Color(Float.parseFloat(tok.nextToken()), Float.parseFloat(tok.nextToken()), Float.parseFloat(tok.nextToken()), 1.0f);
        }
        catch (Exception e) {
            SS.debug("GraphicsTool.colorFromString failed with input of: " + defsString + " -> " + e);
            return Color.BLACK;
        }
    }

    public static Point pointFromString(String loc) {
        if (loc == null || "null".equals(loc)) {
            return null;
        }
        int commaLoc = loc.indexOf(",");
        if (commaLoc == -1) {
            SS.debug("GraphicsTool.pointFromString(" + loc + ") failed.");
            Thread.dumpStack();
            return new Point(0, 0);
        }
        return new Point(Integer.parseInt(loc.substring(0, commaLoc)), Integer.parseInt(loc.substring(commaLoc + 1)));
    }

    public static String stringFromPoint(Point p) {
        if (p == null) {
            return null;
        }
        return p.x + "," + p.y;
    }

    public static void drawHelperText(Graphics2D g, String helperText, int height) {
        if (helperText == null) {
            return;
        }
        FontMetrics fontMetrics = g.getFontMetrics();
        String[] lines = new String[GraphicsTool.countLines(helperText)];
        int pos = 0;
        int boxWidth = 0;
        for (int i = 0; i < lines.length; ++i) {
            int end = helperText.indexOf(10, pos);
            lines[i] = end != -1 ? helperText.substring(pos, end) : helperText.substring(pos);
            pos += lines[i].length() + 1;
            boxWidth = Math.max(boxWidth, fontMetrics.stringWidth(lines[i]));
        }
        int padding = 4;
        int xpadding = 20;
        int boxHeight = fontMetrics.getHeight() * lines.length + padding;
        int x = 1;
        int y = height - 6 - fontMetrics.getHeight() * lines.length;
        Rectangle2D.Double textBox = new Rectangle2D.Double(x, y, boxWidth += xpadding, boxHeight);
        g.setStroke(new BasicStroke(1.0f, 1, 1));
        g.setColor(Color.black);
        g.draw(textBox);
        g.setColor(GraphicsTool.transparent(Color.white, 0.75f));
        g.fill(textBox);
        g.setColor(Color.black);
        for (int i = 0; i < lines.length; ++i) {
            g.drawString(lines[i], x + xpadding / 2, y - 1 + fontMetrics.getHeight() * (i + 1));
        }
    }

    public static void drawArrow(Graphics2D g2d, int fromX, int fromY, int toX, int toY, float arrowheadSize, float lineWidth) {
        double aDir = Math.atan2(fromX - toX, fromY - toY);
        g2d.setStroke(new BasicStroke(lineWidth, 0, 0));
        g2d.drawLine(toX + GraphicsTool.xCor(3, aDir), toY + GraphicsTool.yCor(3, aDir), fromX - GraphicsTool.xCor(3, aDir), fromY - GraphicsTool.yCor(3, aDir));
        g2d.setStroke(new BasicStroke(1.0f));
        Polygon tmpPoly = new Polygon();
        int i1 = 12 + (int)(arrowheadSize * 2.0f);
        int i2 = 6 + (int)arrowheadSize;
        tmpPoly.addPoint(toX, toY);
        tmpPoly.addPoint(toX + GraphicsTool.xCor(i1, aDir + 0.5), toY + GraphicsTool.yCor(i1, aDir + 0.5));
        tmpPoly.addPoint(toX + GraphicsTool.xCor(i2, aDir), toY + GraphicsTool.yCor(i2, aDir));
        tmpPoly.addPoint(toX + GraphicsTool.xCor(i1, aDir - 0.5), toY + GraphicsTool.yCor(i1, aDir - 0.5));
        tmpPoly.addPoint(toX, toY);
        g2d.drawPolygon(tmpPoly);
        g2d.fillPolygon(tmpPoly);
    }

    public static int yCor(int len, double dir) {
        return (int)((double)len * Math.cos(dir));
    }

    public static int xCor(int len, double dir) {
        return (int)((double)len * Math.sin(dir));
    }

    public static void drawArrowBetweenPoints(Graphics2D g, Point2D p1, Point2D p2, boolean doubleArrow, int arrowheadSize, int lineWidth) {
        GraphicsTool.drawArrow(g, (int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY(), arrowheadSize, lineWidth);
        if (doubleArrow) {
            GraphicsTool.drawArrow(g, (int)p2.getX(), (int)p2.getY(), (int)p1.getX(), (int)p1.getY(), arrowheadSize, lineWidth);
        }
    }

    public static Point getContainedPointAlongLine(Point from, Point to, Shape shape) {
        double aDir = Math.atan2(to.x - from.x, to.y - from.y);
        int distance = 1;
        Point checkPoint;
        while (!shape.contains(checkPoint = new Point(from.x + GraphicsTool.xCor(distance, aDir), from.y + GraphicsTool.yCor(distance, aDir)))) {
            ++distance;
        }
        return checkPoint;
    }

    public static void drawDoubleArrowConnectingShapes(Graphics2D g, Shape s1, Shape s2, boolean doubleArrow) {
        Point from = GraphicsTool.getCenterOfShape(s1);
        Point to = GraphicsTool.getCenterOfShape(s2);
        double aDir = Math.atan2(to.getX() - from.getX(), to.getY() - from.getY());
        Point midPoint = GraphicsTool.midpoint(from, to);
        int distance = 15;
        from = new Point(midPoint.x - GraphicsTool.xCor(distance, aDir), midPoint.y - GraphicsTool.yCor(distance, aDir));
        to = new Point(midPoint.x + GraphicsTool.xCor(distance, aDir), midPoint.y + GraphicsTool.yCor(distance, aDir));
        GraphicsTool.drawArrowBetweenPoints(g, from, to, doubleArrow, 1, 2);
    }

    public static Point midpoint(Point2D a, Point2D b) {
        int x = (int)((a.getX() + b.getX()) / 2.0);
        int y = (int)((a.getY() + b.getY()) / 2.0);
        return new Point(x, y);
    }

    public static Point2D midpoint2D(Point2D a, Point2D b) {
        double x = (a.getX() + b.getX()) / 2.0;
        double y = (a.getY() + b.getY()) / 2.0;
        return new Point2D.Double(x, y);
    }

    public static void drawDoubleArrowConnectingShapesBAD(Graphics2D g, Shape s1, Shape s2) {
        Point from = new Point();
        Point to = new Point();
        Point midPoint = GraphicsTool.getMidpointBetweenShapes(s1, s2, from, to);
        double aDir = Math.atan2(((Point2D)to).getX() - ((Point2D)from).getX(), ((Point2D)to).getY() - ((Point2D)from).getY());
        int distance = 15;
        from = new Point(midPoint.x + GraphicsTool.xCor(distance, aDir), midPoint.y + GraphicsTool.yCor(distance, aDir));
        to = new Point(midPoint.x - GraphicsTool.xCor(distance, aDir), midPoint.y - GraphicsTool.yCor(distance, aDir));
        GraphicsTool.drawArrowBetweenPoints(g, from, to, true, 1, 2);
    }

    public static Point getMidpointBetweenShapes(Shape s1, Shape s2, Point2D shape1point, Point2D shape2point) {
        float[] point = new float[2];
        float[] point2 = new float[2];
        Point result = null;
        double closestDistance = 1000000.0;
        PathIterator it = s1.getPathIterator(new AffineTransform());
        while (!it.isDone()) {
            int i;
            it.currentSegment(point);
            Point2D.Float p1 = new Point2D.Float(point[0], point[1]);
            int basketSize = 3;
            int basketMiddle = 1;
            float[][] shape2basket = new float[basketSize][2];
            PathIterator it2 = s2.getPathIterator(new AffineTransform());
            for (int i2 = 1; i2 < basketSize; ++i2) {
                it2.currentSegment(shape2basket[i2]);
            }
            float[][] firstPoints = new float[basketSize - 1][2];
            for (i = 0; i < basketSize - 1; ++i) {
                firstPoints[i][0] = shape2basket[i + 1][0];
                firstPoints[i][1] = shape2basket[i + 1][1];
            }
            while (!it2.isDone()) {
                for (i = 0; i < basketSize - 1; ++i) {
                    shape2basket[i][0] = shape2basket[i + 1][0];
                    shape2basket[i][1] = shape2basket[i + 1][1];
                }
                it2.currentSegment(shape2basket[basketSize - 1]);
                double distance = 0.0;
                for (int i3 = 0; i3 < basketSize; ++i3) {
                    distance += p1.distance(new Point2D.Float(shape2basket[i3][0], shape2basket[i3][1]));
                }
                if (distance < closestDistance) {
                    closestDistance = distance;
                    shape1point.setLocation(p1);
                    shape2point.setLocation(new Point2D.Float(shape2basket[basketMiddle][0], shape2basket[basketMiddle][1]));
                    result = GraphicsTool.midpoint(p1, shape2point);
                }
                it2.next();
            }
            for (i = 0; i < basketSize - 1; ++i) {
            }
            it.next();
        }
        return result;
    }

    public static BufferedImage createBufferedImage(int width, int height, int transparency) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, transparency);
    }

    public static GeneralPath resizeShape(Shape shape, double percent) {
        GeneralPath result = new GeneralPath();
        float[] point = new float[2];
        PathIterator it = shape.getPathIterator(new AffineTransform());
        while (!it.isDone()) {
            int segType = it.currentSegment(point);
            if (segType == 1) {
                result.lineTo((float)((double)point[0] * percent), (float)((double)point[1] * percent));
            } else if (segType == 0) {
                result.moveTo((float)((double)point[0] * percent), (float)((double)point[1] * percent));
            } else if (segType == 4) {
                result.closePath();
            } else {
                System.out.println("GraphicsTool -> GraphicsTool.resizeShape() unknown segType: " + segType);
            }
            it.next();
        }
        return result;
    }

    public static double getResizePercentToFitInsideDimension(int startingWidth, int startingHeight, double fitIntoWidth, double fitIntoHeight) {
        double widthPercentResize = fitIntoWidth / (double)startingWidth;
        double heightPercentResize = fitIntoHeight / (double)startingHeight;
        return Math.min(widthPercentResize, heightPercentResize);
    }

    public static void drawLines(Graphics2D g, List lines, Color defaultColor) {
        if (lines == null) {
            return;
        }
        for (int i = 0; i < lines.size(); ++i) {
            ExtraLine line = (ExtraLine)lines.get(i);
            if (line.color != null) {
                g.setColor(line.color);
            } else {
                g.setColor(defaultColor);
            }
            line.draw(g);
        }
    }

    public static BufferedImage toBufferedImage(Image image, GraphicsConfiguration gc) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        BufferedImage result = GraphicsTool.createBufferedImage(w, h, 1);
        Graphics2D g = result.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return result;
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public static void drawShadowedString(Graphics2D g, String text, int x, int y) {
        g.setColor(new Color(0, 0, 0, 128));
        g.drawString(text, x + 2, y + 2);
        g.setColor(new Color(220, 220, 220));
        g.drawString(text, x, y);
    }

    public static void drawEngravedString(Graphics2D g, String text, int x, int y) {
        g.setColor(new Color(220, 220, 220, 128));
        g.drawString(text, x + 1, y + 1);
        g.setColor(Color.BLACK);
        g.drawString(text, x, y);
    }

    public static void drawOutlinedString(Graphics2D g, String text, int x, int y) {
        g.setColor(new Color(220, 220, 220, 128));
        g.drawString(text, x + 1, y + 1);
        g.drawString(text, x + 1, y - 1);
        g.drawString(text, x - 1, y + 1);
        g.drawString(text, x - 1, y - 1);
        g.setColor(Color.BLACK);
        g.drawString(text, x, y);
    }

    public static String wrapString(String text, int pixelWidth, Font font) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        if (fontMetrics.stringWidth(text) < pixelWidth) {
            return text;
        }
        int lastLength = text.length();
        String shorterText = StringTool.stripLastWord(text);
        while (fontMetrics.stringWidth(shorterText) > pixelWidth) {
            if (shorterText.length() == lastLength) {
                if (lastLength == text.length()) {
                    return text;
                }
                return shorterText + "\n" + GraphicsTool.wrapString(text.substring(shorterText.length() + 1), pixelWidth, font);
            }
            lastLength = shorterText.length();
            shorterText = StringTool.stripLastWord(shorterText);
        }
        return shorterText + "\n" + GraphicsTool.wrapString(text.substring(shorterText.length() + 1), pixelWidth, font);
    }

    public static void drawArrowImageConnectingShapes(Graphics2D g, Shape s1, Shape s2, boolean doubleArrow) {
        Point from = GraphicsTool.getCenterOfShape(s1);
        Point to = GraphicsTool.getCenterOfShape(s2);
        GraphicsTool.drawArrowImageConnectingPoints(g, from, to, doubleArrow);
    }

    public static void drawArrowImageConnectingPoints(Graphics2D g, Point from, Point to, boolean doubleArrow) {
        if (from.x < 150 && to.x > 700) {
            to = new Point(0, to.y);
        } else if (to.x < 150 && from.x > 700) {
            to = new Point(from.x + 200, to.y);
        }
        double aDir = Math.atan2(to.getY() - from.getY(), to.getX() - from.getX());
        Point2D midPoint = GraphicsTool.midpoint2D(from, to);
        if (doubleArrow) {
            GraphicsTool.drawArrowImageDouble(g, midPoint.getX(), midPoint.getY(), aDir);
        } else {
            GraphicsTool.drawArrowImage(g, midPoint.getX(), midPoint.getY(), aDir);
        }
    }

    public static void drawArrowImage(Graphics2D g, double x, double y, double aDir) {
        AffineTransform at = AffineTransform.getTranslateInstance(x - 17.0, y - 9.0);
        at.concatenate(AffineTransform.getRotateInstance(aDir, 17.0, 9.0));
        g.drawImage(GraphicsTool.getManagedImage("arrow05.png"), at, null);
    }

    public static void drawArrowImageDouble(Graphics2D g, double x, double y, double aDir) {
        AffineTransform at = AffineTransform.getTranslateInstance(x - 20.0, y - 9.0);
        at.concatenate(AffineTransform.getRotateInstance(aDir, 20.0, 9.0));
        g.drawImage(GraphicsTool.getManagedImage("arrow05_double.png"), at, null);
    }

    public static BufferedImage convertToBufferedImage(Image im) {
        BufferedImage bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 1);
        Graphics bg = bi.getGraphics();
        bg.drawImage(im, 0, 0, null);
        bg.dispose();
        return bi;
    }

    public static JPanel getNonOpaqueJPanel() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        return panel;
    }

    public static JPanel getNonOpaqueJPanel(LayoutManager lm) {
        JPanel panel = new JPanel(lm);
        panel.setOpaque(false);
        return panel;
    }

    public static List getEllipsePoints(int x, int y, double a, double b, int numberOfPoints) {
        double theta = 0.0;
        double deltheta = Math.PI * 2 / (double)numberOfPoints;
        Vector<Point> points = new Vector<Point>();
        for (int i = 0; i < numberOfPoints; ++i) {
            Point p = new Point(x + (int)(a * Math.cos(theta)), y + (int)(b * Math.sin(theta)));
            points.add(p);
            theta += deltheta;
        }
        return points;
    }

    public static GeneralPath getGeneralPathFromXML(String pathXML) {
        String poly;
        GeneralPath shape = new GeneralPath();
        int s = 0;
        while ((poly = XMLTool.extract("polygon", pathXML, s)) != null) {
            StringTokenizer tok = new StringTokenizer(poly, " ,");
            int firstX = Integer.parseInt(tok.nextToken());
            int firstY = Integer.parseInt(tok.nextToken());
            shape.moveTo(firstX, firstY);
            while (tok.hasMoreTokens()) {
                shape.lineTo(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
            }
            shape.lineTo(firstX, firstY);
            shape.closePath();
            ++s;
        }
        return shape;
    }

    public static GeneralPath generalPathFromString(String pathXML) {
        GeneralPath shape = new GeneralPath();
        String poly = pathXML;
        StringTokenizer tok = new StringTokenizer(poly, " ,");
        int firstX = Integer.parseInt(tok.nextToken());
        int firstY = Integer.parseInt(tok.nextToken());
        shape.moveTo(firstX, firstY);
        while (tok.hasMoreTokens()) {
            shape.lineTo(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
        }
        shape.lineTo(firstX, firstY);
        shape.closePath();
        return shape;
    }

    public static Point getCenterOfGeneralPath(GeneralPath path) {
        Rectangle bounds = path.getBounds();
        Point center = new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
        if (path.contains(center)) {
            return center;
        }
        center = new Point(bounds.x + (int)(bounds.getWidth() / 4.0), (int)bounds.getCenterY());
        if (path.contains(center)) {
            return center;
        }
        center = new Point(bounds.x + (int)(bounds.getWidth() * 3.0 / 4.0), (int)bounds.getCenterY());
        if (path.contains(center)) {
            return center;
        }
        center = new Point((int)bounds.getCenterX(), bounds.y + (int)(bounds.getHeight() / 4.0));
        if (path.contains(center)) {
            return center;
        }
        center = new Point((int)bounds.getCenterX(), bounds.y + (int)(bounds.getHeight() * 3.0 / 4.0));
        if (path.contains(center)) {
            return center;
        }
        return new Point((int)bounds.getCenterX(), (int)bounds.getCenterY());
    }

    public static Polygon getThickArrowPolygon(Point from, Point to) {
        return GraphicsTool.getThickArrowPolygon(from.x, from.y, to.x, to.y);
    }

    public static Polygon getThickArrowPolygon(int fromX, int fromY, int toX, int toY) {
        int l1 = 24;
        double d1 = 0.45;
        int l2 = 18;
        double d2 = 0.3;
        int l22 = 20;
        double d22 = 0.16;
        int l3 = 12;
        double d3 = 0.5;
        double aDir = Math.atan2(fromX - toX, fromY - toY);
        Polygon poly = new Polygon();
        poly.addPoint(toX, toY);
        poly.addPoint(toX + GraphicsTool.xCor(l1, aDir + d1), toY + GraphicsTool.yCor(l1, aDir + d1));
        poly.addPoint(toX + GraphicsTool.xCor(l2, aDir + d2), toY + GraphicsTool.yCor(l2, aDir + d2));
        poly.addPoint(toX + GraphicsTool.xCor(l22, aDir + d22), toY + GraphicsTool.yCor(l22, aDir + d22));
        poly.addPoint(fromX + GraphicsTool.xCor(l3, aDir + d3), fromY + GraphicsTool.yCor(l3, aDir + d3));
        poly.addPoint(fromX, fromY);
        poly.addPoint(fromX + GraphicsTool.xCor(l3, aDir - d3), fromY + GraphicsTool.yCor(l3, aDir - d3));
        poly.addPoint(toX + GraphicsTool.xCor(l22, aDir - d22), toY + GraphicsTool.yCor(l22, aDir - d22));
        poly.addPoint(toX + GraphicsTool.xCor(l2, aDir - d2), toY + GraphicsTool.yCor(l2, aDir - d2));
        poly.addPoint(toX + GraphicsTool.xCor(l1, aDir - d1), toY + GraphicsTool.yCor(l1, aDir - d1));
        poly.addPoint(toX, toY);
        return poly;
    }

    public static void drawThickArrow(Graphics2D g2d, int fromX, int fromY, int toX, int toY) {
        Polygon poly = GraphicsTool.getThickArrowPolygon(fromX, fromY, toX, toY);
        g2d.fillPolygon(poly);
        g2d.setColor(THICK_ARROW_COLOR);
        g2d.drawPolygon(poly);
    }

    public static JLabel getJLabelWithFont(String foo, Font font) {
        JLabel label = new JLabel(foo);
        label.setFont(font);
        return label;
    }

    public static Image getManagedImage(String filename) {
        Object stored;
        if (managedImages == null) {
            managedImages = new Hashtable();
        }
        if ((stored = managedImages.get(filename)) != null) {
            return (Image)stored;
        }
        Image loaded = GraphicsTool.getImageFromJAR(filename);
        managedImages.put(filename, loaded);
        return loaded;
    }

    public static void releaseManagedImage(String filename) {
        if (managedImages != null) {
            managedImages.remove(filename);
        }
    }

    public static void releaseManagedImages() {
        Enumeration e = managedImages.keys();
        while (e.hasMoreElements()) {
            String object_key = (String)e.nextElement();
            managedImages.remove(object_key);
        }
    }

    public static void releaseManagedImagesColored() {
        Enumeration e = managedImagesColored.keys();
        while (e.hasMoreElements()) {
            String object_key = (String)e.nextElement();
            managedImagesColored.remove(object_key);
        }
    }

    public static void printManagedImageList() {
        SS.debug("managedImage List:");
        Enumeration e = managedImages.keys();
        while (e.hasMoreElements()) {
            String object_key = (String)e.nextElement();
            Image object = (Image)managedImages.get(object_key);
            SS.debug("managedImage = " + object);
        }
        SS.debug("managedImage List End.");
    }

    public static Image getManagedImageColored(String filename, Color color, float transparent) {
        return GraphicsTool.getManagedImageColored(filename, GraphicsTool.transparent(color, transparent));
    }

    public static Image getManagedImageColored(String filename, Color color) {
        Object stored;
        if (managedImagesColored == null) {
            managedImagesColored = new Hashtable();
        }
        if ((stored = managedImagesColored.get(filename + color.hashCode())) != null) {
            return (Image)stored;
        }
        Image loaded = GraphicsTool.getImageFromJAR(filename);
        loaded = GraphicsTool.paintColorOverImage(loaded, color);
        managedImagesColored.put(filename + color.hashCode(), loaded);
        return loaded;
    }

    public static Image paintColorOverImage(Image sourceImage, Color paintColor) {
        return GraphicsTool.paintColorOverImage(sourceImage.getWidth(null), sourceImage.getHeight(null), sourceImage, paintColor);
    }

    public static Image paintColorOverImage(int width, int height, Image sourceImage, Color paintColor) {
        BufferedImage coloredImage = GraphicsTool.createBufferedImage(width, height, 3);
        Graphics2D imageG = coloredImage.createGraphics();
        imageG.drawImage(sourceImage, 0, 0, null);
        imageG.setComposite(AlphaComposite.SrcAtop);
        imageG.setColor(paintColor);
        imageG.fillRect(0, 0, width, height);
        imageG.dispose();
        return coloredImage;
    }

    public static Image paintColorOverImage(int width, int height, Image sourceImage, Color paintColor, float transparent) {
        return GraphicsTool.paintColorOverImage(width, height, sourceImage, GraphicsTool.transparent(paintColor, transparent));
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public static Image getBubbleFor(int count, Color color) {
        float transLevel = 0.55f;
        int showNum = count;
        if (showNum < 10) {
            return GraphicsTool.getManagedImageColored("bubbleSource1.png", color, transLevel);
        }
        if (showNum < 100) {
            return GraphicsTool.getManagedImageColored("bubbleSource2.png", color, transLevel);
        }
        if (showNum < 1000) {
            return GraphicsTool.getManagedImageColored("bubbleSource3.png", color, transLevel);
        }
        if (showNum < 10000) {
            return GraphicsTool.getManagedImageColored("bubbleSource4.png", color, transLevel);
        }
        if (showNum < 100000) {
            return GraphicsTool.getManagedImageColored("bubbleSource5.png", color, transLevel);
        }
        if (showNum < 1000000) {
            return GraphicsTool.getManagedImageColored("bubbleSource4.png", color, transLevel);
        }
        return GraphicsTool.getManagedImageColored("bubbleSource5.png", color, transLevel);
    }

    public static Font getSymbolFont() {
        if (!SS.isMacintosh && !SS.isVista) {
            return GraphicsTool.getDejaFontSized(14);
        }
        return null;
    }

    public static Font getSymbolFontForBonus(Graphics2D g, int bonus) {
        int positiveBonus = Math.abs(bonus);
        if (!SS.isMacintosh && !SS.isVista) {
            return GraphicsTool.getDejaFontSized(10 + positiveBonus * 2);
        }
        return new Font(g.getFont().getName(), 0, 10 + positiveBonus * 2);
    }

    public static Font getDejaFontSized(int pointSize) {
        Font vFont;
        Object font = fontCache.get(new Integer(pointSize));
        if (font != null) {
            return (Font)font;
        }
        try {
            vFont = Font.createFont(0, GraphicsTool.class.getResourceAsStream("/DejaVuSans.ttf"));
            vFont = vFont.deriveFont(0, pointSize);
        }
        catch (Exception e) {
            SS.debug("Unable to load the desired font: " + e);
            vFont = new Font("Arial", 0, pointSize);
        }
        fontCache.put(new Integer(pointSize), vFont);
        return vFont;
    }

    public static Dimension getDimensionOfText(String text, FontMetrics fontMetrics) {
        String[] lines = new String[GraphicsTool.countLines(text)];
        int pos = 0;
        int boxWidth = 0;
        for (int i = 0; i < lines.length; ++i) {
            int end = text.indexOf(10, pos);
            lines[i] = end != -1 ? text.substring(pos, end) : text.substring(pos);
            pos += lines[i].length() + 1;
            boxWidth = Math.max(boxWidth, fontMetrics.stringWidth(lines[i]));
        }
        int fontHeight = fontMetrics.getHeight();
        int boxHeight = fontHeight * lines.length;
        return new Dimension(boxWidth, boxHeight);
    }

    static {
        nextColorCounter = 0;
        fontCache = new HashMap();
    }
}

