/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class FileTool {
    public static String fileToString(String filename) {
        try {
            return FileTool.fileToString(new FileReader(filename));
        }
        catch (Exception e) {
            System.out.println("FileTool.fileToString() caught an exception: " + e);
            return "";
        }
    }

    public static String fileToString(File aFile) {
        try {
            return FileTool.fileToString(new FileReader(aFile));
        }
        catch (Exception e) {
            System.out.println("FileTool.fileToString() caught an exception: " + e);
            return "";
        }
    }

    private static String fileToString(FileReader reader) {
        try {
            String temp;
            BufferedReader in = new BufferedReader(reader);
            StringBuffer inputBuffer = new StringBuffer();
            while ((temp = in.readLine()) != null) {
                inputBuffer.append(temp);
                inputBuffer.append("\n");
            }
            in.close();
            return inputBuffer.toString();
        }
        catch (Exception e) {
            System.out.println("FileTool.fileToString() caught an exception: " + e);
            return "";
        }
    }

    public static boolean copyFile(String from, String to) {
        byte[] buf = new byte[512];
        try {
            FileInputStream in = new FileInputStream(from);
            FileOutputStream out = new FileOutputStream(to);
            int numRead = in.read(buf);
            while (numRead > 0) {
                out.write(buf, 0, numRead);
                numRead = in.read(buf);
            }
        }
        catch (Throwable e) {
            System.out.println("Error copying file " + from + " to " + to + ": " + e);
            return false;
        }
        return true;
    }

    public static void copyFolder(String from, String to) {
        if (from.endsWith(".DS_Store")) {
            return;
        }
        File destFolder = new File(to);
        destFolder.mkdirs();
        File[] files = new File(from).listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileTool.copyFolder(from + File.separator + files[i].getName(), to + File.separator + files[i].getName());
                continue;
            }
            String destPath = to + File.separator + files[i].getName();
            File destFile = new File(destPath);
            if (destFile.exists()) {
                destFile.delete();
            }
            FileTool.copyFile(files[i].getPath(), to + File.separator + files[i].getName());
        }
    }

    public static void chmod(String permissions, String path) throws IOException {
        String[] commands = new String[]{"chmod", permissions, path};
        Process pr = Runtime.getRuntime().exec(commands);
        BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        while (in.readLine() != null) {
        }
    }

    public static void hideWindowsFile(String path, boolean hidden) throws IOException {
        String[] commands = new String[]{"attrib", hidden ? "+h" : "-h", path};
        Process pr = Runtime.getRuntime().exec(commands);
        BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        while (in.readLine() != null) {
        }
    }

    public static void stringToFile(String content, String path) throws Exception {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8")));
        out.print(content);
        out.flush();
        out.close();
    }
}

