/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.XMLTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.StringTokenizer;

public class ExtraLine {
    private GeneralPath shape;
    public Color color;
    public int width = 1;
    public boolean above = false;
    private GeneralPath shapeOriginal;

    public ExtraLine(String xml) {
        String position = XMLTool.extract("position", xml);
        StringTokenizer tok = new StringTokenizer(position, " ,");
        this.shape = new GeneralPath();
        this.shape.moveTo(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
        while (tok.hasMoreTokens()) {
            this.shape.lineTo(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
        }
        this.color = GraphicsTool.colorFromString(XMLTool.extract("color", xml));
        String widthString = XMLTool.extract("width", xml);
        if (widthString != null) {
            this.width = Integer.parseInt(widthString);
        }
        if ("true".equals(XMLTool.extract("above", xml))) {
            this.above = true;
        }
    }

    public ExtraLine(Point from, Point to, int width, Color color, boolean above) {
        this.shape = new GeneralPath();
        this.shape.moveTo(from.x, from.y);
        this.shape.lineTo(to.x, to.y);
        this.color = color;
        this.width = width;
        this.above = above;
    }

    public void draw(Graphics2D g) {
        g.setStroke(new BasicStroke(this.width));
        g.draw(this.shape);
    }

    public void flipY(int height) {
        this.shape = GraphicsTool.flipY(this.shape, height);
    }

    public double distanceToPoint(Point p) {
        return GraphicsTool.distanceFromPointToGeneralPath(p, this.shape);
    }

    public String getXML(int height) {
        StringBuffer result = new StringBuffer();
        result.append("<line><position>");
        result.append(GraphicsTool.stringFromGeneralPath(this.shape, height));
        result.append("</position>");
        if (this.color != null) {
            result.append("<color>");
            result.append(GraphicsTool.stringFromColor(this.color));
            result.append("</color>");
        }
        if (this.width != 1) {
            result.append("<width>");
            result.append(this.width);
            result.append("</width>");
        }
        if (this.above) {
            result.append("<above>true</above>");
        }
        result.append("</line>");
        return result.toString();
    }

    public void resize(double percent) {
        if (this.shapeOriginal == null) {
            this.shapeOriginal = this.shape;
        }
        this.shape = GraphicsTool.resizeShape(this.shapeOriginal, percent);
    }

    public String toString() {
        return "<ExtraLine width:" + this.width + " above:" + this.above + " shape:" + this.shape + ">";
    }

    public Point from() {
        PathIterator it = this.shape.getPathIterator(new AffineTransform());
        float[] point = new float[2];
        while (!it.isDone()) {
            int segType = it.currentSegment(point);
            if (segType == 0) {
                return new Point((int)point[0], (int)point[1]);
            }
            it.next();
        }
        return null;
    }

    public Point to() {
        PathIterator it = this.shape.getPathIterator(new AffineTransform());
        float[] point = new float[2];
        while (!it.isDone()) {
            int segType = it.currentSegment(point);
            if (segType == 1) {
                return new Point((int)point[0], (int)point[1]);
            }
            it.next();
        }
        return null;
    }
}

