/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import java.lang.reflect.Method;
import javax.swing.SwingUtilities;

public class EventThread {
    public static void runInEventThread(Runnable runnable) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Throwable e) {
                System.out.println("EventThread.runInEventThread(" + runnable + ") caught an exception");
                e.printStackTrace();
            }
        } else {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                System.out.println("EventThread.runInEventThread-path2(" + runnable + ") caught an exception");
                e.printStackTrace();
            }
        }
    }

    public static void callMethod(Object targetObject, String methodName) {
        final Object target = targetObject;
        final String methodToCall = methodName;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Class<?> cls = target.getClass();
                    Method method = cls.getMethod(methodToCall, new Class[0]);
                    method.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void callMethod(Object targetObject, String methodName, Object parameter) {
        final Object target = targetObject;
        final String methodToCall = methodName;
        final Object methodParam = parameter;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Class<?> cls = target.getClass();
                    Method method = cls.getMethod(methodToCall, Object.class);
                    method.invoke(target, methodParam);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void callMethod(Object targetObject, String methodName, Object parameter, int delayInMillis) {
        final Object target = targetObject;
        final String methodToCall = methodName;
        final Object methodParam = parameter;
        final int delay = delayInMillis;
        new Thread("EventThread-callMethod"){

            public void run() {
                try {
                    Thread.sleep(delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        try {
                            Class<?> cls = target.getClass();
                            Method method = cls.getMethod(methodToCall, Object.class);
                            method.invoke(target, methodParam);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }.start();
    }
}

