/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import java.io.File;
import java.util.Vector;

public class DirectoryTool {
    public static boolean containsFile(String dirPath, String filename) {
        return DirectoryTool.containsFile(new File(dirPath), filename);
    }

    public static boolean containsFile(File dir, String filename) {
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            String nextfilename = files[i].getName();
            if (!(files[i].isDirectory() ? DirectoryTool.containsFile(files[i], filename) : nextfilename.equals(filename))) continue;
            return true;
        }
        return false;
    }

    public static String[] listFilesWithSuffix(String dirPath, String suffix) {
        return DirectoryTool.listFilesWithSuffix(new File(dirPath), suffix, "");
    }

    public static String[] listFilesWithSuffix(File dir, String suffix, String basePath) {
        Vector<String> result = new Vector<String>();
        int suffixLength = suffix.length();
        File[] files = dir.listFiles();
        if (files == null) {
            return new String[0];
        }
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getName();
            if (files[i].isDirectory()) {
                String[] recurseResult = DirectoryTool.listFilesWithSuffix(files[i], suffix, basePath + filename + File.separator);
                for (int j = 0; j < recurseResult.length; ++j) {
                    result.add(recurseResult[j]);
                }
                continue;
            }
            if (!filename.endsWith(suffix)) continue;
            result.add(basePath + filename.substring(0, filename.length() - suffixLength));
        }
        Object[] arrayReturn = new String[result.size()];
        result.copyInto(arrayReturn);
        return arrayReturn;
    }

    public static void deleteFilesWithSuffix(File dir, String suffix) {
        if (dir == null || suffix == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int suffixLength = suffix.length();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                DirectoryTool.deleteFilesWithSuffix(files[i], suffix);
                continue;
            }
            if (!files[i].getName().endsWith(suffix)) continue;
            files[i].delete();
        }
    }

    public static boolean deleteFile(String dirPath, String filename) {
        return DirectoryTool.deleteFile(new File(dirPath), filename);
    }

    public static boolean deleteFile(File dir, String filename) {
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            String nextfilename = files[i].getName();
            if (files[i].isDirectory()) {
                if (!DirectoryTool.deleteFile(files[i], filename)) continue;
                return true;
            }
            if (!nextfilename.equals(filename)) continue;
            files[i].delete();
            return true;
        }
        return false;
    }

    public static int countFilesWithPrefixAndSuffix(String dir, String prefix, String suffix) {
        int count = 0;
        File resourcesDir = new File(dir);
        String[] filenames = resourcesDir.list();
        for (int i = 0; i < filenames.length; ++i) {
            if (!filenames[i].startsWith(prefix) || !filenames[i].endsWith(suffix)) continue;
            ++count;
        }
        return count;
    }

    public static void printDirectoryTree(File directory) {
        if (directory != null && directory.isDirectory()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    DirectoryTool.printDirectoryTree(files[i]);
                    continue;
                }
                System.out.println(files[i].getPath());
            }
        }
    }

    public static void deleteDirectoryTree(File directory) {
        if (directory != null && directory.isDirectory()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    DirectoryTool.deleteDirectoryTree(files[i]);
                    continue;
                }
                files[i].delete();
            }
            directory.delete();
        }
    }
}

