/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.tools;

import com.sillysoft.tools.SS;
import java.io.File;
import net.roydesign.mac.MRJAdapter;

public class DesktopTool {
    private static String applicationName;
    private static String knownBundleResource;
    private static String supportFolderMemory;
    private static boolean headless;

    public static void initDesktopTool(String applicationName_Set, String knownBundleResource_Set, boolean headless_set) {
        applicationName = applicationName_Set;
        knownBundleResource = knownBundleResource_Set;
        headless = headless_set;
    }

    public static String supportFolderPathExecutableSafe() {
        if (SS.isWindows) {
            String testPath = DesktopTool.supportFolderPath();
            testPath = testPath.substring(0, testPath.length() - 8);
            return testPath;
        }
        return DesktopTool.supportFolderPath();
    }

    public static String supportFolderPath() {
        if (applicationName == null) {
            applicationName = "Lux";
        }
        if (SS.isMacintosh) {
            return System.getProperty("user.home") + "/Library/Application Support/" + applicationName + "/";
        }
        if (supportFolderMemory == null) {
            String jarPath = DesktopTool.jarLocation();
            try {
                String jarDir;
                if (SS.isWindows) {
                    jarDir = jarPath.substring(1, jarPath.lastIndexOf(47) + 1);
                    jarDir = jarDir.replaceAll("%20", " ");
                    jarDir = jarDir.replaceAll("/", "\\\\");
                    supportFolderMemory = jarDir + "Support" + File.separator;
                } else {
                    jarDir = jarPath.substring(0, jarPath.lastIndexOf(47));
                    supportFolderMemory = jarDir + File.separator + "Support" + File.separator;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            File supportFolder = new File(supportFolderMemory + "Themes");
            if (!supportFolder.exists()) {
                String testPath = System.getProperty("user.dir") + File.separator + "Support" + File.separator;
                supportFolder = new File(testPath + "Themes");
                if (supportFolder.exists()) {
                    supportFolderMemory = testPath;
                } else {
                    testPath = "C:" + File.separator + "Program Files" + File.separator + applicationName + File.separator + "Support" + File.separator;
                    supportFolder = new File(testPath + "Themes");
                    if (supportFolder.exists()) {
                        supportFolderMemory = testPath;
                    } else {
                        testPath = "F:" + File.separator + "Program Files" + File.separator + applicationName + File.separator + "Support" + File.separator;
                        supportFolder = new File(testPath + "Themes");
                        if (supportFolder.exists()) {
                            supportFolderMemory = testPath;
                        } else {
                            testPath = System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support" + File.separator + applicationName + File.separator;
                            supportFolder = new File(testPath + "Themes");
                            if (supportFolder.exists()) {
                                supportFolderMemory = testPath;
                            } else {
                                supportFolderMemory = System.getProperty("user.dir") + File.separator + "Support" + File.separator;
                                System.out.println("ALERT! " + applicationName + " has failed to find its 'Support' folder. Normally this folder should be where you installed " + applicationName + ". Perhaps your installation is screwed up? Or you are running on a system that " + applicationName + " hasn't been tested on? " + applicationName + " is going to go ahead and use '" + supportFolderMemory + "' as its Support folder. This will likely mean that you will not have any maps, themes, or other plugins. You will also probably not be able to register " + applicationName + ". Please contact lux@sillysoft.net to obtain assistance.");
                            }
                        }
                    }
                }
            }
        }
        return supportFolderMemory;
    }

    public static String modernResourcesLocation() {
        if (SS.isMacintosh) {
            if (!headless) {
                try {
                    File knownResource = MRJAdapter.getBundleResource((String)knownBundleResource);
                    return knownResource.getParent() + File.separator + "Java" + File.separator;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            System.out.println("DesktopTool OSX is guessing about modernResourcesLocation(): " + DesktopTool.jarLocation().substring(0, DesktopTool.jarLocation().length() - 11).replaceAll("%20", " "));
            return DesktopTool.jarLocation().substring(0, DesktopTool.jarLocation().length() - 11).replaceAll("%20", " ");
        }
        return null;
    }

    public static String bundleResourcesLocation() {
        if (SS.isMacintosh) {
            if (!headless) {
                try {
                    File knownResource = MRJAdapter.getBundleResource((String)knownBundleResource);
                    return knownResource.getParent() + File.separator;
                }
                catch (Exception e) {
                    System.out.println("DesktopTool OSX is guessing about bundleResourcesLocation(): " + DesktopTool.jarLocation().substring(0, DesktopTool.jarLocation().length() - 16).replaceAll("%20", " "));
                }
            }
            return DesktopTool.jarLocation().substring(0, DesktopTool.jarLocation().length() - 16).replaceAll("%20", " ");
        }
        String support = DesktopTool.supportFolderPath();
        int pos = support.lastIndexOf(File.separator + "Support");
        String installFolder = "";
        if (pos != -1) {
            installFolder = support.substring(0, pos);
        }
        String result = installFolder + File.separator + "docs" + File.separator;
        return result;
    }

    public static String jarLocation() {
        String fullClassName = DesktopTool.class.getName();
        String smallName = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String classLocation = DesktopTool.class.getResource(smallName + ".class").toString();
        classLocation = classLocation.substring(9, classLocation.lastIndexOf(33));
        return classLocation;
    }

    public static String savedGameDir() {
        return DesktopTool.supportFolderPath() + "SavedGames" + File.separator;
    }
}

