/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.util;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.util.CountryElement;

public class CountryStack {
    protected CountryElement start = null;

    public void push(Country country) {
        this.pushWithValue(country, 0);
    }

    public void pushWithValue(Country country, int value) {
        CountryElement newElement = new CountryElement(country, value);
        if (this.start == null) {
            this.start = newElement;
        } else if (value <= this.start.getValue()) {
            newElement.setNext(this.start);
            this.start = newElement;
        } else {
            CountryElement finger = this.start;
            while (finger.getNext() != null && finger.getNext().getValue() < value) {
                finger = finger.getNext();
            }
            if (finger.getNext() == null) {
                finger.setNext(newElement);
            } else {
                newElement.setNext(finger.getNext());
                finger.setNext(newElement);
            }
        }
    }

    public int pop() {
        int temp = -1;
        if (this.start == null) {
            System.out.println("Error in CountryStack.pop()  The stack is empty, you can't pop!");
        } else {
            temp = this.start.getCode();
            this.start = this.start.getNext();
        }
        return temp;
    }

    public int topValue() {
        return this.start.getValue();
    }

    public boolean isEmpty() {
        return this.start == null;
    }

    public int size() {
        if (this.start == null) {
            return 0;
        }
        return this.start.size();
    }
}

