/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.util;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.util.CountryCluster;
import java.util.ArrayList;
import java.util.List;

public class CountryRoute {
    private List route;

    public CountryRoute(List countries) {
        this.route = countries;
    }

    public CountryRoute(Country[] countryArray) {
        this.route = new ArrayList();
        for (int i = 0; i < countryArray.length; ++i) {
            this.route.add(countryArray[i]);
        }
    }

    public CountryRoute(int[] codeArray, Country[] countries) {
        this.route = new ArrayList();
        for (int i = 0; i < codeArray.length; ++i) {
            this.route.add(countries[codeArray[i]]);
        }
    }

    public Country start() {
        return (Country)this.route.get(0);
    }

    public Country end() {
        return (Country)this.route.get(this.route.size() - 1);
    }

    public int size() {
        return this.route.size();
    }

    public Country get(int index) {
        return (Country)this.route.get(index);
    }

    public boolean contains(Object o) {
        return this.route.contains(o);
    }

    public int getArmies() {
        int result = 0;
        for (int i = 0; i < this.route.size(); ++i) {
            result += ((Country)this.route.get(i)).getArmies();
        }
        return result;
    }

    public int costNotCountingPlayer(int player) {
        int result = 0;
        for (int i = 0; i < this.route.size(); ++i) {
            if (((Country)this.route.get(i)).getOwner() == player) continue;
            result += ((Country)this.route.get(i)).getArmies();
        }
        return result;
    }

    public int costNotCountingPlayer(int player, int player2) {
        int result = 0;
        for (int i = 0; i < this.route.size(); ++i) {
            if (((Country)this.route.get(i)).getOwner() == player || ((Country)this.route.get(i)).getOwner() == player2) continue;
            result += ((Country)this.route.get(i)).getArmies();
        }
        return result;
    }

    public CountryRoute append(CountryRoute other) {
        int i;
        int i2;
        ArrayList result = new ArrayList();
        Country otherRouteEntry = null;
        for (i2 = 0; i2 < this.route.size(); ++i2) {
            if (other.contains(this.route.get(i2))) {
                otherRouteEntry = this.get(i2);
                break;
            }
            result.add(this.route.get(i2));
        }
        if (this.end().equals(otherRouteEntry)) {
            for (i2 = 0; i2 < other.route.size(); ++i2) {
                result.add(other.route.get(i2));
            }
            return new CountryRoute(result);
        }
        if (other.end().equals(otherRouteEntry)) {
            for (i2 = other.route.size() - 1; i2 >= 0; --i2) {
                result.add(other.route.get(i2));
            }
            return new CountryRoute(result);
        }
        CountryCluster otherCluster = new CountryCluster(other.route);
        Country lastNonDupe = (Country)result.get(result.size() - 1);
        Country[] adjoining = lastNonDupe.getAdjoiningList();
        for (i = 0; i < adjoining.length; ++i) {
            CountryRoute newRoute;
            if (!other.contains(adjoining[i]) || (newRoute = otherCluster.getSimpleRouteStartingAt(adjoining[i])) == null) continue;
            for (int j = 0; j < newRoute.size(); ++j) {
                result.add(newRoute.route.get(j));
            }
            return new CountryRoute(result);
        }
        System.out.println("CountryRoute.append() could not complete its task. Returning a partly garbage route.");
        for (i = 0; i < other.route.size(); ++i) {
            if (result.contains(other.route.get(i))) continue;
            result.add(other.route.get(i));
        }
        return new CountryRoute(result);
    }

    public CountryRoute reverse() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.route.size(); ++i) {
            result.add(0, this.route.get(i));
        }
        return new CountryRoute(result);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("\n\t<CountryRoute size:" + this.route.size() + " route:\n\t");
        for (int i = 0; i < this.route.size(); ++i) {
            buffer.append(this.route.get(i));
            if (i == this.route.size() - 1) continue;
            buffer.append("\n\t");
        }
        buffer.append(" end route>");
        return buffer.toString();
    }
}

