/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.util;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.util.CountryCluster;
import com.sillysoft.lux.util.NeighborIterator;
import com.sillysoft.lux.util.PlayerIterator;
import java.util.ArrayList;
import java.util.List;

public class CountryClusterSet {
    private List clusters;

    private CountryClusterSet(List clusters) {
        this.clusters = clusters;
    }

    public static CountryClusterSet getAllCountriesOwnedBy(int owner, Country[] countries) {
        ArrayList<Country> fullSet = new ArrayList<Country>();
        PlayerIterator e = new PlayerIterator(owner, countries);
        while (e.hasNext()) {
            fullSet.add(e.next());
        }
        if (fullSet.size() == 0) {
            System.out.println("WARNING: CountryClusterSet created with a dead player");
        }
        ArrayList clusters = new ArrayList();
        while (fullSet.size() > 0) {
            int i;
            ArrayList cluster = new ArrayList();
            cluster.add(fullSet.get(0));
            for (i = 0; i < cluster.size(); ++i) {
                NeighborIterator neighbors = new NeighborIterator((Country)cluster.get(i));
                while (neighbors.hasNext()) {
                    Country neighbor = neighbors.next();
                    if (neighbor.getOwner() != owner || cluster.contains(neighbor)) continue;
                    cluster.add(neighbor);
                }
            }
            clusters.add(cluster);
            for (i = 0; i < cluster.size(); ++i) {
                fullSet.remove(cluster.get(i));
            }
        }
        return new CountryClusterSet(clusters);
    }

    public static CountryClusterSet getAllCountriesNotOwnedBy(int notOwnedBy, Country[] countries) {
        ArrayList<Country> outstandingCountries = new ArrayList<Country>();
        for (int i = 0; i < countries.length; ++i) {
            if (countries[i].getOwner() == notOwnedBy) continue;
            outstandingCountries.add(countries[i]);
        }
        ArrayList clusters = new ArrayList();
        while (outstandingCountries.size() > 0) {
            Country nextRoot = (Country)outstandingCountries.remove(0);
            ArrayList<Country> cluster = new ArrayList<Country>();
            cluster.add(nextRoot);
            for (int i = 0; i < cluster.size(); ++i) {
                NeighborIterator neighbors = new NeighborIterator((Country)cluster.get(i));
                while (neighbors.hasNext()) {
                    Country neighbor = neighbors.next();
                    if (neighbor.getOwner() == notOwnedBy || cluster.contains(neighbor) || !outstandingCountries.contains(neighbor)) continue;
                    cluster.add(neighbor);
                    outstandingCountries.remove(neighbor);
                }
            }
            clusters.add(cluster);
        }
        return new CountryClusterSet(clusters);
    }

    public static CountryClusterSet getHostileCountries(int hostileToOwner, List startingCountries) {
        ArrayList clusters = new ArrayList();
        ArrayList fullSet = new ArrayList(startingCountries);
        while (fullSet.size() > 0) {
            int i;
            ArrayList cluster = new ArrayList();
            cluster.add(fullSet.get(0));
            for (i = 0; i < cluster.size(); ++i) {
                NeighborIterator neighbors = new NeighborIterator((Country)cluster.get(i));
                while (neighbors.hasNext()) {
                    Country neighbor = neighbors.next();
                    if (neighbor.getOwner() == hostileToOwner || cluster.contains(neighbor)) continue;
                    cluster.add(neighbor);
                }
            }
            clusters.add(cluster);
            for (i = 0; i < cluster.size(); ++i) {
                fullSet.remove(cluster.get(i));
            }
        }
        return new CountryClusterSet(clusters);
    }

    public int numberOfClusters() {
        return this.clusters.size();
    }

    public CountryCluster getCluster(int i) {
        return new CountryCluster((List)this.clusters.get(i));
    }

    public int size() {
        return this.clusters.size();
    }

    public void orderWeakestFirst() {
        boolean madeChange = true;
        while (madeChange) {
            madeChange = false;
            for (int i = 0; i < this.clusters.size() - 1; ++i) {
                if (this.getCluster(i).getArmies() <= this.getCluster(i + 1).getArmies()) continue;
                this.clusters.add(i, this.clusters.remove(i + 1));
            }
        }
    }
}

