/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.util;

import com.sillysoft.lux.Country;
import com.sillysoft.lux.util.CountryIterator;
import com.sillysoft.lux.util.CountryRoute;
import com.sillysoft.lux.util.NeighborIterator;
import com.sillysoft.lux.util.OrderedNeighborIterator;
import java.util.ArrayList;
import java.util.List;

public class CountryCluster {
    private List cluster;

    public static CountryCluster getOwnedCluster(Country root) {
        return CountryCluster.getOwnedCluster(root, false);
    }

    public static CountryCluster getOwnedCluster(Country root, boolean orderNeighbors) {
        if (root == null) {
            throw new NullPointerException("CountryCluster created with a null root country");
        }
        ArrayList<Country> cluster = new ArrayList<Country>();
        cluster.add(root);
        int owner = root.getOwner();
        for (int i = 0; i < cluster.size(); ++i) {
            CountryIterator neighbors = orderNeighbors ? new OrderedNeighborIterator((Country)cluster.get(i)) : new NeighborIterator((Country)cluster.get(i));
            while (neighbors.hasNext()) {
                Country neighbor = neighbors.next();
                if (neighbor.getOwner() != owner || cluster.contains(neighbor)) continue;
                cluster.add(neighbor);
            }
        }
        return new CountryCluster(cluster);
    }

    public CountryCluster(List countries) {
        this.cluster = countries;
    }

    public int getArmies() {
        int result = 0;
        for (int i = 0; i < this.cluster.size(); ++i) {
            result += ((Country)this.cluster.get(i)).getArmies();
        }
        return result;
    }

    public List getList() {
        return this.cluster;
    }

    public int size() {
        return this.cluster.size();
    }

    public CountryRoute getSimpleRoute() {
        return this.getSimpleRoute(false);
    }

    public CountryRoute getSimpleRoute(boolean optimizeForSingleOwner) {
        for (int i = 0; i < this.cluster.size(); ++i) {
            CountryRoute result;
            Country startAt = (Country)this.cluster.get(i);
            if (optimizeForSingleOwner && startAt.getNumberEnemyNeighbors() <= 0 || (result = this.getSimpleRouteStartingAt(startAt)) == null) continue;
            return result;
        }
        return null;
    }

    public CountryRoute getSimpleRoute(boolean optimizeForSingleOwner, int optimizeForAttackingPlayer) {
        CountryRoute result;
        Country startAt;
        int i;
        for (i = 0; i < this.cluster.size(); ++i) {
            startAt = (Country)this.cluster.get(i);
            if (startAt.getNumberPlayerNeighbors(optimizeForAttackingPlayer) <= 0 || (result = this.getSimpleRouteStartingAt(startAt)) == null) continue;
            return result;
        }
        for (i = 0; i < this.cluster.size(); ++i) {
            startAt = (Country)this.cluster.get(i);
            if (startAt.getNumberPlayerNeighbors(optimizeForAttackingPlayer) != 0 || optimizeForSingleOwner && startAt.getNumberEnemyNeighbors() <= 0 || (result = this.getSimpleRouteStartingAt(startAt)) == null) continue;
            return result;
        }
        return null;
    }

    public CountryRoute getSimpleRouteStartingAt(Country start) {
        if (this.cluster.size() == 1) {
            return new CountryRoute(this.cluster);
        }
        CountryRoute found = null;
        CountryCluster startRemoved = this.cloneRemoving(start);
        Country[] adjoining = start.getAdjoiningList();
        for (int i = 0; i < adjoining.length && found == null; ++i) {
            if (!this.cluster.contains(adjoining[i])) continue;
            found = startRemoved.getSimpleRouteStartingAt(adjoining[i]);
        }
        if (found == null) {
            return null;
        }
        ArrayList<Country> result = new ArrayList<Country>();
        result.add(start);
        for (int i = 0; i < found.size(); ++i) {
            result.add(found.get(i));
        }
        return new CountryRoute(result);
    }

    private CountryCluster cloneRemoving(Country remove) {
        ArrayList cloneList = new ArrayList(this.cluster);
        cloneList.remove(remove);
        return new CountryCluster(cloneList);
    }

    private static Country expandWalk(Country walkFrom, List walked, List cluster) {
        Country[] adjoining = walkFrom.getAdjoiningList();
        for (int i = 0; i < adjoining.length; ++i) {
            if (!cluster.contains(adjoining[i]) || walked.contains(adjoining[i])) continue;
            walked.add(adjoining[i]);
            return adjoining[i];
        }
        return null;
    }

    public Country getStrongestNeighborOwnedBy(int ownerID) {
        int strongestArmies = -1;
        Country strongestNeighbor = null;
        for (int i = 0; i < this.cluster.size(); ++i) {
            Country next = (Country)this.cluster.get(i);
            Country strongestCheck = next.getStrongestNeighborOwnedBy(ownerID);
            if (strongestCheck == null || strongestCheck.getArmies() <= strongestArmies) continue;
            strongestArmies = strongestCheck.getArmies();
            strongestNeighbor = strongestCheck;
        }
        return strongestNeighbor;
    }

    public int estimatedNumberOfArmiesNeededToConquer() {
        return (int)((double)(this.getArmies() + this.size()) * 1.2);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("\n\t<CountryCluster size:" + this.size() + " countries:\n\t");
        for (int i = 0; i < this.size(); ++i) {
            buffer.append(this.cluster.get(i));
            if (i == this.size() - 1) continue;
            buffer.append("\n\t");
        }
        buffer.append(" end of cluster>");
        return buffer.toString();
    }
}

