/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.util;

import com.sillysoft.lux.Board;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.util.ContinentIterator;
import com.sillysoft.lux.util.CountryPathStack;
import com.sillysoft.lux.util.CountryStack;
import com.sillysoft.lux.util.PlayerIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class BoardHelper {
    public static Country getPlayersBiggestArmy(int player, Country[] countries) {
        PlayerIterator armies = new PlayerIterator(player, countries);
        int biggestArmies = -1;
        Country root = null;
        while (armies.hasNext()) {
            Country a = armies.next();
            if (a.getArmies() <= biggestArmies) continue;
            biggestArmies = a.getArmies();
            root = a;
        }
        return root;
    }

    public static Country getPlayersBiggestArmyWithEnemyNeighbor(int player, Country[] countries) {
        PlayerIterator armies = new PlayerIterator(player, countries);
        int biggestArmies = -1;
        Country root = null;
        while (armies.hasNext()) {
            Country a = armies.next();
            if (a.getArmies() <= biggestArmies || a.getNumberEnemyNeighbors() <= 0) continue;
            biggestArmies = a.getArmies();
            root = a;
        }
        return root;
    }

    public static int getPlayerArmies(int player, Country[] countries) {
        int enemies = 0;
        for (int i = 0; i < countries.length; ++i) {
            if (countries[i].getOwner() != player) continue;
            enemies += countries[i].getArmies();
        }
        return enemies;
    }

    public static int getPlayerCountries(int player, Country[] countries) {
        int number = 0;
        for (int i = 0; i < countries.length; ++i) {
            if (countries[i].getOwner() != player) continue;
            ++number;
        }
        return number;
    }

    public static int getPlayerArmiesInContinent(int player, int continent, Country[] countries) {
        int enemies = 0;
        ContinentIterator continentE = new ContinentIterator(continent, countries);
        while (continentE.hasNext()) {
            Country c = continentE.next();
            if (c.getOwner() != player) continue;
            enemies += c.getArmies();
        }
        return enemies;
    }

    public static int getEnemyArmiesInContinent(int player, int continent, Country[] countries) {
        int enemies = 0;
        ContinentIterator continentE = new ContinentIterator(continent, countries);
        while (continentE.hasNext()) {
            Country c = continentE.next();
            if (c.getOwner() == player) continue;
            enemies += c.getArmies();
        }
        return enemies;
    }

    public static int getPlayerArmiesAdjoiningContinent(int ID, int cont, Country[] countries) {
        int[] borders = BoardHelper.getContinentBorders(cont, countries);
        ArrayList<Country> adjoining = new ArrayList<Country>();
        for (int b = 0; b < borders.length; ++b) {
            Country[] neighbors = countries[borders[b]].getAdjoiningList();
            for (int j = 0; j < neighbors.length; ++j) {
                if (neighbors[j].getOwner() != ID || neighbors[j].getContinent() == cont || adjoining.contains(neighbors[j])) continue;
                adjoining.add(neighbors[j]);
            }
        }
        int result = 0;
        for (int b = 0; b < adjoining.size(); ++b) {
            result += ((Country)adjoining.get(b)).getArmies();
        }
        return result;
    }

    public static boolean playerIsStillInTheGame(int player, Country[] countries) {
        for (int i = 0; i < countries.length; ++i) {
            if (countries[i].getOwner() != player) continue;
            return true;
        }
        return false;
    }

    public static int numberOfContinents(Country[] countries) {
        boolean lastContExisted = true;
        int i = 0;
        while (lastContExisted) {
            lastContExisted = false;
            ContinentIterator iter = new ContinentIterator(i, countries);
            if (iter.hasNext()) {
                lastContExisted = true;
            }
            ++i;
        }
        return i - 1;
    }

    public static int getContinentSize(int continent, Country[] countries) {
        int count = 0;
        ContinentIterator iter = new ContinentIterator(continent, countries);
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    public static int getCountryInContinent(int continent, Country[] countries) {
        if (continent < 0) {
            System.out.println("BoardHelper.getCountryInContinent() called with a continent code of " + continent);
        }
        ContinentIterator ce = new ContinentIterator(continent, countries);
        return ce.next().getCode();
    }

    public static int[] getContinentBorders(int continent, Country[] countries) {
        ArrayList<Country> tempResults = new ArrayList<Country>();
        ContinentIterator iter = new ContinentIterator(continent, countries);
        while (iter.hasNext()) {
            Country c = iter.next();
            boolean border = false;
            Country[] neighbors = c.getAdjoiningList();
            for (int j = 0; j < neighbors.length; ++j) {
                if (neighbors[j].getContinent() == continent) continue;
                border = true;
            }
            if (!border) continue;
            tempResults.add(c);
        }
        int[] result = new int[tempResults.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Country)tempResults.get(i)).getCode();
        }
        return result;
    }

    public static int[] getContinentBordersBeyond(int continent, Country[] countries) {
        return BoardHelper.getDefensibleBordersBeyond(continent, countries);
    }

    public static boolean playerOwnsContinent(int player, int continent, Country[] countries) {
        ContinentIterator iter = new ContinentIterator(continent, countries);
        while (iter.hasNext()) {
            if (iter.next().getOwner() == player) continue;
            return false;
        }
        return true;
    }

    public static boolean playerOwnsAnyContinent(int player, Country[] countries) {
        boolean lastContExisted = true;
        int i = 0;
        while (lastContExisted) {
            lastContExisted = false;
            ContinentIterator iter = new ContinentIterator(i, countries);
            if (iter.hasNext()) {
                if (BoardHelper.playerOwnsContinent(player, i, countries)) {
                    return true;
                }
                lastContExisted = true;
            }
            ++i;
        }
        return false;
    }

    public static boolean playerOwnsAnyPositiveContinent(int player, Country[] countries, Board board) {
        boolean lastContExisted = true;
        int i = 0;
        while (lastContExisted) {
            lastContExisted = false;
            ContinentIterator iter = new ContinentIterator(i, countries);
            if (iter.hasNext()) {
                if (board.getContinentBonus(i) > 0 && BoardHelper.playerOwnsContinent(player, i, countries)) {
                    return true;
                }
                lastContExisted = true;
            }
            ++i;
        }
        return false;
    }

    public static boolean anyPlayerOwnsContinent(int continent, Country[] countries) {
        ContinentIterator iter = new ContinentIterator(continent, countries);
        int owner = iter.next().getOwner();
        while (iter.hasNext()) {
            if (iter.next().getOwner() == owner) continue;
            return false;
        }
        return true;
    }

    public static boolean playerOwnsContinentCountry(int player, int continent, Country[] countries) {
        ContinentIterator iter = new ContinentIterator(continent, countries);
        while (iter.hasNext()) {
            if (iter.next().getOwner() != player) continue;
            return true;
        }
        return false;
    }

    public static int getSmallestEmptyCont(Country[] countries) {
        int numContinents = BoardHelper.numberOfContinents(countries);
        int smallUnownedContSize = 1000000;
        int smallUnownedCont = -1;
        for (int cont = 0; cont < numContinents; ++cont) {
            int size = BoardHelper.getContinentSize(cont, countries);
            if (size >= smallUnownedContSize || !BoardHelper.playerOwnsContinent(-1, cont, countries)) continue;
            smallUnownedContSize = size;
            smallUnownedCont = cont;
        }
        return smallUnownedCont;
    }

    public static int getSmallestPositiveEmptyCont(Country[] countries, Board board) {
        int numContinents = BoardHelper.numberOfContinents(countries);
        int smallUnownedContSize = 1000000;
        int smallUnownedCont = -1;
        for (int cont = 0; cont < numContinents; ++cont) {
            int size;
            if (board.getContinentBonus(cont) <= 0 || (size = BoardHelper.getContinentSize(cont, countries)) >= smallUnownedContSize || !BoardHelper.playerOwnsContinent(-1, cont, countries)) continue;
            smallUnownedContSize = size;
            smallUnownedCont = cont;
        }
        return smallUnownedCont;
    }

    public static int getSmallestOpenCont(Country[] countries) {
        int numContinents = BoardHelper.numberOfContinents(countries);
        int smallUnownedContSize = 1000000;
        int smallUnownedCont = -1;
        for (int cont = 0; cont < numContinents; ++cont) {
            int size = BoardHelper.getContinentSize(cont, countries);
            if (size >= smallUnownedContSize || !BoardHelper.playerOwnsContinentCountry(-1, cont, countries)) continue;
            smallUnownedContSize = size;
            smallUnownedCont = cont;
        }
        return smallUnownedCont;
    }

    public static int getSmallestPositiveOpenCont(Country[] countries, Board board) {
        int numContinents = BoardHelper.numberOfContinents(countries);
        int smallUnownedContSize = 1000000;
        int smallUnownedCont = -1;
        for (int cont = 0; cont < numContinents; ++cont) {
            int size;
            if (board.getContinentBonus(cont) <= 0 || (size = BoardHelper.getContinentSize(cont, countries)) >= smallUnownedContSize || !BoardHelper.playerOwnsContinentCountry(-1, cont, countries)) continue;
            smallUnownedContSize = size;
            smallUnownedCont = cont;
        }
        return smallUnownedCont;
    }

    public static Country closestCountryWithOwner(Country CC, int owner, Country[] countries) {
        int cc = CC.getCode();
        int retval = BoardHelper.closestCountryWithOwner(cc, owner, countries);
        if (retval < 0) {
            return null;
        }
        return countries[retval];
    }

    public static int closestCountryWithOwner(int CC, int owner, Country[] countries) {
        if (CC < 0 || countries.length <= CC) {
            return -1;
        }
        int testCode = CC;
        int distanceSoFar = 0;
        boolean[] haveSeenAlready = new boolean[countries.length];
        for (int i = 0; i < countries.length; ++i) {
            haveSeenAlready[i] = false;
        }
        haveSeenAlready[CC] = true;
        CountryStack Q = new CountryStack();
        do {
            Country[] neighbors = countries[testCode].getAdjoiningList();
            for (int i = 0; i < neighbors.length; ++i) {
                if (haveSeenAlready[neighbors[i].getCode()]) continue;
                Q.pushWithValue(neighbors[i], distanceSoFar + 1);
                haveSeenAlready[neighbors[i].getCode()] = true;
            }
            if (Q.isEmpty()) {
                return -2;
            }
            distanceSoFar = Q.topValue();
        } while (countries[testCode = Q.pop()].getOwner() != owner);
        return testCode;
    }

    public static int closestCountryWithOwner(List startingCountryList, int owner, Country[] countries) {
        if (startingCountryList.size() < 1) {
            return -1;
        }
        int[] startingCodes = new int[startingCountryList.size()];
        for (int i = 0; i < startingCountryList.size(); ++i) {
            startingCodes[i] = ((Country)startingCountryList.get(i)).getCode();
        }
        boolean[] haveSeenAlready = new boolean[countries.length];
        for (int i = 0; i < countries.length; ++i) {
            haveSeenAlready[i] = false;
        }
        CountryStack Q = new CountryStack();
        for (int i = 0; i < startingCodes.length; ++i) {
            haveSeenAlready[startingCodes[i]] = true;
            Q.pushWithValue(countries[startingCodes[i]], 0);
        }
        int testCode = Q.pop();
        int distanceSoFar = 0;
        do {
            Country[] neighbors = countries[testCode].getAdjoiningList();
            for (int i = 0; i < neighbors.length; ++i) {
                if (haveSeenAlready[neighbors[i].getCode()]) continue;
                Q.pushWithValue(neighbors[i], distanceSoFar + 1);
                haveSeenAlready[neighbors[i].getCode()] = true;
            }
            if (Q.isEmpty()) {
                return -2;
            }
            distanceSoFar = Q.topValue();
        } while (countries[testCode = Q.pop()].getOwner() != owner);
        return testCode;
    }

    public static Country[] easyCostCountryWithOwner(Country CC, int owner, Country[] countries) {
        int cc = CC.getCode();
        int[] retval = BoardHelper.easyCostCountryWithOwner(cc, owner, countries);
        if (retval == null) {
            return null;
        }
        Country[] rets = new Country[retval.length];
        for (int i = 0; i < retval.length; ++i) {
            rets[i] = countries[retval[i]];
        }
        return rets;
    }

    public static int[] easyCostCountryWithOwner(int CC, int owner, Country[] countries) {
        if (CC < 0 || countries.length <= CC) {
            System.out.println("ERROR from easyCostCountryWithOwner: bad params");
            return null;
        }
        if (countries[CC].getOwner() == owner) {
            int[] result = new int[]{CC};
            return result;
        }
        int testCode = CC;
        int armiesSoFar = 0;
        int[] testCodeHistory = new int[]{CC};
        boolean[] haveSeenAlready = new boolean[countries.length];
        for (int i = 0; i < countries.length; ++i) {
            haveSeenAlready[i] = false;
        }
        haveSeenAlready[CC] = true;
        CountryPathStack Q = new CountryPathStack();
        do {
            Country[] neighbors = countries[testCode].getAdjoiningList();
            for (int i = 0; i < neighbors.length; ++i) {
                if (haveSeenAlready[neighbors[i].getCode()]) continue;
                int[] newHistory = new int[testCodeHistory.length + 1];
                newHistory[0] = neighbors[i].getCode();
                for (int j = 1; j < newHistory.length; ++j) {
                    newHistory[j] = testCodeHistory[j - 1];
                }
                Q.pushWithValueAndHistory(neighbors[i], armiesSoFar + (neighbors[i].getOwner() == owner ? -neighbors[i].getArmies() : neighbors[i].getArmies()), newHistory);
                haveSeenAlready[neighbors[i].getCode()] = true;
            }
            if (Q.isEmpty()) {
                System.out.println("ERROR in easyCostCountryWithOwner->can't pop");
                return null;
            }
            armiesSoFar = Q.topValue();
            testCodeHistory = Q.topHistory();
        } while (countries[testCode = Q.pop()].getOwner() != owner);
        return testCodeHistory;
    }

    public static Country[] easyCostFromCountryToContinent(Country CCF, int continent, Country[] countries) {
        int ccf = CCF.getCode();
        int[] retval = BoardHelper.easyCostFromCountryToContinent(ccf, continent, countries);
        if (retval == null) {
            return null;
        }
        Country[] rets = new Country[retval.length];
        for (int i = 0; i < retval.length; ++i) {
            rets[i] = countries[retval[i]];
        }
        return rets;
    }

    public static int[] easyCostFromCountryToContinent(int CCF, int continent, Country[] countries) {
        if (CCF < 0 || countries.length <= CCF || continent < 0) {
            System.out.println("ERROR in easyCostFromCountryToContinent() -> bad parameters.");
            return null;
        }
        int CCFOwner = countries[CCF].getOwner();
        int testCode = CCF;
        int armiesSoFar = 0;
        int[] testCodeHistory = new int[]{CCF};
        boolean[] haveSeenAlready = new boolean[countries.length];
        for (int i = 0; i < countries.length; ++i) {
            haveSeenAlready[i] = false;
        }
        haveSeenAlready[CCF] = true;
        CountryPathStack Q = new CountryPathStack();
        do {
            Country[] neighbors = countries[testCode].getAdjoiningList();
            for (int i = 0; i < neighbors.length; ++i) {
                if (haveSeenAlready[neighbors[i].getCode()] || neighbors[i].getOwner() == CCFOwner) continue;
                int[] newHistory = new int[testCodeHistory.length + 1];
                for (int j = 0; j < testCodeHistory.length; ++j) {
                    newHistory[j] = testCodeHistory[j];
                }
                newHistory[newHistory.length - 1] = neighbors[i].getCode();
                Q.pushWithValueAndHistory(neighbors[i], armiesSoFar + (neighbors[i].getContinent() == continent ? -neighbors[i].getArmies() : neighbors[i].getArmies()), newHistory);
                haveSeenAlready[neighbors[i].getCode()] = true;
            }
            if (Q.isEmpty()) {
                return null;
            }
            armiesSoFar = Q.topValue();
            testCodeHistory = Q.topHistory();
        } while (countries[testCode = Q.pop()].getContinent() != continent);
        return testCodeHistory;
    }

    public static Country[] easyCostBetweenCountries(Country CCF, Country CCT, Country[] countries) {
        int cct;
        int ccf = CCF.getCode();
        int[] retval = BoardHelper.easyCostBetweenCountries(ccf, cct = CCT.getCode(), countries);
        if (retval == null) {
            return null;
        }
        Country[] rets = new Country[retval.length];
        for (int i = 0; i < retval.length; ++i) {
            rets[i] = countries[retval[i]];
        }
        return rets;
    }

    public static int[] easyCostBetweenCountries(int CCF, int CCT, Country[] countries) {
        if (CCF < 0 || countries.length <= CCF || CCT < 0 || countries.length <= CCT) {
            System.out.println("ERROR in easyCostBetweenCountries() -> bad parameters.");
            return null;
        }
        int CCFOwner = countries[CCF].getOwner();
        int testCode = CCF;
        int armiesSoFar = 0;
        int[] testCodeHistory = new int[]{CCF};
        boolean[] haveSeenAlready = new boolean[countries.length];
        for (int i = 0; i < countries.length; ++i) {
            haveSeenAlready[i] = false;
        }
        haveSeenAlready[CCF] = true;
        CountryPathStack Q = new CountryPathStack();
        do {
            Country[] neighbors = countries[testCode].getAdjoiningList();
            for (int i = 0; i < neighbors.length; ++i) {
                if (haveSeenAlready[neighbors[i].getCode()] || neighbors[i].getOwner() == CCFOwner) continue;
                int[] newHistory = new int[testCodeHistory.length + 1];
                newHistory[0] = neighbors[i].getCode();
                for (int j = 1; j < newHistory.length; ++j) {
                    newHistory[j] = testCodeHistory[j - 1];
                }
                Q.pushWithValueAndHistory(neighbors[i], armiesSoFar + (neighbors[i].getCode() == CCT ? -neighbors[i].getArmies() : neighbors[i].getArmies()), newHistory);
                haveSeenAlready[neighbors[i].getCode()] = true;
            }
            if (Q.isEmpty()) {
                return null;
            }
            armiesSoFar = Q.topValue();
            testCodeHistory = Q.topHistory();
        } while ((testCode = Q.pop()) != CCT);
        return testCodeHistory;
    }

    public static Country[] friendlyPathBetweenCountries(Country CF, Country CT, Country[] countries) {
        int cct;
        int ccf = CF.getCode();
        int[] retval = BoardHelper.friendlyPathBetweenCountries(ccf, cct = CT.getCode(), countries);
        if (retval == null) {
            return null;
        }
        Country[] rets = new Country[retval.length];
        for (int i = 0; i < retval.length; ++i) {
            rets[i] = countries[retval[i]];
        }
        return rets;
    }

    public static int[] friendlyPathBetweenCountries(int CCF, int CCT, Country[] countries) {
        if (CCF < 0 || countries.length <= CCF || CCT < 0 || countries.length <= CCT) {
            System.out.println("ERROR in friendlyPathBetweenCountries() -> bad parameters.");
            return null;
        }
        int CCFOwner = countries[CCF].getOwner();
        int testCode = CCF;
        int distanceSoFar = 0;
        int[] testCodeHistory = new int[]{CCF};
        boolean[] haveSeenAlready = new boolean[countries.length];
        for (int i = 0; i < countries.length; ++i) {
            haveSeenAlready[i] = false;
        }
        haveSeenAlready[CCF] = true;
        CountryPathStack Q = new CountryPathStack();
        do {
            Country[] neighbors = countries[testCode].getAdjoiningList();
            for (int i = 0; i < neighbors.length; ++i) {
                if (neighbors[i].getOwner() != CCFOwner || haveSeenAlready[neighbors[i].getCode()]) continue;
                int[] newHistory = new int[testCodeHistory.length + 1];
                for (int j = 0; j < testCodeHistory.length; ++j) {
                    newHistory[j] = testCodeHistory[j];
                }
                newHistory[newHistory.length - 1] = neighbors[i].getCode();
                Q.pushWithValueAndHistory(neighbors[i], distanceSoFar + 1, newHistory);
                haveSeenAlready[neighbors[i].getCode()] = true;
            }
            if (Q.isEmpty()) {
                return null;
            }
            distanceSoFar = Q.topValue();
            testCodeHistory = Q.topHistory();
        } while ((testCode = Q.pop()) != CCT);
        return testCodeHistory;
    }

    public static int[] cheapestRouteFromOwnerToCont(int owner, int continent, Country[] countries) {
        int[] testCodeHistory;
        int armiesSoFar;
        int testCode;
        if (owner < 0 || continent < 0) {
            System.out.println("ERROR in cheapestRouteFromOwnerToCont() -> bad parameters");
            return null;
        }
        if (BoardHelper.playerOwnsContinentCountry(owner, continent, countries)) {
            ContinentIterator iter = new ContinentIterator(continent, countries);
            while (iter.hasNext()) {
                Country next = iter.next();
                if (next.getOwner() != owner) continue;
                return new int[]{next.getCode()};
            }
        }
        boolean[] haveSeenAlready = new boolean[countries.length];
        for (int i = 0; i < countries.length; ++i) {
            haveSeenAlready[i] = false;
        }
        CountryPathStack Q = new CountryPathStack();
        int[] borderCodes = BoardHelper.getContinentBorders(continent, countries);
        for (int i = 0; i < borderCodes.length; ++i) {
            testCode = borderCodes[i];
            armiesSoFar = 0;
            testCodeHistory = new int[]{testCode};
            haveSeenAlready[testCode] = true;
            Q.pushWithValueAndHistory(countries[borderCodes[i]], 0, testCodeHistory);
        }
        do {
            armiesSoFar = Q.topValue();
            testCodeHistory = Q.topHistory();
            testCode = Q.pop();
            if (countries[testCode].getOwner() == owner) {
                return testCodeHistory;
            }
            int[] canAttackInto = BoardHelper.getAttackList(countries[testCode], countries);
            for (int i = 0; i < canAttackInto.length; ++i) {
                if (haveSeenAlready[canAttackInto[i]]) continue;
                int[] newHistory = new int[testCodeHistory.length + 1];
                newHistory[0] = canAttackInto[i];
                for (int j = 1; j < newHistory.length; ++j) {
                    newHistory[j] = testCodeHistory[j - 1];
                }
                Q.pushWithValueAndHistory(countries[canAttackInto[i]], armiesSoFar + (countries[canAttackInto[i]].getOwner() == owner ? -countries[canAttackInto[i]].getArmies() : countries[canAttackInto[i]].getArmies()), newHistory);
                haveSeenAlready[countries[canAttackInto[i]].getCode()] = true;
            }
        } while (!Q.isEmpty());
        System.out.println("ERROR in cheapestRouteFromOwnerToCont->can't pop");
        return null;
    }

    public static Country[] getCountriesCopy(Country[] countries) {
        int i;
        Country[] countriesCopy = new Country[countries.length];
        for (i = 0; i < countries.length; ++i) {
            countriesCopy[i] = new Country(i, countries[i].getContinent(), null);
            countriesCopy[i].setArmies(countries[i].getArmies(), null);
            countriesCopy[i].setName(countries[i].getName(), null);
            countriesCopy[i].setOwner(countries[i].getOwner(), null);
        }
        for (i = 0; i < countries.length; ++i) {
            Country[] around = countries[i].getAdjoiningList();
            for (int j = 0; j < around.length; ++j) {
                countriesCopy[i].addToAdjoiningList(countriesCopy[around[j].getCode()], null);
            }
        }
        return countriesCopy;
    }

    public static int[] getDefensibleBorders(int continent, Country[] countries) {
        Vector<Country> borders = new Vector<Country>();
        for (int c = 0; c < countries.length; ++c) {
            if (countries[c].getContinent() == continent) continue;
            Country[] neighbors = countries[c].getAdjoiningList();
            for (int i = 0; i < neighbors.length; ++i) {
                if (neighbors[i].getContinent() != continent || borders.contains(neighbors[i])) continue;
                borders.add(neighbors[i]);
            }
        }
        int[] result = new int[borders.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Country)borders.get(i)).getCode();
        }
        return result;
    }

    public static int[] getDefensibleBordersBeyond(int continent, Country[] countries) {
        Vector<Country> beyond = new Vector<Country>();
        for (int c = 0; c < countries.length; ++c) {
            if (countries[c].getContinent() == continent) continue;
            Country[] neighbors = countries[c].getAdjoiningList();
            for (int i = 0; i < neighbors.length; ++i) {
                if (neighbors[i].getContinent() != continent || beyond.contains(countries[c])) continue;
                beyond.add(countries[c]);
            }
        }
        int[] result = new int[beyond.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Country)beyond.get(i)).getCode();
        }
        return result;
    }

    public static int[] getAttackList(Country target, Country[] countries) {
        Vector<Country> attackList = new Vector<Country>();
        for (int c = 0; c < countries.length; ++c) {
            if (!countries[c].canGoto(target)) continue;
            attackList.add(countries[c]);
        }
        int[] result = new int[attackList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((Country)attackList.get(i)).getCode();
        }
        return result;
    }
}

