/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.plugin;

import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.plugin.PluginListener;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.URLTool;
import com.sillysoft.vox.Vox;
import com.sillysoft.widgets.SSApp;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;

public class PluginRater
implements PluginListener {
    private static Preferences pluginPreferences;
    private static List waitingRatings;
    private static PluginRater singleton;

    public static Preferences getPluginPreferences() {
        if (pluginPreferences == null) {
            pluginPreferences = SSApp.shortNameLower().equals("lux") ? Preferences.userNodeForPackage(LuxWorld.class).node("PluginRatings") : Preferences.userNodeForPackage(Vox.class).node("PluginRatings");
        }
        return pluginPreferences;
    }

    public static int getRate(String id) {
        return PluginRater.getPluginPreferences().getInt("pluginRating_" + id, 0);
    }

    public static void rateChange(String id, int newRate) {
        if (newRate < 0 || newRate > 5) {
            newRate = 0;
        }
        if (newRate != 0 || PluginRater.getPluginPreferences().getInt("pluginRating_" + id, 0) != 0) {
            System.out.println(id + " is NOW rated " + newRate);
            PluginRater.getPluginPreferences().putInt("pluginRating_" + id, newRate);
        }
    }

    public static void sendRatings() {
        Prefs.flush(PluginRater.getPluginPreferences());
        new Thread("Plugin-send-ratings"){

            public void run() {
                StringBuffer sb = new StringBuffer();
                sb.append("version=" + SSApp.version());
                sb.append("&userKey=" + StringTool.encodeSpaces(Prefs.getUserKey()));
                try {
                    String[] keys = PluginRater.getPluginPreferences().keys();
                    for (int i = 0; i < keys.length; ++i) {
                        sb.append("&" + StringTool.encodeSpaces(keys[i].substring(13)) + "=" + PluginRater.getPluginPreferences().getInt(keys[i], 0));
                    }
                    System.out.println("PluginRater: Sending plugin ratings to the server...");
                    System.out.println("PluginRater: Recieved " + URLTool.getURL("http://sillysoft.net/" + SSApp.shortNameLower() + "/add_plugin_ranking.php?" + sb.toString()).trim());
                }
                catch (Exception e) {
                    System.out.println("Error sending the plugin rankings: " + e);
                }
                PluginRater.clearResources();
            }
        }.start();
    }

    public static void clearResources() {
        pluginPreferences = null;
    }

    public static void rateMapTitled(String title, int rating) {
        if (waitingRatings == null) {
            waitingRatings = new Vector();
        }
        ArrayList<Object> temp = new ArrayList<Object>();
        temp.add(title);
        temp.add(new Integer(rating));
        waitingRatings.add(temp);
        PluginManager.getInstance().getPluginList(PluginRater.getPluginRater());
    }

    private static PluginRater getPluginRater() {
        if (singleton == null) {
            singleton = new PluginRater();
        }
        return singleton;
    }

    public void informUser(String text) {
    }

    public void dataReady() {
        if (waitingRatings.size() > 0) {
            List temp = (List)waitingRatings.remove(0);
            String title = (String)temp.get(0);
            int rating = (Integer)temp.get(1);
            String ID = PluginManager.getInstance().getIDFromTitle(title);
            SS.debug("Rating map from the menu, ID=" + ID);
            if ("".equals(ID)) {
                return;
            }
            PluginRater.rateChange(ID, rating);
        }
    }
}

