/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.plugin;

import com.sillysoft.lux.Biohazard;
import com.sillysoft.lux.BoardCache;
import com.sillysoft.lux.LuxMapGenerator;
import com.sillysoft.lux.RandomMapGenerator;
import com.sillysoft.lux.SSClassLoader;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.gui.LuxView;
import com.sillysoft.lux.gui.PluginLocalMemory;
import com.sillysoft.lux.net.LuxTracker;
import com.sillysoft.lux.plugin.ClassTool;
import com.sillysoft.lux.plugin.PluginListener;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.lux.plugin.PluginRater;
import com.sillysoft.tools.ArrayTool;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.DirectoryTool;
import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.ProgressListener;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.tools.ZipTool;
import com.sillysoft.vox.PluginWindowVox;
import com.sillysoft.vox.Visuals;
import com.sillysoft.vox.VoxTracker;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSOptionPane;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PluginManagerVox
extends AbstractTableModel
implements Runnable,
PluginListener,
ProgressListener {
    public static final int NAME_COLUMN = 0;
    public static final int TYPE_COLUMN = 1;
    public static final int AUTHOR_COLUMN = 2;
    public static final int VERSION_COLUMN = 3;
    public static final int TEAM_COLUMN = 4;
    public static final int STATUS_COLUMN = 5;
    public static final int RATING_COLUMN = 6;
    public static final int DATE_COLUMN = 7;
    public static final int WEBPAGE_COLUMN = 8;
    public static final int DESCRIPTION_COLUMN = 9;
    public static final int FILE_LIST_COLUMN = 10;
    public static final int IMAGE_COLUMN = 11;
    public static final int THEME_COLUMN = 12;
    public static final int INSTALL_LOCATION_COLUMN = 13;
    public static final int ID_COLUMN = 14;
    public static final int CATEGORY_COLUMN = 15;
    private Vector rows = new Vector();
    private Vector rowsAll = new Vector();
    private String[] keys = new String[]{"Name", "Type", "Author", "Version", "Teams", "Status", "Rating", "Date", "Webpage", "Description", "file_list", "Image", "Theme", "install_location", "id"};
    private PluginListener sender = null;
    public static String base_URL = "http://sillysoft.net/" + (SSApp.isVox ? "vox/" : "") + "plugins/";
    private static String supportFolder = DesktopTool.supportFolderPath();
    private static String savedMapLocation = supportFolder + (SSApp.isVox ? "Maps" : "Boards" + File.separator + "Saved");
    private static String tempMapLocation = supportFolder + (SSApp.isVox ? "Temp" : "Boards" + File.separator + "Temp");
    private static String cacheLocation = supportFolder + "Cache" + File.separator + "maps074.dat";
    private static String cacheLocationThemes = supportFolder + "Cache" + File.separator + "themes074.dat";
    private Vector mapList;
    private Hashtable localMapDatabase;
    private static PluginManagerVox shared;
    private int runMode = -1;
    private int installRowIndex = -1;
    private Hashtable onlineThemeDatabase;
    List installQ;
    String progressString = "";
    private String checkingForTheme = null;
    private SSFrame boardWindow;
    String lastSearchTermLower;
    protected List mapGenerators;
    protected List mapGeneratorsChoices;

    public static PluginManagerVox getInstance() {
        if (shared == null) {
            shared = new PluginManagerVox();
        }
        return shared;
    }

    public void wakeUp() {
        if (Prefs.getBoolean("checkforpluginsonline", true)) {
            this.getPluginList(this);
        }
    }

    public String getStatusOfPlugin(Object[] data) {
        boolean debug = true;
        if (debug) {
            System.out.println("getStatusOfPlugin: " + data[0] + " v" + data[3]);
        }
        if ("Boards/Saved".equals(data[13]) || "Maps".equals(data[13])) {
            String localMapVersion = (String)this.localMapDatabase.get(data[0]);
            if (localMapVersion == null) {
                if (debug) {
                    System.out.println("The map " + data[0] + " was not found locally");
                }
                return PluginWindowVox.NOT_INSTALLED;
            }
            float onlineVersionFloat = 1.0f;
            float localVersionFloat = 1.0f;
            try {
                onlineVersionFloat = Float.parseFloat(data[3].toString());
            }
            catch (Exception e) {
                System.out.println("PluginManager found a malformed version string in the online " + data[0]);
            }
            try {
                localVersionFloat = Float.parseFloat(localMapVersion);
            }
            catch (Exception e) {
                System.out.println("PluginManager found a malformed version string in local " + data[0]);
            }
            if (onlineVersionFloat > localVersionFloat) {
                if (debug) {
                    System.out.println("A new version of the " + data[0] + " map was found online.");
                }
                return PluginWindowVox.NEW_VERSION;
            }
        } else {
            Vector files = (Vector)data[10];
            for (int i = 0; i < files.size(); ++i) {
                String filename = StringTool.stripGzip(files.get(i).toString());
                filename = StringTool.getFilenameFromPath(filename);
                String path = supportFolder + data[13] + File.separator + filename;
                if (!new File(path).exists()) {
                    if (debug) {
                        System.out.println("Non-map plugin " + data[0] + " is not present locally. Checked path: " + path + "." + "\n" + supportFolder + "\n" + data[13] + "\n" + File.separator + "\n" + filename);
                    }
                    return PluginWindowVox.NOT_INSTALLED;
                }
                if (i != 0) continue;
                float onlineVersionFloat = 1.0f;
                try {
                    onlineVersionFloat = Float.parseFloat(data[3].toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                float installedVersion = 1.0f;
                try {
                    installedVersion = ClassTool.getVersionOfClass(path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!(installedVersion < onlineVersionFloat)) continue;
                if (debug) {
                    System.out.println("There is an updated version of " + data[0] + " available. " + installedVersion + " vs " + onlineVersionFloat);
                }
                return PluginWindowVox.NEW_VERSION;
            }
        }
        return PluginWindowVox.INSTALLED;
    }

    private void buildLocalMapDatabase() {
        this.localMapDatabase = new Hashtable();
        this.buildMapDatabaseFromFolder(new File(savedMapLocation));
    }

    private void buildMapDatabaseFromFolder(File resourcesDir) {
        File[] files = resourcesDir.listFiles();
        if (files == null) {
            SSOptionPane.showMessageDialog("Your support folder (inside where you installed " + SSApp.shortName() + ") cannot be read or does not exist! Check the file permissions and try again.");
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getName();
            if (filename.endsWith(SSApp.mapExtension)) {
                String contents = FileTool.fileToString(files[i]);
                String t = XMLTool.extract("title", contents);
                String v = XMLTool.extract("version", contents);
                if (t == null || v == null) {
                    System.out.println(filename + " is missing a <title> or <version> tag. It will be ignored by the Plugin Manager.");
                    continue;
                }
                this.localMapDatabase.put(t, v);
                continue;
            }
            if (!files[i].isDirectory()) continue;
            this.buildMapDatabaseFromFolder(files[i]);
        }
    }

    public Vector getMapList() {
        this.mapList = new Vector();
        PluginManagerVox.buildMapListFromFolder(new File(savedMapLocation), "", this.mapList);
        return this.mapList;
    }

    public static void buildMapListFromFolder(File resourcesDir, String base, List mapList) {
        File[] files = resourcesDir.listFiles();
        if (files == null) {
            SSOptionPane.showMessageDialog("Your support folder cannot be read or does not exist! Check the file permissions and try again.");
        }
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getName();
            if (filename.endsWith(SSApp.mapExtension)) {
                mapList.add(base + filename.substring(0, filename.length() - 5));
                continue;
            }
            if (!files[i].isDirectory()) continue;
            PluginManagerVox.buildMapListFromFolder(files[i], base + filename + "/", mapList);
        }
        Comparator caseInsensitive = new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }

            public boolean equals(Object o1, Object o2) {
                return o1.toString().equalsIgnoreCase(o2.toString());
            }
        };
        Collections.sort(mapList, caseInsensitive);
    }

    public boolean isThemeInstalled(String themeName) {
        Vector themeVector = (Vector)this.onlineThemeDatabase.get(themeName);
        if (themeVector == null) {
            return true;
        }
        String[] themeFiles = new String[themeVector.size()];
        for (int i = 0; i < themeFiles.length; ++i) {
            String temp = (String)themeVector.get(i);
            themeFiles[i] = temp.substring(temp.lastIndexOf(47) + 1);
        }
        boolean[] filePresent = new boolean[themeFiles.length];
        for (int i = 0; i < filePresent.length; ++i) {
            filePresent[i] = false;
        }
        String[] themeLocations = PluginLocalMemory.getThemeLocations();
        for (int l = 0; l < themeLocations.length; ++l) {
            for (int f = 0; f < themeFiles.length; ++f) {
                if (!new File(themeLocations[l] + File.separator + themeName + File.separator + themeFiles[f]).exists()) continue;
                filePresent[f] = true;
            }
        }
        for (int i = 0; i < filePresent.length; ++i) {
            if (filePresent[i]) continue;
            return false;
        }
        return true;
    }

    public int getColumnCount() {
        return 8;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int row, int col) {
        return ((Object[])this.rows.get(row))[col];
    }

    public Object getValueAtFullList(int row, int col) {
        return ((Object[])this.rowsAll.get(row))[col];
    }

    public String getColumnName(int col) {
        return Translator.getString(this.keys[col]);
    }

    public int getColumnIndex(String title) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(title)) continue;
            return i;
        }
        System.out.println("PluginManager failed for getColumnIndex(" + title + ")");
        return -1;
    }

    public void getPluginList(PluginListener sender) {
        this.sender = sender;
        if (this.rows.size() != 0) {
            sender.dataReady();
            return;
        }
        if (this.runMode != -1) {
            System.out.println("getPluginList() called while something is going on. abort");
            return;
        }
        sender.informUser(Translator.getString("Downloadingdata"));
        this.runMode = 0;
        new Thread((Runnable)this, "Plugin-data-downloader").start();
    }

    public void run() {
        if (this.runMode == 0) {
            this.downloadPluginList();
        } else if (this.runMode == 1) {
            while (this.installQ.size() > 0) {
                int nextRowIndex;
                this.installRowIndex = nextRowIndex = ((Integer)this.installQ.remove(0)).intValue();
                this.installPluginAction();
            }
            PluginWindowVox.getInstance().setProgressBar(false);
            this.writeRowsToDisk();
        }
        this.runMode = -1;
        this.sender = null;
    }

    private void downloadPluginList() {
        ObjectInputStream in;
        String lastCheckDate;
        System.out.println("PluginManager: Downloading the plugin list from sillysoft");
        String contents = null;
        try {
            lastCheckDate = Prefs.get("plugins_mostRecentPluginDate", "2007-11-07 15:01:41");
            if (!new File(cacheLocation).exists()) {
                lastCheckDate = "";
            }
            String pluginURL = "http://sillysoft.net/" + SSApp.shortName().toLowerCase() + "/plugins_gz.php?mostRecentDate=" + URLEncoder.encode(lastCheckDate, "UTF-8") + "&platform=" + (SS.isMacintosh ? "mac" : (SS.isWindows ? "win" : "other")) + "&" + (SSApp.shortNameLower().equals("lux") ? LuxTracker.cookie() : VoxTracker.cookie()) + (Prefs.getBoolean("showBetaMaps") ? "&showBetaMaps=true" : "") + (Prefs.get("expansionsInstalled", null) != null ? "&expansionsInstalled=" + Prefs.get("expansionsInstalled", null) : "");
            contents = URLTool.getURL(pluginURL, "UTF-8");
        }
        catch (Exception e) {
            this.sender.informUser(Translator.getString("Couldnotdownloaddata"));
            System.out.println("PluginManager: Could not download the plugin list: " + e);
            return;
        }
        this.sender.informUser(Translator.getString("Buildinglocalplugins"));
        this.buildLocalMapDatabase();
        if (new File(cacheLocation).exists()) {
            try {
                in = new ObjectInputStream(new FileInputStream(cacheLocation));
                this.rowsAll = (Vector)in.readObject();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.onlineThemeDatabase = new Hashtable();
        if (new File(cacheLocationThemes).exists()) {
            try {
                in = new ObjectInputStream(new FileInputStream(cacheLocationThemes));
                this.onlineThemeDatabase = (Hashtable)in.readObject();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (contents.indexOf("<message>no new plugins</message>") == -1) {
            this.parsePluginData(contents);
            String mostRectDate = XMLTool.extract("most_recent_date", contents);
            Prefs.put("plugins_mostRecentPluginDate", mostRectDate);
            this.writeRowsToDisk();
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(cacheLocationThemes));
                out.writeObject(this.onlineThemeDatabase);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.rowsAll.size() < 100 && SSApp.shortName().equals("Lux")) {
            SS.debug("Firing plugin manager restore");
            lastCheckDate = Prefs.get("plugins_mostRecentPluginDate", "2007-11-07 15:01:41");
            new File(cacheLocation).delete();
            new File(cacheLocationThemes).delete();
            this.downloadPluginList();
            return;
        }
        this.rows = (Vector)this.rowsAll.clone();
        this.sender.dataReady();
    }

    private void parsePluginData(String contents) {
        try {
            this.sender.informUser(Translator.getString("Parsingdata"));
            base_URL = XMLTool.extract("base_URL", contents);
            String contentsTheme = XMLTool.extract("themelist", contents);
            String plugin = XMLTool.extract("themefile", contentsTheme);
            int h = 1;
            while (plugin != null) {
                String theme = XMLTool.extract("theme", plugin);
                String URL2 = XMLTool.extract("URL", plugin);
                Vector<String> aThemeList = (Vector<String>)this.onlineThemeDatabase.get(theme);
                if (aThemeList == null) {
                    aThemeList = new Vector<String>();
                    this.onlineThemeDatabase.put(theme, aThemeList);
                }
                aThemeList.add(URL2);
                plugin = XMLTool.extract("themefile", contentsTheme, h);
                ++h;
            }
            this.sender.informUser(Translator.getString("Parsingmapdata"));
            plugin = XMLTool.extract("map", contents);
            h = 1;
            while (plugin != null) {
                try {
                    String title = XMLTool.extract("title", plugin);
                    String version = XMLTool.extract("version", plugin);
                    String theme = XMLTool.extract("theme", plugin);
                    String URL3 = XMLTool.extract("file_list", plugin);
                    Vector<String> URLVector = new Vector<String>();
                    int subStart = 0;
                    int subEnd = URL3.indexOf(59);
                    while (subEnd != -1) {
                        URLVector.add(StringTool.encodeSpaces(URL3.substring(subStart, subEnd)));
                        subStart = subEnd + 1;
                        subEnd = URL3.indexOf(59, subEnd + 1);
                    }
                    URLVector.add(StringTool.encodeSpaces(URL3.substring(subStart)));
                    String install_location = XMLTool.extract("install_location", plugin);
                    Object[] obs = new Object[]{title, "Maps".equals(install_location) ? Translator.getString("Map") : ("Agents".equals(install_location) ? Translator.getString("AI") : ("MapGenerators".equals(install_location) ? Translator.getString("RandomMapGenerator") : install_location)), XMLTool.extract("author", plugin), version, XMLTool.extract("teams", plugin), "placeholder", XMLTool.extract("rating", plugin), XMLTool.extract("date", plugin), XMLTool.extract("webpage", plugin), XMLTool.extract("description", plugin), URLVector, XMLTool.extract("image", plugin), theme, install_location, XMLTool.extract("id", plugin), XMLTool.extract("cat", plugin)};
                    obs[5] = this.getStatusOfPlugin(obs);
                    int mapExistsIndex = this.rowsAllGetIndexOfID(XMLTool.extract("id", plugin));
                    if (mapExistsIndex > -1) {
                        this.rowsAll.remove(mapExistsIndex);
                    }
                    this.rowsAll.add(obs);
                }
                catch (Exception f) {
                    f.printStackTrace();
                }
                plugin = XMLTool.extract("map", contents, h);
                ++h;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void installPlugin(int rowIndex, boolean uninstall) {
        if (this.installQ == null) {
            this.installQ = new ArrayList();
        }
        if (((Object[])this.rows.get(rowIndex))[5] == "Installing...") {
            return;
        }
        if (!uninstall && !((Object[])this.rows.get(rowIndex))[13].equals("URL")) {
            ((Object[])this.rows.get((int)rowIndex))[5] = "Installing...";
        }
        this.installQ.add(new Integer(rowIndex));
        if (this.runMode == -1) {
            this.runMode = 1;
            new Thread((Runnable)this, "Plugin-installer").start();
        }
    }

    private void installPluginAction() {
        int rowIndex = this.installRowIndex;
        if (this.getValueAt(rowIndex, 5).equals(PluginWindowVox.INSTALLED)) {
            this.uninstallPlugin(rowIndex);
            return;
        }
        String title = (String)this.getValueAt(rowIndex, 0);
        Vector URLVector = (Vector)this.getValueAt(rowIndex, 10);
        boolean errors = false;
        if ("URL".equals(this.getValueAt(rowIndex, 13))) {
            BrowserLauncher.openURL((String)URLVector.get(0));
            PluginWindowVox.getInstance().informUser(" ");
            return;
        }
        PluginWindowVox.getInstance().setProgressBar(true);
        PluginWindowVox.getInstance().informUser(Translator.getString("Installing") + " " + title + "...");
        for (int i = 0; i < URLVector.size(); ++i) {
            String url = base_URL + (String)URLVector.get(i);
            String filename = url.substring(url.lastIndexOf(47) + 1);
            filename = StringTool.stripGzip(filename);
            filename = URLDecoder.decode(filename);
            try {
                String finalDestination;
                File tempFile;
                String installPath;
                System.out.println("PluginManager: Downloading plugin file " + filename);
                new File(tempMapLocation).mkdirs();
                String localFile = URLTool.downloadURLtoFile(url, tempMapLocation);
                if (url.endsWith(".gz")) {
                    System.out.println("PluginManager: Decompressing " + localFile);
                    String unzippedLocalLocation = ZipTool.ungzip(localFile);
                    System.out.println("PluginManager: Deleting " + localFile);
                    new File(localFile).delete();
                    localFile = unzippedLocalLocation;
                }
                if ("Boards/Saved".equals(installPath = (String)this.getValueAt(rowIndex, 13)) || "Maps".equals(installPath)) {
                    System.out.println("PluginManager: Installing map " + localFile);
                    this.mapList = null;
                    String theme = (String)((Object[])this.rows.get(rowIndex))[12];
                    if (!this.isThemeInstalled(theme)) {
                        PluginWindowVox.getInstance().informUser(Translator.getString("Installingthetheme") + " " + theme + ". This could take a few minutes...");
                        if (!this.installTheme(theme)) {
                            errors = true;
                        }
                    }
                    this.installBoard(localFile, true);
                } else if ("Agents".equals(installPath)) {
                    System.out.println("PluginManager: AI temporarily at " + localFile);
                    tempFile = new File(localFile);
                    finalDestination = supportFolder + installPath + File.separator + tempFile.getName();
                    int lastSlashLoc = ((String)URLVector.get(i)).lastIndexOf("/");
                    if (lastSlashLoc > 8) {
                        String subfolder = ((String)URLVector.get(i)).substring(((String)URLVector.get(i)).indexOf("/") + 1, lastSlashLoc);
                        System.out.println("PluginManager: AI needs subfolder: " + subfolder);
                        new File(supportFolder + installPath + File.separator + subfolder).mkdirs();
                        finalDestination = supportFolder + installPath + File.separator + subfolder + File.separator + tempFile.getName();
                    }
                    System.out.println("PluginManager: AI installing to " + finalDestination);
                    tempFile.renameTo(new File(finalDestination));
                    LuxController.getInstance().fillPlayerTypes();
                } else if ("MapGenerators".equals(installPath)) {
                    System.out.println("PluginManager: Installing MapGenerator " + localFile);
                    tempFile = new File(localFile);
                    finalDestination = supportFolder + installPath + File.separator + tempFile.getName();
                    System.out.println("PluginManager: Installing MapGenerator to " + finalDestination);
                    tempFile.renameTo(new File(finalDestination));
                    if (finalDestination.endsWith(".pl")) {
                        System.out.println("PluginManager: Changing permissions for " + finalDestination);
                        try {
                            FileTool.chmod("755", finalDestination);
                        }
                        catch (Exception e) {
                            System.out.println("PluginManager: While installing the '" + title + "' plugin the command 'chmod 755 " + finalDestination + "' failed. This is expected when running on Windows OS. If you are running Mac OS X or a unix then this is failure will break things and you should correct it (the file must be made executable).");
                        }
                    }
                    if (i + 1 == URLVector.size()) {
                        SSApp.getInstance().fillMapSelector(title);
                    }
                    BoardCache.clearCache();
                } else {
                    System.out.println("PluginManager: Unknown plugin type. InstallPath = '" + installPath + "'");
                }
                ((Object[])this.rows.get((int)rowIndex))[5] = PluginWindowVox.INSTALLED;
                continue;
            }
            catch (Exception e) {
                errors = true;
                e.printStackTrace();
            }
        }
        PluginWindowVox.getInstance().doneInstalling();
        if (errors) {
            PluginWindowVox.getInstance().informUser(Translator.getString("errorsinstalling") + " '" + title + "'.");
        } else {
            PluginWindowVox.getInstance().informUser(title + " " + Translator.getString("installsuccess"));
        }
    }

    public void installThemeInBackground(String themeName) {
        final String name = themeName;
        Runnable installTheme = new Runnable(){

            public void run() {
                PluginManager.getInstance().installTheme(name);
            }
        };
        new Thread(installTheme, "Plugin-background-theme-installer").start();
    }

    public boolean installBoard(String filename, boolean overwrite) {
        SS.debug("PluginManager -> installBoard(" + filename + ", " + overwrite + ")");
        if (!filename.endsWith(SSApp.mapExtension)) {
            return false;
        }
        File newBoard = new File(filename);
        String name = newBoard.getName();
        String moveTo = savedMapLocation + File.separator + name;
        File oldBoard = new File(moveTo);
        if (oldBoard.exists() && overwrite) {
            oldBoard.delete();
        }
        if (!oldBoard.exists()) {
            if (!FileTool.copyFile(filename, moveTo)) {
                SS.debug("PluginManager -> error copying a custom board to the proper place");
                SS.beep();
                SSOptionPane.showMessageWithTitle(Translator.getString("Therewasanerrortryingtoaddthecustomboard") + " '" + name + "'\n\nError code: 44653", Translator.getString("Error"));
                return false;
            }
            try {
                newBoard.delete();
            }
            catch (Throwable e) {
                SS.debug("PluginManager -> couldn't delete a custom board file after copying it.");
            }
        }
        SSApp.getInstance().fillMapSelector(name.substring(0, name.length() - 5));
        return true;
    }

    public void progress(int intParam, int fileSize, String stringParam) {
        PluginWindowVox.getInstance().informUser(this.progressString + ": " + intParam + "/" + fileSize + "k");
    }

    public boolean installTheme(String theme) {
        System.out.println("PluginManager: Installing theme -> " + theme);
        boolean result = true;
        String themeLocation = supportFolder + "Themes" + File.separator + theme;
        new File(themeLocation).mkdirs();
        Vector themeVector = (Vector)this.onlineThemeDatabase.get(theme);
        ArrayTool.removeDuplicates(themeVector);
        for (int i = 0; i < themeVector.size(); ++i) {
            try {
                System.out.println("PluginManager: Downloading theme file " + themeVector.get(i));
                this.progressString = Translator.getString("Installing") + " " + theme + " " + StringTool.getFilenameFromPath((String)themeVector.get(i)).toLowerCase();
                URLTool.downloadURLtoFile(base_URL + (String)themeVector.get(i), themeLocation, this);
                continue;
            }
            catch (Exception e) {
                System.out.println("PluginManager: Error downloading the theme file " + themeVector.get(i));
                e.printStackTrace();
                result = false;
            }
        }
        PluginLocalMemory.clearThemeList();
        if (SSApp.isVox) {
            Visuals.reloadTheme(theme);
        } else {
            LuxView.reloadTheme(theme);
        }
        return result;
    }

    public void uninstallPlugin(int rowIndex) {
        String title = (String)this.getValueAt(rowIndex, 0);
        PluginWindowVox.getInstance().informUser(Translator.getString("Removing") + " '" + title + "'...");
        boolean errors = false;
        boolean fillPlayerTypes = false;
        Vector URLVector = (Vector)this.getValueAt(rowIndex, 10);
        for (int i = 0; i < URLVector.size(); ++i) {
            String url = (String)URLVector.get(i);
            String filename = url.substring(url.lastIndexOf(47) + 1);
            filename = StringTool.stripGzip(filename);
            filename = URLDecoder.decode(filename);
            String fileLocation = supportFolder + this.getValueAt(rowIndex, 13) + File.separator + filename;
            int lastSlashLoc = ((String)URLVector.get(i)).lastIndexOf("/");
            if (lastSlashLoc > 8) {
                String subfolder = ((String)URLVector.get(i)).substring(((String)URLVector.get(i)).indexOf("/") + 1, lastSlashLoc);
                System.out.println("PluginManager: Deleting inside subfolder " + subfolder);
                fileLocation = supportFolder + this.getValueAt(rowIndex, 13) + File.separator + subfolder + File.separator + filename;
            }
            System.out.println("PluginManager: Deleting file " + fileLocation);
            if (!new File(fileLocation).delete()) {
                errors = true;
            }
            if (!"Agents".equals(this.getValueAt(rowIndex, 13))) continue;
            fillPlayerTypes = true;
        }
        SSApp.getInstance().fillMapSelector(null);
        PluginWindowVox.getInstance().doneInstalling();
        if (errors) {
            SS.beep();
            PluginWindowVox.getInstance().informUser(Translator.getString("errorsuninstalling") + " '" + title + "'.");
        } else {
            ((Object[])this.rows.get((int)rowIndex))[5] = PluginWindowVox.NOT_INSTALLED;
            PluginWindowVox.getInstance().informUser(title + " " + Translator.getString("removesuccess"));
        }
    }

    public int getRate(int rowIndex) {
        String title = (String)this.getValueAt(rowIndex, 14);
        return PluginRater.getRate(title);
    }

    public void rateChange(int rowIndex, int newRate) {
        if (rowIndex == -1) {
            return;
        }
        String id = (String)this.getValueAt(rowIndex, 14);
        PluginRater.rateChange(id, newRate);
    }

    public void informUser(String text) {
    }

    public void dataReady() {
        int oldCount;
        int newCount = this.rowsAll.size();
        int newPluginCount = newCount - (oldCount = Prefs.getInt("plugin_seen_count", 0));
        if (newPluginCount > 0) {
            if (this.checkingForTheme == null) {
                Prefs.putInt("plugin_seen_count", newCount);
                PluginWindowVox.getInstance();
                PluginWindowVox.newPluginsAvailable(newPluginCount, this.boardWindow);
            }
        } else {
            System.out.println("PluginManager: Automatic plugin check found no new maps");
        }
        if (this.checkingForTheme != null && this.onlineThemeDatabase != null) {
            Vector themeVector = (Vector)this.onlineThemeDatabase.get(this.checkingForTheme);
            if (themeVector != null) {
                System.out.println("PluginManager: Found the theme '" + this.checkingForTheme + "' in the online database");
                PluginWindowVox.askUserToInstallTheme(this.checkingForTheme, this.boardWindow);
            } else {
                System.out.println("PluginManager: Did not find theme '" + this.checkingForTheme + "' online");
            }
            this.boardWindow = null;
            this.checkingForTheme = null;
        }
        this.fireTableDataChanged();
        this.refreshRatingsCheck();
    }

    public void lookForTheme(String themeName, SSFrame boardWindow) {
        if (Prefs.getBoolean("lookformissingthemes", true)) {
            System.out.println("PluginManager: Looking for the theme '" + themeName + "' online...");
            if (this.onlineThemeDatabase == null) {
                this.getPluginList(this);
            }
            this.checkingForTheme = themeName;
            this.boardWindow = boardWindow;
            this.dataReady();
        } else {
            System.out.println("PluginManager: Found a reference to a theme that we don't have (" + themeName + "). However the user has preferences set to NOT check for updates, so do not go looking for the theme online. =(");
        }
    }

    public void changeSet(int setIndex) {
        Prefs.putInt("pluginMode", setIndex);
        if (SSApp.isVox) {
            if (setIndex > 10) {
                setIndex += 3;
            } else if (setIndex > 3) {
                ++setIndex;
            }
        }
        this.rows = new Vector();
        if (setIndex == 0) {
            float rating = 0.0f;
            for (int i = 0; i < this.rowsAll.size(); ++i) {
                try {
                    String ratingString = (String)((Object[])this.rowsAll.get(i))[6];
                    rating = Float.parseFloat(ratingString.substring(0, ratingString.indexOf(32)));
                }
                catch (Exception e) {
                    rating = 0.0f;
                }
                if (!((double)rating >= 3.9)) continue;
                this.rows.add(this.rowsAll.get(i));
            }
        } else if (setIndex == 1) {
            this.rows = this.rowsAll;
        } else if (setIndex == 2) {
            SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd");
            GregorianCalendar monthsAgo = new GregorianCalendar();
            ((Calendar)monthsAgo).add(2, -3);
            Date monthsAgoDate = monthsAgo.getTime();
            for (int i = 0; i < this.rowsAll.size(); ++i) {
                String dateString = (String)((Object[])this.rowsAll.get(i))[7];
                try {
                    Date d = dateParser.parse(dateString);
                    if (!d.after(monthsAgoDate)) continue;
                    this.rows.add(this.rowsAll.get(i));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("pm chech 2534342: " + e);
                }
            }
        } else if (setIndex != 3) {
            if (setIndex == 4) {
                for (int i = 0; i < this.rowsAll.size(); ++i) {
                    String install_loc = (String)((Object[])this.rowsAll.get(i))[13];
                    if (!"Agents".equals(install_loc)) continue;
                    this.rows.add(this.rowsAll.get(i));
                }
            } else if (setIndex == 13) {
                for (int i = 0; i < this.rowsAll.size(); ++i) {
                    String install_loc = (String)((Object[])this.rowsAll.get(i))[13];
                    if (!"MapGenerators".equals(install_loc)) continue;
                    this.rows.add(this.rowsAll.get(i));
                }
            } else {
                int catXMLindex = 4 < setIndex && setIndex < 12 ? setIndex - 5 : (12 == setIndex ? 9 : (10 < setIndex ? setIndex - 7 : 0));
                for (int i = 0; i < this.rowsAll.size(); ++i) {
                    String category = (String)((Object[])this.rowsAll.get(i))[15];
                    if (category.charAt(catXMLindex) != '1') continue;
                    this.rows.add(this.rowsAll.get(i));
                }
            }
        }
        this.fireTableDataChanged();
    }

    public void changeSetToSearch(String searchTerm) {
        String lowerTerm = searchTerm.toLowerCase();
        if (lowerTerm.equals(this.lastSearchTermLower)) {
            return;
        }
        if (lowerTerm.equals("refreshratings")) {
            this.refreshRatings();
            SS.beep();
        }
        if (lowerTerm.equals("deletecache") || lowerTerm.equals("recache")) {
            SS.beep();
            PluginManagerVox.deleteCache();
        }
        if (searchTerm.trim().equals("")) {
            this.changeSet(Prefs.getInt("pluginMode", SSApp.isVox ? 2 : 0));
            return;
        }
        this.lastSearchTermLower = lowerTerm;
        this.rows = new Vector();
        for (int i = 0; i < this.rowsAll.size(); ++i) {
            try {
                if (((String)((Object[])this.rowsAll.get(i))[0]).toLowerCase().indexOf(lowerTerm) == -1 && ((String)((Object[])this.rowsAll.get(i))[2]).toLowerCase().indexOf(lowerTerm) == -1 && ((String)((Object[])this.rowsAll.get(i))[9]).toLowerCase().indexOf(lowerTerm) == -1) continue;
                this.rows.add(this.rowsAll.get(i));
                continue;
            }
            catch (Exception e) {
                System.out.println("search error 2873: " + e);
            }
        }
        this.fireTableDataChanged();
    }

    public boolean isRowURL(int rowIndex) {
        return "URL".equals(this.getValueAt(rowIndex, 13));
    }

    public String getIDFromTitle(String title) {
        if (title == null) {
            return " ";
        }
        if (this.rowsAll.size() == 0) {
            // empty if block
        }
        for (int i = 0; i < this.rowsAll.size(); ++i) {
            if (!title.equals(this.getValueAtFullList(i, 0))) continue;
            return (String)this.getValueAtFullList(i, 14);
        }
        return " ";
    }

    public void loadMapGenerators() {
        this.mapGenerators = new Vector();
        this.mapGeneratorsChoices = new Vector();
        String[] possibleGenerators = DirectoryTool.listFilesWithSuffix(DesktopTool.supportFolderPath() + "MapGenerators", ".class");
        SSClassLoader loader = new SSClassLoader(DesktopTool.supportFolderPath() + "MapGenerators");
        for (int i = 0; i < possibleGenerators.length; ++i) {
            try {
                Class mapClass = loader.loadClass(possibleGenerators[i]);
                LuxMapGenerator gen = (LuxMapGenerator)mapClass.newInstance();
                this.mapGenerators.add(gen);
                this.mapGeneratorsChoices.add(gen.getChoices());
                continue;
            }
            catch (Throwable t) {
                System.out.println("LuxMapGenerator failed to load (may be a secondary class): " + possibleGenerators[i]);
            }
        }
    }

    public LuxMapGenerator getMapGeneratorForChoice(String theChoice) {
        for (int i = 0; i < this.mapGenerators.size(); ++i) {
            List choices = (List)this.mapGeneratorsChoices.get(i);
            if (!choices.contains(theChoice)) continue;
            return (LuxMapGenerator)this.mapGenerators.get(i);
        }
        if (theChoice.indexOf("- Bio -") > 0) {
            return new Biohazard();
        }
        SS.debug("The LuxMapGenerator for choice '" + theChoice + "' could not be found. Using default random generator instead. This may cause an error.");
        return new RandomMapGenerator();
    }

    public List getAllMapGeneratorChoices() {
        Vector result = new Vector();
        for (int i = 0; i < this.mapGeneratorsChoices.size(); ++i) {
            result.addAll((List)this.mapGeneratorsChoices.get(i));
        }
        return result;
    }

    public List getMapGeneratorList() {
        return this.mapGenerators;
    }

    public List getMapGeneratorChoicesList() {
        return this.mapGeneratorsChoices;
    }

    public int rowsAllGetIndexOfID(String id) {
        for (int i = 0; i < this.rowsAll.size(); ++i) {
            if (!id.equals((String)((Object[])this.rowsAll.get(i))[14])) continue;
            return i;
        }
        return -1;
    }

    public void refreshRatingsCheck() {
        long lastPluginRatingRefresh;
        long now = System.currentTimeMillis();
        if (now - (lastPluginRatingRefresh = Prefs.getLong("lastPluginRatingRefresh", 1194934261566L)) > 259200000L) {
            new Thread("Refresh-Plugin-Ratings"){

                public void run() {
                    Thread.currentThread().setPriority(1);
                    PluginManagerVox.this.refreshRatings();
                }
            }.start();
        }
    }

    public void refreshRatings() {
        System.out.println("PluginManager: Starting to refresh rankings");
        String pluginURL = "http://sillysoft.net/" + SSApp.shortNameLower() + "/plugins_gz_ratings.php?" + (SSApp.shortNameLower().equals("lux") ? LuxTracker.cookie() : VoxTracker.cookie()) + (Prefs.getBoolean("showBetaMaps") ? "&showBetaMaps=true" : "") + (Prefs.get("expansionsInstalled", null) != null ? "&expansionsInstalled=" + Prefs.get("expansionsInstalled", null) : "");
        try {
            String contents = URLTool.getURL(pluginURL, "UTF-8");
            String ratingSet = XMLTool.extract("n", contents);
            int i = 1;
            while (ratingSet != null) {
                String id = XMLTool.extract("id", ratingSet);
                String rating = XMLTool.extract("r", ratingSet);
                int index = this.rowsAllGetIndexOfID(id);
                if (index > -1) {
                    ((Object[])this.rowsAll.get((int)index))[6] = rating;
                }
                ratingSet = XMLTool.extract("n", contents, i);
                ++i;
            }
            this.writeRowsToDisk();
            Prefs.putLong("lastPluginRatingRefresh", System.currentTimeMillis());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("PluginManager: Finished updating ratings");
    }

    private void writeRowsToDisk() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(cacheLocation));
            out.writeObject(this.rowsAll);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteCache() {
        new File(cacheLocation).delete();
        new File(cacheLocationThemes).delete();
        if (shared != null) {
            PluginManagerVox.shared.rows = new Vector();
            PluginManagerVox.shared.rowsAll = new Vector();
            shared.getPluginList(shared);
        }
    }
}

