/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.net;

import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.LuxOptions;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import com.sillysoft.tools.XMLTool;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Vector;

public class PingRankings
extends Thread {
    String[] nick;
    String[] userKey;
    String[] IP;
    int[] finalPosition;
    int[] finalRounds;
    NetBoss boss;
    String networkKey;
    String map;
    StringBuffer extraInfo;
    private LuxOptions ops;
    private boolean sentData = false;
    private boolean invalid = false;
    private String invalidateString;

    PingRankings(String[] nick, String[] userKey, String map, String[] IP) {
        this.nick = nick;
        this.userKey = userKey;
        this.IP = IP;
        this.finalPosition = new int[nick.length];
        this.finalRounds = new int[nick.length];
        this.map = map;
        this.extraInfo = new StringBuffer();
    }

    void invalidate(String lostUserName) {
        this.invalidateString = lostUserName;
        this.invalid = true;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public String invalidateString() {
        if (!this.invalid) {
            return null;
        }
        return this.invalidateString;
    }

    void addRankings(int[] finalPosition, int[] finalRounds, String networkKey, LuxOptions ops, NetBoss boss) {
        this.ops = ops;
        ops.setEndTime();
        if (this.invalid) {
            System.out.println("PingRankings is invalid. Will not send.");
            if (!"HOSTHUMAN".equals(this.invalidateString)) {
                boss.println("\u2731 " + Translator.getString("Rankingswerenotsent") + " \u2731");
                boss.sendToAll("tra: 2 Rankingswerenotsent");
            }
            return;
        }
        if (this.sentData) {
            System.out.println("PingRankings almost sent data twice. That's not allowed.");
            return;
        }
        this.sentData = true;
        this.finalPosition = finalPosition;
        this.finalRounds = finalRounds;
        this.networkKey = networkKey;
        this.boss = boss;
        this.start();
    }

    public void run() {
        for (int i = 0; i < this.nick.length; ++i) {
            if (this.finalPosition[i] == i + 1) continue;
            for (int j = 0; j < this.nick.length; ++j) {
                if (this.finalPosition[j] != i + 1) continue;
                String temp = this.nick[i];
                this.nick[i] = this.nick[j];
                this.nick[j] = temp;
                temp = this.userKey[i];
                this.userKey[i] = this.userKey[j];
                this.userKey[j] = temp;
                temp = this.IP[i];
                this.IP[i] = this.IP[j];
                this.IP[j] = temp;
                int tempInt = this.finalPosition[i];
                this.finalPosition[i] = this.finalPosition[j];
                this.finalPosition[j] = tempInt;
                tempInt = this.finalRounds[i];
                this.finalRounds[i] = this.finalRounds[j];
                this.finalRounds[j] = tempInt;
                j = this.nick.length;
            }
        }
        int uniqueHumanCount = 0;
        Vector<String> seenHumanKeys = new Vector<String>();
        for (int i = 0; i < this.userKey.length; ++i) {
            if (this.userKey[i].equals("666") || seenHumanKeys.contains(this.userKey[i])) continue;
            ++uniqueHumanCount;
            seenHumanKeys.add(this.userKey[i]);
        }
        if (uniqueHumanCount < 2) {
            SS.debug("Rankings only has " + uniqueHumanCount + " human. Rankings will not be sent.");
            return;
        }
        StringBuffer varlist = new StringBuffer("version=");
        varlist.append(6.23f);
        varlist.append("&networkKey=");
        varlist.append(this.networkKey);
        try {
            for (int i = 0; i < this.nick.length; ++i) {
                if ("".equals(this.userKey[i])) {
                    this.nick[i] = "Unregistered";
                }
                varlist.append("&");
                varlist.append(URLEncoder.encode("nick[]"));
                varlist.append("=");
                varlist.append(URLEncoder.encode(this.nick[i], "UTF-8"));
                varlist.append("&");
                varlist.append(URLEncoder.encode("rounds[]"));
                varlist.append("=");
                varlist.append(this.finalRounds[i]);
                varlist.append("&");
                varlist.append(URLEncoder.encode("userKey[]"));
                varlist.append("=");
                varlist.append(URLEncoder.encode(this.userKey[i]));
                varlist.append("&");
                varlist.append(URLEncoder.encode("IP[]"));
                varlist.append("=");
                if (this.IP[i] == null) {
                    this.IP[i] = "na";
                }
                varlist.append(URLEncoder.encode(this.IP[i]));
            }
            if (!this.ops.isRanked) {
                varlist.append("&nonRanked=true");
            }
            varlist.append("&map=");
            varlist.append(URLEncoder.encode(this.map, "UTF-8"));
            varlist.append("&hostName=");
            varlist.append(URLEncoder.encode(this.boss.name(), "UTF-8"));
            varlist.append("&startTime=");
            varlist.append(this.ops.gameStarted);
            varlist.append("&endTime=");
            varlist.append(this.ops.gameEnded);
            varlist.append("&options=");
            varlist.append(PingRankings.createOptionsString(this.ops));
            varlist.append("&extraInfo=");
            varlist.append(URLEncoder.encode(this.extraInfo.toString()));
        }
        catch (UnsupportedEncodingException unex) {
            this.boss.println("\u2731 Error: UnsupportedEncodingException. \u2731");
        }
        String urlstring = "http://sillysoft.net/lux/addranking503.php";
        String postData = varlist.toString();
        for (int tries = 0; tries < 5; ++tries) {
            try {
                String inputFull = URLTool.postToURL(urlstring, postData, "UTF-8");
                String input = XMLTool.extract("message", inputFull);
                if (input != null && !"".equals(input.trim())) {
                    input = input.replace('~', '\n');
                    this.boss.println(input);
                    this.boss.sendToAll(input);
                    System.out.println(inputFull);
                    return;
                }
                if (tries >= 4) continue;
                this.boss.println("\u2731 Error sending rankings (empty response). Lux will try again in 10 seconds. \u2731");
                this.boss.sendToAll("\u2731 Error sending rankings (empty response). Lux will try again in 10 seconds. \u2731");
                Thread.sleep(10000L);
                continue;
            }
            catch (Throwable t) {
                if (tries < 4) {
                    try {
                        this.boss.println("\u2731 Error sending rankings (" + t + "). Lux will try again in 10 seconds." + " \u2731");
                        this.boss.sendToAll("\u2731 Error sending rankings (" + t + "). Lux will try again in 10 seconds." + " \u2731");
                        Thread.sleep(10000L);
                    }
                    catch (Throwable y) {
                        // empty catch block
                    }
                }
                System.out.println("Lux -> Error adding internet record info: ");
                t.printStackTrace();
            }
        }
        this.boss.println("\u2731 " + Translator.getString("errorSendingRankings") + " \u2731");
        this.boss.sendToAll("tra: 2 errorSendingRankings");
    }

    void log(String info) {
        this.extraInfo.append(new Date() + ": " + info + "\n");
    }

    private static String createOptionsString(LuxOptions ops) {
        StringBuffer sb = new StringBuffer("The starting position was ");
        if (ops.useScenario) {
            sb.append("taken from the map's scenario.");
        } else {
            sb.append("initial countries ");
            if (ops.initialCountries) {
                sb.append("random");
            } else {
                sb.append("selected");
            }
            sb.append(", initial armies ");
            if (ops.initialArmies == 0) {
                sb.append("random.");
            } else if (ops.initialArmies == 1) {
                sb.append("placed.");
            } else if (ops.initialArmies == 2) {
                sb.append("even.");
            }
        }
        if (ops.useCards) {
            sb.append(" Cards were set at ");
            sb.append(CardSequence.sequences[ops.cardSequenceCode]);
            sb.append(" transfer cards on conquer was ");
            if (ops.cardTransfer) {
                sb.append("ON, immediate cash was ");
                if (ops.immediateCardCash) {
                    sb.append("ON");
                } else {
                    sb.append("OFF");
                }
            } else {
                sb.append("OFF");
            }
        } else {
            sb.append(" Cards were not used");
        }
        if (ops.continentSequence.increases()) {
            sb.append(". Continent bonuses went up by ");
            sb.append(ops.continentSequence.shortString());
            sb.append(" each round");
        }
        if (!ops.firstTurnContBonus) {
            sb.append(" NFTCB");
        }
        sb.append(". The turn timer was ");
        if (ops.useTurnTimer) {
            sb.append("set to ");
            if (ops.turnTimerLength < 60.0f) {
                sb.append((int)ops.turnTimerLength);
                sb.append("s. ");
            } else {
                String sec = String.valueOf((int)(ops.turnTimerLength % 60.0f));
                if (sec.length() == 1) {
                    sec = "0" + sec;
                }
                sb.append((int)(ops.turnTimerLength / 60.0f));
                sb.append(":");
                sb.append(sec);
                sb.append(". ");
            }
        } else {
            sb.append("OFF. ");
        }
        if (ops.gameLimitMinutes > 0) {
            sb.append("Game limit was " + ops.gameLimitMinutes + "m. ");
        }
        return URLEncoder.encode(sb.toString());
    }
}

