/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.net;

import com.sillysoft.lux.Card;
import com.sillysoft.lux.Country;
import com.sillysoft.lux.LuxObserver;
import com.sillysoft.lux.LuxOptions;
import com.sillysoft.lux.gui.GameControllerAbstract;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.net.LuxTracker;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class NetConnection
extends Thread
implements LuxObserver {
    private static final float networkVersion = 2.5f;
    private float remoteLuxVersion;
    private NetBoss netBoss;
    private GameControllerAbstract control;
    private Thread listenThread;
    private boolean forcingTurnEnd = false;
    private boolean readingHeaders;
    private String remoteName;
    private boolean guestOnly;
    private String remoteUserKey;
    private boolean server;
    private boolean killed = false;
    private boolean moderator = false;
    private Socket sock;
    private OutputStream out;
    private InputStream in;
    private boolean acceptPlayerList = false;
    private List playerList;
    private byte[] byteBuffer = new byte[20];
    private int byteBufferCount = 0;
    private boolean notAllowedToPlay = false;
    private int raw = 0;

    public NetConnection(Socket s, NetBoss netBoss, boolean server) {
        this(s, netBoss, server, false);
    }

    public NetConnection(Socket s, NetBoss netBoss, boolean server, boolean guestOnly) {
        super("NetConnection-" + (server ? "server-side" : "client-side"));
        this.sock = s;
        this.netBoss = netBoss;
        this.server = server;
        this.guestOnly = guestOnly;
        this.start();
    }

    public String name() {
        return this.remoteName;
    }

    public String ip() {
        if (this.sock == null || this.sock.getInetAddress() == null) {
            return "null-IP";
        }
        return this.sock.getInetAddress().getHostAddress();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block18: {
            this.listenThread = Thread.currentThread();
            try {
                String input;
                block20: {
                    block22: {
                        block21: {
                            block19: {
                                this.in = this.sock.getInputStream();
                                this.out = this.sock.getOutputStream();
                                if (!this.server) break block19;
                                input = this.readLine();
                                if (input != null && input.startsWith("LUXCONNECT-")) {
                                    float remoteVersion = Float.parseFloat(input.substring(11, input.indexOf(":")));
                                    if (remoteVersion < 2.5f) {
                                        this.encodeln("LUXCONNECT-" + remoteVersion + ":" + this.netBoss.name());
                                        this.encodeln("<< " + Translator.getString("oldVersion") + " >>");
                                        this.encodeln("<< " + Translator.getString("goDownload") + " >>");
                                        this.encodeln("\u2731 " + Translator.getString("oldVersion") + " \u2731");
                                        this.encodeln("\u2731 " + Translator.getString("goDownload") + " \u2731");
                                        this.sock.close();
                                        return;
                                    }
                                    this.encodeln("LUXCONNECT-2.5:" + this.netBoss.name());
                                    this.remoteName = input.substring(input.indexOf(":") + 1);
                                    String nextLine = this.readLine();
                                    this.readingHeaders = true;
                                    while (!"".equals(nextLine.trim())) {
                                        this.decode(nextLine);
                                        nextLine = this.readLine();
                                    }
                                    this.readingHeaders = false;
                                    this.netBoss.registerConnection(this, this.remoteUserKey);
                                    if (2.5f < remoteVersion) {
                                        this.netBoss.println("\u2731 Warning: Client '" + this.remoteName + "' is using a version of Lux with a more recent network protocol" + " \u2731");
                                        this.netBoss.println("\u2731 To update to the latest version go to http://sillysoft.net \u2731");
                                        this.debug("Lux -> Warning: Client '" + this.remoteName + "' is using a more recent networkVersion. They have " + remoteVersion + " and we have " + 2.5f);
                                    }
                                    break block20;
                                } else {
                                    if (input != null && input.startsWith("LUXTRACKER-")) {
                                        this.encodeln("LUXTRACKER-0.1:verify");
                                        this.sock.close();
                                        return;
                                    }
                                    this.sock.close();
                                    return;
                                }
                            }
                            this.encodeln("LUXCONNECT-2.5:" + this.netBoss.name());
                            input = this.readLine();
                            if (input == null || !input.startsWith("LUXCONNECT-")) break block21;
                            this.remoteName = input.substring(input.indexOf(":") + 1);
                            this.netBoss.registerConnection(this);
                            float remoteVersion = Float.parseFloat(input.substring(11, input.indexOf(":")));
                            if (remoteVersion < 2.5f) {
                                this.netBoss.println("\u2731 " + Translator.getString("badHostVersion") + " \u2731");
                                this.kill();
                                break block22;
                            } else if (remoteVersion != 2.5f) {
                                this.debug("Lux -> Warning: '" + this.remoteName + "' is using a different networkVersion. They have " + remoteVersion + " and we have " + 2.5f);
                            }
                            break block22;
                        }
                        this.netBoss.println("\u2731 " + Translator.getString("Error") + " \u2731");
                        this.debug("\u2731 Bad negotiation: Aborting connection \u2731");
                        this.sock.close();
                        return;
                    }
                    this.encodeln("userKey: " + (LuxController.getInstance().sharewareVersion ? "" : Prefs.getUserKey()));
                    if (this.guestOnly) {
                        this.encodeln("guestOnly: true");
                    }
                    this.encodeln("remote-version: 6.23");
                    this.encodeln("");
                }
                while (!this.killed) {
                    input = this.readLine();
                    if (input == null) {
                        this.kill();
                        continue;
                    }
                    try {
                        this.decode(input);
                        if (!this.server || this.control.world == null) continue;
                        this.control.world.commandFromPlayer(this.remoteName);
                    }
                    catch (Throwable t) {
                        this.debug("decode failed with input of (" + input + "): " + t);
                        t.printStackTrace();
                    }
                }
                this.in.close();
                this.out.close();
                this.sock.close();
            }
            catch (Throwable e) {
                this.debug("netConnection.run caught an exception");
                e.printStackTrace();
                if (this.server) break block18;
                this.netBoss.println("\u2731 Connection " + Translator.getString("Error") + " \u2731");
            }
        }
        this.kill();
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sock = null;
        this.listenThread = null;
        this.control = null;
        this.netBoss = null;
    }

    public void decode(String command) {
        block161: {
            String[] params = StringTool.tokenize(command, " ");
            if (params.length == 0) {
                return;
            }
            if (params[0].equals("CHAT:")) {
                if (this.server) {
                    if (command.substring(6).startsWith(this.name() + ": ")) {
                        this.netBoss.recieveChat(command.substring(6), this.name());
                    } else {
                        this.hackAttempt("A client sent a chat with the wrong name: " + command);
                    }
                } else {
                    int nameEnd = command.indexOf(": ", 6);
                    if (nameEnd == -1) {
                        this.netBoss.recieveChat(command.substring(6), "");
                    } else {
                        this.netBoss.recieveChat(command.substring(6), command.substring(6, nameEnd));
                    }
                }
            } else if (params[0].equals("EMOTE:")) {
                if (this.server) {
                    if (command.substring(7).startsWith(this.name() + " ")) {
                        this.netBoss.recieveServerSideEmote(this.name(), command.substring(params[0].length() + this.name().length() + 2));
                    } else {
                        this.hackAttempt("Emote sent with the wrong name: " + command);
                    }
                } else {
                    this.netBoss.recieveClientSideEmote(command.substring(7));
                }
            } else if (params[0].equals("SMOTE:")) {
                if (this.server) {
                    if (command.substring(7).startsWith(this.name() + " ")) {
                        this.netBoss.recieveServerSideSEmote(this.name(), command.substring(params[0].length() + this.name().length() + 2));
                    } else {
                        this.hackAttempt("SEmote sent with the wrong name: " + command);
                    }
                } else {
                    this.netBoss.recieveClientSideSEmote(command.substring(7));
                }
            } else if (params[0].equals("HMOTE:")) {
                if (this.server) {
                    if (command.substring(7).startsWith(this.name() + " ")) {
                        this.netBoss.recieveServerSideHEmote(this.name(), command.substring(params[0].length() + this.name().length() + 2));
                    } else {
                        this.hackAttempt("HEmote sent with the wrong name: " + command);
                    }
                } else {
                    this.netBoss.recieveClientSideHEmote(command.substring(7));
                }
            } else if (params[0].equals("ZMOTE:")) {
                if (this.server) {
                    if (command.substring(7).startsWith(this.name() + " ")) {
                        this.netBoss.recieveServerSideZEmote(this.name(), command.substring(params[0].length() + this.name().length() + 2));
                    } else {
                        this.hackAttempt("ZEmote sent with the wrong name: " + command);
                    }
                } else {
                    this.netBoss.recieveClientSideZEmote(command.substring(7));
                }
            } else if (params[0].equals("clientCommand:")) {
                String clientCommand = command.substring(15);
                this.netBoss.takeClientCommand(clientCommand, this);
            } else if (params[0].equals("tra:")) {
                if (params[1].equals("1")) {
                    this.netBoss.println("\u2731 " + Translator.getString(params[2]) + " \u2731");
                } else if (params[1].equals("2")) {
                    this.netBoss.println("\u2731 " + Translator.getString(params[2]) + " \u2731");
                    if (this.server) {
                        this.debug("forwarding along message: " + command);
                        this.netBoss.sendToAll(command);
                    }
                } else if (params[1].equals("3")) {
                    this.netBoss.println("\u2731 " + Translator.translateTokens(command.substring(7)) + " \u2731");
                    if (command.endsWith(":hasjoined:") || command.endsWith(":hasjoinedasguestonly:")) {
                        if (PrefsCache.playerJoinedSound) {
                            NetBoss.joinSound.play();
                        }
                        if (!this.server) {
                            this.netBoss.addPlayerToList(command.substring(7, command.indexOf(" :hasjoined")));
                        }
                    }
                    if (this.server) {
                        this.debug("forwarding along message: " + command);
                        this.netBoss.sendToAll(command);
                    }
                } else if (params[1].equals("4")) {
                    if (this.acceptPlayerList) {
                        if (this.playerList == null) {
                            this.playerList = new ArrayList();
                        }
                        int nameEndPosition = command.lastIndexOf(40) - 1;
                        int nameEndPositionTeams = command.lastIndexOf(91) - 1;
                        if (nameEndPositionTeams > 0) {
                            nameEndPosition = nameEndPositionTeams;
                        }
                        this.playerList.add(command.substring(10, nameEndPosition).trim());
                    }
                    this.netBoss.println(Translator.translateTokens(command.substring(7)));
                }
            } else if (params[0].equals("sco:")) {
                if (!this.control.world.setCountryOwnerFromNetwork(Integer.parseInt(params[1]), Integer.parseInt(params[2]), this.remoteName)) {
                    this.debug("A setcountryowner command was not accepted by the world: " + this.control.world);
                    this.encodeln("sco: " + Integer.parseInt(params[1]) + " " + this.control.world.countries[Integer.parseInt(params[1])].getOwner());
                }
            } else if (params[0].equals("sca:")) {
                if (!this.control.world.setCountryArmiesFromNetwork(Integer.parseInt(params[1]), Integer.parseInt(params[2]), this.remoteName)) {
                    this.encodeln("sca: " + Integer.parseInt(params[1]) + " " + this.control.world.countries[Integer.parseInt(params[1])].getArmies());
                }
            } else if (params[0].equals("sc:")) {
                if (this.control.world.acceptNetworkCommandFrom(this.remoteName)) {
                    this.control.viewManager.selectCountry(Integer.parseInt(params[1]));
                }
            } else if (params[0].equals("ex:")) {
                this.control.viewManager.explode(Integer.parseInt(params[1]));
            } else if (params[0].equals("gt:")) {
                if (this.control.masterControl) {
                    this.control.world.validateRemotePlayerTurnEnd(this.remoteName);
                } else {
                    int gotoPlayer = Integer.parseInt(params[1]);
                    if (gotoPlayer == this.control.world.currentPlayer) {
                        System.out.println("got a go to player " + params[1] + " when currentPlayer = " + this.control.world.currentPlayer);
                        this.control.world.gotoPlayer(gotoPlayer);
                    } else if (this.control.ops.guiControl[this.control.world.currentPlayer] && this.control.world.gamePhase == 3) {
                        this.debug("client thinks that master is ending his turn");
                        this.forcingTurnEnd = true;
                        ((GameControllerGUI)this.control).forceClientEndTurn();
                        this.forcingTurnEnd = false;
                        Thread.yield();
                    } else {
                        this.control.world.gotoPlayer(gotoPlayer);
                    }
                }
            } else if (params[0].equals("nr:")) {
                if (this.server) {
                    this.hackAttempt("nr sent to the server");
                    return;
                }
                this.control.world.incrementGameRound();
            } else if (params[0].equals("ga:")) {
                try {
                    ObjectInputStream p = new ObjectInputStream(this.in);
                    String gameOverText = (String)p.readObject();
                    if (this.control.world.gameOver()) {
                        this.control.viewManager.gameOver(gameOverText);
                        break block161;
                    }
                    this.hackAttempt("gameover sent out-of-place");
                }
                catch (Throwable e) {
                    this.hackAttempt("ga was decoded with an error: " + SS.getStackTrace(e));
                }
            } else if (params[0].equals("OPS:")) {
                try {
                    ObjectInputStream p = new ObjectInputStream(this.in);
                    LuxOptions options = (LuxOptions)p.readObject();
                    if (options.boardFile == null) {
                        this.debug("Lux -> netConnection got some ops with a null boardFile");
                    }
                    if (this.control == null) {
                        this.control = new GameControllerGUI(options, false, this.netBoss);
                    } else {
                        this.control.takeNewOps(options);
                    }
                    this.netBoss.setControl(this.control);
                    this.control.viewManager.addObserver(this);
                    this.waitForWorldCreation();
                    this.netBoss.showIntroInformation();
                }
                catch (Throwable e) {
                    this.netBoss.println("\u2731 " + Translator.getString("Error") + " recieving game options" + " \u2731");
                    this.debug("\u2731 ERROR recieving game options \u2731");
                    e.printStackTrace(System.out);
                }
            } else if (params[0].equals("KILL:")) {
                this.kill();
            } else if (params[0].equals("PASSVOTE:")) {
                this.control.recieveVote("true".equals(params[1]));
            } else if (params[0].equals("PLAYERLIST:")) {
                this.netBoss.sendPlayerList(this);
            } else if (params[0].equals("CINFO:")) {
                this.encodeln("tra: 3 " + this.netBoss.getCardsInfoTranslateString());
            } else if (params[0].equals("userListStart:")) {
                this.acceptPlayerList = true;
            } else if (params[0].equals("userListEnd:")) {
                this.acceptPlayerList = false;
                this.netBoss.takePlayerList(this.playerList);
                this.playerList = null;
            } else if (params[0].equals("wakeMaster:")) {
                this.control.world.resumeWorldThread();
            } else if (params[0].equals("setGamePhase:")) {
                if (this.control.masterControl) {
                    this.hackAttempt("setGamePhase was sent to masterControl");
                } else {
                    this.control.world.gamePhase = Integer.parseInt(params[1]);
                    if (this.control.world.gamePhase == 3) {
                        this.control.world.gameRound = 1;
                    }
                }
            } else if (params[0].equals("setGameRound:")) {
                if (this.control.masterControl) {
                    this.hackAttempt("setGameRound was sent to masterControl");
                } else {
                    this.control.world.gameRound = Integer.parseInt(params[1]);
                }
            } else if (params[0].equals("rate:")) {
                try {
                    String hostName = this.remoteName;
                    if (params.length > 2) {
                        hostName = command.substring(command.indexOf(" ", 7) + 1);
                    }
                    this.netBoss.println("\u2731 " + Translator.getString("hostcausesproblems") + " ``lux/rankings/hosts/rate.php?host=" + URLEncoder.encode(hostName, "UTF-8") + "`" + Translator.getString("hostcausesproblemsLinkText") + "`" + " \u2731");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (command.startsWith("\u2731 ")) {
                this.netBoss.println(command);
                if (command.endsWith(" has joined \u2731") || command.endsWith(" has joined with guest only status \u2731")) {
                    if (PrefsCache.playerJoinedSound) {
                        this.debug("playing sound for client 2");
                        NetBoss.joinSound.play();
                    }
                    if (!this.server) {
                        this.netBoss.addPlayerToList(command.substring(3, command.indexOf(" has joined")));
                    }
                }
                if (this.server) {
                    this.debug("forwarding along message: " + command);
                    this.netBoss.sendToAll(command);
                }
            } else if (params[0].equals("takeOverPlayer:")) {
                this.debug(command);
                int playerIndex = Integer.parseInt(params[1]);
                this.control.takeOverPlayer(playerIndex);
                this.netBoss.println("\u2731 " + Translator.getString("takeOver") + " " + this.control.ops.playerNames[playerIndex] + " \u2731");
            } else if (params[0].equals("giveUpPlayer:")) {
                this.debug(command);
                if (this.control.masterControl) {
                    this.hackAttempt("giveUpPlayer was sent to masterControl");
                    return;
                }
                int playerIndex = Integer.parseInt(params[1]);
                this.control.giveUpPlayer(playerIndex);
            } else if (params[0].equals("incrementCardSetValue:")) {
                this.control.ops.cardSequence.incrementCardSetValue();
                this.control.cardsWereCashed();
                if (this.server) {
                    this.netBoss.echoToOthers(this, command);
                }
            } else if (params[0].equals("cardFromPlayerToDeck:")) {
                try {
                    int player = Integer.parseInt(params[1]);
                    int countryCode = Integer.parseInt(params[2]);
                    int symbol = Integer.parseInt(params[3]);
                    this.control.world.cardFromPlayerToDeck(player, countryCode, symbol);
                }
                catch (Exception e) {
                    this.debug("Exception on token cardFromPlayerToDeck:");
                }
                if (this.server) {
                    this.netBoss.echoToOthers(this, command);
                }
            } else if (params[0].equals("givePlayerCard:")) {
                if (this.server) {
                    this.hackAttempt("givePlayerCard was sent to masterControl");
                    this.debug("The host is being sent givePlayerCard. Reject it!");
                    return;
                }
                int player = Integer.parseInt(params[1]);
                int countryCode = Integer.parseInt(params[2]);
                int symbol = Integer.parseInt(params[3]);
                this.control.world.givePlayerCardLocalWorld(player, new Card(countryCode, symbol));
                if (this.server) {
                    this.netBoss.echoToOthers(this, command);
                }
            } else if (params[0].equals("guestOnly:")) {
                if (this.notAllowedToPlay) {
                    this.guestOnly = true;
                    this.encodeln("tra: 3 You have guest-only status in this room. ``lux/buy/`Register for full access`.");
                    return;
                }
                boolean bl = this.guestOnly = !this.guestOnly;
                if (!this.readingHeaders && this.netBoss.playerCanTalk(this.name())) {
                    if (this.guestOnly) {
                        this.netBoss.printToAll("tra: 3 " + this.name() + " :guestOnlyOn:");
                    } else {
                        this.netBoss.printToAll("tra: 3 " + this.name() + " :guestOnlyOff:");
                    }
                }
            } else if (params[0].equals("guestIn:")) {
                if (this.notAllowedToPlay) {
                    this.guestOnly = true;
                    this.encodeln("tra: 3 You have guest-only status in this room. ``lux/buy/`Register for full access`.");
                    return;
                }
                if (this.guestOnly) {
                    boolean bl = this.guestOnly = !this.guestOnly;
                    if (this.netBoss.playerCanTalk(this.name())) {
                        this.netBoss.printToAll("tra: 3 " + this.name() + " :guestOnlyOff:");
                    }
                }
            } else if (params[0].equals("guestOut:")) {
                if (!this.guestOnly) {
                    boolean bl = this.guestOnly = !this.guestOnly;
                    if (this.netBoss.playerCanTalk(this.name())) {
                        this.netBoss.printToAll("tra: 3 " + this.name() + " :guestOnlyOn:");
                    }
                }
            } else if (params[0].equals("userKey:")) {
                if (!this.server) {
                    this.hackAttempt("userKey was sent to a client?!");
                    this.debug("userKey was sent to a client?!");
                    return;
                }
                this.remoteUserKey = command.substring(9);
            } else if (params[0].equals("MUTE:")) {
                this.debug("server got a mute command: " + command);
                this.netBoss.toggleMute(this.name(), command.substring(6));
            } else if (params[0].equals("hostQuitOnPurpose:")) {
                this.netBoss.hostQuitOnPurpose = true;
            } else if (params[0].equals("remote-version:")) {
                this.remoteLuxVersion = Float.parseFloat(params[1]);
            } else {
                this.debug("Lux -> Unknown network command: " + command);
            }
        }
    }

    public synchronized void sendBoardState() {
        Country[] countries = this.control.world.countries;
        for (int i = 0; i < countries.length; ++i) {
            this.encodeln("sco: " + i + " " + countries[i].getOwner());
            this.encodeln("sca: " + i + " " + countries[i].getArmies());
        }
        for (int p = 0; p < this.control.ops.playerNames.length; ++p) {
            Card[] cards = this.control.world.getPlayerCards(p);
            for (int c = 0; c < cards.length; ++c) {
                this.encodeln("givePlayerCard: " + p + " " + cards[c].getCode() + " " + cards[c].getSymbol());
            }
        }
        this.encodeln("gt: " + this.control.world.currentPlayer);
        this.encodeln("setGamePhase: " + this.control.world.gamePhase);
        this.encodeln("setGameRound: " + this.control.world.gameRound);
    }

    private void waitForWorldCreation() {
        while (!this.control.doneCreation) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable e) {
                this.debug("While waiting for LuxWorld to finish creation 3: " + e);
            }
        }
    }

    public void setCountryOwner(int countryCode, int ownerCode) {
        if (Thread.currentThread() != this.listenThread) {
            this.encodeln("sco: " + countryCode + " " + ownerCode);
        }
    }

    public void setCountryArmies(int countryCode, int armies) {
        if (this.forcingTurnEnd || Thread.currentThread() != this.listenThread) {
            this.encodeln("sca: " + countryCode + " " + armies);
        }
    }

    public void selectCountry(int code) {
        if (Thread.currentThread() != this.listenThread) {
            this.encodeln("sc: " + code);
        }
    }

    public void gotoPlayer(int player) {
        if (Thread.currentThread() != this.listenThread) {
            this.encodeln("gt: " + player);
        }
    }

    public synchronized void gameOver(String endText) {
        if (Thread.currentThread() != this.listenThread) {
            this.encodeln("ga:");
            try {
                ObjectOutputStream p = new ObjectOutputStream(this.out);
                p.writeObject(endText);
                p.flush();
            }
            catch (Throwable e) {
                this.debug("Error sending gameOver");
                e.printStackTrace();
            }
        }
    }

    public void explode(int code) {
        if (Thread.currentThread() != this.listenThread) {
            this.encodeln("ex: " + code);
        }
    }

    public void reset() {
    }

    public synchronized void startGame(GameControllerAbstract control, LuxOptions ops) {
        if (!this.server) {
            this.debug("Lux -> A client tried to start a game!");
            Thread.dumpStack();
            return;
        }
        try {
            if (ops.boardFile == null) {
                this.debug("tried to send ops with a null boardfile");
                return;
            }
            this.encodeln("OPS:");
            ObjectOutputStream p = new ObjectOutputStream(this.out);
            p.writeObject(ops);
            p.flush();
        }
        catch (Throwable e) {
            this.debug("NetCon -> exception sending ops");
            e.printStackTrace();
        }
        this.control = control;
        control.viewManager.addObserver(this);
    }

    public synchronized void kill() {
        if (this.control != null && this.control.viewManager != null) {
            this.control.viewManager.removeObserver(this);
        }
        this.killed = true;
        this.encodeln("KILL:");
        if (this.netBoss != null) {
            this.netBoss.connectionLost(this);
        }
        try {
            this.in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listenThread = null;
    }

    synchronized void encodeln(String message) {
        block4: {
            try {
                this.out.write((message + "\n").getBytes("UTF-8"));
                this.out.flush();
            }
            catch (SocketException e) {
                if (!"KILL:".equals(message)) {
                    this.kill();
                }
            }
            catch (Throwable e) {
                this.debug("Lux -> caught (" + e + ") in encodeln()");
                if ("KILL:".equals(message)) break block4;
                this.kill();
            }
        }
    }

    private String readLine() {
        try {
            boolean done = false;
            while (!done) {
                int next = this.in.read();
                if (next == -1) {
                    this.debug("Lux -> read() got a -1 (EOS) buf=" + this.getStringFromByteBuffer());
                    return null;
                }
                char n = (char)next;
                if (n == '\r' || n == '\n') {
                    done = true;
                    continue;
                }
                this.addByteToBuffer((byte)next);
            }
            return this.getStringFromByteBuffer();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void clearByteBuffer() {
        this.byteBufferCount = 0;
    }

    private void addByteToBuffer(byte b) {
        if (this.byteBufferCount == this.byteBuffer.length) {
            byte[] newBuffer = new byte[this.byteBuffer.length * 2];
            for (int i = 0; i < this.byteBuffer.length; ++i) {
                newBuffer[i] = this.byteBuffer[i];
            }
            this.byteBuffer = newBuffer;
        }
        this.byteBuffer[this.byteBufferCount] = b;
        ++this.byteBufferCount;
    }

    private String getStringFromByteBuffer() {
        String result;
        try {
            result = new String(this.byteBuffer, 0, this.byteBufferCount, "UTF-8");
        }
        catch (Exception e) {
            result = "";
        }
        this.clearByteBuffer();
        return result;
    }

    public String toString() {
        if (this.server) {
            return "<NetCon - Server-side of " + this.remoteName + ">";
        }
        try {
            return "<NetCon - Client-side of " + this.netBoss.name() + ">";
        }
        catch (Exception e) {
            return "<NetCon - Client-side infant>";
        }
    }

    String userKey() {
        return this.remoteUserKey;
    }

    void debug(Object o) {
        System.out.println(this + " " + o);
        System.out.flush();
    }

    private void hackAttempt(final String message) {
        this.debug("Oopsalon?!?!?! - " + message);
        new Thread(){

            public void run() {
                this.setPriority(1);
                try {
                    URLTool.getURL("http://sillysoft.net/lux/alert.php?message=" + URLEncoder.encode(message) + "&attackerIP=" + URLEncoder.encode(NetConnection.this.ip()) + "&attackerKey=" + URLEncoder.encode(NetConnection.this.userKey()) + "&attackerNick=" + URLEncoder.encode(NetConnection.this.server ? NetConnection.this.remoteName : NetConnection.this.netBoss.name()) + "&server=" + NetConnection.this.server);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    boolean guestOnly() {
        return this.guestOnly;
    }

    public String getTeam() {
        return LuxTracker.getTeam(this.name());
    }

    public void setPlayable(boolean value) {
        boolean bl = this.notAllowedToPlay = !value;
        if (!this.guestOnly && this.notAllowedToPlay) {
            this.guestOnly = true;
        }
    }

    public int getRaw() {
        return this.raw;
    }

    public void setRaw(int newRaw) {
        this.raw = newRaw;
    }

    public void setModerator(boolean value) {
        this.moderator = value;
    }

    public boolean isModerator() {
        return this.moderator;
    }
}

