/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.net;

import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.ContinentSequence;
import com.sillysoft.lux.GameControllerHeadless;
import com.sillysoft.lux.Lux;
import com.sillysoft.lux.LuxOptions;
import com.sillysoft.lux.gui.GameControllerAbstract;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.net.LuxTracker;
import com.sillysoft.lux.net.NetConnection;
import com.sillysoft.lux.net.PingRankings;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.lux.util.BoardHelper;
import com.sillysoft.lux.util.CountryCluster;
import com.sillysoft.lux.util.CountryRoute;
import com.sillysoft.lux.util.OrderedNeighborIterator;
import com.sillysoft.tools.ArrayTool;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.IntegerHashtable;
import com.sillysoft.tools.LogFile;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSChatArea;
import com.sillysoft.widgets.SSChatAreaParent;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SoundEffect;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;

public class NetBoss
implements Runnable,
SSChatAreaParent {
    public static final String gameNoticeStart = "\u2731 ";
    public static final String gameNoticeEnd = " \u2731";
    public static final String zemoteString = "\u25c6\u25c6\u25c6\u25c6";
    public static final String zemoteStringEnd = "\u25c6\u25c6\u25c6\u25c6";
    public static final String heartString = "\u2665\u2665\u2665";
    public static final String singString = "\u266a\u266b";
    GameControllerAbstract control;
    private Vector connections = new Vector();
    private Vector playingConnections = new Vector();
    private String hostAddress;
    private int hostPort;
    private String userName;
    private boolean server = false;
    private SSChatArea chatArea;
    private boolean activeSoloWindow;
    public boolean hostQuitOnPurpose = false;
    private boolean killed = false;
    private boolean internetPublic;
    private Thread serverThread = null;
    private ServerSocket sock;
    private LuxTracker luxTracker;
    public String description;
    public static boolean maplock = true;
    private int silentLevel = 0;
    public static boolean[] robotSpot = new boolean[6];
    private PingRankings pingRankings;
    private int raw = 0;
    private int maxHumanClients = 6;
    private static SoundEffect chatSound = new SoundEffect("chat.wav");
    static SoundEffect joinSound = new SoundEffect("joinNetwork.wav");
    private boolean guestOnly;
    private Vector banList;
    private Vector megaMutedPlayers = new Vector();
    private Object muteOnKey = new Object();
    private Hashtable muteTable = new Hashtable();
    private String networkKey = null;
    char[] letterarray = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    String keytext = "luxrawkspleasedonthackitpleaseluxrawkspleasedonthackitplease";
    private List playerList;
    private NetConnection clientExecutingCommand;

    public NetBoss(String address, int connectToPort, String joinName, boolean internetPublic, boolean joinAsGuestOnly) {
        this.server = false;
        this.internetPublic = internetPublic;
        this.hostAddress = address;
        this.hostPort = connectToPort;
        this.userName = joinName;
        this.guestOnly = joinAsGuestOnly;
        this.chatArea = new SSChatArea(this, this.userName);
        this.activeSoloWindow = false;
        this.goSolo();
        new Thread((Runnable)this, "NetBoss-client").start();
    }

    public NetBoss(boolean internetPublic) {
        this.server = true;
        this.internetPublic = internetPublic;
        this.userName = LuxController.getInstance().userName();
        this.hostPort = PrefsCache.hostPort;
        this.guestOnly = PrefsCache.headless;
        if (!PrefsCache.headless) {
            this.chatArea = new SSChatArea(this, this.userName);
        }
        this.activeSoloWindow = false;
        if (PrefsCache.headless) {
            new Thread("headless-stdin-reader"){

                public void run() {
                    try {
                        String temp;
                        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                        while ((temp = in.readLine()) != null) {
                            if ("".equals(temp.trim())) continue;
                            try {
                                NetBoss.this.dealWithCommand(temp);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        new Thread((Runnable)this, "NetBoss-server").start();
    }

    public void setControl(GameControllerAbstract con) {
        this.control = con;
    }

    public String name() {
        return this.userName;
    }

    public void run() {
        if (!this.server) {
            this.connectToServer();
            return;
        }
        this.serverThread = Thread.currentThread();
        try {
            block27: {
                if (this.internetPublic) {
                    String validateName = this.userName;
                    if (validateName.endsWith(" (dedicated host)")) {
                        validateName = validateName.substring(0, validateName.length() - 17);
                    }
                    this.println(gameNoticeStart + Translator.getString("Validatingnickname") + " '" + validateName + "'" + gameNoticeEnd);
                    try {
                        String keyCheck = LuxTracker.isNameKeyValid(validateName, Prefs.getUserKey(), null, null, null);
                        if ("1".equals(keyCheck)) break block27;
                        if ("2".equals(keyCheck)) {
                            this.println("\u2731 You have GUEST ONLY status in this room \u2731");
                            break block27;
                        }
                        this.println("\u2731 ERROR: " + Translator.translateTokens(keyCheck) + gameNoticeEnd);
                        this.println(gameNoticeStart + Translator.getString("LuxServerShutdown") + gameNoticeEnd);
                        this.serverThread = null;
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.println("\u2731 ERROR: The server could not be reached to validate your nickname for Internet Public games. Please try again later \u2731");
                        this.println(gameNoticeStart + Translator.getString("LuxServerShutdown") + gameNoticeEnd);
                        this.serverThread = null;
                        return;
                    }
                }
            }
            this.println(gameNoticeStart + Translator.getString("StartingLuxServer") + " " + InetAddress.getLocalHost().getHostAddress() + " " + Translator.getString("port") + " " + this.hostPort + " " + Translator.getString("LuxServerWaiting") + "..." + gameNoticeEnd);
            this.sock = new ServerSocket(this.hostPort);
            if (this.internetPublic) {
                Thread.yield();
                while (this.control == null || !this.control.doneCreation) {
                    try {
                        Thread.sleep(500L);
                        Thread.yield();
                    }
                    catch (Throwable e) {
                        this.debug("While waiting for LuxWorld to finish creation 2: " + e);
                    }
                }
                String defaultDescription = "Play nice, have fun!    http://sillysoft.net/wiki/?Welcome";
                if (!PrefsCache.headless) {
                    if (this.control instanceof GameControllerGUI && !((GameControllerGUI)this.control).fullscreen) {
                        this.description = SSOptionPane.showMultiLineInputDialog(((GameControllerGUI)this.control).boardWindow, Translator.getString("Enterdescription") + ":   ", Prefs.get("lastDescription", defaultDescription));
                    }
                    if (this.description == null) {
                        this.description = Prefs.get("lastDescription", defaultDescription);
                    } else {
                        Prefs.put("lastDescription", this.description);
                        this.updateTracker();
                    }
                } else {
                    this.description = Prefs.get("lastDescription", defaultDescription);
                }
                if (!this.killed) {
                    this.luxTracker = new LuxTracker(this);
                }
            }
            while (!this.killed) {
                Socket incoming = null;
                try {
                    incoming = this.sock.accept();
                }
                catch (SocketException e) {
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (incoming == null) continue;
                incoming.setKeepAlive(true);
                new NetConnection(incoming, this, true);
            }
        }
        catch (BindException e) {
            this.println(gameNoticeStart + Translator.getString("OnlyOneLuxServer") + gameNoticeEnd);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (!this.killed) {
                this.println(gameNoticeStart + Translator.getString("LuxServerShutdown") + gameNoticeEnd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.serverThread = null;
        if (this.luxTracker != null) {
            LuxTracker.stop();
            this.luxTracker = null;
        }
    }

    synchronized void registerConnection(NetConnection n) {
        if (this.server) {
            this.debug("the server hit the client method in NetConnection 23542354236");
        }
        this.connections.add(n);
        new Thread("delayed-chat-scroll"){

            public void run() {
                try {
                    Thread.yield();
                    Thread.sleep(3000L);
                    NetBoss.this.scrollDown();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void scrollDown() {
        SwingUtilities.invokeLater(this.chatArea.scrollDownRunnable);
    }

    synchronized void registerConnection(NetConnection n, String userKey) {
        if (!this.server) {
            this.debug("the client hit the server method in NetConnection 12365412384");
        }
        if (this.banList != null && this.banList.contains(n.ip())) {
            n.encodeln("tra: 2 youAreBanned");
            n.kill();
            return;
        }
        String clientName = n.name();
        boolean nameConflict = false;
        boolean regConflict = false;
        boolean promoteConnection = false;
        if (this.userName.equalsIgnoreCase(clientName) && !PrefsCache.headless) {
            nameConflict = true;
        }
        if (!userKey.equals("") && userKey.equalsIgnoreCase(Prefs.getUserKey())) {
            this.debug("matched against server ");
            if (PrefsCache.headless) {
                promoteConnection = true;
            } else {
                String localIP = "0";
                try {
                    localIP = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception e) {
                    SS.debug(e);
                }
                if (!this.control.ops.internetPublic && StringTool.sameSubnetIP(localIP, n.ip())) {
                    SS.debug("allowing multiple people on the same reg for non-public LAN game: " + localIP + " - " + n.ip());
                } else {
                    regConflict = true;
                }
            }
        }
        for (int i = 0; !nameConflict && i < this.connections.size(); ++i) {
            NetConnection next = (NetConnection)this.connections.get(i);
            if (next.name().equalsIgnoreCase(clientName)) {
                this.debug("matched 1 against client ");
                nameConflict = true;
            }
            if (next.userKey().equalsIgnoreCase(userKey)) {
                this.debug("matched 2 against client ");
                String localIP = "0";
                try {
                    localIP = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception e) {
                    SS.debug(e);
                }
                if (!this.control.ops.internetPublic && StringTool.sameSubnetIP(next.ip(), n.ip()) && StringTool.sameSubnetIP(localIP, n.ip())) {
                    SS.debug("allowing multiple people on the same reg for non-public LAN game: " + next.ip() + " - " + n.ip());
                } else {
                    regConflict = true;
                }
            }
            if (!nameConflict || !regConflict) continue;
            this.debug("player has joined with the same info as a player. kick the old connection and take the new one. old IP:" + next.ip() + ", new IP:" + n.ip());
            if ("null-IP".equals(next.ip())) {
                this.debug("null IP in old connection, ditch current joiner");
                return;
            }
            next.kill();
            try {
                Thread.yield();
                Thread.sleep(500L);
            }
            catch (Throwable e) {
                this.debug("While waiting for old connection to be killed off: " + e);
            }
            this.registerConnection(n, userKey);
            return;
        }
        if (nameConflict) {
            n.encodeln("tra: 3 :duplicateName: '" + clientName + "'");
            n.kill();
            return;
        }
        if (regConflict && !"".equals(userKey)) {
            n.encodeln("tra: 2 duplicateRegistration");
            n.kill();
            return;
        }
        if (this.internetPublic) {
            n.encodeln("tra: 3 :Validatingnickname: '" + clientName + "'");
            try {
                Vector activeAlias = new Vector();
                String keyCheck = LuxTracker.isNameKeyValid(clientName, userKey, n.ip(), activeAlias, n);
                if (!"1".equals(keyCheck)) {
                    if ("2".equals(keyCheck)) {
                        n.setPlayable(false);
                    } else {
                        n.encodeln("tra: 3 ERROR: " + keyCheck);
                        n.kill();
                        return;
                    }
                }
                if (activeAlias.size() > 0) {
                    n.encodeln("tra: 3 WARNING: :Aliascheck1:" + activeAlias.get(0) + "). If you play with this new name, you will reset your other player's RAW");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                n.encodeln("\u2731 ERROR: The server could not be reached to validate your nickname for Internet Public games. Please try again later \u2731");
                n.kill();
                return;
            }
        }
        if (promoteConnection) {
            this.connections.add(0, n);
        } else {
            this.connections.add(n);
        }
        if (this.luxTracker != null) {
            this.luxTracker.setNumberOfPlayers(this.connections.size() + 1);
        }
        if (PrefsCache.playerJoinedSound) {
            joinSound.play();
        }
        int playersSoFar = this.connections.size() + 1;
        System.out.println(clientName + " has joined from IP " + n.ip());
        n.startGame(this.control, this.control.ops.copyWithGuiControlFor(""));
        n.sendBoardState();
        boolean rejoinedPlayer = false;
        for (int i = 0; i < this.pingRankings.userKey.length && !rejoinedPlayer; ++i) {
            if (!this.pingRankings.userKey[i].equals(n.userKey()) || !this.pingRankings.nick[i].equals(clientName)) continue;
            this.log("Lost player " + clientName + " has rejoined");
            rejoinedPlayer = true;
            try {
                this.control.playerRejoined(n);
                continue;
            }
            catch (Exception e) {
                this.debug(e);
            }
        }
        if (n.guestOnly()) {
            this.println(gameNoticeStart + clientName + " " + Translator.getString("hasjoinedasguestonly") + " (" + n.ip() + ")" + gameNoticeEnd);
            this.sendToAll("tra: 3 " + clientName + " :hasjoinedasguestonly:");
        } else {
            this.println(gameNoticeStart + clientName + " " + Translator.getString("hasjoined") + " (" + n.ip() + ")" + gameNoticeEnd);
            this.sendToAll("tra: 3 " + clientName + " :hasjoined:");
        }
        this.control.world.recieveChat(gameNoticeStart + clientName + " has joined" + gameNoticeEnd, clientName);
        if (this.guestOnly && n == this.getFirstNonGuestOnlyConnection()) {
            new Thread("delayed-guest-host-notice"){

                public void run() {
                    try {
                        NetConnection nc;
                        Thread.sleep(5000L);
                        if (NetBoss.this.guestOnly && (nc = NetBoss.this.getFirstNonGuestOnlyConnection()) != null) {
                            nc.encodeln("tra: 3 :youareguesthost:");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public void connectToServer() {
        try {
            this.println(gameNoticeStart + Translator.getString("Connecting") + " " + this.hostAddress + " " + Translator.getString("port") + " " + this.hostPort + "..." + gameNoticeEnd);
            InetAddress host = InetAddress.getByName(this.hostAddress);
            Socket outgoing = new Socket(host, this.hostPort);
            outgoing.setKeepAlive(true);
            new NetConnection(outgoing, this, false, this.guestOnly);
        }
        catch (ConnectException e) {
            this.println(gameNoticeStart + Translator.getString("Connectionrefused") + gameNoticeEnd);
        }
        catch (UnknownHostException e) {
            this.println(gameNoticeStart + Translator.getString("Unknownhost") + ": " + this.hostAddress + gameNoticeEnd);
        }
        catch (Throwable e) {
            this.println(gameNoticeStart + Translator.getString("Error") + ": " + e + gameNoticeEnd);
            e.printStackTrace();
        }
    }

    public void echoToOthers(NetConnection sender, String command) {
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection n = (NetConnection)this.connections.get(i);
            if (n == sender) continue;
            n.encodeln(command);
        }
    }

    public void dealWithCommand(String command) {
        this.dealWithCommand(command, false);
    }

    public void dealWithCommand(String command, boolean silent) {
        if (command.startsWith("/") || command.startsWith("\\")) {
            if (PrefsCache.chatSound && !silent) {
                chatSound.play();
            }
            if ((command = command.substring(1)).startsWith("help") || "?".equals(command)) {
                try {
                    BrowserLauncher.openURL("http://sillysoft.net/wiki/?Chat%20Commands");
                }
                catch (Exception e) {}
            } else {
                if (command.startsWith("start")) {
                    if (!command.trim().equals("start")) {
                        this.println(gameNoticeStart + Translator.getString("Startcommandprotection") + gameNoticeEnd);
                        return;
                    }
                    if (!this.server) {
                        this.sendToAll("clientCommand: " + command);
                        return;
                    }
                    this.startGame();
                    return;
                }
                if (command.startsWith("mute")) {
                    this.dealWithMuteCommand(command);
                } else if (command.startsWith("megamute")) {
                    if (!this.server) {
                        this.sendToAll("clientCommand: " + command);
                        return;
                    }
                    this.dealWithMegaMuteCommand(command);
                } else if (command.startsWith("guest") || "g".equalsIgnoreCase(command)) {
                    if (this.server) {
                        boolean bl = this.guestOnly = !this.guestOnly;
                        if (this.guestOnly) {
                            this.println(gameNoticeStart + this.userName + " " + Translator.getString("guestOnlyOn") + gameNoticeEnd);
                            this.sendToAll("tra: 3 " + this.userName + " :guestOnlyOn:");
                        } else {
                            this.println(gameNoticeStart + this.userName + " " + Translator.getString("guestOnlyOff") + gameNoticeEnd);
                            this.sendToAll("tra: 3 " + this.userName + " :guestOnlyOff:");
                        }
                    } else {
                        ((NetConnection)this.connections.get(0)).encodeln("guestOnly:");
                    }
                } else if ("gin".equalsIgnoreCase(command) || "gi".equalsIgnoreCase(command)) {
                    if (this.server) {
                        if (this.guestOnly) {
                            this.guestOnly = !this.guestOnly;
                            this.printToAll("tra: 3 " + this.userName + " :guestOnlyOff:");
                        }
                    } else {
                        ((NetConnection)this.connections.get(0)).encodeln("guestIn:");
                    }
                } else if ("gout".equalsIgnoreCase(command) || "go".equalsIgnoreCase(command)) {
                    if (this.server) {
                        if (!this.guestOnly) {
                            this.guestOnly = !this.guestOnly;
                            this.printToAll("tra: 3 " + this.userName + " :guestOnlyOn:");
                        }
                    } else {
                        ((NetConnection)this.connections.get(0)).encodeln("guestOut:");
                    }
                } else if (command.startsWith("users") || "u".equalsIgnoreCase(command)) {
                    if (this.server) {
                        this.println("  " + Translator.getString("UserList") + " - " + (this.getNumberOfHumans() - this.getNumberOfGuestOnly()) + "/" + this.getNumberOfHumans() + " " + Translator.getString("players") + ":");
                        this.println("    " + this.userName + " " + LuxTracker.getTeam(this.name()) + "(" + Translator.getString("host") + (this.guestOnly ? " - " + Translator.getString("guestonly") : "") + ")");
                        for (int i = 0; i < this.connections.size(); ++i) {
                            NetConnection n = (NetConnection)this.connections.get(i);
                            String team = LuxTracker.getTeam(n.name());
                            if (this.playingConnections.contains(n) || this.playerControlsSomebody(n)) {
                                if (n.guestOnly()) {
                                    this.println("    " + n.name() + " " + team + "- " + n.ip() + " (" + Translator.getString("player") + " - " + Translator.getString("guestonly") + ")");
                                    continue;
                                }
                                this.println("    " + n.name() + " " + team + "- " + n.ip() + " (" + (this.isClientControlling(n) ? Translator.getString("host") + " - " : "") + Translator.getString("player") + ")");
                                continue;
                            }
                            if (n.guestOnly()) {
                                this.println("    " + n.name() + " " + team + "- " + n.ip() + " (" + Translator.getString("guestonly") + ")");
                                continue;
                            }
                            this.println("    " + n.name() + " " + team + "- " + n.ip() + " (" + (this.isClientControlling(n) ? Translator.getString("host") + " - " : "") + Translator.getString("guest") + ")");
                        }
                    } else if (this.connections == null || this.connections.size() == 0) {
                        this.println(gameNoticeStart + Translator.getString("NoGame") + gameNoticeEnd);
                    } else {
                        ((NetConnection)this.connections.get(0)).encodeln("PLAYERLIST:");
                    }
                } else if (command.startsWith("forum")) {
                    try {
                        BrowserLauncher.openURL("http://sillysoft.net/forums/search.php?search_id=newposts");
                    }
                    catch (Exception e) {}
                } else if (command.startsWith("rank")) {
                    try {
                        BrowserLauncher.openURL("http://sillysoft.net/lux/rankings/");
                    }
                    catch (Exception e) {}
                } else {
                    if (command.startsWith("maxclients")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        String setting = "";
                        int settingID = -1;
                        try {
                            setting = command.substring(11);
                            settingID = Integer.parseInt(setting);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (settingID < 0) {
                            settingID = 0;
                        }
                        if (settingID > 6) {
                            settingID = 6;
                        }
                        this.maxHumanClients = settingID;
                        this.printToControllingUser("tra: 3 The next game will use a maximum of " + this.maxHumanClients + " networked players");
                        return;
                    }
                    if (command.startsWith("setcards")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        String setting = "";
                        int settingID = -1;
                        try {
                            setting = command.substring(9);
                            settingID = CardSequence.getIDFromString(setting);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (settingID == -1) {
                            this.printToControllingUser("tra: 3 Unknown card setting. Example: /setcards 4681015");
                            return;
                        }
                        Prefs.putInt("cardSequence", settingID);
                        Lux.cardsParam = settingID;
                        this.printToAll("tra: 3 The cards for the next game have been set to " + setting);
                    } else if (command.startsWith("setconts")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        String setting = "";
                        int settingID = -1;
                        try {
                            setting = command.substring(9);
                            settingID = ContinentSequence.getIDFromString(setting);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (settingID == -1) {
                            this.printToControllingUser("tra: 3 Unknown continent setting. Example: /setconts 15");
                            return;
                        }
                        Prefs.putInt("continentSequenceCode", settingID);
                        Lux.contsParam = settingID;
                        this.printToAll("tra: 3 The continent increase for the next game has been set to " + setting + "%");
                    } else if (command.startsWith("settime")) {
                        String setting;
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        int seconds = -1;
                        try {
                            setting = command.substring(8);
                            seconds = Integer.parseInt(setting);
                        }
                        catch (Exception e) {
                            this.printToControllingUser("tra: 3 Improper time given. Example: /settime 30");
                            return;
                        }
                        if (seconds == 0) {
                            Prefs.putBoolean("turnTimer", false);
                            this.printToAll("tra: 3 The turn timer has been turned off for the next game");
                        } else {
                            seconds = Math.max(seconds, 8);
                            Prefs.putInt("turnTimerSeconds", seconds);
                            Prefs.putBoolean("turnTimer", true);
                            Lux.timeParam = seconds;
                            this.printToAll("tra: 3 The turn time for the next game has been set to " + setting + " seconds");
                        }
                    } else if (command.startsWith("setrank")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        if (PrefsCache.forceUnranked) {
                            this.printToControllingUser("tra: 3 This is an unranked room");
                            return;
                        }
                        boolean value = false;
                        try {
                            String setting = command.substring(8);
                            value = Boolean.parseBoolean(setting);
                        }
                        catch (Exception e) {
                            this.printToControllingUser("tra: 3 Improper value given. Example: /setrank true");
                            return;
                        }
                        Prefs.putBoolean("isRanked", value);
                        this.printToAll("tra: 3 The next game will be " + (value ? "" : "un") + "ranked");
                    } else if (command.startsWith("setauto")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        boolean value = false;
                        try {
                            String setting = command.substring(8);
                            value = Boolean.parseBoolean(setting);
                        }
                        catch (Exception e) {
                            this.printToControllingUser("tra: 3 Improper value given. Example: /setauto true");
                            return;
                        }
                        Lux.autoplay = value;
                        this.printToControllingUser("tra: 3 Autoplay is now set to " + value);
                    } else if (command.startsWith("setshuffle")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        int shuffleCode = -1;
                        try {
                            String setting = command.substring(11);
                            shuffleCode = Integer.parseInt(setting);
                        }
                        catch (Exception e) {
                            this.printToControllingUser("tra: 3 Improper shuffle-state given. Example: /setshuffle 4");
                            return;
                        }
                        if (shuffleCode < 0 || shuffleCode > 4) {
                            this.printToControllingUser("tra: 3 Improper shuffle-state given. Example: /setshuffle 4");
                        } else {
                            Prefs.putInt("shuffleState", shuffleCode);
                            Lux.shuffleMode = shuffleCode;
                            String desc = shuffleCode == 0 ? ":firstcome:" : (shuffleCode == 1 ? ":shuffleplayers:" : (shuffleCode == 2 ? ":shufflewithwinner:" : (shuffleCode == 3 ? ":highestrankedfirst:" : (shuffleCode == 4 ? ":cyclelosers:" : "NULL"))));
                            this.printToAll("tra: 3 The shuffle-mode for the next game has been set to: " + desc + " ");
                        }
                    } else if (command.startsWith("setlimit")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        int limitMinutes = -1;
                        try {
                            String setting = command.substring(9);
                            limitMinutes = Integer.parseInt(setting);
                        }
                        catch (Exception e) {
                            this.printToControllingUser("tra: 3 Improper game-limit given. Example: /setlimit 30");
                            return;
                        }
                        if (limitMinutes == 0) {
                            Prefs.putBoolean("gameLimit", false);
                            Lux.gameLimitMinutes = limitMinutes;
                            this.printToAll("tra: 3 The game-limit for the next game has been turned off");
                        } else {
                            limitMinutes = Math.max(limitMinutes, 30);
                            Prefs.putInt("gameLimitMinutes", limitMinutes);
                            Prefs.putBoolean("gameLimit", true);
                            Lux.gameLimitMinutes = limitMinutes;
                            this.printToAll("tra: 3 The game-limit for the next game has been set to: " + limitMinutes + " minutes");
                        }
                    } else if (command.equals("quit")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        if (this.server && PrefsCache.headless || this.clientExecutingCommand != null && this.isFullControlUser(this.clientExecutingCommand)) {
                            this.kill();
                            try {
                                Thread.yield();
                                Thread.sleep(2000L);
                                Thread.yield();
                            }
                            catch (Throwable e) {
                                this.debug("exception shutting down in /quit: " + e);
                            }
                            System.exit(0);
                        }
                    } else if (command.startsWith("setsilent")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        String setting = "";
                        int settingID = this.silentLevel == 0 ? 2 : 0;
                        try {
                            setting = command.substring(10);
                            settingID = Integer.parseInt(setting);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (settingID == 1) {
                            this.printToAll("tra: 3 :chatturnedoff2:");
                            this.silentLevel = 1;
                        } else if (settingID == 2) {
                            this.printToAll("tra: 3 :chatturnedoff:");
                            this.silentLevel = 2;
                        } else {
                            this.printToAll("tra: 3 :chatturnedon:");
                            this.silentLevel = 0;
                        }
                    } else if (command.startsWith("color")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        String colorString = null;
                        if (command.length() > 6) {
                            colorString = command.substring(6);
                        }
                        if (null == colorString || "".equals(colorString.trim())) {
                            Lux.memoryColor = null;
                            this.printToControllingUser("tra: 3 Player colors have been reset to saved defaults");
                        } else {
                            Lux.memoryColor = colorString;
                            this.printToControllingUser("tra: 3 All player colors have been set to be RGB " + colorString);
                        }
                    } else if (command.startsWith("set ") && !LuxController.getInstance().sharewareVersion) {
                        String[] params = StringTool.tokenize(command, " ");
                        if (params == null || params.length < 2) {
                            this.println("\u2731 Improper usage. Example: /set makeScreenshotThumbnail true \u2731");
                            return;
                        }
                        boolean newState = params.length < 3 ? true : new Boolean(params[2]);
                        try {
                            int intValue = Integer.parseInt(params[2]);
                            this.println("\u2731 Setting switch: " + params[1] + " to " + intValue + gameNoticeEnd);
                            SS.debug("Setting switch: " + params[1] + " to " + intValue);
                            Prefs.putInt(params[1], intValue);
                            return;
                        }
                        catch (Exception e) {
                            this.println("\u2731 Setting switch: " + params[1] + " to " + newState + gameNoticeEnd);
                            SS.debug("Setting switch: " + params[1] + " to " + newState);
                            Prefs.putBoolean(params[1], newState);
                        }
                    } else if (command.startsWith("log")) {
                        this.println("\u2731 The /log command no longer does anything. Use the /debug command for bug reports, or the /report command for abusive players \u2731");
                    } else if (command.startsWith("report")) {
                        String extraText = command.substring(6);
                        if ("".equals(extraText.trim())) {
                            this.println("\u2731 You must enter a single line summary with your report. i.e: /report BadApple is being abusive \u2731");
                            return;
                        }
                        String logReport = this.name() + " " + command;
                        this.alertSillysoftWithChat(logReport);
                        this.println("\u2731 A report has been sent to Sillysoft \u2731");
                        this.printToAll("tra: 3 WARNING: Lux is governed by the ``lux/rules.php`Online Rules` and a report has been sent to the admins");
                    } else if (command.startsWith("debug")) {
                        String extraText = command.substring(5);
                        if ("".equals(extraText.trim())) {
                            this.println("\u2731 You must enter a single line summary with your report. i.e: /debug the player info table is broken \u2731");
                            return;
                        }
                        String logReport = this.name() + " report: " + command + "\n" + ((LogFile)System.out).getLog() + "\n\n" + Prefs.exportSubtree() + "\n\n" + this.chatArea.tail();
                        SSApp.alertSillysoft(logReport);
                        this.println("\u2731 Your debugging info has been sent to Sillysoft. Email any extra details to lux@sillysoft.net \u2731");
                    } else if (command.startsWith("cards") || "c".equalsIgnoreCase(command)) {
                        if (this.control == null) {
                            this.println(gameNoticeStart + Translator.getString("NoGame") + gameNoticeEnd);
                            return;
                        }
                        if (this.server) {
                            this.println(Translator.translateTokens(this.getCardsInfoTranslateString()));
                        } else {
                            ((NetConnection)this.connections.get(0)).encodeln("CINFO:");
                        }
                    } else if (command.startsWith("players") || "p".equalsIgnoreCase(command)) {
                        if (this.control == null) {
                            this.println(gameNoticeStart + Translator.getString("NoGame") + gameNoticeEnd);
                            return;
                        }
                        this.println("  " + Translator.getString("PlayerList") + ":");
                        for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
                            this.println("    " + this.control.ops.playerNames[i] + " " + Translator.getString("beforeCardValue") + " " + this.control.stats.getArmies(i) + " armies and " + this.control.stats.getCards(i) + " " + Translator.getString("betweenCardsAndIncome") + " " + this.control.stats.getIncome(i));
                        }
                    } else if (command.startsWith("me")) {
                        if (command.length() < 4) {
                            this.println(gameNoticeStart + Translator.getString("/menoinput") + gameNoticeEnd);
                            return;
                        }
                        String emote = command.substring(2, 3).equals("'") ? command.substring(2) : command.substring(3);
                        if (this.server) {
                            this.recieveServerSideEmote(this.userName, emote);
                        } else {
                            this.sendToAll("EMOTE: " + this.userName + " " + emote);
                        }
                    } else if (command.startsWith("sing") || command.startsWith("mme")) {
                        if (command.length() < 5) {
                            this.println(gameNoticeStart + Translator.getString("/menoinput") + gameNoticeEnd);
                            return;
                        }
                        String emote = command.substring(4, 5).equals("'") ? command.substring(4) : command.substring(command.indexOf(32) + 1);
                        if (this.server) {
                            this.recieveServerSideSEmote(this.userName, emote);
                        } else {
                            this.sendToAll("SMOTE: " + this.userName + " " + emote);
                        }
                    } else if (command.startsWith("love") || command.startsWith("hme")) {
                        if (command.length() < 5) {
                            this.println(gameNoticeStart + Translator.getString("/menoinput") + gameNoticeEnd);
                            return;
                        }
                        String emote = command.substring(4, 5).equals("'") ? command.substring(4) : command.substring(command.indexOf(32) + 1);
                        if (this.server) {
                            this.recieveServerSideHEmote(this.userName, emote);
                        } else {
                            this.sendToAll("HMOTE: " + this.userName + " " + emote);
                        }
                    } else if (command.startsWith("re")) {
                        if (command.length() < 4) {
                            this.println(gameNoticeStart + Translator.getString("/menoinput") + gameNoticeEnd);
                            return;
                        }
                        String emote = command.substring(2, 3).equals("'") ? command.substring(2) : command.substring(3);
                        if (this.server) {
                            this.recieveServerSideZEmote(this.userName, emote);
                        } else {
                            this.sendToAll("ZMOTE: " + this.userName + " " + emote);
                        }
                    } else if (command.equalsIgnoreCase("i")) {
                        this.println("\u2731 Enter the name of a player to look up their info. i.e: /i " + this.name() + gameNoticeEnd);
                    } else if (command.startsWith("i ") || command.startsWith("I ") || command.startsWith("info ") || command.startsWith("whois ")) {
                        String user = command.substring(command.indexOf(32) + 1);
                        try {
                            BrowserLauncher.openURL("http://sillysoft.net/lux/rankings/user/" + URLEncoder.encode(user, "UTF-8"));
                        }
                        catch (Exception e) {}
                    } else if (command.equalsIgnoreCase("alias")) {
                        this.println("\u2731 Enter the name of a player to look up their info. i.e: /a " + this.name() + gameNoticeEnd);
                    } else if (command.startsWith("a ") || command.startsWith("A ") || command.startsWith("alias ")) {
                        String user = command.substring(command.indexOf(32) + 1);
                        try {
                            BrowserLauncher.openURL("http://sillysoft.net/lux/rankings/alias.php?username=" + URLEncoder.encode(user, "UTF-8"));
                        }
                        catch (Exception e) {}
                    } else if (command.equalsIgnoreCase("v")) {
                        NetConnection next = (NetConnection)this.connections.get(0);
                        this.println("\u2731 Enter the name of a player to compare your results with. i.e: /v " + next.name() + gameNoticeEnd);
                    } else if (command.startsWith("v ") || command.startsWith("V ") || command.startsWith("versus ")) {
                        String user = command.substring(command.indexOf(32) + 1);
                        try {
                            BrowserLauncher.openURL("http://sillysoft.net/lux/rankings/versus.php?player1=" + URLEncoder.encode(this.name(), "UTF-8") + "&player2=" + URLEncoder.encode(user, "UTF-8"));
                        }
                        catch (Exception e) {}
                    } else if (command.equalsIgnoreCase("rate")) {
                        NetConnection next = (NetConnection)this.connections.get(0);
                        this.println("\u2731 Enter the name of a player to rate. i.e: /rate " + next.name() + gameNoticeEnd);
                    } else if (command.startsWith("rate ")) {
                        String user = command.substring(command.indexOf(32) + 1);
                        try {
                            BrowserLauncher.openURL("http://sillysoft.net/lux/rankings/hosts/rate.php?host=" + URLEncoder.encode(user, "UTF-8"));
                        }
                        catch (Exception e) {}
                    } else if (command.startsWith("teamcheck")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        this.teamCheck();
                    } else if (command.startsWith("teamcheckauto")) {
                        if (!this.server) {
                            this.sendToAll("clientCommand: " + command);
                            return;
                        }
                        this.teamCheck(true);
                    } else {
                        if (command.startsWith("teams")) {
                            if (!this.server) {
                                this.sendToAll("clientCommand: " + command);
                                return;
                            }
                            this.printToControllingUser("tra: 3 :UnknownCommand:: " + command);
                            return;
                        }
                        if (command.startsWith("promote")) {
                            if (!this.server) {
                                this.sendToAll("clientCommand: " + command);
                                return;
                            }
                            this.printToControllingUser("tra: 3 :UnknownCommand:: " + command);
                            return;
                        }
                        if (command.startsWith("demoteall")) {
                            if (!this.server) {
                                this.sendToAll("clientCommand: " + command);
                                return;
                            }
                            this.printToControllingUser("tra: 3 :UnknownCommand:: " + command);
                            return;
                        }
                        if (command.startsWith("demote")) {
                            if (!this.server) {
                                this.sendToAll("clientCommand: " + command);
                                return;
                            }
                            this.printToControllingUser("tra: 3 :UnknownCommand:: " + command);
                            return;
                        }
                        if (command.startsWith("boot")) {
                            if (!this.server) {
                                this.sendToAll("clientCommand: " + command);
                                return;
                            }
                            this.dealWithBootCommand(command);
                        } else {
                            if (command.startsWith("ban")) {
                                if (!this.server) {
                                    this.sendToAll("clientCommand: " + command);
                                    return;
                                }
                                this.log("command: '" + command + "'");
                                String banPlayer = command.substring(command.indexOf(" ") + 1);
                                if (banPlayer.equalsIgnoreCase(this.name())) {
                                    if (this.clientExecutingCommand != null) {
                                        this.clientExecutingCommand.encodeln("tra: 1 Youcannotbootyourslef");
                                    } else {
                                        this.println(gameNoticeStart + Translator.getString("Youcannotbootyourslef") + gameNoticeEnd);
                                    }
                                    return;
                                }
                                NetConnection playerConnection = this.connectionFromNameIgnoreCase(banPlayer);
                                if (playerConnection == null) {
                                    if (this.clientExecutingCommand != null) {
                                        this.clientExecutingCommand.encodeln("tra: 3 :Noplayerfoundwiththename: " + banPlayer);
                                    } else {
                                        this.println(gameNoticeStart + Translator.getString("Noplayerfoundwiththename") + " " + banPlayer + gameNoticeEnd);
                                    }
                                    return;
                                }
                                if (this.playerControlsSomebody(banPlayer)) {
                                    this.alertSillysoftWithChat(this.controllingHostName() + " tried to ban " + banPlayer + " but was not allowed too");
                                    if (this.clientExecutingCommand != null) {
                                        this.clientExecutingCommand.encodeln("tra: 1 Cannotbanaplayer");
                                    } else {
                                        this.println(gameNoticeStart + Translator.getString("Cannotbanaplayer") + gameNoticeEnd);
                                    }
                                    return;
                                }
                                if (this.banList == null) {
                                    this.banList = new Vector();
                                }
                                this.banList.add(playerConnection.ip());
                                if (this.clientExecutingCommand != null) {
                                    this.clientExecutingCommand.encodeln("tra: 3 :Cannotbanaplayer: " + banPlayer);
                                } else {
                                    this.println(gameNoticeStart + Translator.getString("IPaddress") + " " + playerConnection.ip() + " " + Translator.getString("hasbeenbanned") + gameNoticeEnd);
                                }
                                playerConnection.encodeln("tra: 2 beenBooted");
                                playerConnection.encodeln("rate: ban" + (this.clientExecutingCommand != null ? " " + this.clientExecutingCommand.name() : ""));
                                playerConnection.kill();
                                if (this.control.ops.internetPublic) {
                                    this.printToControllingUser("tra: 3 :Bootbanhostwarning:");
                                }
                                this.alertSillysoftWithChat(this.controllingHostName() + " banned " + banPlayer);
                                return;
                            }
                            if (command.startsWith("clearban")) {
                                if (!this.server) {
                                    this.sendToAll("clientCommand: " + command);
                                    return;
                                }
                                this.log("command: '" + command + "'");
                                this.banList = null;
                                if (this.clientExecutingCommand != null) {
                                    this.clientExecutingCommand.encodeln("tra: 1 ipunban");
                                } else {
                                    this.println(gameNoticeStart + Translator.getString("ipunban") + gameNoticeEnd);
                                }
                                return;
                            }
                            if (command.startsWith("desc") || "d".equalsIgnoreCase(command)) {
                                if (!this.server) {
                                    this.sendToAll("clientCommand: " + command);
                                    return;
                                }
                                if (command.length() < 6) {
                                    if (this.description == null) {
                                        this.description = Prefs.get("lastDescription", "Welcome!");
                                    }
                                } else {
                                    this.description = command.substring(command.indexOf(" ") + 1);
                                    Prefs.put("lastDescription", this.description);
                                    this.updateTracker();
                                }
                                String netDescription = this.description;
                                int pos = this.description.indexOf("\n");
                                if (pos != -1) {
                                    netDescription = this.description.substring(0, pos);
                                }
                                if (this.clientExecutingCommand == null) {
                                    this.printToAll("tra: 3 :Descriptionhasbeenupdated:: " + netDescription);
                                } else {
                                    this.clientExecutingCommand.encodeln("tra: 3 :Descriptionhasbeenupdated:: " + netDescription);
                                }
                            } else if (command.startsWith("maplock")) {
                                if (!this.server) {
                                    this.sendToAll("clientCommand: " + command);
                                    return;
                                }
                                maplock = !maplock;
                                this.printToControllingUser("tra: 3 :maplockhasbeenturned: " + (maplock ? Translator.getString("ON") : Translator.getString("OFF")));
                            } else if (command.startsWith("map")) {
                                if (!this.server) {
                                    this.sendToAll("clientCommand: " + command);
                                    return;
                                }
                                if (command.length() < 5) {
                                    this.printToControllingUser("tra: 3 You must enter the name of a map. Example: /map Classic Part Deux");
                                    return;
                                }
                                String mapName = command.substring(4);
                                if (LuxController.getInstance().selectMap(mapName)) {
                                    this.printToAll("tra: 3 The map for the next game has been set to " + mapName);
                                    Lux.mapParam = mapName;
                                    Lux.headlessGenerator = false;
                                    Prefs.put("mapSelector", mapName);
                                } else {
                                    PluginManager.getInstance().loadMapGenerators();
                                    List mapList = PluginManager.getInstance().getAllMapGeneratorChoices();
                                    for (int j = 0; j < mapList.size() && mapName != null; ++j) {
                                        String map = (String)mapList.get(j);
                                        SS.debug(map);
                                        if (!StringTool.stripSpaces(map).equals(mapName)) continue;
                                        Lux.mapParam = map;
                                        Prefs.put("mapSelector", map);
                                        Lux.headlessGenerator = true;
                                        System.out.println("Set the map generator to be " + map);
                                        mapName = null;
                                    }
                                    if (mapName != null) {
                                        this.printToControllingUser("tra: 3 :Error:: No map found named '" + mapName + "'");
                                    }
                                }
                            } else if (command.toLowerCase().startsWith("easycost")) {
                                try {
                                    int secondSpaceAt = command.lastIndexOf(32);
                                    int countryID = Integer.parseInt(command.substring(9, secondSpaceAt));
                                    int playerID = Integer.parseInt(command.substring(secondSpaceAt + 1));
                                    this.println("The easiest cost for player " + this.control.ops.playerNames[playerID] + " to get to country " + this.control.world.countries[countryID].getName() + " is through: " + new CountryRoute(BoardHelper.easyCostCountryWithOwner(countryID, playerID, this.control.world.countries), this.control.world.countries).toString());
                                }
                                catch (Exception e) {
                                    this.println("\u2731 Error - bad integer value? use syntax '/easycost <countryID> <playerID>' i.e. '/easycost 4 0' \u2731");
                                    e.printStackTrace();
                                }
                            } else if (command.toLowerCase().startsWith("routestarting")) {
                                try {
                                    int countryID = Integer.parseInt(command.substring(14));
                                    Date startTime = null;
                                    Date endTime = null;
                                    CountryRoute route = null;
                                    Thread.yield();
                                    startTime = new Date();
                                    route = CountryCluster.getOwnedCluster(this.control.world.countries[countryID]).getSimpleRouteStartingAt(this.control.world.countries[countryID]);
                                    endTime = new Date();
                                    this.println("Test 1: Took " + (endTime.getTime() - startTime.getTime()) + " milliseconds");
                                    this.println("A route through the owned cluster starting at " + this.control.world.countries[countryID].getName() + " is: " + route);
                                }
                                catch (Exception e) {
                                    this.println("\u2731 Error - bad integer value? use syntax '/routestarting <countryID>' i.e. '/routestarting 4' \u2731");
                                    e.printStackTrace();
                                }
                            } else if (command.toLowerCase().startsWith("orderedneighbors")) {
                                try {
                                    int countryID = Integer.parseInt(command.substring(17));
                                    this.println("The neighbors of " + this.control.world.countries[countryID].getName() + " ordered by least enemy neighbors first are: ");
                                    OrderedNeighborIterator neighbors = new OrderedNeighborIterator(this.control.world.countries[countryID]);
                                    while (neighbors.hasNext()) {
                                        this.println("\t" + neighbors.next());
                                    }
                                }
                                catch (Exception e) {
                                    this.println("\u2731 Error - bad integer value? use syntax '/orderedneighbors <countryID>' i.e. '/orderedneighbors 4' \u2731");
                                    e.printStackTrace();
                                }
                            } else if (command.toLowerCase().startsWith("colsize")) {
                                ((GameControllerGUI)this.control).columnsResizePI();
                            } else if (command.toLowerCase().startsWith("fullscreen")) {
                                ((GameControllerGUI)this.control).toggleFullscreen();
                            } else {
                                this.println(gameNoticeStart + Translator.getString("UnknownCommand") + ": " + command + gameNoticeEnd);
                            }
                        }
                    }
                }
            }
        } else if (this.server) {
            this.recieveChat(this.userName + ": " + command, this.name());
        } else {
            this.sendToAll("CHAT: " + this.userName + ": " + command);
        }
    }

    private void dealWithTransferCommand(String command) {
        if (!this.server) {
            this.sendToAll("clientCommand: " + command);
            return;
        }
        if (!this.areThereGuestsWhoWantToPlay()) {
            if (this.clientExecutingCommand != null) {
                this.clientExecutingCommand.encodeln("tra: 1 Therearenoplayerstotransferto");
            } else {
                this.println(gameNoticeStart + Translator.getString("Therearenoplayerstotransferto") + gameNoticeEnd);
            }
            return;
        }
        int playerIndex = -1;
        int spacePosition = command.indexOf(32);
        if (spacePosition != -1) {
            String giveAwayPlayer = command.substring(spacePosition + 1);
            for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
                if ("Human".equals(this.control.ops.playerTypes[i]) || !this.control.ops.playerNames[i].equalsIgnoreCase(giveAwayPlayer)) continue;
                playerIndex = i;
            }
            if (playerIndex == -1) {
                if (this.clientExecutingCommand != null) {
                    this.clientExecutingCommand.encodeln("tra: 3 :Noplayerfoundwiththename: " + giveAwayPlayer);
                } else {
                    this.println(gameNoticeStart + Translator.getString("Noplayerfoundwiththename") + " " + giveAwayPlayer + gameNoticeEnd);
                }
                return;
            }
            this.log("/transfer for playerIndex: " + playerIndex);
            this.println("\u2731 Transfering control of player " + this.control.ops.playerNames[playerIndex] + gameNoticeEnd);
            this.control.giveGuestPlayer(this.control.ops.playerNames[playerIndex]);
            return;
        }
        for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
            if (!this.control.ops.guiControl[i] || !"bot".equals(this.control.takenOverPlayerNames[i])) continue;
            playerIndex = i;
        }
        if (playerIndex == -1) {
            if (this.clientExecutingCommand != null) {
                this.clientExecutingCommand.encodeln("tra: 1 Nolostplayers");
            } else {
                this.println(gameNoticeStart + Translator.getString("Nolostplayers") + gameNoticeEnd);
            }
            return;
        }
        this.log("/transfer for playerIndex: " + playerIndex);
        this.println("\u2731 Transfering control of player " + this.control.ops.playerNames[playerIndex] + gameNoticeEnd);
        this.control.giveGuestPlayer(this.control.ops.playerNames[playerIndex]);
    }

    private void dealWithBootCommand(String command) {
        this.log("command: '" + command + "'");
        if (command.length() < 6) {
            this.printToControllingUser("tra: 3 :Youmustenterthenameofaplayertoboot:");
            return;
        }
        String bootPlayer = command.substring(5);
        if (bootPlayer.equalsIgnoreCase(this.name())) {
            this.printToControllingUser("tra: 3 :Youcannotbootyourslef:");
            return;
        }
        NetConnection bootedConnection = this.connectionFromNameIgnoreCase(bootPlayer);
        if (bootedConnection == null) {
            this.printToControllingUser("tra: 3 :Noplayerfoundwiththename: " + bootPlayer);
            return;
        }
        boolean doBoot = true;
        boolean afkBoot = false;
        if (this.playingConnections.contains(bootedConnection)) {
            if (!this.control.world.isPlayerActive(bootedConnection.name())) {
                if (this.clientExecutingCommand != null && this.control.world.gamePhase == 4) {
                    doBoot = false;
                } else {
                    doBoot = true;
                    afkBoot = true;
                }
            } else if (this.clientExecutingCommand != null && this.isFullControlUser(this.clientExecutingCommand)) {
                doBoot = true;
            } else {
                doBoot = false;
                this.printToControllingUser("tra: 3 :Youcannotbootanactiveplayer:");
            }
        } else if (this.clientExecutingCommand != null && !this.isFullControlUser(this.clientExecutingCommand)) {
            doBoot = false;
        }
        if (doBoot) {
            bootedConnection.encodeln("tra: 2 beenBooted");
            bootedConnection.encodeln("rate: boot" + (this.clientExecutingCommand != null ? " " + this.clientExecutingCommand.name() : ""));
            bootedConnection.kill();
            if (this.control.ops.internetPublic) {
                this.printToControllingUser("tra: 3 :Bootbanhostwarning:");
            }
            if (!afkBoot) {
                this.alertSillysoftWithChat(this.controllingHostName() + " booted " + bootedConnection.name());
            }
        }
    }

    private void dealWithMegaMuteCommand(String command) {
        this.log("command: '" + command + "'");
        if (command.length() < 10) {
            this.printToControllingUser("tra: 3 :Youmustenterthenameofaplayertomute:");
            return;
        }
        String mutePlayer = command.substring(command.indexOf(" ") + 1);
        String mutePlayerLower = mutePlayer.toLowerCase();
        if (!this.megaMutedPlayers.contains(mutePlayerLower)) {
            this.megaMutedPlayers.add(mutePlayerLower);
            this.printToAll("tra: 3 :Player: " + this.controllingHostName() + " :hasput: " + mutePlayer + " on mute for everyone");
            if (null != this.connectionFromName(mutePlayerLower)) {
                this.alertSillysoftWithChat(this.controllingHostName() + " megamuted " + mutePlayerLower);
            }
        } else {
            this.megaMutedPlayers.remove(mutePlayerLower);
            this.printToAll("tra: 3 :Player: " + this.controllingHostName() + " :hasput: " + mutePlayer + " off of mute for everyone");
        }
    }

    protected boolean playerCanTalk(String player) {
        if (player == null) {
            return false;
        }
        return !this.megaMutedPlayers.contains(player.toLowerCase());
    }

    private void dealWithMuteCommand(String command) {
        if (command.length() < 6) {
            this.println(gameNoticeStart + Translator.getString("Youmustenterthenameofaplayertomute") + gameNoticeEnd);
            return;
        }
        String mutePlayer = command.substring(command.indexOf(" ") + 1);
        if (mutePlayer.equalsIgnoreCase(this.name())) {
            this.println(gameNoticeStart + Translator.getString("Youcannotmuteyourslef") + gameNoticeEnd);
            return;
        }
        if (this.server) {
            this.toggleMute(this.name(), mutePlayer);
        } else {
            this.sendToAll("MUTE: " + mutePlayer);
        }
    }

    public void toggleMute(String fromPlayer, String toPlayer) {
        Object key;
        if (!this.server) {
            this.debug("toggleMute hit in a client. bad");
            return;
        }
        if (toPlayer.equalsIgnoreCase(this.name())) {
            NetConnection sender = this.connectionFromName(fromPlayer);
            if (sender != null) {
                sender.encodeln("tra: 2 cannotMuteHost");
            }
            return;
        }
        NetConnection mutedConnection = this.connectionFromNameIgnoreCase(toPlayer);
        if (mutedConnection == null) {
            boolean muteBot = false;
            for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
                if (!this.control.ops.playerTypes[i].equalsIgnoreCase(toPlayer)) continue;
                toPlayer = this.control.ops.playerTypes[i] + " (AI)";
                this.debug("mute a bot");
                muteBot = true;
            }
            if (!muteBot) {
                NetConnection sender = this.connectionFromName(fromPlayer);
                if (sender == null) {
                    if (fromPlayer.equals(this.name())) {
                        this.println(gameNoticeStart + Translator.getString("Noplayerfoundwiththename") + " " + toPlayer + " " + Translator.getString("tomute") + gameNoticeEnd);
                    }
                } else {
                    sender.encodeln("tra: 3 :Noplayerfoundwiththename: " + toPlayer + " :tomute:");
                }
                return;
            }
        } else {
            toPlayer = mutedConnection.name();
        }
        if (!this.muteOnKey.equals(key = this.muteTable.get(fromPlayer + toPlayer))) {
            this.muteTable.put(fromPlayer + toPlayer, this.muteOnKey);
            if (this.playerCanTalk(fromPlayer) && this.silentLevel != 2) {
                this.printToAll("tra: 3 :Player: " + fromPlayer + " :hasput: " + toPlayer + " :onmute:");
            }
        } else {
            this.muteTable.put(fromPlayer + toPlayer, new Object());
            if (this.playerCanTalk(fromPlayer) && this.silentLevel != 2) {
                this.printToAll("tra: 3 :Player: " + fromPlayer + " :hasput: " + toPlayer + " :offmute:");
            }
        }
    }

    public void dealWithAgentChat(String message, String fromname, String secondaryname) {
        this.recieveChat(fromname + " (AI): " + message, fromname + " (AI)", secondaryname + " (AI)");
    }

    public void dealWithAgentEmote(String message, String fromname, String secondaryname) {
        if (!this.server) {
            return;
        }
        this.recieveServerSideEmote(fromname + " (AI)", message, secondaryname + " (AI)");
    }

    public boolean dealWithAgentAudio(URL audio, String classname) {
        return false;
    }

    public void sendPlayerList(NetConnection requester) {
        requester.encodeln("tra: 4 :UserList: - " + (this.getNumberOfHumans() - this.getNumberOfGuestOnly()) + "/" + this.getNumberOfHumans() + " " + Translator.getString("players") + ":");
        requester.encodeln("userListStart:");
        if (!PrefsCache.headless) {
            requester.encodeln("tra: 4    " + this.userName + " " + LuxTracker.getTeam(this.name()) + "(:host:" + (this.guestOnly ? " - :guestonly:" : "") + ")");
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection next = (NetConnection)this.connections.get(i);
            String team = LuxTracker.getTeam(next.name());
            if (this.playingConnections.contains(next) || this.playerControlsSomebody(next)) {
                if (next.guestOnly()) {
                    requester.encodeln("tra: 4      " + next.name() + " " + team + "(:player: - :guestonly:)");
                    continue;
                }
                requester.encodeln("tra: 4      " + next.name() + " " + team + "(" + (this.isClientControlling(next) ? ":host: - " : "") + ":player:)");
                continue;
            }
            if (next.guestOnly()) {
                requester.encodeln("tra: 4      " + next.name() + " " + team + "(:guestonly:)");
                continue;
            }
            requester.encodeln("tra: 4      " + next.name() + " " + team + "(" + (this.isClientControlling(next) ? ":host: - " : "") + ":guest:)");
        }
        requester.encodeln("userListEnd:");
    }

    public void recieveChat(String text, String from) {
        this.recieveChat(text, from, null);
    }

    public void recieveChat(String text, String from, String secondaryFrom) {
        if (this.server) {
            if (this.silentLevel == 2 || this.silentLevel == 1 && this.control.world.isPlayerPlaying(from)) {
                return;
            }
            if (this.megaMutedPlayers.contains(from.toLowerCase())) {
                return;
            }
            if (!(this.muteOnKey.equals(this.muteTable.get(this.name() + from)) || secondaryFrom != null && this.muteOnKey.equals(this.muteTable.get(this.name() + secondaryFrom)))) {
                int index = this.control.getPlayerIndexForControllingName(from);
                if (index != -1) {
                    if (PrefsCache.headless) {
                        this.println(text);
                    } else {
                        this.println(text, ((GameControllerGUI)this.control).luxView.getColor(index));
                    }
                } else {
                    this.println(text);
                }
                if (!PrefsCache.headless && PrefsCache.chatSound) {
                    chatSound.play();
                }
            }
            for (int i = 0; i < this.connections.size(); ++i) {
                NetConnection n = (NetConnection)this.connections.get(i);
                if (this.muteOnKey.equals(this.muteTable.get(n.name() + from))) continue;
                n.encodeln("CHAT: " + text);
            }
            this.control.world.recieveChat(text, from);
        } else {
            int index = -1;
            if (this.control != null) {
                index = this.control.getPlayerIndexForControllingName(from);
            }
            if (index != -1) {
                this.println(text, ((GameControllerGUI)this.control).luxView.getColor(index));
            } else {
                this.println(text);
            }
            if (PrefsCache.chatSound) {
                chatSound.play();
            }
        }
    }

    public void recieveClientSideEmote(String emoteString) {
        if (this.server) {
            this.log("recieveClientSideEmote called on the non-server");
            return;
        }
        this.println("\u221e " + emoteString + " \u221e", 1);
        if (PrefsCache.chatSound) {
            chatSound.play();
        }
    }

    public void recieveClientSideHEmote(String emoteString) {
        if (this.server) {
            this.log("recieveClientSideHEmote called on the non-server");
            return;
        }
        this.println("\u2665\u2665\u2665 " + emoteString + " " + heartString, SSChatArea.heartStyle);
        if (PrefsCache.chatSound) {
            chatSound.play();
        }
    }

    public void recieveClientSideSEmote(String emoteString) {
        if (this.server) {
            this.log("recieveClientSideSEmote called on the non-server");
            return;
        }
        this.println("\u266a\u266b " + emoteString + " " + singString, SSChatArea.singStyle);
        if (PrefsCache.chatSound) {
            chatSound.play();
        }
    }

    public void recieveServerSideEmote(String from, String emote) {
        this.recieveServerSideEmote(from, emote, null);
    }

    public void recieveServerSideEmote(String from, String emote, String secondaryFrom) {
        if (!this.server) {
            this.log("recieveServerSideEmote called on the non-server");
            return;
        }
        if (this.silentLevel == 2 || this.silentLevel == 1 && this.control.world.isPlayerPlaying(from)) {
            return;
        }
        if (this.megaMutedPlayers.contains(from.toLowerCase())) {
            return;
        }
        if (!(this.muteOnKey.equals(this.muteTable.get(this.name() + from)) || secondaryFrom != null && this.muteOnKey.equals(this.muteTable.get(this.name() + secondaryFrom)))) {
            this.println("\u221e " + from + (emote.startsWith("'") ? "" : " ") + emote + " \u221e", 1);
            if (!PrefsCache.headless && PrefsCache.chatSound) {
                chatSound.play();
            }
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection n = (NetConnection)this.connections.get(i);
            if (this.muteOnKey.equals(this.muteTable.get(n.name() + from))) continue;
            if (emote.startsWith("'")) {
                n.encodeln("EMOTE: " + from + emote);
                continue;
            }
            n.encodeln("EMOTE: " + from + " " + emote);
        }
        this.control.world.recieveEmote(emote, from);
    }

    public void recieveServerSideHEmote(String from, String emote) {
        this.recieveServerSideHEmote(from, emote, null);
    }

    public void recieveServerSideHEmote(String from, String emote, String secondaryFrom) {
        if (!this.server) {
            this.log("recieveServerSideHEmote called on the non-server");
            return;
        }
        if (this.silentLevel == 2 || this.silentLevel == 1 && this.control.world.isPlayerPlaying(from)) {
            return;
        }
        if (this.megaMutedPlayers.contains(from.toLowerCase())) {
            return;
        }
        if (!(this.muteOnKey.equals(this.muteTable.get(this.name() + from)) || secondaryFrom != null && this.muteOnKey.equals(this.muteTable.get(this.name() + secondaryFrom)))) {
            this.println("\u2665\u2665\u2665 " + from + (emote.startsWith("'") ? "" : " ") + emote + " " + heartString, SSChatArea.heartStyle);
            if (!PrefsCache.headless && PrefsCache.chatSound) {
                chatSound.play();
            }
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection n = (NetConnection)this.connections.get(i);
            if (this.muteOnKey.equals(this.muteTable.get(n.name() + from))) continue;
            if (emote.startsWith("'")) {
                n.encodeln("HMOTE: " + from + emote);
                continue;
            }
            n.encodeln("HMOTE: " + from + " " + emote);
        }
        this.control.world.recieveHEmote(emote, from);
    }

    public void recieveServerSideSEmote(String from, String emote) {
        this.recieveServerSideSEmote(from, emote, null);
    }

    public void recieveServerSideSEmote(String from, String emote, String secondaryFrom) {
        if (!this.server) {
            this.log("recieveServerSideSEmote called on the non-server");
            return;
        }
        if (this.silentLevel == 2 || this.silentLevel == 1 && this.control.world.isPlayerPlaying(from)) {
            return;
        }
        if (this.megaMutedPlayers.contains(from.toLowerCase())) {
            return;
        }
        if (!(this.muteOnKey.equals(this.muteTable.get(this.name() + from)) || secondaryFrom != null && this.muteOnKey.equals(this.muteTable.get(this.name() + secondaryFrom)))) {
            this.println("\u266a\u266b " + from + (emote.startsWith("'") ? "" : " ") + emote + " " + singString, SSChatArea.singStyle);
            if (!PrefsCache.headless && PrefsCache.chatSound) {
                chatSound.play();
            }
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection n = (NetConnection)this.connections.get(i);
            if (this.muteOnKey.equals(this.muteTable.get(n.name() + from))) continue;
            if (emote.startsWith("'")) {
                n.encodeln("SMOTE: " + from + emote);
                continue;
            }
            n.encodeln("SMOTE: " + from + " " + emote);
        }
        this.control.world.recieveSEmote(emote, from);
    }

    public void recieveServerSideZEmote(String from, String emote) {
        this.recieveServerSideZEmote(from, emote, null);
    }

    public void recieveServerSideZEmote(String from, String emote, String secondaryFrom) {
        if (!this.server) {
            this.log("recieveServerSideZEmote called on the non-server");
            return;
        }
        if (this.silentLevel == 2 || this.silentLevel == 1 && this.control.world.isPlayerPlaying(from)) {
            return;
        }
        if (this.megaMutedPlayers.contains(from.toLowerCase())) {
            return;
        }
        if (!(this.muteOnKey.equals(this.muteTable.get(this.name() + from)) || secondaryFrom != null && this.muteOnKey.equals(this.muteTable.get(this.name() + secondaryFrom)))) {
            this.println("\u25c6\u25c6\u25c6\u25c6 " + emote + " " + from + " " + "\u25c6\u25c6\u25c6\u25c6", SSChatArea.zemoteStyle);
            if (!PrefsCache.headless && PrefsCache.chatSound) {
                chatSound.play();
            }
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection n = (NetConnection)this.connections.get(i);
            if (this.muteOnKey.equals(this.muteTable.get(n.name() + from))) continue;
            n.encodeln("ZMOTE: " + emote + " " + from);
        }
        this.control.world.recieveZEmote(emote, from);
    }

    public void recieveClientSideZEmote(String emoteString) {
        if (this.server) {
            this.log("recieveClientSideZEmote called on the non-server");
            return;
        }
        this.println("\u25c6\u25c6\u25c6\u25c6 " + emoteString + " " + "\u25c6\u25c6\u25c6\u25c6", SSChatArea.zemoteStyle);
        if (PrefsCache.chatSound) {
            chatSound.play();
        }
    }

    public void sendToAll(String command) {
        for (int i = 0; i < this.connections.size(); ++i) {
            ((NetConnection)this.connections.get(i)).encodeln(command);
        }
    }

    public void println(String text) {
        if (PrefsCache.headless) {
            System.out.println(text);
        } else if (this.chatArea != null) {
            this.chatArea.println(text);
        }
    }

    public void println(String text, Color color) {
        this.println(text, color, false);
    }

    public void println(String text, Color color, boolean doubleSided) {
        if (PrefsCache.headless) {
            System.out.println(text);
        } else {
            this.chatArea.println(text, color, doubleSided);
        }
    }

    public void println(String text, int styleCode) {
        if (PrefsCache.headless) {
            System.out.println(text);
        } else {
            this.chatArea.println(text, styleCode);
        }
    }

    public void println(String text, SimpleAttributeSet style) {
        if (PrefsCache.headless) {
            System.out.println(text);
        } else {
            this.chatArea.println(text, style);
        }
    }

    public void focusChatField() {
        if (PrefsCache.headless) {
            return;
        }
        this.chatArea.focusChatField();
    }

    private void teamCheck() {
        this.teamCheck(false);
    }

    private void teamCheck(boolean autoSetup) {
        this.printToControllingUser("tra: 3 Team Check:");
        IntegerHashtable teamCountsPlayers = new IntegerHashtable();
        IntegerHashtable teamCountsTotal = new IntegerHashtable();
        if (!PrefsCache.headless) {
            teamCountsTotal.increment(LuxTracker.getTeam(this.name()));
            if (!this.guestOnly) {
                teamCountsPlayers.increment(LuxTracker.getTeam(this.name()));
            }
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection net = (NetConnection)this.connections.get(i);
            teamCountsTotal.increment(LuxTracker.getTeam(net.name()));
            if (net.guestOnly()) continue;
            teamCountsPlayers.increment(LuxTracker.getTeam(net.name()));
        }
        List v = teamCountsTotal.getSortedKeys();
        Iterator it = v.iterator();
        ArrayList<String> teamsWithAtLeastTwo = new ArrayList<String>();
        ArrayList<String> teamsWithAtLeastThree = new ArrayList<String>();
        while (it.hasNext()) {
            String team = (String)it.next();
            int players = teamCountsPlayers.getInt(team);
            int total = teamCountsTotal.getInt(team);
            this.printToControllingUser("tra: 3 " + team + "has " + players + "/" + total);
            if (players > 1) {
                teamsWithAtLeastTwo.add(NetBoss.extractTeam(team));
            }
            if (players <= 2) continue;
            teamsWithAtLeastThree.add(NetBoss.extractTeam(team));
        }
        if (autoSetup) {
            Random rand = new Random();
            if (teamsWithAtLeastTwo.size() > 2) {
                String team1 = (String)teamsWithAtLeastTwo.remove(rand.nextInt(teamsWithAtLeastTwo.size()));
                String team2 = (String)teamsWithAtLeastTwo.remove(rand.nextInt(teamsWithAtLeastTwo.size()));
                String team3 = (String)teamsWithAtLeastTwo.remove(rand.nextInt(teamsWithAtLeastTwo.size()));
                this.dealWithCommand("/teams " + team1 + " " + team2 + " " + team3);
            } else if (teamsWithAtLeastThree.size() > 1) {
                String team1 = (String)teamsWithAtLeastThree.remove(rand.nextInt(teamsWithAtLeastThree.size()));
                String team2 = (String)teamsWithAtLeastThree.remove(rand.nextInt(teamsWithAtLeastThree.size()));
                this.dealWithCommand("/teams " + team1 + " " + team2);
            } else if (teamsWithAtLeastTwo.size() > 1) {
                String team1 = (String)teamsWithAtLeastTwo.remove(rand.nextInt(teamsWithAtLeastTwo.size()));
                String team2 = (String)teamsWithAtLeastTwo.remove(rand.nextInt(teamsWithAtLeastTwo.size()));
                String team3 = "ROB";
                this.dealWithCommand("/teams " + team1 + " " + team2 + " " + team3);
            } else if (teamsWithAtLeastThree.size() > 0) {
                String team1 = (String)teamsWithAtLeastThree.remove(rand.nextInt(teamsWithAtLeastThree.size()));
                String team2 = "ROB";
                this.dealWithCommand("/teams " + team1 + " " + team2);
            } else {
                this.dealWithCommand("/teams foo ROB");
            }
        }
    }

    private static String extractTeam(String teamWithPadding) {
        String result = teamWithPadding.trim();
        if (result.startsWith("[")) {
            result = result.substring(1);
        }
        if (result.endsWith("]")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void dealWithTeamsCommand(String command) {
        block27: {
            NetConnection next;
            int i;
            int startAtPosition;
            int i2;
            String[] tokens;
            block26: {
                tokens = StringTool.tokenize(command, " ");
                if (tokens.length < 3) {
                    this.printToControllingUser("tra: 3 :Error:. Example: /teams SED 10M MFS");
                    return;
                }
                tokens[1] = "[" + tokens[1] + "] ";
                tokens[2] = "[" + tokens[2] + "] ";
                if (tokens.length > 3) {
                    tokens[3] = "[" + tokens[3] + "] ";
                }
                for (i2 = 0; i2 < robotSpot.length; ++i2) {
                    NetBoss.robotSpot[i2] = false;
                }
                this.printToAll("tra: 3 Setting up a team game with " + tokens[1].toUpperCase() + "vs " + tokens[2].toUpperCase() + (tokens.length > 3 ? "vs " + tokens[3].toUpperCase() : ""));
                if (tokens.length != 3) break block26;
                this.set3v3colors();
                if ("[ROB] ".equalsIgnoreCase(tokens[1])) {
                    this.printToAll("tra: 3 Reserving team 1 spots for the robot team");
                    NetBoss.robotSpot[0] = true;
                    NetBoss.robotSpot[2] = true;
                    NetBoss.robotSpot[4] = true;
                } else if ("[ROB] ".equalsIgnoreCase(tokens[2])) {
                    this.printToAll("tra: 3 Reserving team 2 spots for the robot team");
                    NetBoss.robotSpot[1] = true;
                    NetBoss.robotSpot[3] = true;
                    NetBoss.robotSpot[5] = true;
                }
                for (i2 = 0; i2 < this.connections.size(); ++i2) {
                    NetConnection next2 = (NetConnection)this.connections.get(i2);
                    if (next2.guestOnly() || !next2.getTeam().equalsIgnoreCase(tokens[1])) continue;
                    this.connections.remove(next2);
                    this.connections.add(0, next2);
                    this.printToAll("tra: 3 :Player: " + next2.name() + " has been promoted to the top of the player list");
                }
                startAtPosition = 1;
                if (!LuxTracker.getTeam(this.name()).equalsIgnoreCase(tokens[1]) && !LuxTracker.getTeam(this.name()).equalsIgnoreCase(tokens[2])) {
                    if (!this.guestOnly) {
                        this.dealWithCommand("/guest");
                    }
                } else if (LuxTracker.getTeam(this.name()).equalsIgnoreCase(tokens[1]) && !this.guestOnly) {
                    startAtPosition = 0;
                }
                for (int i3 = 0; i3 < this.connections.size(); ++i3) {
                    NetConnection next3 = (NetConnection)this.connections.get(i3);
                    if (next3.guestOnly() || !next3.getTeam().equalsIgnoreCase(tokens[2])) continue;
                    this.connections.remove(next3);
                    this.connections.add(startAtPosition, next3);
                    this.printToAll("tra: 3 :Player: " + next3.name() + " has been promoted to " + ((startAtPosition += 2) == 0 ? "the top of" : "position " + (startAtPosition + 1) + " in") + " the player list");
                }
                break block27;
            }
            if (tokens.length <= 3) break block27;
            this.set2v2v2colors();
            if (!this.guestOnly && !PrefsCache.headless) {
                if (!(LuxTracker.getTeam(this.name()).equalsIgnoreCase(tokens[1]) || LuxTracker.getTeam(this.name()).equalsIgnoreCase(tokens[2]) || LuxTracker.getTeam(this.name()).equalsIgnoreCase(tokens[3]))) {
                    this.dealWithCommand("/guest");
                } else if (LuxTracker.getTeam(this.name()).equalsIgnoreCase(tokens[2])) {
                    String temp = tokens[1];
                    tokens[1] = tokens[2];
                    tokens[2] = temp;
                } else if (LuxTracker.getTeam(this.name()).equalsIgnoreCase(tokens[3])) {
                    String temp = tokens[1];
                    tokens[1] = tokens[3];
                    tokens[3] = temp;
                }
            }
            if ("[ROB] ".equalsIgnoreCase(tokens[1])) {
                this.printToAll("tra: 3 Reserving team 1 spots for the robot team");
                NetBoss.robotSpot[0] = true;
                NetBoss.robotSpot[3] = true;
            } else if ("[ROB] ".equalsIgnoreCase(tokens[2])) {
                this.printToAll("tra: 3 Reserving team 2 spots for the robot team");
                NetBoss.robotSpot[1] = true;
                NetBoss.robotSpot[4] = true;
            } else if ("[ROB] ".equalsIgnoreCase(tokens[3])) {
                this.printToAll("tra: 3 Reserving team 3 spots for the robot team");
                NetBoss.robotSpot[2] = true;
                NetBoss.robotSpot[5] = true;
            }
            for (i2 = 0; i2 < this.connections.size(); ++i2) {
                NetConnection next4 = (NetConnection)this.connections.get(i2);
                if (next4.guestOnly() || !next4.getTeam().equalsIgnoreCase(tokens[1])) continue;
                this.connections.remove(next4);
                this.connections.add(0, next4);
                this.printToAll("tra: 3 :Player: " + next4.name() + " has been promoted to the top of the player list");
            }
            startAtPosition = this.guestOnly ? 1 : 0;
            for (i = 0; i < this.connections.size(); ++i) {
                next = (NetConnection)this.connections.get(i);
                if (next.guestOnly() || !next.getTeam().equalsIgnoreCase(tokens[2])) continue;
                this.connections.remove(next);
                this.connections.add(startAtPosition, next);
                this.printToAll("tra: 3 :Player: " + next.name() + " has been promoted to " + ((startAtPosition += 2) == 0 ? "the top of" : "position " + (startAtPosition + 1) + " in") + " the player list");
            }
            startAtPosition = this.guestOnly ? 2 : 1;
            for (i = 0; i < this.connections.size(); ++i) {
                next = (NetConnection)this.connections.get(i);
                if (next.guestOnly() || !next.getTeam().equalsIgnoreCase(tokens[3])) continue;
                this.connections.remove(next);
                this.connections.add(startAtPosition, next);
                this.printToAll("tra: 3 :Player: " + next.name() + " has been promoted to " + ((startAtPosition += 3) == 0 ? "the top of" : "position " + (startAtPosition + 1) + " in") + " the player list");
            }
        }
    }

    private LuxOptions getNetOps() throws Exception {
        boolean forceInternetPublic = this.control != null && this.control.ops != null && this.control.ops.internetPublic || this.control == null && LuxController.getInstance().internetPublic();
        LuxOptions ops = LuxController.getInstance().currentOptions(true, forceInternetPublic);
        boolean tooManyPlayers = this.playingConnections != null && this.control != null && this.control.ops != null && this.control.ops.playerNames != null && this.playingConnections.size() > this.control.ops.playerNames.length;
        tooManyPlayers = true;
        SS.debug("adjusting player order based on shuffle preference");
        if ((Prefs.getInt("shuffleState", 4) == 2 || Lux.shuffleMode == 2) && tooManyPlayers) {
            this.shuffleConnections();
            this.printToAll("tra: 3 :Playerorderhasbeenrandomized: ");
            this.promoteWinner();
        } else if ((Prefs.getInt("shuffleState", 4) == 1 || Lux.shuffleMode == 1) && tooManyPlayers) {
            this.shuffleConnections();
            this.printToAll("tra: 3 :Playerorderhasbeenrandomized: ");
        } else if (Prefs.getInt("shuffleState", 4) == 3 || Lux.shuffleMode == 3) {
            this.printToAll("tra: 3 :Playerorderrawfirst: ");
            this.raw = this.refreshRaws();
            this.sortConnectionsByRaw();
            this.promoteWinner();
            if (!this.guestOnly) {
                int humanCount = 0;
                for (int i = 0; i < this.connections.size(); ++i) {
                    NetConnection nextPlayer = (NetConnection)this.connections.get(i);
                    if (!nextPlayer.guestOnly()) {
                        ++humanCount;
                    }
                    if (humanCount != 6 || this.raw >= nextPlayer.getRaw()) continue;
                    this.guestOnly = true;
                }
            }
        }
        this.promoteHeadlessOwner();
        if (this.guestOnly) {
            for (int i = 0; i < ops.playerTypes.length; ++i) {
                if (!"Human".equals(ops.playerTypes[i])) continue;
                ops.playerTypes[i] = LuxController.getInstance().usingNetworkPlayerOnly() ? "networkplayeronly" : LuxController.getInstance().getFirstAI();
                ops.guiControl[i] = false;
            }
        }
        int replaceAI = ops.getNextRemoteReplacedIndex();
        int humanClientCount = 0;
        for (int i = 0; i < this.connections.size() && humanClientCount < this.maxHumanClients; ++i) {
            NetConnection nextPlayer = (NetConnection)this.connections.get(i);
            if (nextPlayer.guestOnly() || replaceAI == -1) continue;
            ops.playerTypes[replaceAI] = "Human";
            ops.playerNames[replaceAI] = nextPlayer.name();
            replaceAI = ops.getNextRemoteReplacedIndex();
            ++humanClientCount;
        }
        ops.removeRemoteOnly();
        ops.ensureProperOrder();
        if (this.control != null && this.control.ops.boardFile != null && this.control.ops.boardName().equals(ops.boardName()) && this.control.ops.biohazardLevel == 0) {
            SS.debug("NetBoss is reusing the old boardFile");
            ops.boardFile = this.control.ops.boardFile;
        }
        ops.ensureBoardFile();
        return ops;
    }

    private int refreshRaws() {
        return LuxTracker.refreshRaws(this.connections, LuxController.getInstance().userName());
    }

    private void sortConnectionsByRaw() {
        Comparator rawSort = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((NetConnection)o2).getRaw() - ((NetConnection)o1).getRaw();
            }

            public boolean equals(Object o1, Object o2) {
                return ((NetConnection)o1).getRaw() == ((NetConnection)o2).getRaw();
            }
        };
        Collections.sort(this.connections, rawSort);
    }

    private void promoteHeadlessOwner() {
        if (PrefsCache.headless) {
            for (int i = 0; i < this.connections.size(); ++i) {
                NetConnection n = (NetConnection)this.connections.get(i);
                if (!n.userKey().equals(Prefs.getUserKey())) continue;
                this.connections.remove(n);
                this.connections.add(0, n);
            }
        }
    }

    public void promoteWinner() {
        if (this.control != null && this.control.masterControl && this.control.world != null && this.control.world.gamePhase == 4) {
            SS.debug("promoting the winner of the game");
            try {
                String lastWinner = this.control.ops.playerNames[this.control.world.getFirstNonEmptyPlayer()];
                NetConnection lastNetCon = this.connectionFromName(lastWinner);
                if (null != lastNetCon) {
                    this.connections.remove(lastNetCon);
                    this.connections.add(0, lastNetCon);
                    this.printToAll("tra: 3 :Player: " + lastNetCon.name() + " has been promoted to the top of the player list");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void startGame() {
        try {
            this.startGameWithOptions(this.getNetOps());
            this.updateTracker();
        }
        catch (Throwable t) {
            this.println(gameNoticeStart + Translator.getString("ErrorNetOps") + gameNoticeEnd);
            t.printStackTrace();
            if (PrefsCache.headless) {
                this.printToAll("tra: 3 :Error: while starting the game " + t);
            } else {
                this.control.showMessage("There was an error trying to start the game. \n\n" + t);
                LuxController.getInstance().showNewGameWindow();
                try {
                    this.kill();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return;
        }
    }

    public synchronized void startGameWithSameBoard(LuxOptions opsOld) {
        try {
            LuxOptions ops = this.getNetOps();
            ops.width = opsOld.width;
            ops.height = opsOld.height;
            ops.customBoard = opsOld.customBoard;
            ops.boardSize = opsOld.boardSize;
            ops.boardNumber = opsOld.boardNumber;
            ops.boardFile = opsOld.boardFile;
            this.startGameWithOptions(ops);
        }
        catch (Exception t) {
            t.printStackTrace();
            this.control.showMessage("There was an error when trying to start the game. \n\n" + t);
            LuxController.getInstance().showNewGameWindow();
            try {
                this.kill();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    synchronized void startGameWithOptions(LuxOptions ops) {
        System.out.println("startGameWithOptions");
        if (!this.server) {
            this.debug("a client netboss tried to start a game!");
            Thread.dumpStack();
            return;
        }
        this.userName = LuxController.getInstance().userName();
        if (this.control == null) {
            SS.debug("startGameWithOptions with control=null");
            this.control = PrefsCache.headless ? new GameControllerHeadless(ops, true, this) : new GameControllerGUI(ops, true, this);
        } else {
            this.control.takeNewOps(ops);
        }
        this.playingConnections = new Vector();
        for (int c = 0; c < this.connections.size(); ++c) {
            NetConnection net = (NetConnection)this.connections.get(c);
            net.startGame(this.control, ops.copyWithGuiControlFor(net.name()));
            if (!ArrayTool.arrayContains(ops.playerNames, net.name())) continue;
            this.playingConnections.add(net);
        }
        String[] nicks = new String[ops.playerNames.length];
        String[] userKeys = new String[nicks.length];
        String[] IP = new String[nicks.length];
        for (int i = 0; i < nicks.length; ++i) {
            nicks[i] = this.control.ops.playerTypes[i];
            if ("Human".equals(nicks[i])) {
                nicks[i] = this.control.ops.playerNames[i];
                IP[i] = this.IPFromName(this.control.ops.playerNames[i]);
                userKeys[i] = "";
                if (this.userName.equalsIgnoreCase(nicks[i])) {
                    userKeys[i] = Prefs.getUserKey();
                    continue;
                }
                if (this.control.ops.playerTypes[i].equals("Human") && this.control.ops.guiControl[i]) {
                    userKeys[i] = "HOSTHUMAN";
                    continue;
                }
                NetConnection netcon = this.connectionFromNameIgnoreCase(nicks[i]);
                if (netcon == null) {
                    this.log("Could not find connection for name " + nicks[i]);
                    userKeys[i] = "UNKNOWN";
                    continue;
                }
                userKeys[i] = netcon.userKey();
                continue;
            }
            userKeys[i] = "666";
        }
        String map = this.control.ops.boardTitle();
        map = map.substring(map.lastIndexOf(47) + 1);
        this.pingRankings = new PingRankings(nicks, userKeys, map, IP);
        this.showIntroInformation();
    }

    public void playerIsInactive(int playerID) {
        String inactiveName = this.control.ops.playerNames[playerID];
        this.printToAll("tra: 3 " + inactiveName + " :hasbeeninactive:");
        NetConnection guestHost = this.getFirstNonGuestOnlyConnection();
        if (guestHost != null && inactiveName.equals(guestHost.name()) && !this.isFullControlUser(guestHost)) {
            this.connections.remove(guestHost);
            this.connections.add(guestHost);
            this.printToAll("tra: 3 :Player: " + inactiveName + " :hasbeenmovedtothebottom:");
        }
    }

    public void showIntroInformation() {
        new Thread("showIntroInformation-delay"){

            public void run() {
                try {
                    Thread.sleep(1000L);
                    NetBoss.this.println(NetBoss.gameNoticeStart + Translator.getString("Type/help") + NetBoss.gameNoticeEnd);
                    NetBoss.this.dealWithCommand("/cards");
                    NetBoss.this.dealWithCommand("/users");
                    if (!NetBoss.this.server) {
                        NetBoss.this.dealWithCommand("/desc");
                    } else {
                        NetBoss.this.println(Translator.getString("Descriptionhasbeenupdated") + ": " + Prefs.get("lastDescription", "Welcome!"));
                    }
                }
                catch (Exception e) {
                    NetBoss.this.debug("Caught an exception in showIntroInformation(): probably the first game hosted?");
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public void passVote(boolean voteFor) {
        NetConnection net = (NetConnection)this.connections.get(0);
        if (net == null) {
            this.debug("oops, net is null in NetBoss.passVote");
            return;
        }
        net.encodeln("PASSVOTE: " + voteFor);
    }

    public void connectionLost(NetConnection n) {
        if (this.connections != null && !this.connections.remove(n)) {
            this.playingConnections.remove(n);
            return;
        }
        if (this.server) {
            this.updateTracker();
            String lostName = n.name();
            this.println(gameNoticeStart + lostName + " " + Translator.getString("hasExited") + " (" + n.ip() + ")" + gameNoticeEnd);
            this.sendToAll("tra: 3 " + lostName + " :hasExited:");
            if (this.playingConnections.remove(n) && this.control.world.gamePhase < 4) {
                boolean freeGuests = this.areThereGuestsWhoWantToPlay();
                this.log(lostName + " disconnected, freeGuests=" + freeGuests);
                this.control.lostClient(lostName, freeGuests);
            } else {
                this.log("a guest disconnected");
            }
        } else if (this.connections == null || this.connections.size() == 0) {
            this.println(gameNoticeStart + Translator.getString("ConnectionTerminated") + gameNoticeEnd);
            if (this.control != null) {
                ((GameControllerGUI)this.control).lostServer(n.name());
            }
        }
    }

    private boolean areThereFreePlayers() {
        int i;
        boolean freeGuests = false;
        for (i = 0; i < this.connections.size(); ++i) {
            if (this.playingConnections.contains(this.connections.get(i))) continue;
            freeGuests = true;
        }
        if (freeGuests) {
            return true;
        }
        if (!this.playerControlsSomebody(this.name())) {
            return true;
        }
        for (i = 0; i < this.connections.size(); ++i) {
            if (this.playerControlsSomebody(((NetConnection)this.connections.get(i)).name())) continue;
            return true;
        }
        return false;
    }

    private boolean playerControlsSomebody(NetConnection netCon) {
        return this.playerControlsSomebody(netCon.name());
    }

    private boolean playerControlsSomebody(String playerName) {
        for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
            if (!playerName.equalsIgnoreCase(this.control.ops.playerNames[i]) && !playerName.equalsIgnoreCase(this.control.takenOverPlayerNames[i]) || this.control.stats.getOwned(i) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean areThereGuests() {
        boolean freeGuests = false;
        for (int i = 0; i < this.connections.size(); ++i) {
            if (this.playingConnections.contains(this.connections.get(i))) continue;
            freeGuests = true;
        }
        return freeGuests;
    }

    private boolean areThereGuestsWhoWantToPlay() {
        for (int i = 0; i < this.connections.size(); ++i) {
            if (this.playingConnections.contains(this.connections.get(i)) || ((NetConnection)this.connections.get(i)).guestOnly()) continue;
            return true;
        }
        return !this.playerControlsSomebody(this.name()) && !this.guestOnly && !LuxController.getInstance().userName().endsWith("(dedicated host)");
    }

    public synchronized String giveGuestPlayer(int playerIndex) {
        NetConnection net;
        int i;
        this.log("giveGuestPlayer hit");
        for (i = 0; i < this.connections.size(); ++i) {
            net = (NetConnection)this.connections.get(i);
            if (this.playingConnections.contains(net) || net.guestOnly()) continue;
            net.encodeln("takeOverPlayer: " + playerIndex);
            net.encodeln("setGamePhase: " + this.control.world.gamePhase);
            this.playingConnections.add(net);
            return net.name();
        }
        if (!(this.playerControlsSomebody(this.name()) || this.guestOnly || LuxController.getInstance().userName().endsWith("(dedicated host)"))) {
            this.control.takeOverPlayer(playerIndex);
            return this.name();
        }
        for (i = 0; i < this.connections.size(); ++i) {
            net = (NetConnection)this.connections.get(i);
            if (this.playerControlsSomebody(net.name()) || net.guestOnly()) continue;
            net.encodeln("takeOverPlayer: " + playerIndex);
            net.encodeln("setGamePhase: " + this.control.world.gamePhase);
            return net.name();
        }
        return null;
    }

    public void restoreLostPlayer(NetConnection n, int playerIndex) {
        this.sendToAll("giveUpPlayer: " + playerIndex);
        n.encodeln("takeOverPlayer: " + playerIndex);
        n.encodeln("setGamePhase: " + this.control.world.gamePhase);
        this.playingConnections.add(n);
        this.playingConnections.remove(this.connectionFromName(this.control.takenOverPlayerNames[playerIndex]));
        if (this.server) {
            this.sendToAll("tra: 3 " + n.name() + " :regainedControl: " + n.name());
        }
    }

    public NetConnection connectionFromName(String connectionName) {
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection net = (NetConnection)this.connections.get(i);
            if (!net.name().equals(connectionName)) continue;
            return net;
        }
        return null;
    }

    public NetConnection connectionFromNameIgnoreCase(String connectionName) {
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection net = (NetConnection)this.connections.get(i);
            if (!net.name().equalsIgnoreCase(connectionName)) continue;
            return net;
        }
        return null;
    }

    public String IPFromName(String name) {
        NetConnection n = this.connectionFromName(name);
        if (n == null) {
            return "n/a";
        }
        return n.ip();
    }

    public boolean hasPlayingConnections() {
        return this.playingConnections != null && this.playingConnections.size() != 0;
    }

    public boolean hasConnections() {
        return this.connections.size() != 0;
    }

    public int getNumberOfHumans() {
        if (PrefsCache.headless) {
            return this.connections.size();
        }
        return this.connections.size() + 1;
    }

    public int getNumberOfGuestOnly() {
        int count = 0;
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection net = (NetConnection)this.connections.get(i);
            if (!net.guestOnly()) continue;
            ++count;
        }
        if (!PrefsCache.headless && (this.guestOnly || LuxController.getInstance().userName().endsWith("(dedicated host)"))) {
            ++count;
        }
        return count;
    }

    public void prepForDrawer() {
        if (PrefsCache.headless) {
            return;
        }
        this.activeSoloWindow = false;
        this.chatArea.prepForDrawer();
    }

    public void goSolo() {
        if (PrefsCache.headless) {
            return;
        }
        if (!this.activeSoloWindow) {
            this.activeSoloWindow = true;
            this.chatArea.goSolo(Translator.getString("Chatterbox") + ": " + this.userName);
        }
    }

    public boolean activeSoloWindow() {
        return this.activeSoloWindow;
    }

    public void kill() {
        this.control = null;
        this.println(gameNoticeStart + Translator.getString("ShuttingNetwork") + gameNoticeEnd);
        NetConnection[] netc = this.connections.toArray(new NetConnection[this.connections.size()]);
        for (int i = 0; i < netc.length; ++i) {
            try {
                netc[i].kill();
                continue;
            }
            catch (Exception e) {
                System.out.println(e + " while killing netconnection as we kill() the net boss");
            }
        }
        this.killed = true;
        if (this.server) {
            try {
                this.sock.close();
            }
            catch (Throwable e) {
                this.debug("Exception closing the ServerSocket");
            }
            if (this.serverThread != null) {
                this.serverThread.interrupt();
            }
            this.serverThread = null;
        }
        this.connections = null;
        this.playingConnections = null;
        if (this.chatArea != null) {
            this.chatArea.kill();
        }
        this.chatArea = null;
    }

    public SSChatArea getChatView() {
        return this.chatArea;
    }

    public void setNetworkKey(String cypherstring) {
        StringBuffer plaintext = new StringBuffer();
        for (int i = 0; i < cypherstring.length(); ++i) {
            plaintext.append(this.decodechar(cypherstring.charAt(i), this.keytext.charAt(i)));
        }
        this.networkKey = plaintext.toString();
    }

    char decodechar(char cyphered, char key) {
        return this.getchar((26 + this.getint(cyphered) - this.getint(key)) % 26);
    }

    char getchar(int pos) {
        return this.letterarray[pos];
    }

    int getint(char achar) {
        for (int i = 0; i < 26; ++i) {
            if (this.letterarray[i] != achar) continue;
            return i;
        }
        return 0;
    }

    public void invalidateRankings(String lostUser) {
        this.pingRankings.invalidate(lostUser);
        this.log("Invalidating the rankings");
    }

    public void addRankings(int[] finalPosition, int[] finalRounds) {
        if (this.networkKey == null) {
            return;
        }
        if ((Prefs.getInt("shuffleState", 4) == 4 || Lux.shuffleMode == 4) && this.control != null && this.control.world != null && this.control.world.gamePhase == 4) {
            this.demoteLoser(2, finalPosition);
            this.demoteLoser(1, finalPosition);
            this.demoteLoser(0, finalPosition);
        }
        this.pingRankings.addRankings(finalPosition, finalRounds, this.networkKey, this.control.ops, this);
    }

    private void demoteLoser(int spotsFromBottom, int[] finalPosition) {
        try {
            int lastLoserID = -1;
            for (int i = 0; i < finalPosition.length; ++i) {
                if (finalPosition[i] != finalPosition.length - spotsFromBottom) continue;
                lastLoserID = i;
            }
            String lastLoser = this.control.ops.playerNames[lastLoserID];
            NetConnection lastNetCon = this.connectionFromName(lastLoser);
            if (null != lastNetCon) {
                this.connections.remove(lastNetCon);
                this.connections.add(lastNetCon);
                this.printToAll("tra: 3 :Player: " + lastNetCon.name() + " has been moved to the bottom of the player list");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void debug(Object o) {
        System.out.println("NetBoss: server=" + this.server + ": " + o);
        System.out.flush();
    }

    public void log(String text) {
        if (this.pingRankings != null) {
            this.pingRankings.log(text);
        }
        this.debug(text);
    }

    List getGuestNameList() {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection n = (NetConnection)this.connections.get(i);
            if (this.playingConnections.contains(n)) continue;
            result.add(n.name());
        }
        return result;
    }

    public boolean isGuest(NetConnection n) {
        return !this.playingConnections.contains(n);
    }

    public void updateTracker() {
        if (this.luxTracker != null) {
            this.luxTracker.update();
        }
    }

    public JButton getDefaultButton() {
        return ((GameControllerGUI)this.control).boardWindow.getRootPane().getDefaultButton();
    }

    public JMenuBar getJMenuBarForChatArea(JFrame window) {
        if (this.control == null) {
            return LuxController.getInstance().makeCommonMenuBar(window);
        }
        return ((GameControllerGUI)this.control).makeJMenuBar(null);
    }

    public void chatAreaWindowClosing(WindowEvent e) {
        if (this.control != null) {
            ((GameControllerGUI)this.control).windowClosing(e);
        } else {
            this.kill();
        }
    }

    public String getCompletionFor(String commandStart) {
        if (this.control.cardsMode()) {
            this.control.clickCards();
        }
        if ("".equals(commandStart)) {
            return "";
        }
        if (commandStart.startsWith("`")) {
            return "`" + this.getCompletionFor(commandStart.substring(1));
        }
        int spacePosition = commandStart.indexOf(" ");
        String nameSegment = commandStart.substring(spacePosition + 1);
        String nameSegmentLower = nameSegment.toLowerCase();
        ArrayList<String> possibleNameCompletions = new ArrayList<String>();
        if (commandStart.startsWith("/map ")) {
            Vector mapList = PluginManager.getInstance().getMapList();
            for (int j = 0; j < mapList.size(); ++j) {
                String map = (String)mapList.get(j);
                if (!map.toLowerCase().startsWith(nameSegmentLower)) continue;
                possibleNameCompletions.add(map);
            }
        } else if (commandStart.startsWith("/set ")) {
            if ("abortbotgames".startsWith(nameSegmentLower)) {
                possibleNameCompletions.add("abortbotgames");
            }
            if ("bioicons".startsWith(nameSegmentLower)) {
                possibleNameCompletions.add("bioicons");
            }
            if ("biotheme".startsWith(nameSegmentLower)) {
                possibleNameCompletions.add("biotheme");
            }
            if ("blockConsoleOutput".startsWith(nameSegmentLower)) {
                possibleNameCompletions.add("blockConsoleOutput");
            }
            if ("makeScreenshotThumbnail".startsWith(nameSegmentLower)) {
                possibleNameCompletions.add("makeScreenshotThumbnail");
            }
            if ("showBetaMaps".startsWith(nameSegmentLower)) {
                possibleNameCompletions.add("showBetaMaps");
            }
            if ("tooltipDelay".startsWith(nameSegmentLower)) {
                possibleNameCompletions.add("tooltipDelay");
            }
        } else {
            int i;
            if (this.server) {
                for (i = 0; i < this.connections.size(); ++i) {
                    NetConnection n = (NetConnection)this.connections.get(i);
                    if (!n.name().toLowerCase().startsWith(nameSegmentLower)) continue;
                    possibleNameCompletions.add(n.name());
                }
            } else {
                if (this.playerList == null) {
                    this.println("\u2731 Clients can only use name-completion when connected to a 5.1.3 or greater host \u2731");
                    return commandStart;
                }
                for (i = 0; i < this.playerList.size(); ++i) {
                    if (!((String)this.playerList.get(i)).toLowerCase().startsWith(nameSegmentLower)) continue;
                    possibleNameCompletions.add((String)this.playerList.get(i));
                }
            }
            for (i = 0; i < this.control.ops.playerNames.length; ++i) {
                if (!this.control.ops.playerNames[i].toLowerCase().startsWith(nameSegmentLower) || possibleNameCompletions.contains(this.control.ops.playerNames[i])) continue;
                possibleNameCompletions.add(this.control.ops.playerNames[i]);
            }
            for (i = 0; i < this.control.ops.playerTypes.length; ++i) {
                if (!this.control.ops.playerTypes[i].toLowerCase().startsWith(nameSegmentLower) || possibleNameCompletions.contains(this.control.ops.playerTypes[i])) continue;
                possibleNameCompletions.add(this.control.ops.playerTypes[i]);
            }
            if (nameSegmentLower.startsWith("/")) {
                if ("/boot".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/boot");
                }
                if ("/ban".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/ban");
                }
                if ("/cards".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/cards");
                }
                if ("/clearban".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/clearban");
                }
                if ("/colsize".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/colsize");
                }
                if ("/debug".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/debug");
                }
                if ("/desc".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/desc");
                }
                if ("/fullscreen".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/fullscreen");
                }
                if ("/guest".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/guest");
                }
                if ("/help".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/help");
                }
                if ("/players".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/players");
                }
                if ("/map ".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/map ");
                }
                if ("/me".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/me");
                }
                if ("/love".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/love");
                }
                if ("/sing".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/sing");
                }
                if ("/mute".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/mute");
                }
                if ("/start".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/start");
                }
                if ("/users".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/users");
                }
                if ("/setcards".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/setcards");
                }
                if ("/setconts".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/setconts");
                }
                if ("/settime".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/settime");
                }
                if ("/setrank".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/setrank");
                }
                if ("/versus".startsWith(nameSegmentLower)) {
                    possibleNameCompletions.add("/versus");
                }
            }
        }
        if (possibleNameCompletions.size() == 0) {
            int lastSpacePosition = commandStart.lastIndexOf(" ");
            if (lastSpacePosition == spacePosition) {
                this.println(gameNoticeStart + Translator.getString("Nocompletions") + " " + nameSegment + gameNoticeEnd);
                return commandStart;
            }
            nameSegment = commandStart.substring(lastSpacePosition + 1);
            return commandStart.substring(0, lastSpacePosition + 1) + this.getCompletionFor(nameSegment);
        }
        if (possibleNameCompletions.size() == 1) {
            return commandStart.substring(0, spacePosition + 1) + (String)possibleNameCompletions.get(0);
        }
        StringBuffer printout = new StringBuffer(gameNoticeStart + Translator.getString("Possiblecompletions") + " ");
        for (int i = 0; i < possibleNameCompletions.size(); ++i) {
            printout.append(possibleNameCompletions.get(i));
            if (i + 1 == possibleNameCompletions.size()) continue;
            printout.append(", ");
        }
        printout.append(gameNoticeEnd);
        this.println(printout.toString());
        return commandStart.substring(0, spacePosition + 1) + StringTool.getCommonStart(possibleNameCompletions);
    }

    public void takePlayerList(List playerListNew) {
        this.playerList = playerListNew;
    }

    public void addPlayerToList(String playerName) {
        if (this.playerList != null && !this.playerList.contains(playerName)) {
            this.playerList.add(playerName);
        }
    }

    private boolean isClientControlling(NetConnection sender) {
        int humanCount = 0;
        for (int i = 0; i < this.control.ops.playerNames.length; ++i) {
            if (!"Human".equals(this.control.ops.playerTypes[i])) continue;
            ++humanCount;
        }
        return sender != null && sender == this.getFirstNonGuestOnlyConnection() && (PrefsCache.headless || this.guestOnly && !this.control.world.humanPlayerExists(this.userName));
    }

    private NetConnection getFirstNonGuestOnlyConnection() {
        for (int i = 0; i < this.connections.size(); ++i) {
            NetConnection nc = (NetConnection)this.connections.get(i);
            if (nc.guestOnly()) continue;
            return nc;
        }
        return null;
    }

    public synchronized void takeClientCommand(String clientCommand, NetConnection sender) {
        if ("desc".equals(clientCommand.toLowerCase().trim()) || "d".equals(clientCommand.toLowerCase().trim())) {
            this.clientExecutingCommand = sender;
            this.dealWithCommand("/" + clientCommand, true);
            this.clientExecutingCommand = null;
            return;
        }
        if (!this.isClientControlling(sender) && !this.isFullControlUser(sender)) {
            SS.debug("catch 1 disallowed: " + sender + " " + clientCommand);
            sender.encodeln("tra: 1 OnlyServerStart");
            return;
        }
        if (!(clientCommand.toLowerCase().trim().startsWith("boot ") || clientCommand.toLowerCase().trim().startsWith("start") || this.isFullControlUser(sender))) {
            SS.debug("catch 2 disallowed: " + sender + " " + clientCommand);
            sender.encodeln("tra: 1 OnlyServerStart");
            return;
        }
        if (clientCommand.toLowerCase().trim().startsWith("start")) {
            boolean allowGuestRestart = false;
            int numberOfPlayingClients = this.getNumberOfHumans() - this.getNumberOfGuestOnly();
            if (this.pingRankings != null && this.pingRankings.isInvalid()) {
                allowGuestRestart = true;
            }
            if (this.control.world.getNumberOfHumanPlayers() < 2) {
                allowGuestRestart = true;
            }
            if (this.control.world.gameRound < 4 && numberOfPlayingClients > this.control.ops.numberOfHumans()) {
                allowGuestRestart = true;
            }
            if (this.control.world.gameRound < 6 && numberOfPlayingClients == 6 && numberOfPlayingClients > this.control.ops.numberOfHumans()) {
                allowGuestRestart = true;
            }
            if (this.control.world.gamePhase > 3) {
                allowGuestRestart = true;
            }
            if (this.isFullControlUser(sender)) {
                allowGuestRestart = true;
            }
            if (!allowGuestRestart) {
                SS.debug("catch 3 disallowed: " + sender + " " + clientCommand);
                sender.encodeln("tra: 3 You cannot restart the game at this time (round " + this.control.world.gameRound + ")");
                return;
            }
        }
        this.clientExecutingCommand = sender;
        System.out.println(sender + " sending client command " + clientCommand);
        this.dealWithCommand("/" + clientCommand);
        this.clientExecutingCommand = null;
    }

    private void printToControllingUser(String text) {
        if (this.clientExecutingCommand != null) {
            this.clientExecutingCommand.encodeln(text);
        } else {
            this.println(gameNoticeStart + Translator.translateTokens(text.substring(7)) + gameNoticeEnd);
        }
    }

    public void printToAll(String text) {
        this.println(gameNoticeStart + Translator.translateTokens(text.substring(7)) + gameNoticeEnd);
        this.sendToAll(text);
    }

    private void set2v2v2colors() {
        SS.debug("NetBoss.set2v2v2colors()");
        if (PrefsCache.headless) {
            Lux.memoryColor = "2v2v2";
            return;
        }
        LuxController.getInstance().playerColors[0].setColor(new Color(0, 0, 0));
        LuxController.getInstance().playerColors[1].setColor(new Color(0, 0, 204));
        LuxController.getInstance().playerColors[2].setColor(new Color(0, 153, 0));
        LuxController.getInstance().playerColors[3].setColor(new Color(128, 128, 128));
        LuxController.getInstance().playerColors[4].setColor(new Color(102, 153, 255));
        LuxController.getInstance().playerColors[5].setColor(new Color(153, 255, 153));
    }

    private void set3v3colors() {
        SS.debug("NetBoss.set3v3colors()");
        if (PrefsCache.headless) {
            Lux.memoryColor = "3v3";
            return;
        }
        LuxController.getInstance().playerColors[0].setColor(new Color(0, 0, 0));
        LuxController.getInstance().playerColors[1].setColor(new Color(0, 0, 204));
        LuxController.getInstance().playerColors[2].setColor(new Color(128, 128, 128));
        LuxController.getInstance().playerColors[3].setColor(new Color(102, 153, 255));
        LuxController.getInstance().playerColors[4].setColor(new Color(250, 250, 250));
        LuxController.getInstance().playerColors[5].setColor(new Color(102, 255, 255));
    }

    public Object getControl() {
        if (this.control instanceof GameControllerGUI) {
            return (GameControllerGUI)this.control;
        }
        return null;
    }

    private boolean isFullControlUser(NetConnection sender) {
        if (sender.isModerator()) {
            if (PrefsCache.headless) {
                return true;
            }
            if (this.guestOnly) {
                return true;
            }
        }
        return false;
    }

    public void setPlacingKey(int placingKey) {
        ((GameControllerGUI)this.control).setPlacingKey(placingKey);
    }

    public boolean usedPlacedDividerKey() {
        return ((GameControllerGUI)this.control).luxView.usedPlacedDividerKey();
    }

    public boolean usedZeroAttack() {
        return ((GameControllerGUI)this.control).world.usedZeroAttack();
    }

    private String controllingHostName() {
        if (this.clientExecutingCommand != null) {
            return this.clientExecutingCommand.name();
        }
        return this.name();
    }

    private void shuffleConnections() {
        ArrayTool.randomize(this.connections);
        if (this.connections.size() > 5) {
            for (int i = 0; i < this.connections.size(); ++i) {
                NetConnection n = (NetConnection)this.connections.get(i);
                if (!"".equals(n.userKey())) continue;
                this.connections.remove(n);
                this.connections.add(n);
                return;
            }
        }
    }

    private void alertSillysoftWithChat(String message) {
        String logReport = message;
        if (this.chatArea != null) {
            logReport = logReport + "\n" + this.chatArea.tail(3200);
        }
        SSApp.alertSillysoft(logReport);
    }

    public void escapeKeyPressed() {
    }

    public void cacheModKeys(KeyEvent e) {
        if (this.control instanceof GameControllerGUI && ((GameControllerGUI)this.control).fullscreen && (e.isAltDown() || e.isControlDown())) {
            ((GameControllerGUI)this.control).luxView.keyPressed(e);
        }
    }

    public void gameLimitHit() {
        NetConnection n;
        int i;
        for (i = 0; i < this.control.ops.playerNames.length; ++i) {
            if (this.control.stats.getOwned(i) <= 0 || !"Human".equals(this.control.ops.playerTypes[i]) || (n = this.connectionFromNameIgnoreCase(this.control.ops.playerNames[i])) == null) continue;
            this.connections.remove(n);
            this.connections.add(n);
            this.printToAll("tra: 3 :Player: " + n.name() + " :hasbeenmovedtothebottom:");
        }
        for (i = 0; i < this.control.ops.playerNames.length; ++i) {
            if (this.control.stats.getOwned(i) != 0 || !"Human".equals(this.control.ops.playerTypes[i]) || (n = this.connectionFromNameIgnoreCase(this.control.ops.playerNames[i])) == null) continue;
            this.connections.remove(n);
            this.connections.add(n);
            this.printToAll("tra: 3 :Player: " + n.name() + " :hasbeenmovedtothebottom:");
        }
        this.promoteHeadlessOwner();
        this.startGame();
    }

    public String getCardsInfoTranslateString() {
        StringBuffer sb = new StringBuffer("");
        if (this.control.ops.useCards) {
            sb.append(":CardsGoUp:");
            sb.append(" ");
            sb.append(CardSequence.sequences[this.control.ops.cardSequenceCode]);
            sb.append(" ");
            if (!this.control.ops.cardTransfer || !this.control.ops.immediateCardCash) {
                sb.append(":transferCards:");
                sb.append(" ");
                if (this.control.ops.cardTransfer) {
                    sb.append(":ON:, :immediateCash: ");
                    if (this.control.ops.immediateCardCash) {
                        sb.append(":ON:");
                    } else {
                        sb.append(":OFF:");
                    }
                } else {
                    sb.append(":OFF:");
                }
                sb.append(",");
            }
            sb.append(" ");
            sb.append(":currentCardValueIs:");
            sb.append(" ");
            sb.append(this.control.getNextCardSetValue());
            sb.append(".");
        } else {
            sb.append(":CardsOFF:");
            sb.append(".");
        }
        if (this.control.ops.continentSequence.increases()) {
            sb.append(" ");
            sb.append(":Continentsgoup:");
            sb.append(" ");
            sb.append(this.control.ops.continentSequence.longString());
            sb.append(".");
        }
        sb.append(" ");
        sb.append(":Gameisinround:");
        sb.append(" ");
        sb.append(this.control.world.gameRound);
        sb.append(", ");
        sb.append(":hasbeengoingonfor:");
        sb.append(" ");
        sb.append(StringTool.timeFormat(System.currentTimeMillis() - this.control.ops.gameStarted, 1));
        sb.append(".");
        return sb.toString().trim();
    }
}

