/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.net;

import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.Lux;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.lux.net.NetConnection;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.widgets.SSApp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class LuxTracker
implements Runnable {
    static final String trackerAddress = "http://sillysoft.net/lux/";
    private static Thread regThread;
    private static boolean initialRun;
    private static boolean registering;
    private NetBoss boss;
    private static Hashtable teamDictionary;
    private static int teamCounter;

    public LuxTracker(NetBoss boss) {
        this.boss = boss;
        initialRun = true;
        new Thread((Runnable)this, "LuxTracker").start();
    }

    public void setNumberOfPlayers(int newNum) {
        this.update();
    }

    public void update() {
        if (regThread != null) {
            regThread.interrupt();
        }
    }

    public void run() {
        regThread = Thread.currentThread();
        registering = true;
        while (registering) {
            try {
                if (initialRun) {
                    this.boss.println("\u2731 Registering with the LuxTracker... \u2731");
                }
                String requestPage = "http://sillysoft.net/lux/host503.php";
                StringBuffer request = new StringBuffer("name=");
                request.append(URLEncoder.encode(this.boss.name(), "UTF-8"));
                request.append("&");
                request.append(LuxTracker.cookie());
                if (this.boss.control == null) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Throwable t) {
                        SS.debug(t);
                    }
                }
                try {
                    if (this.boss.control != null) {
                        while (!this.boss.control.doneCreation) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Throwable e) {
                                System.out.println("LuxTracker awakened while waiting for LuxWorld to finish creation");
                            }
                        }
                        if ("custom".equals(this.boss.control.ops.boardSize)) {
                            request.append("&boardSize=");
                            String map = this.boss.control.ops.boardNameBio();
                            map = map.substring(map.lastIndexOf(47) + 1);
                            request.append(URLEncoder.encode(map, "UTF-8"));
                        } else {
                            request.append("&boardSize=");
                            request.append(this.boss.control.ops.boardSize);
                        }
                        request.append("&initialCountries=");
                        request.append(this.boss.control.ops.initialCountries);
                        request.append("&initialArmies=");
                        request.append(this.boss.control.ops.initialArmies);
                        if (this.boss.control.ops.useTurnTimer) {
                            request.append("&turnTimerLength=");
                            if (this.boss.control.ops.turnTimerLength < 60.0f) {
                                request.append((int)this.boss.control.ops.turnTimerLength);
                                request.append(URLEncoder.encode(" s"));
                            } else if (this.boss.control.ops.turnTimerLength == 60.0f) {
                                request.append(URLEncoder.encode("1 min"));
                            } else if (this.boss.control.ops.turnTimerLength == 120.0f) {
                                request.append(URLEncoder.encode("2 min"));
                            } else if (this.boss.control.ops.turnTimerLength == 180.0f) {
                                request.append(URLEncoder.encode("3 min"));
                            } else {
                                String timeString = "" + this.boss.control.ops.turnTimerLength / 60.0f;
                                if (timeString.length() > 3) {
                                    timeString = timeString.substring(0, 3);
                                }
                                request.append(timeString);
                                request.append(URLEncoder.encode(" min"));
                            }
                        } else {
                            request.append("&turnTimerLength=--");
                        }
                        request.append("&gameLimit=");
                        request.append(this.boss.control.ops.gameLimitMinutes);
                        if (this.boss.control.ops.useCards) {
                            request.append("&cardSequence=");
                            request.append(URLEncoder.encode(CardSequence.sequences[this.boss.control.ops.cardSequenceCode]));
                        } else {
                            request.append("&cardSequence=off");
                        }
                        request.append("&continentSequence=");
                        request.append(URLEncoder.encode(this.boss.control.ops.continentSequence.shortString()));
                        request.append("&shuffleState=");
                        request.append(Lux.shuffleMode != -1 ? Lux.shuffleMode : Prefs.getInt("shuffleState", 4));
                        int playersLeft = 0;
                        int computerPlayers = 0;
                        for (int i = 0; i < this.boss.control.ops.playerTypes.length; ++i) {
                            if ("Human".equals(this.boss.control.ops.playerTypes[i])) {
                                request.append("&");
                                request.append(URLEncoder.encode("playerNames[]"));
                                request.append("=");
                                request.append(URLEncoder.encode(this.boss.control.ops.playerNames[i], "UTF-8"));
                            } else {
                                ++computerPlayers;
                            }
                            if (this.boss.control.stats == null || this.boss.control.stats.getOwned(i) == 0) continue;
                            ++playersLeft;
                        }
                        request.append("&robotCount=");
                        request.append(computerPlayers);
                        request.append("&playersLeft=");
                        request.append(playersLeft);
                        request.append(URLEncoder.encode("/"));
                        request.append(this.boss.control.ops.playerNames.length);
                        request.append("&gameStarted=");
                        request.append(this.boss.control.ops.gameStarted);
                        String start = this.boss.control.ops.useScenario ? "scenario" : (this.boss.control.ops.initialCountries ? (this.boss.control.ops.initialArmies == 0 ? "random" : (this.boss.control.ops.initialArmies == 1 ? URLEncoder.encode("random/placed") : (this.boss.control.ops.initialArmies == 2 ? URLEncoder.encode("random/even") : URLEncoder.encode("random/" + this.boss.control.ops.initialArmies)))) : (this.boss.control.ops.initialArmies == 0 ? URLEncoder.encode("selected/random") : (this.boss.control.ops.initialArmies == 1 ? URLEncoder.encode("selected/placed") : (this.boss.control.ops.initialArmies == 2 ? URLEncoder.encode("selected/even") : URLEncoder.encode("selected/" + this.boss.control.ops.initialArmies)))));
                        request.append("&start=");
                        request.append(start);
                        request.append("&isRanked=");
                        request.append(this.boss.control.ops.isRanked ? "Yes" : "No");
                        request.append("&port=");
                        request.append(PrefsCache.hostPort);
                        request.append("&numberOfPlayers=");
                        request.append(this.boss.getNumberOfHumans());
                        request.append("&numberOfGuestOnly=");
                        request.append(this.boss.getNumberOfGuestOnly());
                        List guests = this.boss.getGuestNameList();
                        for (int i = 0; i < guests.size(); ++i) {
                            request.append("&");
                            request.append(URLEncoder.encode("guestNames[]"));
                            request.append("=");
                            request.append(URLEncoder.encode((String)guests.get(i), "UTF-8"));
                        }
                        request.append("&firstTurnContBonus=");
                        request.append(this.boss.control.ops.firstTurnContBonus);
                        request.append("&description=");
                        request.append(URLEncoder.encode(this.boss.description == null ? "" : this.boss.description, "UTF-8"));
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (registering) {
                    String contents = URLTool.postToURL(requestPage, request.toString(), "UTF-8");
                    String input = XMLTool.extract("ip", contents);
                    if (input != null) {
                        if (initialRun) {
                            this.boss.println("\u2731 " + Translator.getString("RegisteredsuccessfullywithLuxTrackerfromaddress") + " " + input + " \u2731");
                        }
                        this.boss.setNetworkKey(XMLTool.extract("networkKey", contents));
                    } else {
                        input = XMLTool.extract("error", contents);
                        if (input == null) {
                            input = "Unknown error";
                        }
                        if (initialRun) {
                            this.boss.println("\u2731 ERROR connecting to the LuxTracker: " + input + " \u2731");
                            SS.beep();
                        }
                        SS.debug("Lux -> Error connecting to the LuxTracker: " + input);
                    }
                }
            }
            catch (Throwable e) {
                this.boss.println("\u2731 Error connecting to the LuxTracker: Either you are not connected to the internet or the LuxTracker is currently offline \u2731");
                SS.debug("Lux -> Couldn't connect to the LuxTracker: " + e);
                this.boss.log("Couldn't connect to the LuxTracker: " + e);
                e.printStackTrace();
            }
            initialRun = false;
            try {
                Thread.sleep(60000L);
            }
            catch (Throwable throwable) {}
        }
        registering = false;
        regThread = null;
        this.boss = null;
    }

    public static void stop() {
        registering = false;
        if (regThread != null) {
            try {
                SS.debug("Lux -> Stopping the LuxTracker");
                URLTool.getURL("http://sillysoft.net/lux/host_remove.php?port=" + PrefsCache.hostPort);
            }
            catch (Exception e) {
                SS.debug("Lux -> Error stopping the LuxTracker: " + e);
            }
            if (regThread != null) {
                regThread.interrupt();
            }
        }
    }

    public static String cookie() {
        int clientID = Prefs.getInt("clientID", 0);
        if (clientID == 0) {
            clientID = new Random().nextInt(1000000) + 1;
            Prefs.putInt("clientID", clientID);
        }
        StringBuffer addressBuffer = new StringBuffer("version=");
        addressBuffer.append(SSApp.version());
        addressBuffer.append("&");
        addressBuffer.append("userKey=");
        try {
            addressBuffer.append(URLEncoder.encode(Prefs.getUserKey(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        addressBuffer.append("&id=");
        addressBuffer.append(clientID);
        return addressBuffer.toString();
    }

    public static String getHostList() throws MalformedURLException, IOException {
        StringBuffer addressBuffer = new StringBuffer(trackerAddress);
        addressBuffer.append("list503.php?");
        addressBuffer.append(LuxTracker.cookie());
        return URLTool.getURL(addressBuffer.toString(), "UTF-8");
    }

    public static String isNameKeyValid(String name, String key, String IP, Vector activeAliasReturn, NetConnection n) throws MalformedURLException, IOException {
        String URL2 = "http://sillysoft.net/lux/nick_check565.php?name=" + URLEncoder.encode(name, "UTF-8") + "&key=" + URLEncoder.encode(key, "UTF-8") + (IP != null ? "&ip=" + URLEncoder.encode(IP) : "") + "" + "" + "&hl=" + Translator.getLocale() + "&version=" + 6.23f;
        String nickCheck = URLTool.getURL(URL2);
        String aliasCheck = XMLTool.extract("alias", nickCheck);
        if (activeAliasReturn != null && aliasCheck != null && !"".equals(aliasCheck)) {
            activeAliasReturn.add(aliasCheck);
        }
        String modCheck = XMLTool.extract("mod", nickCheck);
        if (n != null && modCheck != null && "true".equals(modCheck)) {
            n.setModerator(true);
        }
        return XMLTool.extract("result", nickCheck);
    }

    public static String getTeam(String forName) {
        if (teamDictionary == null) {
            return "";
        }
        Object result = teamDictionary.get(forName);
        if (result == null) {
            return "";
        }
        return "[" + result.toString() + "] ";
    }

    public static int refreshRaws(List connections, String bossname) {
        try {
            StringBuffer request = new StringBuffer(LuxTracker.cookie());
            if (!PrefsCache.headless) {
                request.append("&");
                request.append(URLEncoder.encode("playerNames[]"));
                request.append("=");
                request.append(URLEncoder.encode(bossname, "UTF-8"));
            }
            for (int i = 0; i < connections.size(); ++i) {
                NetConnection n = (NetConnection)connections.get(i);
                request.append("&");
                request.append(URLEncoder.encode("playerNames[]"));
                request.append("=");
                request.append(URLEncoder.encode(n.name(), "UTF-8"));
            }
            String requestPage = "http://sillysoft.net/lux/playerDetails.php";
            String contents = URLTool.postToURL(requestPage, request.toString(), "UTF-8");
            for (int i = 0; i < connections.size(); ++i) {
                NetConnection n = (NetConnection)connections.get(i);
                n.setRaw(LuxTracker.fetchRawForNameFromContents(n.name(), contents));
            }
            return LuxTracker.fetchRawForNameFromContents(bossname, contents);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static int fetchRawForNameFromContents(String name, String contents) {
        try {
            int startPos = contents.indexOf("\"" + name + "\"");
            if (startPos == -1) {
                return 0;
            }
            int endPos = contents.indexOf("\"", startPos += name.length() + 8);
            return Integer.parseInt(contents.substring(startPos, endPos));
        }
        catch (Exception e) {
            SS.debug("refreshRaws -> " + name + " inside " + contents);
            e.printStackTrace();
            return 0;
        }
    }

    static {
        teamCounter = 0;
    }
}

