/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.LuxView;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class WidthBar
extends JComponent {
    public static final int BOTTOM_BAR_HEIGHT = 40;
    private static int timerWidth = 40;
    private static Image shine;
    private boolean colorsAreSet;
    private int usableTurnBoxWidth;
    private int currentPlayer;
    private Color[] colors;
    private float[] widths;
    private GameControllerGUI control;

    public WidthBar(int width, int height, GameControllerGUI control) {
        this.setSize(width, height);
        this.setBackground(Color.black);
        this.control = control;
        if ((int)this.bounds().getHeight() != 40) {
            SS.debug("WARNING: widthBar.getHeight() != BOTTOM_BAR_HEIGHT");
        }
        this.colorsAreSet = false;
        this.currentPlayer = 0;
        this.usableTurnBoxWidth = 300;
        if (this.showTimer()) {
            this.usableTurnBoxWidth -= timerWidth;
        }
        if (shine == null) {
            shine = GraphicsTool.getImageFromJAR("shine.png");
        }
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
        this.colorsAreSet = true;
        this.widths = new float[colors.length];
        this.setToolTipText("tooltip");
        ToolTipManager.sharedInstance().setInitialDelay(Prefs.getInt("tooltipDelay", 200));
    }

    public void gotoPlayer(int player) {
        this.currentPlayer = player;
        this.repaintColors();
    }

    public void resetPlayer() {
        this.currentPlayer = 0;
        this.repaintColors();
    }

    public void clearView() {
        this.colorsAreSet = false;
        this.currentPlayer = 0;
        this.repaint();
    }

    void kill() {
        this.control = null;
    }

    public void paintComponent(Graphics badg) {
        Graphics2D g = (Graphics2D)badg;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        g.fill(g.getClipBounds());
        if (this.colorsAreSet) {
            int startingX;
            this.calculateWidths();
            int x = startingX = this.showTimer() ? 43 : 3;
            for (int i = 0; i < this.widths.length; ++i) {
                int drawPlayerBox = (i + this.currentPlayer) % this.widths.length;
                if (!((double)this.widths[drawPlayerBox] > 0.001)) continue;
                g.setColor(this.colors[drawPlayerBox]);
                g.fillRect(x, 3, (int)this.widths[drawPlayerBox], 34);
                x += (int)this.widths[drawPlayerBox];
            }
            if (x != startingX && x < this.usableTurnBoxWidth + startingX) {
                g.fillRect(x, 3, this.usableTurnBoxWidth + startingX - x, 34);
            }
            g.drawImage(shine, startingX, 1, this.usableTurnBoxWidth, 38, null);
            if (this.showTimer()) {
                int s = this.control.getTurnSecondsLeft();
                if (s < 0) {
                    s = 0;
                }
                if (s != 0) {
                    if (SS.isMacintosh) {
                        g.setFont(LuxView.arial24);
                    } else {
                        g.setFont(LuxView.sansSerif24);
                    }
                    g.setColor(Color.RED);
                    int xPos = 3;
                    if (s < 10) {
                        xPos = 10;
                    }
                    if (s > 99) {
                        g.drawString(s + "", xPos - 2, 28);
                    } else {
                        g.drawString(s + "s", xPos, 28);
                    }
                }
            }
        }
    }

    private void calculateWidths() {
        int i;
        for (int i2 = 0; i2 < this.widths.length; ++i2) {
            this.widths[i2] = 0.0f;
        }
        int divideBy = 0;
        for (i = 0; i < this.widths.length; ++i) {
            this.widths[i] = this.control.stats.getArmies(i);
            divideBy = (int)((float)divideBy + this.widths[i]);
        }
        i = 0;
        while (i < this.widths.length) {
            int n = i++;
            this.widths[n] = this.widths[n] * ((float)this.usableTurnBoxWidth / (float)Math.max(1, divideBy));
        }
    }

    public void setWidth(int width) {
        this.setPreferredSize(new Dimension(width, 40));
        super.setSize(width, 40);
        this.usableTurnBoxWidth = width;
        if (this.showTimer()) {
            this.usableTurnBoxWidth -= timerWidth;
        }
        this.repaint();
    }

    public void setSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, 40));
        super.setSize(width, 40);
    }

    public Dimension getMaximumSize() {
        Dimension parent = super.getMaximumSize();
        return new Dimension((int)parent.getWidth(), 40);
    }

    public void repaintColors() {
        this.repaint(0L, 0, 0, this.usableTurnBoxWidth + 43, 40);
    }

    public boolean isOpaque() {
        return true;
    }

    private boolean showTimer() {
        return this.control != null && this.control.world != null && this.control.ops.useTurnTimer && !this.control.gameIsOver;
    }

    private boolean gameUsesTimer() {
        return this.control != null && this.control.ops != null && this.control.ops.useTurnTimer;
    }

    public String getToolTipText(MouseEvent event) {
        int widthSoFar;
        int x = event.getPoint().x;
        int n = widthSoFar = this.gameUsesTimer() ? timerWidth + 3 : 3;
        if (x < widthSoFar) {
            return this.gameUsesTimer() ? "Turn Time" : "Player Strength Bar";
        }
        for (int i = 0; i < this.widths.length; ++i) {
            int index = (i + this.currentPlayer) % this.widths.length;
            if (x >= (widthSoFar = (int)((float)widthSoFar + this.widths[index]))) continue;
            String agent = this.control.world.getBoard().getAgentName(index);
            agent = "Human".equals(agent) ? this.control.world.getBoard().getPlayerName(index) : agent + " " + Translator.getString("AI");
            return agent;
        }
        return "Player Strength Bar";
    }
}

