/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.UpdateAvailableWindow;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSOptionPaneBuyHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Date;

public class UpdateController
implements Runnable,
SSOptionPaneBuyHandler {
    private static String appServer;
    private static String appNameShort;
    private static float appVersion;
    private static SSApplicationGUI appGUI;
    private boolean userRequest;

    public static void initUpdateController(String appServer_set, float appVersion_set, SSApplicationGUI appGUI_set) {
        appServer = appServer_set;
        appVersion = appVersion_set;
        appGUI = appGUI_set;
        appNameShort = appGUI.shortName();
    }

    public static void checkForUpdateIfNeeded() {
        if (Prefs.getBoolean("updateCheck", true) && new Date().getTime() - Prefs.getLong("updateCheckLastDate") > 86400000L) {
            UpdateController.checkForUpdate(null);
        }
    }

    public static void checkForUpdate(Object sender) {
        boolean userRequest = false;
        if (sender != null) {
            userRequest = true;
        }
        new Thread((Runnable)new UpdateController(userRequest), "UpdateController").start();
    }

    public UpdateController(boolean userRequest) {
        this.userRequest = userRequest;
    }

    private String localeParam() {
        if (Translator.getLocale() != null && Translator.getLocale().getLanguage() != "en") {
            return "&hl=" + Translator.getLocale().getLanguage();
        }
        return "";
    }

    public void run() {
        try {
            float version;
            String contents;
            float currentVersion;
            Thread.currentThread().setPriority(Thread.currentThread().getPriority() - 1);
            if (!this.userRequest) {
                Thread.sleep(2000L);
            }
            if ((currentVersion = Float.parseFloat(XMLTool.extract("number", contents = URLTool.getURL(appServer + appNameShort + "/version/?version=" + appVersion + "&user=" + this.userRequest + "&demo=" + appGUI.isDemo() + this.localeParam())))) > (version = appVersion)) {
                String changes = XMLTool.extract("changes", contents).replace('~', '\n');
                this.updateExists(currentVersion, changes);
            } else if (this.userRequest) {
                SSOptionPane.showMessageDialog(null, Translator.getString("NoUpdatesWords"), Translator.getString("NoUpdates"), 1);
            } else {
                System.out.println("UpdateController -> automatic update check found no updates available");
            }
            Prefs.putLong("updateCheckLastDate", new Date().getTime());
        }
        catch (Exception e) {
            if (this.userRequest) {
                SSOptionPane.showMessageDialog(null, Translator.getString("ErrorUpdating"), Translator.getString("Error"), 0);
            }
            System.out.println("UpdateController -> error checking for updates:");
            e.printStackTrace();
        }
    }

    public void updateExists(float currentVersion, String changes) {
        UpdateAvailableWindow.show(this, currentVersion, changes);
    }

    public static void gotoAppDownload() {
        UpdateAvailableWindow.hide();
        BrowserLauncher.openURL(appServer + appNameShort + "/update/");
    }

    public void gotoBuyHandler(String statsKey) {
        UpdateController.gotoBuy(statsKey);
    }

    public static void gotoBuy(String statsKey) {
        String affURL = null;
        if (affURL == null) {
            BrowserLauncher.openURL(appServer + appNameShort + "/buy/?source=" + statsKey + "&os=" + (SS.isMacintosh ? "mac" : (SS.isWindows ? "win" : "other")) + "&lc=" + Prefs.getInt("launchCount", 0) + "&g=" + appGUI.getSharewareCount() + "&version=" + appVersion);
        } else {
            BrowserLauncher.openURL(affURL);
        }
    }

    public static void gotoForums() {
        BrowserLauncher.openURL(appServer + "forums/");
    }

    public static void gotoWiki() {
        BrowserLauncher.openURL(appServer + "wiki/");
    }

    public static void gotoRankings() {
        BrowserLauncher.openURL(appServer + appNameShort + "/rankings/");
    }

    public static void gotoBugReport() {
        BrowserLauncher.openURL(appServer + appNameShort + "/bugreport/");
    }

    public static void gotoFeatureRequest() {
        BrowserLauncher.openURL(appServer + appNameShort + "/featurerequest/");
    }

    public static void gotoAppHomepage() {
        BrowserLauncher.openURL(appServer + appNameShort + "/");
    }

    public static void gotoSillysoftHomepage() {
        BrowserLauncher.openURL(appServer);
    }

    public static void gotoAI() {
        BrowserLauncher.openURL(appServer + "sdk/");
    }

    public static void gotoAppGuide() {
        BrowserLauncher.openURL(appServer + appNameShort + "/guide/");
    }

    public static void gotoThemes() {
        BrowserLauncher.openURL(appServer + "themes/");
    }

    public static void notesShortcuts() {
        BrowserLauncher.openURL("file://" + DesktopTool.bundleResourcesLocation() + Translator.getString("shortcuts.html"));
    }

    public static void notesChangelog() {
        BrowserLauncher.openURL("file://" + DesktopTool.bundleResourcesLocation() + "changelog.html");
    }

    public static void notesPrefs() {
        BrowserLauncher.openURL("file://" + DesktopTool.bundleResourcesLocation() + Translator.getString("preferences.html"));
    }

    public static void notesRules() {
        BrowserLauncher.openURL("file://" + DesktopTool.bundleResourcesLocation() + Translator.getString("rules.html"));
    }

    public static void notesHosting() {
        BrowserLauncher.openURL("file://" + DesktopTool.bundleResourcesLocation() + Translator.getString("hosting.html"));
    }

    public static void sendEmail() {
        BrowserLauncher.openURL("mailto:" + appNameShort + "@sillysoft.net");
    }

    public static void openRadio(final String address) {
        Runnable radioRunnable = new Runnable(){

            public void run() {
                if (SS.isMacintosh) {
                    UpdateController.execCommand(new String[]{"/usr/bin/osascript", "-e", "tell application \"iTunes\" to open location \"" + address + "\""});
                } else if (SS.isWindows) {
                    String radioPref = Prefs.get("radioPreference", "WindowsMedia");
                    String application = radioPref.equals("iTunes") ? "iTunes" + File.separator + "iTunes.exe" : (radioPref.equals("WinAmp") ? "Winamp" + File.separator + "winamp.exe" : (radioPref.equals("WindowsMedia") ? "Windows Media Player" + File.separator + "wmplayer.exe" : "Real" + File.separator + "RealPlayer" + File.separator + "realplay.exe"));
                    String programFiles = ":\\Program Files\\";
                    String drive = "C";
                    if (new File("C" + programFiles + application).exists()) {
                        drive = "C";
                    } else if (new File("D" + programFiles + application).exists()) {
                        drive = "D";
                    } else if (new File("E" + programFiles + application).exists()) {
                        drive = "E";
                    } else if (new File("F" + programFiles + application).exists()) {
                        drive = "F";
                    } else if (new File("G" + programFiles + application).exists()) {
                        drive = "G";
                    } else if (new File("H" + programFiles + application).exists()) {
                        drive = "H";
                    } else {
                        SSOptionPane.showMessageDialog("Could not launch a radio application. Please select another player in the menu and try again.\n\nNot found:\n" + programFiles + application, Translator.getString("Error"));
                        return;
                    }
                    UpdateController.execCommand(new String[]{drive + programFiles + application, address});
                } else {
                    UpdateController.execCommand(new String[]{DesktopTool.supportFolderPath() + "linuxradio.sh", address});
                }
            }
        };
        new Thread(radioRunnable, "RadioLauncher").start();
    }

    public static void execCommand(String command) {
        try {
            Process pr = Runtime.getRuntime().exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while (in.readLine() != null) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void execCommand(String[] command) {
        try {
            Process pr = Runtime.getRuntime().exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while (in.readLine() != null) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getdown() {
        try {
            String result;
            String[] commands = new String[]{"java", "-version"};
            Process pr = Runtime.getRuntime().exec(commands);
            BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((result = in.readLine()) != null) {
                SS.debug(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

