/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.EnterCodeWindow;
import com.sillysoft.lux.gui.UpdateController;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SharewareOverWindow {
    private static SharewareOverWindow instance = null;
    private SSFrame theFrame;
    private SSButton noThanksButton = null;
    private SSButton enterCodeButton = null;
    private SSButton registerButton = null;
    ActionListener noThanksListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            SharewareOverWindow.this.theFrame.hide();
        }
    };
    ActionListener enterCodeListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            EnterCodeWindow.show(luxconBridge);
        }
    };
    ActionListener registerListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            UpdateController.gotoBuy("demoover");
            SharewareOverWindow.this.theFrame.hide();
            System.out.println("Lux -> Opening the register webpage");
        }
    };
    private static SSApplicationGUI luxconBridge;

    private SharewareOverWindow() {
        this.initGUI();
    }

    private void initGUI() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.noThanksButton = new SSButton(Translator.getString("NoThanks"));
        this.noThanksButton.addActionListener(this.noThanksListener);
        JPanel noThanksButtonPanel = new JPanel();
        noThanksButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        noThanksButtonPanel.add(this.noThanksButton);
        buttonPanel.add(noThanksButtonPanel);
        this.enterCodeButton = new SSButton(Translator.getString("EnterCodeShort"));
        this.enterCodeButton.addActionListener(this.enterCodeListener);
        JPanel enterCodeButtonPanel = new JPanel();
        enterCodeButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        enterCodeButtonPanel.add(this.enterCodeButton);
        buttonPanel.add(enterCodeButtonPanel);
        this.registerButton = new SSButton(Translator.getString("RegisterLuxNow"));
        this.registerButton.addActionListener(this.registerListener);
        JPanel registerButtonPanel = new JPanel();
        registerButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        registerButtonPanel.add(this.registerButton);
        buttonPanel.add(registerButtonPanel);
        contentPanel.add((Component)this.createEditorPane(), "North");
        contentPanel.add((Component)buttonPanel, "South");
        this.theFrame = new SSFrame(Translator.getString("Luxitorloseit"));
        this.theFrame.setLocationID("SharewareOver");
        this.theFrame.setContentPane(contentPanel);
        this.theFrame.setDefaultCloseOperation(1);
        this.theFrame.setResizable(false);
        if (SS.isMacintosh) {
            this.theFrame.setJMenuBar(luxconBridge.makeCommonMenuBar(this.theFrame));
        }
    }

    private JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setFocusable(false);
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        editorPane.setPreferredSize(new Dimension(415, SS.isMacintosh ? 455 : 485));
        URL helpURL = SharewareOverWindow.class.getResource("/" + Translator.getString("shareware_over.html"));
        if (helpURL != null) {
            try {
                editorPane.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
        } else {
            System.err.println("Couldn't find file: shareware_over.html");
        }
        return editorPane;
    }

    public void showFrame() {
        this.theFrame.pack();
        this.theFrame.show();
        this.theFrame.getRootPane().setDefaultButton(this.registerButton);
    }

    public static void show(SSApplicationGUI luxconBridge_set) {
        luxconBridge = luxconBridge_set;
        if (instance == null) {
            instance = new SharewareOverWindow();
        }
        instance.showFrame();
    }

    public static void hide() {
        if (instance != null) {
            instance.hideFrame();
        }
    }

    private void hideFrame() {
        this.theFrame.hide();
    }
}

