/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.TableSorter;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSRootPane;
import com.sillysoft.widgets.SSTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;

public class RankingController
extends AbstractTableModel
implements ActionListener {
    private SSFrame rankingsWindow;
    private SSTable rankingsTableView;
    private SSButton switchButton;
    private SSButton clearButton;
    String lastId;
    private int numberRows;
    private boolean byName = true;
    private Vector rows;
    private static RankingController singleton;
    String[] keys = new String[]{Translator.getString("Name"), Translator.getString("Played"), Translator.getString("Won"), Translator.getString("Lost"), Translator.getString("Percentage"), Translator.getString("Rounds"), Translator.getString("Place")};

    public static void show() {
        if (singleton == null) {
            singleton = new RankingController();
        }
        singleton.showRankings();
    }

    private RankingController() {
        this.rankingsWindow = new SSFrame(Translator.getString("TheLuxRecordBook"));
        this.rankingsWindow.setLocationID("recordBook");
        this.rankingsWindow.setJMenuBar(LuxController.getInstance().makeCommonMenuBar(this.rankingsWindow));
        TableSorter sorter = new TableSorter("RankingControllerSortOrder", this);
        this.rankingsTableView = new SSTable(sorter);
        this.rankingsTableView.setAlternatingRowColors();
        sorter.setTableHeader(this.rankingsTableView.getTableHeader());
        sorter.setSortingsFromString(Prefs.get("RankingControllerSortOrder", ""));
        JScrollPane scrollpane = new JScrollPane(this.rankingsTableView);
        this.rankingsTableView.setColumnWidth(0, 120);
        this.rankingsTableView.setColumnWidth(1, 60);
        this.rankingsTableView.setColumnWidth(2, 60);
        this.rankingsTableView.setColumnWidth(3, 60);
        this.rankingsTableView.setColumnWidth(4, 75);
        this.rankingsTableView.setColumnWidth(5, 60);
        this.rankingsTableView.setColumnWidth(6, 60);
        this.switchButton = new SSButton("foo");
        this.switchButton.setActionCommand("switch");
        this.switchButton.addActionListener(this);
        this.clearButton = new SSButton("foo");
        this.clearButton.setActionCommand("clear");
        this.clearButton.addActionListener(this);
        JPanel bottom = new JPanel(new FlowLayout(1));
        bottom.add(this.switchButton);
        bottom.add(this.clearButton);
        JLabel infoLabel = new JLabel(Translator.getString("sortingString"));
        infoLabel.setHorizontalAlignment(0);
        SSRootPane rootPane = new SSRootPane(new BorderLayout());
        rootPane.add((Component)infoLabel, "North");
        rootPane.add((Component)scrollpane, "Center");
        rootPane.add((Component)bottom, "South");
        rootPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.rankingsWindow.setContentPane(rootPane);
    }

    public void showRankings() {
        this.lastId = null;
        this.byName = !Prefs.getBoolean("rankByName", false);
        this.switchRankings();
        int min_height = 125;
        int height = (int)this.rankingsTableView.getPreferredSize().getHeight() + 75;
        if (height < min_height) {
            height = min_height;
        }
        ((JComponent)this.rankingsWindow.getContentPane()).setPreferredSize(new Dimension((int)this.rankingsWindow.getContentPane().getPreferredSize().getWidth(), height));
        this.rankingsWindow.pack();
        this.rankingsWindow.show();
    }

    private void setupData() {
        String[] all;
        Preferences recordPrefs;
        try {
            recordPrefs = Preferences.userNodeForPackage(LuxWorld.class).node("RecordBook");
            all = recordPrefs.keys();
        }
        catch (Throwable t) {
            System.out.println("Lux -> record book error: " + t);
            return;
        }
        this.rows = new Vector();
        this.numberRows = 0;
        if (this.byName) {
            for (int i = 0; i < all.length; ++i) {
                String key = all[i];
                if (!key.startsWith("ngp_")) continue;
                String name = key.substring(4);
                int played = recordPrefs.getInt(key, 0);
                int won = recordPrefs.getInt("ngw_" + name, 0);
                int lost = played - won;
                float percent = (float)(100 * won) / (float)played;
                float newStatsGames = recordPrefs.getInt("nnsgr_" + name, 1);
                float rounds = (float)recordPrefs.getInt("nrt_" + name, 0) / newStatsGames;
                float place = (float)recordPrefs.getInt("npt_" + name, 0) / newStatsGames;
                ++this.numberRows;
                Object[] obs = new Object[]{name, new Integer(played), new Integer(won), new Integer(lost), new Float(this.nice(percent)), new Float(this.nice(rounds)), new Float(this.nice(place))};
                this.rows.add(obs);
            }
        } else {
            for (int i = 0; i < all.length; ++i) {
                String key = all[i];
                if (!key.startsWith("agp_")) continue;
                String name = key.substring(4);
                int played = recordPrefs.getInt(key, 0);
                int won = recordPrefs.getInt("agw_" + name, 0);
                int lost = played - won;
                float percent = (float)(100 * won) / (float)played;
                float newStatsGames = recordPrefs.getInt("ansgr_" + name, 1);
                float rounds = (float)recordPrefs.getInt("art_" + name, 0) / newStatsGames;
                float place = (float)recordPrefs.getInt("apt_" + name, 0) / newStatsGames;
                Object[] obs = new Object[]{name, new Integer(played), new Integer(won), new Integer(lost), new Float(this.nice(percent)), new Float(this.nice(rounds)), new Float(this.nice(place))};
                this.rows.add(obs);
                ++this.numberRows;
            }
        }
    }

    public void switchRankings() {
        this.byName = !this.byName;
        this.lastId = null;
        Prefs.putBoolean("rankByName", this.byName);
        if (this.byName) {
            this.keys[0] = Translator.getString("Name");
            this.switchButton.setText(Translator.getString("ViewByAgent"));
            this.clearButton.setText(Translator.getString("ClearNameRecords"));
        } else {
            this.keys[0] = Translator.getString("Agent");
            this.switchButton.setText(Translator.getString("ViewByName"));
            this.clearButton.setText(Translator.getString("ClearAgentRecords"));
        }
        this.setupData();
        this.fireTableDataChanged();
    }

    public void clearRankings() {
        String message = this.byName ? Translator.getString("ClearNameQuestion") : Translator.getString("ClearAgentQuestion");
        if (SSOptionPane.showConfirmDialog(this.rankingsWindow, message, Translator.getString("ClearRecords"), 0) == 0) {
            String[] all;
            Preferences recordPrefs;
            try {
                recordPrefs = Preferences.userNodeForPackage(LuxWorld.class).node("RecordBook");
                all = recordPrefs.keys();
            }
            catch (Throwable t) {
                System.out.println("Lux -> error clearing the record book: " + t);
                return;
            }
            for (int i = 0; i < all.length; ++i) {
                String key = all[i];
                if (this.byName && key.startsWith("n")) {
                    recordPrefs.remove(key);
                    continue;
                }
                if (this.byName || !key.startsWith("a")) continue;
                recordPrefs.remove(key);
            }
            this.setupData();
            this.fireTableDataChanged();
        }
    }

    String nice(float number) {
        int intValue = Math.round(number);
        if ((float)intValue == number) {
            return String.valueOf(intValue);
        }
        return String.valueOf((float)Math.round(number * 10.0f) / 10.0f);
    }

    public int getRowCount() {
        return this.numberRows;
    }

    public int getColumnCount() {
        return this.keys.length;
    }

    public String getColumnName(int col) {
        return this.keys[col];
    }

    public Object getValueAt(int row, int col) {
        return ((Object[])this.rows.get(row))[col];
    }

    public Class getColumnClass(int columnIndex) {
        if (this.rows.size() > 1) {
            return ((Object[])this.rows.get(1))[columnIndex].getClass();
        }
        return Object.class;
    }

    public void actionPerformed(ActionEvent e) {
        if ("clear".equals(e.getActionCommand())) {
            this.clearRankings();
        } else if ("switch".equals(e.getActionCommand())) {
            this.switchRankings();
        }
    }
}

