/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.CardSequence;
import com.sillysoft.lux.ContinentSequence;
import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.gui.LuxController;
import com.sillysoft.lux.gui.LuxView;
import com.sillysoft.lux.gui.UpdateController;
import com.sillysoft.tools.ArrayTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.MusicEngine;
import com.sillysoft.widgets.SSBindingControlManager;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSCheckBox;
import com.sillysoft.widgets.SSCheckBoxBinding;
import com.sillysoft.widgets.SSComboBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSSlider;
import com.sillysoft.widgets.SSTextField;
import com.sillysoft.widgets.SoundEffect;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreferencesWindow {
    public static final int SHUFFLE = 1;
    public static final int SHUFFLE_WINNER = 2;
    public static final int SHUFFLE_RAWFIRST = 3;
    public static final int SHUFFLE_CYCLE = 4;
    final Object[] languages = new Object[]{"\u010cesky", "Dansk", "Deutsch", "Eesti", "English", "Espa\u00f1ol", "E\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", "Fran\u00e7ais", "Hrvatski", "Italiano", "Nederlands (BE)", "Nederlands (NL)", "Portugu\u00eas (BR)", "Portugu\u00eas (PT)", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "Rom\u00e2n\u0103", "Sloven\u0161\u010dina", "Suomen kieli", "Svenska", "T\u00fcrk\u00e7e", "\u2f47\u672c\u8a9e"};
    final String[] languageCodes = new String[]{"cs", "da", "de", "et", "en", "es", "el", "fr", "hr", "it", "nl_BE", "nl_NL", "pt_BR", "pt_PT", "ru", "ro", "sl", "fi", "sv", "tr", "ja"};
    public static PreferencesWindow instance = null;
    private static final int number_winning_messages = 7;
    public SSFrame prefsFrame;
    private JTabbedPane tabs;
    private SSButton okButton;
    private SSButton cancelButton;
    private SSButton applyButton;
    private SSButton explanationsButton;
    private SSButton restoreDefaultsButton;
    private JPanel prefsPanel;
    private JPanel gameOptionsPanel;
    private JPanel winningMessagesPanel;
    private SSCheckBox updateCheck;
    private SSComboBox languageChoice;
    private SSSlider countryBorderWidth;
    private SSComboBox explosions;
    private SSCheckBox useSound;
    private SSCheckBox oneLessArmy;
    private SSComboBox whenShowCards;
    private JRadioButton perAttackClick_once;
    private JRadioButton perAttackClick_tillDeaths;
    private JRadioButton perAttackClick_tillDead;
    private SSTextField perAttackDeaths;
    private JRadioButton armyAdvancement_manually;
    private JRadioButton armyAdvancement_automatically;
    private SSSlider agentDelay;
    private SSCheckBox useCards;
    private SSCheckBox cardTransfer;
    private SSCheckBox immediateCardCash;
    private SSComboBox cardSequence;
    private SSCheckBox randomStartingPlayer;
    private SSCheckBox turnTimerSwitch;
    private SSTextField turnTimerWords;
    private SSCheckBox gameLimitSwitch;
    private SSTextField gameLimitWords;
    private SSCheckBox isRanked;
    private SSCheckBox autoplay;
    private SSComboBox shuffleState;
    private SSComboBox continentSequence;
    private SSCheckBox soundStartTurn;
    private SSCheckBox soundActiveCountry;
    private SSCheckBox soundArmies;
    private SSCheckBox soundEliminated;
    private SSCheckBox soundCardCash;
    private SSCheckBox soundButtons;
    private SSCheckBox soundSelectCountry;
    private SSCheckBox soundTimeUp;
    private SSCheckBox soundExplosions;
    private SSCheckBox soundGameOver;
    private SSCheckBox soundChat;
    private SSCheckBox soundJoin;
    private SSCheckBox soundAI;
    private SSSlider volumeSound;
    private SSSlider volumeMusic;
    private SSTextField[] winningMessages;
    private SSTextField winningMessagesNick;
    ActionListener okButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            boolean doApply = PreferencesWindow.this.applyButton.isEnabled();
            if (doApply) {
                PreferencesWindow.this.applyButtonPressed.actionPerformed(e);
            }
            PreferencesWindow.this.prefsFrame.hide();
        }
    };
    ActionListener cancelButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PreferencesWindow.this.prefsFrame.hide();
        }
    };
    ActionListener applyButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PreferencesWindow.this.applyButton.setEnabled(false);
            PreferencesWindow.this.publishChanges();
        }
    };
    ActionListener explanationsButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            UpdateController.notesPrefs();
        }
    };
    ActionListener restoreDefaultsButtonPressed = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PreferencesWindow.this.restoreDefaultsPrefs();
            PreferencesWindow.this.changeActionListener.actionPerformed(e);
        }
    };
    ActionListener changeActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PreferencesWindow.this.applyButton.setEnabled(true);
            PreferencesWindow.this.validateUI();
        }
    };
    ChangeListener changeChangeListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            PreferencesWindow.this.changeActionListener.actionPerformed(new ActionEvent(e.getSource(), 0, "change made"));
        }
    };
    CaretListener changeCaretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            PreferencesWindow.this.changeActionListener.actionPerformed(new ActionEvent(e.getSource(), 0, "change made"));
        }
    };

    public PreferencesWindow() {
        this.initGUI();
    }

    private void publishChanges() {
        Prefs.putBoolean("updateCheck", this.updateCheck.isSelected());
        if (!Prefs.get("locale", null).equals(this.languageCodes[this.languageChoice.getSelectedIndex()])) {
            Prefs.put("locale", this.languageCodes[this.languageChoice.getSelectedIndex()]);
            String translatedWarning = Translator.getString("Youmustrestart", this.languageCodes[this.languageChoice.getSelectedIndex()]);
            String englishWarning = Translator.getString("Youmustrestart", "en");
            String warning = englishWarning.equals(translatedWarning) ? translatedWarning : translatedWarning + "\n\n" + englishWarning;
            SSOptionPane.showMessageDialog(this.prefsFrame, (Object)warning);
        }
        Prefs.putInt("countryBorderWidth", this.countryBorderWidth.getValue());
        Prefs.putInt("explosions", this.explosions.getSelectedIndex());
        Prefs.putInt("whenShowCards", this.whenShowCards.getSelectedIndex());
        Prefs.putBoolean("oneLessArmy", this.oneLessArmy.isSelected());
        Prefs.putBoolean("useSound", this.useSound.isSelected());
        try {
            Prefs.putInt("perAttackDeaths", Integer.parseInt(this.perAttackDeaths.getText()));
        }
        catch (NumberFormatException e) {
            System.out.println("Error: couldn't parse Int");
        }
        int perAttackClick = 0;
        if (this.perAttackClick_tillDeaths.isSelected()) {
            perAttackClick = 1;
        } else if (this.perAttackClick_tillDead.isSelected()) {
            perAttackClick = 2;
        }
        Prefs.putInt("perAttackClick", perAttackClick);
        if (this.armyAdvancement_manually.isSelected()) {
            Prefs.putInt("armyAdvancement", 0);
        } else {
            Prefs.putInt("armyAdvancement", 1);
        }
        Prefs.putInt("agentDelay", this.agentDelay.getValue());
        Prefs.putBoolean("useCards", this.useCards.isSelected());
        Prefs.putInt("cardSequence", this.cardSequence.getSelectedIndex());
        Prefs.putBoolean("cardTransfer", this.cardTransfer.isSelected());
        Prefs.putBoolean("immediateCardCash", this.immediateCardCash.isSelected());
        Prefs.putInt("continentSequenceCode", this.continentSequence.getSelectedIndex());
        Prefs.putBoolean("randomStartingPlayer", this.randomStartingPlayer.isSelected());
        Prefs.putBoolean("turnTimer", this.turnTimerSwitch.isSelected());
        Prefs.putBoolean("gameLimit", this.gameLimitSwitch.isSelected());
        try {
            int timeLength = Integer.parseInt(this.turnTimerWords.getText());
            int minTurnTime = 8;
            timeLength = Math.max(timeLength, minTurnTime);
            Prefs.putInt("turnTimerSeconds", timeLength);
        }
        catch (NumberFormatException e) {
            System.out.println("Error: couldn't parse Float");
            Prefs.putInt("turnTimerSeconds", 45);
        }
        try {
            int timeLength = Integer.parseInt(this.gameLimitWords.getText());
            int minTurnTime = 30;
            timeLength = Math.max(timeLength, minTurnTime);
            Prefs.putInt("gameLimitMinutes", timeLength);
        }
        catch (NumberFormatException e) {
            System.out.println("Error: couldn't parse Float");
            Prefs.putInt("gameLimitMinutes", 45);
        }
        Prefs.putBoolean("isRanked", this.isRanked.isSelected());
        Prefs.putBoolean("autoplay", this.autoplay.isSelected());
        Prefs.putInt("shuffleState", this.shuffleState.getSelectedIndex());
        Prefs.putBoolean("soundStartTurn", this.soundStartTurn.isSelected());
        Prefs.putBoolean("soundActiveCountry", this.soundActiveCountry.isSelected());
        Prefs.putBoolean("soundArmies", this.soundArmies.isSelected());
        Prefs.putBoolean("soundExplosions", this.soundExplosions.isSelected());
        Prefs.putBoolean("soundGameOver", this.soundGameOver.isSelected());
        Prefs.putBoolean("soundChat", this.soundChat.isSelected());
        Prefs.putBoolean("soundPlayerJoined", this.soundJoin.isSelected());
        Prefs.putBoolean("soundAI", this.soundAI.isSelected());
        Prefs.putInt("volume", this.volumeSound.getValue());
        SoundEffect.setSoundVolume((double)this.volumeSound.getValue() / 100.0);
        Prefs.putInt("musicVolume", this.volumeMusic.getValue());
        MusicEngine.setVolume();
        int winningMessagesCount = 0;
        for (int i = 0; i < 7; ++i) {
            Prefs.put("winMessage" + i, this.winningMessages[i].getText());
            if ("".equals(this.winningMessages[i].getText())) continue;
            ++winningMessagesCount;
        }
        Prefs.put("winningMessagesNick", this.winningMessagesNick.getText());
        Prefs.putInt("winMessageNumber", winningMessagesCount);
        SSBindingControlManager.publishChanges();
        LuxView.setBorderWidth(this.countryBorderWidth.getValue());
        LuxWorld.setDelay(this.agentDelay.getValue());
        LuxController.getInstance().refreshGamePrefs();
        PrefsCache.reloadStatics();
    }

    private void getPreferences() {
        this.updateCheck.setSelected(Prefs.getBoolean("updateCheck", true));
        if (Prefs.get("locale", null) == null) {
            int langIndex;
            String defaultLanguage = Locale.getDefault().getLanguage();
            if (defaultLanguage.equals("nl")) {
                defaultLanguage = "nl_" + Locale.getDefault().getCountry();
            }
            if ((langIndex = ArrayTool.arrayIndex(this.languageCodes, defaultLanguage)) == -1) {
                Prefs.put("locale", "en");
                this.languageChoice.setSelectedItem("English");
            } else {
                Prefs.put("locale", this.languageCodes[langIndex]);
                this.languageChoice.setSelectedItem(this.languages[langIndex]);
            }
        } else {
            int languageIndex = ArrayTool.arrayIndex(this.languageCodes, Prefs.get("locale", "en"));
            if (languageIndex == -1) {
                languageIndex = ArrayTool.arrayIndex(this.languageCodes, "en");
            }
            this.languageChoice.setSelectedItem(this.languages[languageIndex]);
        }
        this.countryBorderWidth.setValue(Prefs.getInt("countryBorderWidth", 7));
        this.explosions.setSelectedIndex(Prefs.getInt("explosions", 2));
        this.whenShowCards.setSelectedIndex(Prefs.getInt("whenShowCards", 1));
        this.oneLessArmy.setSelected(Prefs.getBoolean("oneLessArmy", true));
        this.useSound.setSelected(Prefs.getBoolean("useSound", true));
        switch (Prefs.getInt("perAttackClick", 0)) {
            case 0: {
                this.perAttackClick_once.setSelected(true);
                break;
            }
            case 1: {
                this.perAttackClick_tillDeaths.setSelected(true);
                break;
            }
            default: {
                this.perAttackClick_tillDead.setSelected(true);
            }
        }
        if (Prefs.getInt("armyAdvancement") == 0) {
            this.armyAdvancement_manually.setSelected(true);
        } else {
            this.armyAdvancement_automatically.setSelected(true);
        }
        this.perAttackDeaths.setText(Integer.toString(Prefs.getInt("perAttackDeaths", 5)));
        this.agentDelay.setValue(Prefs.getInt("agentDelay", 400));
        this.useCards.setSelected(Prefs.getBoolean("useCards", true));
        this.cardSequence.setSelectedIndex(Prefs.getInt("cardSequence", 3));
        this.cardTransfer.setSelected(Prefs.getBoolean("cardTransfer", true));
        this.immediateCardCash.setSelected(Prefs.getBoolean("immediateCardCash", true));
        this.continentSequence.setSelectedIndex(Prefs.getInt("continentSequenceCode", 1));
        this.randomStartingPlayer.setSelected(Prefs.getBoolean("randomStartingPlayer", true));
        this.turnTimerSwitch.setSelected(Prefs.getBoolean("turnTimer", false));
        this.turnTimerWords.setText(Integer.toString(Prefs.getInt("turnTimerSeconds", 45)));
        this.gameLimitSwitch.setSelected(Prefs.getBoolean("gameLimit", false));
        this.gameLimitWords.setText(Integer.toString(Prefs.getInt("gameLimitMinutes", 45)));
        this.isRanked.setSelected(Prefs.getBoolean("isRanked", true));
        this.autoplay.setSelected(Prefs.getBoolean("autoplay", false));
        this.shuffleState.setSelectedIndex(Prefs.getInt("shuffleState", 4));
        this.soundStartTurn.setSelected(Prefs.getBoolean("soundStartTurn", true));
        this.soundActiveCountry.setSelected(Prefs.getBoolean("soundActiveCountry", true));
        this.soundArmies.setSelected(Prefs.getBoolean("soundArmies", true));
        this.soundExplosions.setSelected(Prefs.getBoolean("soundExplosions", true));
        this.soundGameOver.setSelected(Prefs.getBoolean("soundGameOver", true));
        this.soundChat.setSelected(Prefs.getBoolean("soundChat", true));
        this.soundJoin.setSelected(Prefs.getBoolean("soundPlayerJoined", true));
        this.soundAI.setSelected(Prefs.getBoolean("soundAI", true));
        this.volumeSound.setValue(Prefs.getInt("volume", 100));
        this.volumeMusic.setValue(Prefs.getInt("musicVolume", 70));
        SSBindingControlManager.loadValues();
        for (int i = 0; i < 7; ++i) {
            this.winningMessages[i].setText(Prefs.get("winMessage" + i, ""));
        }
        this.winningMessagesNick.setText(Prefs.get("winningMessagesNick", ""));
        this.applyButton.setEnabled(false);
        this.validateUI();
    }

    private void validateUI() {
        this.perAttackDeaths.setEnabled(this.perAttackClick_tillDeaths.isSelected());
        this.turnTimerWords.setEnabled(this.turnTimerSwitch.isSelected());
        this.gameLimitWords.setEnabled(this.gameLimitSwitch.isSelected());
        this.cardTransfer.setEnabled(this.useCards.isSelected());
        this.immediateCardCash.setEnabled(this.useCards.isSelected());
        this.cardSequence.setEnabled(this.useCards.isSelected());
        this.soundStartTurn.setEnabled(this.useSound.isSelected());
        this.soundActiveCountry.setEnabled(this.useSound.isSelected());
        this.soundArmies.setEnabled(this.useSound.isSelected());
        this.soundExplosions.setEnabled(this.useSound.isSelected());
        this.soundGameOver.setEnabled(this.useSound.isSelected());
        this.soundChat.setEnabled(this.useSound.isSelected());
        this.soundJoin.setEnabled(this.useSound.isSelected());
        this.soundEliminated.setEnabled(this.useSound.isSelected());
        this.soundCardCash.setEnabled(this.useSound.isSelected());
        this.soundButtons.setEnabled(this.useSound.isSelected());
        this.soundSelectCountry.setEnabled(this.useSound.isSelected());
        this.soundTimeUp.setEnabled(this.useSound.isSelected());
        this.soundAI.setEnabled(this.useSound.isSelected());
        this.volumeSound.setEnabled(this.useSound.isSelected());
    }

    private void initGUI() {
        int i;
        this.prefsFrame = new SSFrame(Translator.getString("Preferences"));
        this.prefsFrame.setLocationID("Prefs");
        this.prefsFrame.setResizable(false);
        this.tabs = new JTabbedPane();
        this.prefsPanel = new JPanel(new FlowLayout());
        this.winningMessagesPanel = new JPanel();
        this.gameOptionsPanel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout contentLayout = new GridBagLayout();
        GridBagConstraints contentConstraints = new GridBagConstraints();
        GridBagLayout effectsLayout = new GridBagLayout();
        GridBagConstraints attacksConstraints = new GridBagConstraints();
        GridBagLayout attacksLayout = new GridBagLayout();
        GridBagConstraints computerSpeedConstraints = new GridBagConstraints();
        GridBagLayout computerSpeedLayout = new GridBagLayout();
        JPanel contentPanel = new JPanel(contentLayout);
        JPanel effectsPanel = new JPanel(effectsLayout);
        JPanel attacksPanel = new JPanel(attacksLayout);
        JPanel[] actionButtonPanels = new JPanel[]{new JPanel(new GridLayout(1, 2)), new JPanel(new GridLayout(1, 3))};
        this.okButton = new SSButton(Translator.getString("OK"));
        this.applyButton = new SSButton(Translator.getString("Apply"));
        this.cancelButton = new SSButton(Translator.getString("Cancel"));
        this.restoreDefaultsButton = new SSButton(Translator.getString("RestoreDefaults"));
        this.explanationsButton = new SSButton(Translator.getString("Explanations"));
        this.okButton.setPreferredWidth(150);
        this.applyButton.setPreferredWidth(150);
        this.cancelButton.setPreferredWidth(150);
        this.restoreDefaultsButton.setPreferredWidth(150);
        this.explanationsButton.setPreferredWidth(150);
        GridBagLayout mapsLayout = new GridBagLayout();
        GridBagLayout cardsLayout = new GridBagLayout();
        GridBagLayout continentLayout = new GridBagLayout();
        GridBagLayout turnsLayout = new GridBagLayout();
        JPanel cardsPanel = new JPanel(cardsLayout);
        JPanel turnsPanel = new JPanel(turnsLayout);
        JPanel continentPanel = new JPanel(continentLayout);
        GridBagLayout attackRadioLayout = new GridBagLayout();
        JPanel attackRadioPanel = new JPanel(attackRadioLayout);
        JPanel advArmiesRadioPanel = new JPanel(new GridLayout(2, 1));
        JLabel l = null;
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        contentPanel.setOpaque(true);
        this.prefsFrame.setContentPane(contentPanel);
        this.prefsFrame.setDefaultCloseOperation(1);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        contentLayout.setConstraints(this.tabs, c);
        contentPanel.add(this.tabs);
        contentLayout.setConstraints(actionButtonPanels[0], c);
        contentPanel.add(actionButtonPanels[0]);
        contentLayout.setConstraints(actionButtonPanels[1], c);
        contentPanel.add(actionButtonPanels[1]);
        this.prefsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        JPanel soundPanel = new JPanel();
        soundPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 30, 15));
        this.tabs.addTab(Translator.getString("Prefs"), this.prefsPanel);
        this.tabs.addTab(Translator.getString("GameOptions"), this.gameOptionsPanel);
        this.tabs.addTab(Translator.getString("Sounds"), soundPanel);
        this.tabs.addTab(Translator.getString("WinningMessages"), this.winningMessagesPanel);
        JPanel okButtonPanel = new JPanel();
        okButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        okButtonPanel.add(this.okButton);
        JPanel cancelButtonPanel = new JPanel();
        cancelButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        cancelButtonPanel.add(this.cancelButton);
        JPanel applyButtonPanel = new JPanel();
        applyButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        applyButtonPanel.add(this.applyButton);
        JPanel restoreDefaultsPanel = new JPanel();
        restoreDefaultsPanel.setBorder(BorderFactory.createEmptyBorder(0, 70, 0, 0));
        restoreDefaultsPanel.add(this.restoreDefaultsButton);
        JPanel explanationsPanel = new JPanel();
        explanationsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 70));
        explanationsPanel.add(this.explanationsButton);
        actionButtonPanels[0].add(restoreDefaultsPanel);
        actionButtonPanels[0].add(explanationsPanel);
        actionButtonPanels[1].add(applyButtonPanel);
        actionButtonPanels[1].add(cancelButtonPanel);
        actionButtonPanels[1].add(okButtonPanel);
        this.okButton.addActionListener(this.okButtonPressed);
        this.cancelButton.addActionListener(this.cancelButtonPressed);
        this.applyButton.addActionListener(this.applyButtonPressed);
        this.explanationsButton.addActionListener(this.explanationsButtonPressed);
        this.restoreDefaultsButton.addActionListener(this.restoreDefaultsButtonPressed);
        JPanel generalPanel = new JPanel(new BorderLayout());
        JPanel updatePanel = new JPanel(new BorderLayout());
        generalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Translator.getString("General")), BorderFactory.createEmptyBorder(1, 5, 0, 5)));
        this.updateCheck = new SSCheckBox(Translator.getString("Checkforupdatesonline"));
        this.updateCheck.addActionListener(this.changeActionListener);
        updatePanel.add((Component)this.updateCheck, "North");
        SSCheckBoxBinding box = new SSCheckBoxBinding(Translator.getString("checkforpluginsonline"), "checkforpluginsonline", true);
        box.addActionListener(this.changeActionListener);
        updatePanel.add((Component)box, "Center");
        box = new SSCheckBoxBinding(Translator.getString("lookformissingthemes"), "lookformissingthemes", true);
        box.addActionListener(this.changeActionListener);
        updatePanel.add((Component)box, "South");
        generalPanel.add((Component)updatePanel, "North");
        this.languageChoice = new SSComboBox(this.languages);
        this.languageChoice.setMaximumRowCount(25);
        this.languageChoice.addActionListener(this.changeActionListener);
        JPanel bottomGeneral = new JPanel(new FlowLayout(0));
        bottomGeneral.add(new JLabel("Language:"));
        bottomGeneral.add(this.languageChoice);
        generalPanel.add((Component)bottomGeneral, "Center");
        JPanel computerSpeedPanel = new JPanel(computerSpeedLayout);
        JLabel computerPlayerSpeed = new JLabel(Translator.getString("Computerplayerspeed") + ":");
        computerPlayerSpeed.setHorizontalAlignment(2);
        computerSpeedLayout.setConstraints(computerPlayerSpeed, c);
        computerSpeedPanel.add(computerPlayerSpeed);
        this.agentDelay = new SSSlider(10, 1010);
        this.agentDelay.setMajorTickSpacing(250);
        this.agentDelay.setMinorTickSpacing(50);
        this.agentDelay.setPaintTicks(true);
        this.agentDelay.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JLabel sideLabel = new JLabel(Translator.getString("fast"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.agentDelay.getMinimum()), sideLabel);
        sideLabel = new JLabel(Translator.getString("slow"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.agentDelay.getMaximum()), sideLabel);
        this.agentDelay.setLabelTable(labelTable);
        this.agentDelay.setPaintLabels(true);
        this.agentDelay.addChangeListener(this.changeChangeListener);
        computerSpeedLayout.setConstraints(this.agentDelay, c);
        computerSpeedPanel.add(this.agentDelay);
        generalPanel.add((Component)computerSpeedPanel, "South");
        effectsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Translator.getString("Effects")), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.weightx = 0.5;
        c.gridwidth = 1;
        JLabel explosionsLabel = new JLabel(Translator.getString("Explosions") + ": ");
        explosionsLabel.setHorizontalAlignment(2);
        effectsLayout.setConstraints(explosionsLabel, c);
        effectsPanel.add(explosionsLabel);
        c.weightx = 1.0;
        c.gridwidth = 0;
        DefaultComboBoxModel<String> explosionsModel = new DefaultComboBoxModel<String>();
        explosionsModel.addElement(Translator.getString("none"));
        explosionsModel.addElement(Translator.getString("few"));
        explosionsModel.addElement(Translator.getString("normal"));
        explosionsModel.addElement(Translator.getString("lots"));
        explosionsModel.addElement(Translator.getString("nuke'em"));
        this.explosions = new SSComboBox((ComboBoxModel)explosionsModel);
        effectsLayout.setConstraints(this.explosions, c);
        effectsPanel.add(this.explosions);
        this.explosions.addActionListener(this.changeActionListener);
        this.useSound = new SSCheckBox(Translator.getString("Sounds"));
        this.useSound.addActionListener(this.changeActionListener);
        this.oneLessArmy = new SSCheckBox(Translator.getString("Showonelessarmy"));
        effectsLayout.setConstraints(this.oneLessArmy, c);
        effectsPanel.add(this.oneLessArmy);
        this.oneLessArmy.addActionListener(this.changeActionListener);
        SSCheckBoxBinding showArmyGraphics = new SSCheckBoxBinding(Translator.getString("Showarmygraphics"), "showArmyGraphics", true);
        effectsLayout.setConstraints(showArmyGraphics, c);
        effectsPanel.add(showArmyGraphics);
        showArmyGraphics.addActionListener(this.changeActionListener);
        SSCheckBoxBinding flashContinentTakeover = new SSCheckBoxBinding(Translator.getString("flashContinentTakeover"), "flashContinentTakeover", true);
        effectsLayout.setConstraints(flashContinentTakeover, c);
        effectsPanel.add(flashContinentTakeover);
        flashContinentTakeover.addActionListener(this.changeActionListener);
        JLabel spacer = new JLabel(" ");
        effectsLayout.setConstraints(spacer, c);
        effectsPanel.add(spacer);
        SSCheckBoxBinding autoGrowMaps = new SSCheckBoxBinding(Translator.getString("AutosizeMapsBigger"), "autosizeMapsBigger", false);
        effectsLayout.setConstraints(autoGrowMaps, c);
        effectsPanel.add(autoGrowMaps);
        autoGrowMaps.addActionListener(this.changeActionListener);
        SSCheckBoxBinding autoShrinkMaps = new SSCheckBoxBinding(Translator.getString("AutosizeMaps"), "autosizeMaps", true);
        effectsLayout.setConstraints(autoShrinkMaps, c);
        effectsPanel.add(autoShrinkMaps);
        autoShrinkMaps.addActionListener(this.changeActionListener);
        box = new SSCheckBoxBinding(Translator.getString("SeperateChat"), "seperateChatWindow", false);
        effectsLayout.setConstraints(box, c);
        effectsPanel.add(box);
        box.addActionListener(this.changeActionListener);
        box = new SSCheckBoxBinding(Translator.getString("PlayerInfoSeperateWindow"), "playerInfoSeperate", false);
        effectsLayout.setConstraints(box, c);
        effectsPanel.add(box);
        box.addActionListener(this.changeActionListener);
        Component b = Box.createVerticalStrut(6);
        effectsLayout.setConstraints(b, c);
        effectsPanel.add(b);
        JLabel showCardsLabel = new JLabel(Translator.getString("Showcardsatstartofturn"));
        showCardsLabel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        showCardsLabel.setHorizontalAlignment(2);
        effectsLayout.setConstraints(showCardsLabel, c);
        effectsPanel.add(showCardsLabel);
        DefaultComboBoxModel<String> cardRulesModel = new DefaultComboBoxModel<String>();
        cardRulesModel.addElement(Translator.getString("whenyouMUSTcashaset"));
        cardRulesModel.addElement(Translator.getString("whenyouhaveaset"));
        cardRulesModel.addElement(Translator.getString("whenyouhavecards"));
        cardRulesModel.addElement(Translator.getString("everyturn"));
        this.whenShowCards = new SSComboBox((ComboBoxModel)cardRulesModel);
        effectsLayout.setConstraints(this.whenShowCards, c);
        effectsPanel.add(this.whenShowCards);
        this.whenShowCards.addActionListener(this.changeActionListener);
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JLabel countryBorderWidthLabel = new JLabel(Translator.getString("Countryborderwidth") + ":");
        countryBorderWidthLabel.setBorder(BorderFactory.createEmptyBorder(12, 0, 0, 0));
        countryBorderWidthLabel.setHorizontalAlignment(2);
        effectsLayout.setConstraints(countryBorderWidthLabel, c);
        effectsPanel.add(countryBorderWidthLabel);
        this.countryBorderWidth = new SSSlider(0, 14);
        this.countryBorderWidth.setMajorTickSpacing(7);
        this.countryBorderWidth.setMinorTickSpacing(1);
        this.countryBorderWidth.setPaintTicks(true);
        this.countryBorderWidth.setSnapToTicks(true);
        this.countryBorderWidth.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        labelTable = new Hashtable();
        sideLabel = new JLabel(Translator.getString("thin"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.countryBorderWidth.getMinimum()), sideLabel);
        sideLabel = new JLabel(Translator.getString("thick"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.countryBorderWidth.getMaximum()), sideLabel);
        this.countryBorderWidth.setLabelTable(labelTable);
        this.countryBorderWidth.setPaintLabels(true);
        this.countryBorderWidth.addChangeListener(this.changeChangeListener);
        effectsLayout.setConstraints(this.countryBorderWidth, c);
        effectsPanel.add(this.countryBorderWidth);
        c = new GridBagConstraints();
        GridBagLayout prefsLeftLayout = new GridBagLayout();
        JPanel prefsLeftPanel = new JPanel(prefsLeftLayout);
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        prefsLeftLayout.setConstraints(effectsPanel, c);
        prefsLeftPanel.add(effectsPanel);
        this.prefsPanel.add(prefsLeftPanel);
        attacksPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Translator.getString("Attacks")), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        attacksConstraints = new GridBagConstraints();
        attacksConstraints.fill = 1;
        attacksConstraints.weightx = 1.0;
        attacksConstraints.gridwidth = 1;
        l = new JLabel(Translator.getString("Attackperclick") + ": ");
        l.setHorizontalAlignment(4);
        attacksLayout.setConstraints(l, attacksConstraints);
        attacksPanel.add(l);
        ActionListener enable_perAttackDeathsTextField = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesWindow.this.perAttackDeaths.setEnabled(PreferencesWindow.this.perAttackClick_tillDeaths.isSelected());
            }
        };
        c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.perAttackClick_once = new JRadioButton(Translator.getString("once"));
        this.perAttackClick_once.addActionListener(enable_perAttackDeathsTextField);
        attackRadioLayout.setConstraints(this.perAttackClick_once, c);
        attackRadioPanel.add(this.perAttackClick_once);
        this.perAttackClick_once.addActionListener(this.changeActionListener);
        c.gridwidth = 1;
        this.perAttackClick_tillDeaths = new JRadioButton(Translator.getString("till"));
        this.perAttackClick_tillDeaths.addActionListener(enable_perAttackDeathsTextField);
        attackRadioLayout.setConstraints(this.perAttackClick_tillDeaths, c);
        attackRadioPanel.add(this.perAttackClick_tillDeaths);
        this.perAttackClick_tillDeaths.addActionListener(this.changeActionListener);
        this.perAttackDeaths = new SSTextField(3);
        attackRadioLayout.setConstraints(this.perAttackDeaths, c);
        attackRadioPanel.add(this.perAttackDeaths);
        this.perAttackDeaths.addCaretListener(this.changeCaretListener);
        c.gridwidth = 0;
        JLabel deathsLabel = new JLabel(" " + Translator.getString("deaths"));
        attackRadioLayout.setConstraints(deathsLabel, c);
        attackRadioPanel.add(deathsLabel);
        this.perAttackClick_tillDead = new JRadioButton(Translator.getString("tilldead"));
        this.perAttackClick_tillDead.addActionListener(enable_perAttackDeathsTextField);
        attackRadioLayout.setConstraints(this.perAttackClick_tillDead, c);
        attackRadioPanel.add(this.perAttackClick_tillDead);
        this.perAttackClick_tillDead.addActionListener(this.changeActionListener);
        ButtonGroup group = new ButtonGroup();
        group.add(this.perAttackClick_once);
        group.add(this.perAttackClick_tillDeaths);
        group.add(this.perAttackClick_tillDead);
        attacksConstraints.gridwidth = 0;
        attacksLayout.setConstraints(attackRadioPanel, attacksConstraints);
        attacksPanel.add(attackRadioPanel);
        l = new JLabel(" ");
        attacksLayout.setConstraints(l, attacksConstraints);
        attacksPanel.add(l);
        l = new JLabel(Translator.getString("Advancearmies") + ": ");
        l.setHorizontalAlignment(4);
        attacksConstraints.gridwidth = 1;
        attacksLayout.setConstraints(l, attacksConstraints);
        attacksPanel.add(l);
        this.armyAdvancement_manually = new JRadioButton(Translator.getString("manually"));
        advArmiesRadioPanel.add(this.armyAdvancement_manually);
        this.armyAdvancement_manually.addActionListener(this.changeActionListener);
        this.armyAdvancement_automatically = new JRadioButton(Translator.getString("automatically"));
        advArmiesRadioPanel.add(this.armyAdvancement_automatically);
        this.armyAdvancement_automatically.addActionListener(this.changeActionListener);
        group = new ButtonGroup();
        group.add(this.armyAdvancement_manually);
        group.add(this.armyAdvancement_automatically);
        attacksLayout.setConstraints(advArmiesRadioPanel, attacksConstraints);
        attacksPanel.add(advArmiesRadioPanel);
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c = new GridBagConstraints();
        GridBagLayout prefsRightLayout = new GridBagLayout();
        JPanel prefsRightPanel = new JPanel(prefsRightLayout);
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        prefsRightLayout.setConstraints(attacksPanel, c);
        prefsRightPanel.add(attacksPanel);
        prefsRightLayout.setConstraints(generalPanel, c);
        prefsRightPanel.add(generalPanel);
        this.prefsPanel.add(prefsRightPanel);
        cardsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Translator.getString("Cards")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.useCards = new SSCheckBox(Translator.getString("Usecards"));
        cardsLayout.setConstraints(this.useCards, c);
        cardsPanel.add(this.useCards);
        this.useCards.addActionListener(this.changeActionListener);
        this.cardTransfer = new SSCheckBox(Translator.getString("Transfercardstoconqueringplayer"));
        cardsLayout.setConstraints(this.cardTransfer, c);
        cardsPanel.add(this.cardTransfer);
        this.cardTransfer.addActionListener(this.changeActionListener);
        this.immediateCardCash = new SSCheckBox(Translator.getString("Forceimmediatecashfor5ormore"));
        cardsLayout.setConstraints(this.immediateCardCash, c);
        cardsPanel.add(this.immediateCardCash);
        this.immediateCardCash.addActionListener(this.changeActionListener);
        c.gridwidth = 0;
        l = new JLabel("  " + Translator.getString("Cardsequence") + ":");
        cardsLayout.setConstraints(l, c);
        cardsPanel.add(l);
        c.gridwidth = 1;
        l = new JLabel("   ");
        cardsLayout.setConstraints(l, c);
        cardsPanel.add(l);
        c.gridwidth = 0;
        DefaultComboBoxModel<String> cardSequenceModel = new DefaultComboBoxModel<String>();
        for (int i2 = 0; i2 < CardSequence.sequences.length; ++i2) {
            cardSequenceModel.addElement(CardSequence.sequences[i2]);
        }
        this.cardSequence = new SSComboBox((ComboBoxModel)cardSequenceModel);
        this.cardSequence.addActionListener(this.changeActionListener);
        cardsLayout.setConstraints(this.cardSequence, c);
        cardsPanel.add(this.cardSequence);
        turnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Translator.getString("Turns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        turnsPanel.setAlignmentX(1.0f);
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.randomStartingPlayer = new SSCheckBox(Translator.getString("Randomstartingorder"));
        turnsLayout.setConstraints(this.randomStartingPlayer, c);
        turnsPanel.add(this.randomStartingPlayer);
        this.randomStartingPlayer.addActionListener(this.changeActionListener);
        this.turnTimerSwitch = new SSCheckBox(Translator.getString("Turntimelimit"));
        this.turnTimerSwitch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesWindow.this.turnTimerWords.setEnabled(PreferencesWindow.this.turnTimerSwitch.isSelected());
            }
        });
        turnsLayout.setConstraints(this.turnTimerSwitch, c);
        turnsPanel.add(this.turnTimerSwitch);
        this.turnTimerSwitch.addActionListener(this.changeActionListener);
        c.gridwidth = 1;
        l = new JLabel("   ");
        turnsLayout.setConstraints(l, c);
        turnsPanel.add(l);
        c.gridwidth = 1;
        this.turnTimerWords = new SSTextField(2);
        turnsLayout.setConstraints(this.turnTimerWords, c);
        turnsPanel.add(this.turnTimerWords);
        this.turnTimerWords.addCaretListener(this.changeCaretListener);
        c.gridwidth = 0;
        l = new JLabel("  " + Translator.getString("seconds") + " (8 " + Translator.getString("minimum") + ")");
        turnsLayout.setConstraints(l, c);
        turnsPanel.add(l);
        JPanel hostsPanel = new JPanel(new BorderLayout());
        JPanel checkPanel = new JPanel(new BorderLayout());
        hostsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Translator.getString("Hosting")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.isRanked = new SSCheckBox(Translator.getString("Rankedgame"));
        this.isRanked.addActionListener(this.changeActionListener);
        checkPanel.add((Component)this.isRanked, "North");
        this.autoplay = new SSCheckBox(Translator.getString("AutoplayMode"));
        this.autoplay.addActionListener(this.changeActionListener);
        checkPanel.add((Component)this.autoplay, "South");
        hostsPanel.add((Component)checkPanel, "North");
        DefaultComboBoxModel<String> shuffleModel = new DefaultComboBoxModel<String>();
        shuffleModel.addElement(Translator.getString("firstcome"));
        shuffleModel.addElement(Translator.getString("shuffleplayers"));
        shuffleModel.addElement(Translator.getString("shufflewithwinner"));
        shuffleModel.addElement(Translator.getString("highestrankedfirst"));
        shuffleModel.addElement(Translator.getString("cyclelosers"));
        this.shuffleState = new SSComboBox((ComboBoxModel)shuffleModel);
        this.shuffleState.addActionListener(this.changeActionListener);
        JPanel shufflePanel = new JPanel(new BorderLayout());
        shufflePanel.add((Component)new JLabel("  " + Translator.getString("remoteplayerorder")), "North");
        shufflePanel.add((Component)new JLabel("   "), "West");
        shufflePanel.add((Component)this.shuffleState, "Center");
        hostsPanel.add((Component)shufflePanel, "South");
        this.gameLimitSwitch = new SSCheckBox(Translator.getString("gamelimit"));
        this.gameLimitSwitch.addActionListener(this.changeActionListener);
        this.gameLimitSwitch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesWindow.this.gameLimitWords.setEnabled(PreferencesWindow.this.gameLimitSwitch.isSelected());
            }
        });
        this.gameLimitWords = new SSTextField(2);
        this.gameLimitWords.addCaretListener(this.changeCaretListener);
        JPanel jp = new JPanel();
        jp.add(this.gameLimitWords);
        JPanel limitPanel = new JPanel(new BorderLayout());
        limitPanel.add((Component)this.gameLimitSwitch, "North");
        limitPanel.add((Component)jp, "Center");
        l = new JLabel("  " + Translator.getString("minutes") + " (30 " + Translator.getString("minimum") + ")");
        limitPanel.add((Component)l, "East");
        limitPanel.add((Component)new JLabel("   "), "West");
        hostsPanel.add((Component)limitPanel, "Center");
        continentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Translator.getString("Continents")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        SSCheckBoxBinding firstTurnContBonus = new SSCheckBoxBinding(Translator.getString("firstTurnContBonus"), "firstTurnContBonus", true);
        firstTurnContBonus.addActionListener(this.changeActionListener);
        continentLayout.setConstraints(firstTurnContBonus, c);
        continentPanel.add(firstTurnContBonus);
        c.gridwidth = 0;
        l = new JLabel("  " + Translator.getString("Continentsgoup") + ":");
        continentLayout.setConstraints(l, c);
        continentPanel.add(l);
        c.gridwidth = 1;
        l = new JLabel("   ");
        continentLayout.setConstraints(l, c);
        continentPanel.add(l);
        c.gridwidth = 0;
        DefaultComboBoxModel<String> continentSequenceModel = new DefaultComboBoxModel<String>();
        for (int i3 = 0; i3 < ContinentSequence.sequences.length; ++i3) {
            continentSequenceModel.addElement(ContinentSequence.sequences[i3] + "     ");
        }
        this.continentSequence = new SSComboBox((ComboBoxModel)continentSequenceModel);
        this.continentSequence.addActionListener(this.changeActionListener);
        continentLayout.setConstraints(this.continentSequence, c);
        continentPanel.add(this.continentSequence);
        c = new GridBagConstraints();
        GridBagLayout gameOptionsLeftLayout = new GridBagLayout();
        JPanel gameOptionsLeftPanel = new JPanel(gameOptionsLeftLayout);
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.anchor = 11;
        gameOptionsLeftLayout.setConstraints(cardsPanel, c);
        gameOptionsLeftPanel.add(cardsPanel);
        gameOptionsLeftLayout.setConstraints(continentPanel, c);
        gameOptionsLeftPanel.add(continentPanel);
        JPanel gameOptionsRightPanel = new JPanel(new BorderLayout());
        gameOptionsRightPanel.add((Component)turnsPanel, "Center");
        gameOptionsRightPanel.add((Component)hostsPanel, "South");
        GridBagLayout gameOptionsMainLayout = new GridBagLayout();
        JPanel gameOptionsMainPanel = new JPanel(gameOptionsMainLayout);
        c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        gameOptionsMainLayout.setConstraints(gameOptionsLeftPanel, c);
        gameOptionsMainPanel.add(gameOptionsLeftPanel);
        gameOptionsMainLayout.setConstraints(gameOptionsRightPanel, c);
        gameOptionsMainPanel.add(gameOptionsRightPanel);
        GridBagLayout gameOptionsContentLayout = new GridBagLayout();
        JPanel gameOptionsContentPanel = new JPanel(gameOptionsContentLayout);
        c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        gameOptionsContentLayout.setConstraints(gameOptionsMainPanel, c);
        gameOptionsContentPanel.add(gameOptionsMainPanel);
        l = new JLabel(Translator.getString("Changestotheseoptionsonlytakeeffectinthenextgame"));
        l.setHorizontalAlignment(0);
        l.setVerticalAlignment(0);
        l.setFont(new Font(l.getFont().getFontName(), 1, 14));
        l.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        gameOptionsContentLayout.setConstraints(l, c);
        gameOptionsContentPanel.add(l);
        this.gameOptionsPanel.setAlignmentY(1.0f);
        this.gameOptionsPanel.add(gameOptionsContentPanel);
        soundPanel.setLayout(new BorderLayout());
        this.soundStartTurn = new SSCheckBox(Translator.getString("soundStartTurn"));
        this.soundActiveCountry = new SSCheckBox(Translator.getString("soundActiveCountry"));
        this.soundArmies = new SSCheckBox(Translator.getString("soundArmies"));
        this.soundExplosions = new SSCheckBox(Translator.getString("soundExplosions"));
        this.soundGameOver = new SSCheckBox(Translator.getString("soundGameOver"));
        this.soundChat = new SSCheckBox(Translator.getString("soundChat"));
        this.soundJoin = new SSCheckBox(Translator.getString("soundJoin"));
        this.soundAI = new SSCheckBox(Translator.getString("soundAI"));
        this.soundEliminated = new SSCheckBoxBinding(Translator.getString("soundEliminated"), "soundEliminated", true);
        this.soundCardCash = new SSCheckBoxBinding(Translator.getString("soundCardCash"), "soundCardCash", true);
        this.soundButtons = new SSCheckBoxBinding(Translator.getString("soundButtons"), "soundButtons", true);
        this.soundSelectCountry = new SSCheckBoxBinding(Translator.getString("soundSelectCountry"), "soundSelectCountry", true);
        this.soundTimeUp = new SSCheckBoxBinding(Translator.getString("soundTimeUp"), "soundTimeUp", true);
        this.soundStartTurn.addActionListener(this.changeActionListener);
        this.soundActiveCountry.addActionListener(this.changeActionListener);
        this.soundArmies.addActionListener(this.changeActionListener);
        this.soundExplosions.addActionListener(this.changeActionListener);
        this.soundGameOver.addActionListener(this.changeActionListener);
        this.soundChat.addActionListener(this.changeActionListener);
        this.soundJoin.addActionListener(this.changeActionListener);
        this.soundAI.addActionListener(this.changeActionListener);
        this.soundEliminated.addActionListener(this.changeActionListener);
        this.soundCardCash.addActionListener(this.changeActionListener);
        this.soundButtons.addActionListener(this.changeActionListener);
        this.soundSelectCountry.addActionListener(this.changeActionListener);
        this.soundTimeUp.addActionListener(this.changeActionListener);
        soundPanel.add((Component)this.useSound, "North");
        JPanel togglePanel = new JPanel(new GridLayout(1, 2));
        JPanel togglePanelLeft = new JPanel();
        togglePanelLeft.setLayout(new BoxLayout(togglePanelLeft, 1));
        togglePanelLeft.add(this.soundStartTurn);
        togglePanelLeft.add(this.soundSelectCountry);
        togglePanelLeft.add(this.soundActiveCountry);
        togglePanelLeft.add(this.soundArmies);
        togglePanelLeft.add(this.soundExplosions);
        togglePanelLeft.add(this.soundCardCash);
        togglePanelLeft.add(this.soundEliminated);
        togglePanelLeft.add(this.soundGameOver);
        JPanel togglePanelRight = new JPanel();
        togglePanelRight.setLayout(new BoxLayout(togglePanelRight, 1));
        togglePanelRight.add(this.soundChat);
        togglePanelRight.add(this.soundJoin);
        togglePanelRight.add(this.soundTimeUp);
        togglePanelRight.add(this.soundAI);
        togglePanelRight.add(this.soundButtons);
        togglePanel.add(togglePanelLeft);
        togglePanel.add(togglePanelRight);
        soundPanel.add((Component)new JLabel("     "), "West");
        soundPanel.add((Component)togglePanel, "Center");
        this.volumeSound = new SSSlider(0, 180);
        this.volumeSound.setMaximumSize(new Dimension(300, 1000));
        this.volumeSound.setMajorTickSpacing(30);
        this.volumeSound.setMinorTickSpacing(6);
        this.volumeSound.setPaintTicks(true);
        this.volumeSound.setSnapToTicks(false);
        this.volumeSound.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        labelTable = new Hashtable();
        sideLabel = new JLabel(Translator.getString("quiet"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.volumeSound.getMinimum()), sideLabel);
        sideLabel = new JLabel(Translator.getString("loud"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.volumeSound.getMaximum()), sideLabel);
        this.volumeSound.setLabelTable(labelTable);
        this.volumeSound.setPaintLabels(true);
        this.volumeSound.addChangeListener(this.changeChangeListener);
        JPanel volumePanel = new JPanel(new BorderLayout());
        volumePanel.add((Component)new JLabel(Translator.getString("Volume") + ":"), "North");
        volumePanel.add((Component)this.volumeSound, "Center");
        volumePanel.add((Component)new JLabel("     "), "West");
        volumePanel.add((Component)new JLabel("     "), "East");
        JPanel sliderPanel = new JPanel();
        sliderPanel.add(volumePanel);
        this.volumeMusic = new SSSlider(0, 180);
        this.volumeMusic.setMaximumSize(new Dimension(300, 1000));
        this.volumeMusic.setMajorTickSpacing(30);
        this.volumeMusic.setMinorTickSpacing(6);
        this.volumeMusic.setPaintTicks(true);
        this.volumeMusic.setSnapToTicks(false);
        this.volumeMusic.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        labelTable = new Hashtable();
        sideLabel = new JLabel(Translator.getString("quiet"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.volumeMusic.getMinimum()), sideLabel);
        sideLabel = new JLabel(Translator.getString("loud"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.volumeMusic.getMaximum()), sideLabel);
        this.volumeMusic.setLabelTable(labelTable);
        this.volumeMusic.setPaintLabels(true);
        this.volumeMusic.addChangeListener(this.changeChangeListener);
        this.volumeMusic.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Prefs.putInt("musicVolume", PreferencesWindow.this.volumeMusic.getValue());
                MusicEngine.setVolume();
            }
        });
        volumePanel = new JPanel(new BorderLayout());
        volumePanel.add((Component)new JLabel(Translator.getString("MusicVolume") + ":"), "North");
        volumePanel.add((Component)this.volumeMusic, "Center");
        volumePanel.add((Component)new JLabel("     "), "West");
        volumePanel.add((Component)new JLabel("     "), "East");
        sliderPanel.add(volumePanel);
        soundPanel.add((Component)sliderPanel, "South");
        GridBagLayout winningMessagesContentLayout = new GridBagLayout();
        JPanel winningMessagesContentPanel = new JPanel(winningMessagesContentLayout);
        c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 10.0;
        c.gridwidth = 0;
        l = new JLabel(Translator.getString("Entersomemessagestosaytootherplayerswhenyouwin") + ":");
        l.setFont(new Font(l.getFont().getFontName(), 0, 14));
        winningMessagesContentLayout.setConstraints(l, c);
        winningMessagesContentPanel.add(l);
        l = new JLabel(" ");
        winningMessagesContentLayout.setConstraints(l, c);
        winningMessagesContentPanel.add(l);
        c.gridwidth = 1;
        c.weightx = 2.0;
        l = new JLabel(" ");
        winningMessagesContentLayout.setConstraints(l, c);
        winningMessagesContentPanel.add(l);
        c.gridwidth = 0;
        c.weightx = 8.0;
        this.winningMessages = new SSTextField[7];
        JPanel winningMessagesGrid = new JPanel(new GridLayout(7, 1));
        CaretListener enableListener = new CaretListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void caretUpdate(CaretEvent e) {
                block18: {
                    block17: {
                        int index = 0;
                        for (int i = 0; i < PreferencesWindow.this.winningMessages.length; ++i) {
                            if (e.getSource() != PreferencesWindow.this.winningMessages[i]) continue;
                            index = i;
                        }
                        try {
                            if (index >= PreferencesWindow.this.winningMessages.length - 1) {
                                Object var5_5 = null;
                                break block17;
                            }
                            String text = ((SSTextField)e.getSource()).getText();
                            if (text.equals("")) {
                                if (index < PreferencesWindow.this.winningMessages.length - 2) {
                                    PreferencesWindow.this.winningMessages[index + 1].setEnabled(PreferencesWindow.this.winningMessages[index + 2].isEnabled());
                                    break block18;
                                } else {
                                    PreferencesWindow.this.winningMessages[index + 1].setEnabled(!PreferencesWindow.this.winningMessages[index + 1].getText().equals(""));
                                }
                                break block18;
                            }
                            PreferencesWindow.this.winningMessages[index + 1].setEnabled(true);
                            break block18;
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            int i = PreferencesWindow.this.winningMessages.length - 2;
                            while (true) {
                                if (i < 0) {
                                    throw throwable;
                                }
                                if (PreferencesWindow.this.winningMessages[i].getText().equals("") && PreferencesWindow.this.winningMessages[i + 1].getText().equals("")) {
                                    PreferencesWindow.this.winningMessages[i + 1].setEnabled(false);
                                } else {
                                    i = 0;
                                }
                                --i;
                            }
                        }
                    }
                    for (int i = PreferencesWindow.this.winningMessages.length - 2; i >= 0; --i) {
                        if (PreferencesWindow.this.winningMessages[i].getText().equals("") && PreferencesWindow.this.winningMessages[i + 1].getText().equals("")) {
                            PreferencesWindow.this.winningMessages[i + 1].setEnabled(false);
                            continue;
                        }
                        i = 0;
                    }
                    return;
                }
                Object var5_6 = null;
                int i = PreferencesWindow.this.winningMessages.length - 2;
                while (i >= 0) {
                    if (PreferencesWindow.this.winningMessages[i].getText().equals("") && PreferencesWindow.this.winningMessages[i + 1].getText().equals("")) {
                        PreferencesWindow.this.winningMessages[i + 1].setEnabled(false);
                    } else {
                        i = 0;
                    }
                    --i;
                }
                return;
            }
        };
        for (i = 0; i < 7; ++i) {
            this.winningMessages[i] = new SSTextField(20);
            this.winningMessages[i].addCaretListener(enableListener);
            this.winningMessages[i].addCaretListener(this.changeCaretListener);
            winningMessagesGrid.add(this.winningMessages[i]);
        }
        winningMessagesContentLayout.setConstraints(winningMessagesGrid, c);
        winningMessagesContentPanel.add(winningMessagesGrid);
        l = new JLabel(" ");
        winningMessagesContentLayout.setConstraints(l, c);
        winningMessagesContentPanel.add(l);
        c.weightx = 10.0;
        l = new JLabel(Translator.getString("Onlyusethesemessageswhenplayingwiththenickname") + ":");
        l.setFont(new Font(l.getFont().getFontName(), 0, 14));
        winningMessagesContentLayout.setConstraints(l, c);
        winningMessagesContentPanel.add(l);
        l = new JLabel(" ");
        winningMessagesContentLayout.setConstraints(l, c);
        winningMessagesContentPanel.add(l);
        c.gridwidth = 1;
        c.weightx = 2.0;
        l = new JLabel(" ");
        winningMessagesContentLayout.setConstraints(l, c);
        winningMessagesContentPanel.add(l);
        c.gridwidth = 0;
        c.weightx = 8.0;
        this.winningMessagesNick = new SSTextField(15);
        winningMessagesContentLayout.setConstraints(this.winningMessagesNick, c);
        winningMessagesContentPanel.add(this.winningMessagesNick);
        this.winningMessagesNick.addCaretListener(this.changeCaretListener);
        this.winningMessagesPanel.setAlignmentX(2.0f);
        this.winningMessagesPanel.add(winningMessagesContentPanel);
        for (i = 1; i < this.winningMessages.length; ++i) {
            this.winningMessages[i].setEnabled(false);
        }
        this.applyButton.setEnabled(false);
        if (SS.isMacintosh) {
            this.prefsFrame.setJMenuBar(LuxController.getInstance().makeCommonMenuBar(this.prefsFrame));
        }
        this.prefsFrame.pack();
    }

    public void showFrame() {
        this.getPreferences();
        this.prefsFrame.show();
        this.prefsFrame.getRootPane().setDefaultButton(this.okButton);
    }

    public static void show() {
        if (instance == null) {
            instance = new PreferencesWindow();
        }
        instance.showFrame();
    }

    public void restoreDefaultsPrefs() {
        this.updateCheck.setSelected(true);
        this.agentDelay.setValue(400);
        LuxWorld.setDelay(this.agentDelay.getValue());
        this.countryBorderWidth.setValue(7);
        LuxView.setBorderWidth(this.countryBorderWidth.getValue());
        this.perAttackDeaths.setText(Integer.toString(5));
        this.perAttackClick_once.setSelected(true);
        this.armyAdvancement_manually.setSelected(true);
        this.whenShowCards.setSelectedIndex(1);
        this.explosions.setSelectedIndex(2);
        this.oneLessArmy.setSelected(true);
        this.useSound.setSelected(true);
        this.randomStartingPlayer.setSelected(true);
        this.isRanked.setSelected(true);
        this.autoplay.setSelected(false);
        this.shuffleState.setSelectedIndex(4);
        this.turnTimerSwitch.setSelected(false);
        this.turnTimerWords.setText(Integer.toString(120));
        this.gameLimitSwitch.setSelected(false);
        this.gameLimitWords.setText(Integer.toString(45));
        this.useCards.setSelected(true);
        this.cardSequence.setSelectedIndex(3);
        this.cardTransfer.setSelected(true);
        this.immediateCardCash.setSelected(true);
        this.continentSequence.setSelectedIndex(1);
        this.soundStartTurn.setSelected(true);
        this.soundActiveCountry.setSelected(true);
        this.soundArmies.setSelected(true);
        this.soundExplosions.setSelected(true);
        this.soundGameOver.setSelected(true);
        this.soundChat.setSelected(true);
        this.soundJoin.setSelected(true);
        this.soundAI.setSelected(true);
        this.volumeSound.setValue(100);
        this.volumeMusic.setValue(100);
        SSBindingControlManager.loadDefaults();
        this.validateUI();
    }
}

