/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.EsellerateWrapper;
import com.sillysoft.lux.gui.SSNonModalOptionPane;
import com.sillysoft.lux.plugin.PluginListener;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.lux.plugin.PluginRater;
import com.sillysoft.tools.EventThread;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.RemoteImageFetcher;
import com.sillysoft.tools.RemoteImageListener;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.tools.TableSorter;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.RegisterNag;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSComboBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSLink;
import com.sillysoft.widgets.SSLinkingTextPane;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSRootPane;
import com.sillysoft.widgets.SSTable;
import com.sillysoft.widgets.SearchField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PluginWindow
implements PluginListener,
WindowListener,
RemoteImageListener {
    public static final String INSTALLED = Translator.getString("Installed");
    public static final String NOT_INSTALLED = Translator.getString("Available");
    public static final String NEW_VERSION = Translator.getString("NewVersion");
    public static final String INSTALLING = "Installing...";
    private static PluginWindow instance = null;
    private SSFrame pluginWindow;
    private static SSComboBox pluginMode;
    private SearchField pluginSearch;
    private SSTable pluginTable;
    private JTextPane pluginDescription;
    private JLabel pluginImage;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private JPanel progressBarPanel;
    private JLabel lblRate;
    private SSComboBox buttonRate;
    private SSLink linkURL;
    private SSButton buttonInstall;
    private TableSorter sorter;
    private static final String InstallString;
    private PluginManager manager = PluginManager.getInstance();
    private boolean changedRating = false;
    private static SSFrame activeFrame;

    public PluginWindow() {
        this.initGUI();
    }

    private void initGUI() {
        this.pluginWindow = new SSFrame(Translator.getString("PluginManager"));
        this.pluginWindow.setLocationID("pluginWindow");
        this.pluginWindow.setResizeID("pluginWindow");
        SSRootPane rootPane = new SSRootPane(new BorderLayout());
        rootPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.pluginWindow.setContentPane(rootPane);
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        modePanel.setLayout(new BoxLayout(modePanel, 0));
        modePanel.add(new JLabel(Translator.getString("ShowPlugins") + "    "));
        pluginMode = new SSComboBox(new String[]{Translator.getString("pluginmode1"), Translator.getString("pluginmode2"), Translator.getString("pluginmode3"), Translator.getString("pluginmode4"), Translator.getString("pluginmode5"), Translator.getString("pluginmode6"), Translator.getString("pluginmode7"), Translator.getString("pluginmode8"), Translator.getString("pluginmode9"), Translator.getString("pluginmode10"), Translator.getString("pluginmode11"), Translator.getString("pluginmode12"), Translator.getString("pluginmode13"), Translator.getString("pluginmode14"), Translator.getString("pluginmode15"), Translator.getString("pluginmode16")});
        if (SSApp.isVox) {
            pluginMode = new SSComboBox(new String[]{Translator.getString("pluginmode1"), Translator.getString("pluginmode2"), Translator.getString("pluginmode3"), Translator.getString("pluginmode4"), Translator.getString("pluginmode6"), Translator.getString("pluginmode7"), Translator.getString("pluginmode8"), Translator.getString("pluginmode9"), Translator.getString("pluginmode10"), Translator.getString("pluginmode11"), Translator.getString("pluginmode12"), Translator.getString("pluginmode15"), Translator.getString("pluginmode16")});
        }
        pluginMode.setSelectedIndex(Prefs.getInt("pluginMode", SSApp.isVox ? 2 : 0));
        pluginMode.setFocusable(false);
        pluginMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginWindow.this.pluginSearch.setText("");
                PluginWindow.this.manager.changeSet(((SSComboBox)e.getSource()).getSelectedIndex());
            }
        });
        modePanel.add(pluginMode);
        modePanel.add(Box.createHorizontalStrut(20));
        modePanel.add(Box.createHorizontalGlue());
        this.pluginSearch = new SearchField(SS.isMacintosh105 ? "" : Translator.getString("Search"));
        this.pluginSearch.setSendsNotificationForEachKeystroke(true);
        this.pluginSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginWindow.this.manager.changeSetToSearch(PluginWindow.this.pluginSearch.getText());
            }
        });
        JPanel spacer = new JPanel(new FlowLayout(2));
        spacer.add((Component)this.pluginSearch, "East");
        modePanel.add(spacer);
        rootPane.add((Component)modePanel, "North");
        this.sorter = new TableSorter("PluginWindowSortOrder", this.manager);
        this.pluginTable = new SSTable(this.sorter);
        this.pluginTable.setShowVerticalLines(false);
        this.pluginTable.setShowHorizontalLines(false);
        this.pluginTable.setShowGrid(false);
        this.pluginTable.setAlternatingRowColors();
        this.sorter.setTableHeader(this.pluginTable.getTableHeader());
        this.pluginTable.setSelectionMode(2);
        this.pluginTable.setColumnWidth(0, 200);
        this.pluginTable.setColumnWidth(1, 45);
        this.pluginTable.setColumnWidth(2, 180);
        this.pluginTable.setColumnWidth(3, 60);
        this.pluginTable.setColumnWidth(4, 85);
        this.pluginTable.setColumnWidth(5, 115);
        this.pluginTable.setColumnWidth(6, 100);
        ListSelectionModel rowSM = this.pluginTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    PluginWindow.this.selectRow(-1);
                } else {
                    int maxRow;
                    int selectedRow = lsm.getMinSelectionIndex();
                    if (selectedRow == (maxRow = lsm.getMaxSelectionIndex())) {
                        PluginWindow.this.selectRow(selectedRow);
                    } else {
                        PluginWindow.this.selectMultipleRows();
                    }
                }
            }
        });
        JScrollPane tablePane = new JScrollPane(this.pluginTable);
        tablePane.setPreferredSize(new Dimension(750, 420));
        rootPane.add((Component)tablePane, "Center");
        this.lblRate = new JLabel(Translator.getString("Ratethisplugin"));
        this.buttonRate = new SSComboBox(new String[]{"--", "1 \u2605", "2 \u2605\u2605", "3 \u2605\u2605\u2605", "4 \u2605\u2605\u2605\u2605", "5 \u2605\u2605\u2605\u2605\u2605"});
        this.buttonRate.setFocusable(false);
        this.buttonRate.setMaximumSize(new Dimension(200, 30));
        this.buttonRate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginWindow.this.manager.rateChange(PluginWindow.this.getSelectedRow(), PluginWindow.this.buttonRate.getSelectedIndex());
            }
        });
        this.buttonInstall = new SSButton(InstallString);
        this.buttonInstall.setPreferredWidth(150);
        this.buttonInstall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i;
                if ((SS.isMacintosh || SS.isWindows) && EsellerateWrapper.validRegistration("mapStart", "DE-222222-4444-5555-6666-7777-8888")) {
                    SSOptionPane.showMessageDialog("Corruption error 357.");
                    SSApp.getInstance().terminate();
                    return;
                }
                int[] rows = PluginWindow.this.getSelectedRows();
                boolean uninstall = true;
                for (i = 0; i < rows.length; ++i) {
                    if (PluginWindow.this.manager.getValueAt(rows[i], 4).equals(INSTALLED)) continue;
                    uninstall = false;
                }
                for (i = 0; i < rows.length; ++i) {
                    if (SSApp.getInstance().isDemo() && !PluginWindow.this.manager.isRowURL(rows[i])) {
                        PluginWindow.this.setProgressBar(false);
                        new RegisterNag("Marketing_Plugins.jpg", "pluginManagerInstall");
                        return;
                    }
                    PluginWindow.this.manager.installPlugin(rows[i], uninstall);
                    PluginWindow.this.buttonInstall.setEnabled(false);
                }
                PluginWindow.this.pluginTable.requestFocusInWindow();
            }
        });
        this.buttonRate.setEnabled(false);
        this.buttonInstall.setEnabled(false);
        this.linkURL = new SSLink("sillysoft.net", "Sillysoft Games");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(this.linkURL);
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(this.lblRate);
        bottomPanel.add(this.buttonRate);
        bottomPanel.add(this.buttonInstall);
        JPanel bottomPanelWithProgress = new JPanel();
        bottomPanelWithProgress.setLayout(new BoxLayout(bottomPanelWithProgress, 1));
        bottomPanelWithProgress.add(bottomPanel);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        if (this.showProgressBar()) {
            this.progressBar = new JProgressBar();
            this.progressBar.putClientProperty("JProgressBar.style", "circular");
            this.progressBar.setIndeterminate(true);
            this.progressBarPanel = new JPanel();
            this.progressBarPanel.setLayout(new BoxLayout(this.progressBarPanel, 0));
            this.progressBarPanel.add(this.progressBar);
            panel.add(this.progressBarPanel);
        }
        this.progressLabel = new JLabel("Loading the plugin data...");
        panel.add(this.progressLabel);
        panel.add(Box.createHorizontalGlue());
        bottomPanelWithProgress.add(panel);
        JPanel controlsPanel = new JPanel(new BorderLayout());
        controlsPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.pluginDescription = new SSLinkingTextPane();
        this.pluginDescription.setText(Translator.getString("Downloadingdata"));
        if (SS.isWindows) {
            this.pluginDescription.setFont(SwingTool.getGlobalFont());
        }
        this.pluginDescription.setBorder(BorderFactory.createEmptyBorder(2, 4, 0, 2));
        JScrollPane descscrollpane = new JScrollPane(this.pluginDescription);
        descscrollpane.setPreferredSize(new Dimension(600, 160));
        descscrollpane.setMaximumSize(new Dimension(6000, 220));
        JPanel controlsCenterPanel = new JPanel();
        controlsCenterPanel.setLayout(new BoxLayout(controlsCenterPanel, 1));
        controlsCenterPanel.add(descscrollpane);
        controlsPanel.add((Component)controlsCenterPanel, "Center");
        this.pluginImage = new JLabel();
        this.pluginImage.setVerticalAlignment(1);
        this.pluginImage.setHorizontalAlignment(0);
        this.pluginImage.setMaximumSize(new Dimension(190, 160));
        this.pluginImage.setMinimumSize(new Dimension(190, 160));
        this.pluginImage.setPreferredSize(new Dimension(190, 160));
        this.pluginImage.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 3));
        controlsPanel.add((Component)this.pluginImage, "West");
        controlsPanel.add((Component)bottomPanelWithProgress, "South");
        rootPane.add((Component)controlsPanel, "South");
        this.pluginWindow.addWindowListener(this);
        this.pluginWindow.setJMenuBar(SSApp.getInstance().makeCommonMenuBar(this.pluginWindow));
    }

    public void showFrame() {
        this.pluginWindow.pack();
        this.pluginTable.requestFocusInWindow();
        this.pluginWindow.show();
        this.manager.getPluginList(this);
        if (this.getSelectedRows().length == 0 && this.pluginTable.getRowCount() > 0) {
            this.pluginTable.setRowSelectionInterval(0, 0);
        }
    }

    public static void showAI() {
        PluginWindow.show();
        pluginMode.setSelectedIndex(4);
    }

    public static void show() {
        if (instance == null) {
            instance = new PluginWindow();
        }
        instance.showFrame();
    }

    public static void show(String selectName) {
        PluginWindow.show();
        EventThread.callMethod(instance, "showSetMain", selectName);
    }

    public void showSetMain(Object message) {
        String selectName = (String)message;
        this.pluginSearch.setText(selectName, true);
        this.manager.changeSetToSearch(selectName);
        this.selectRow(0);
    }

    public static PluginWindow getInstance() {
        if (instance == null) {
            instance = new PluginWindow();
        }
        return instance;
    }

    public void informUser(String info) {
        if (info == null) {
            return;
        }
        EventThread.callMethod(this, "informUserMain", info);
    }

    public void informUserMain(Object message) {
        if (this.pluginWindow == null || !this.pluginWindow.isVisible()) {
            return;
        }
        String str = message.toString();
        if (str.length() > 150) {
            this.pluginDescription.setText(str);
            this.progressLabel.setText(" ");
            this.setProgressBar(false);
        } else {
            this.progressLabel.setText(str);
        }
    }

    public static void askUserToInstallTheme(String themeName, SSFrame activeFrameWindow) {
        activeFrame = activeFrameWindow;
        System.out.println("askUserToInstallTheme: " + themeName + " - " + Thread.currentThread());
        EventThread.callMethod(PluginWindow.getInstance(), "askUserToInstallThemeMain", themeName, 500);
    }

    public void askUserToInstallThemeMain(Object themeName) {
        int result = 0;
        if (activeFrame != null) {
            result = SSOptionPane.showYesNoDialog(activeFrame, Translator.getString("NewThemeFound"), Translator.getString("newthemestart") + " '" + themeName + "' " + Translator.getString("newthemeend"));
        }
        activeFrame = null;
        if (result == 0) {
            PluginManager.getInstance().installThemeInBackground((String)themeName);
        }
    }

    public static void newPluginsAvailable(int numberOfNewPlugins, SSFrame activeFrameWindow) {
        activeFrame = activeFrameWindow;
        EventThread.callMethod(PluginWindow.getInstance(), "newPluginsAvailableMain", new Integer(numberOfNewPlugins));
    }

    public void newPluginsAvailableMain(Object count) {
        Runnable yesRunnable = new Runnable(){

            public void run() {
                PluginWindow.showNew();
            }
        };
        SSNonModalOptionPane.showYesNoDialog(Translator.getString("NewPluginsAvailable"), Translator.getString("newpluginstart") + " " + count + " " + Translator.getString("newpluginend"), yesRunnable);
        activeFrame = null;
    }

    public static void showNew() {
        PluginWindow.show();
        pluginMode.setSelectedIndex(2);
        PluginWindow.instance.sorter.setSortingsFromString("6,1;");
    }

    public void doneInstalling() {
        EventThread.callMethod(this, "doneInstallingMain");
    }

    public void doneInstallingMain() {
        int[] viewRows = this.pluginTable.getSelectedRows();
        this.manager.fireTableDataChanged();
        this.pluginTable.setRowSelection(viewRows);
        this.validateInstallButton();
    }

    public void dataReady() {
        EventThread.callMethod(this, "dataReadyMain");
    }

    public void dataReadyMain() {
        if (this.manager != null && ("".equals(this.pluginSearch.getText()) || Translator.getString("Search").equals(this.pluginSearch.getText()))) {
            this.manager.changeSet(Prefs.getInt("pluginMode", SSApp.isVox ? 2 : 0));
            if (this.getSelectedRows().length == 0 && this.pluginTable.getRowCount() > 0) {
                this.pluginTable.setRowSelectionInterval(0, 0);
            }
        }
        this.setProgressBar(false);
        this.manager.refreshRatingsCheck();
    }

    public void selectMultipleRows() {
        this.informUser(null);
        this.pluginDescription.setText(Translator.getString("Multipleselection"));
        this.buttonRate.setSelectedIndex(0);
        this.buttonRate.setEnabled(false);
        this.buttonInstall.setEnabled(true);
        this.linkURL.setText("", "");
        this.imageReady(-1, new ImageIcon(GraphicsTool.getImageFromJAR("multiple_selection.jpg")));
    }

    private void selectRow(int row) {
        this.progressLabel.setText(" ");
        this.pluginImage.setIcon(null);
        if (row == -1) {
            this.informUser(null);
            this.pluginDescription.setText(Translator.getString("Plugindescription"));
            this.buttonRate.setSelectedIndex(0);
            this.buttonRate.setEnabled(false);
            this.buttonInstall.setEnabled(false);
            this.linkURL.setText("sillysoft.net", "Sillysoft Games");
            return;
        }
        row = this.sorter.modelIndex(row);
        this.pluginDescription.setText((String)this.manager.getValueAt(row, 8));
        RemoteImageFetcher.getImage(PluginManager.base_URL + (String)this.manager.getValueAt(row, 10), row, this);
        this.validateInstallButton();
        this.buttonRate.setSelectedIndex(this.manager.getRate(row));
        this.pluginDescription.setCaretPosition(0);
        String URL2 = (String)this.manager.getValueAt(row, 7);
        if (URL2 == null || URL2.trim().equals("")) {
            this.linkURL.setText("", "");
            return;
        }
        String URLnoHTTP = URL2.substring(7);
        if (URLnoHTTP.length() > 45) {
            this.linkURL.setText(URL2, URLnoHTTP.substring(0, 43) + "...");
        } else {
            this.linkURL.setText(URL2, URLnoHTTP);
        }
    }

    private void validateInstallButton() {
        int[] rows = this.getSelectedRows();
        if (rows.length == 0) {
            this.buttonInstall.setEnabled(false);
            this.buttonRate.setEnabled(false);
            return;
        }
        if (rows.length > 1) {
            this.buttonInstall.setText(InstallString);
        } else {
            int row = rows[0];
            if (this.manager.getValueAt(row, 4).equals(INSTALLED)) {
                this.buttonInstall.setText(Translator.getString("Remove"));
            } else {
                this.buttonInstall.setText(InstallString);
            }
        }
        this.buttonInstall.setEnabled(true);
        this.buttonRate.setEnabled(true);
    }

    public void imageReady(int row, Object image) {
        int[] rows = this.getSelectedRows();
        if (rows.length > 1) {
            EventThread.callMethod(this, "imageReadyMain", new ImageIcon(GraphicsTool.getImageFromJAR("multiple_selection.jpg")));
            return;
        }
        if (row == this.getSelectedRow()) {
            EventThread.callMethod(this, "imageReadyMain", image);
        }
    }

    public void imageReadyMain(Object image) {
        try {
            this.pluginImage.setIcon((Icon)image);
        }
        catch (Exception e) {
            System.out.println("Exception displaying plugin image: " + this.manager.getValueAt(this.getSelectedRow(), 10));
        }
    }

    private int getSelectedRow() {
        int viewRow = this.pluginTable.getSelectedRow();
        if (viewRow == -1) {
            return viewRow;
        }
        return this.sorter.modelIndex(viewRow);
    }

    private int[] getSelectedRows() {
        int[] viewRow = this.pluginTable.getSelectedRows();
        if (viewRow.length == 0) {
            return viewRow;
        }
        int[] realRow = new int[viewRow.length];
        for (int i = 0; i < realRow.length; ++i) {
            realRow[i] = this.sorter.modelIndex(viewRow[i]);
        }
        return realRow;
    }

    public void windowClosing(WindowEvent e) {
        this.pluginWindow.dispose();
    }

    public void windowClosed(WindowEvent e) {
        if (!SSApp.getInstance().isDemo()) {
            PluginRater.sendRatings();
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void setProgressBar(boolean on) {
        if (this.pluginWindow == null || this.progressBar == null || !this.showProgressBar()) {
            return;
        }
        if (on) {
            if (this.progressBar.getParent() != this.progressBarPanel) {
                this.progressBarPanel.add(this.progressBar);
                this.progressBarPanel.revalidate();
            }
        } else if (this.progressBar.getParent() == this.progressBarPanel) {
            this.progressBarPanel.remove(this.progressBar);
            this.progressBarPanel.revalidate();
        }
    }

    public boolean showProgressBar() {
        return SS.isMacintosh105 || SS.isMacintosh106;
    }

    static {
        InstallString = Translator.getString("Install");
    }
}

