/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.LuxObserver;
import com.sillysoft.lux.LuxOptions;
import com.sillysoft.lux.gui.CustomTableCellRenderer;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.tools.EventThread;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.FitTableColumnsAction;
import com.sillysoft.widgets.HeaderPanel;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSHeaderCellRenderer;
import com.sillysoft.widgets.SSTable;
import com.sillysoft.widgets.ToolTipHeader;
import com.sillysoft.widgets.watermark.WatermarkViewport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class PlayerInfoController
extends AbstractTableModel
implements LuxObserver,
WindowListener,
MouseListener,
MouseMotionListener,
ComponentListener {
    private int currentPlayer = 0;
    public Vector deadPlayers = new Vector();
    public Vector playingPlayers = new Vector();
    public int alivePlayers = 0;
    public int[] playerPositions;
    GameControllerGUI control;
    LuxOptions options = null;
    SSFrame playerInfoWindow;
    SSTable playerTableView;
    JScrollPane scrollpane;
    private int numberRows;
    protected boolean slaveMode = false;
    private String lastMap;
    private boolean columsHaveBeenAutosized = false;
    private Point pressedPoint;
    private Point lastMouseDragPoint;

    public PlayerInfoController(GameControllerGUI control) {
        if (this.options != null && control.ops != this.options) {
            this.options = control.ops;
            this.reset();
        }
        this.control = control;
        this.playerInfoWindow = new SSFrame(Translator.getString("PlayerInfo"));
        this.playerInfoWindow.setLocationID("playerInfo");
        this.playerInfoWindow.setResizeID("playerInfo");
        this.playerInfoWindow.setAutoTracking(false);
        this.playerInfoWindow.addWindowListener(this);
        this.playerInfoWindow.addComponentListener(this);
        this.playerTableView = new SSTable(this);
        this.playerTableView.setDefaultRenderer(Object.class, new CustomTableCellRenderer(this, control));
        this.playerTableView.setGridColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
        WatermarkViewport viewport = new WatermarkViewport(null, null);
        viewport.setView(this.playerTableView);
        this.scrollpane = new JScrollPane();
        this.scrollpane.setViewport(viewport);
        this.scrollpane.setBorder(null);
        this.scrollpane.setOpaque(false);
        this.playerTableView.setOpaque(false);
        this.playerInfoWindow.setContentPane(this.scrollpane);
        if (SS.isMacintosh) {
            this.playerInfoWindow.setJMenuBar(control.makeJMenuBar(this.playerInfoWindow));
        }
        this.playerTableView.setColumnWidth(0, 25);
        this.playerTableView.setColumnWidth(1, 65);
        this.playerTableView.setColumnWidth(2, 50);
        this.playerTableView.setColumnWidth(3, 20);
        this.playerTableView.setColumnWidth(4, 32);
        this.playerTableView.setColumnWidth(5, 32);
        this.playerTableView.setColumnWidth(6, 25);
        this.playerTableView.addMouseListener(this);
        this.playerTableView.addMouseMotionListener(this);
        HeaderPanel panel = new HeaderPanel("pi_header_texture.png", "pi_country.png");
        this.playerTableView.getColumnModel().getColumn(3).setHeaderRenderer(new SSHeaderCellRenderer());
        this.playerTableView.getColumnModel().getColumn(3).setHeaderValue(panel);
        panel = new HeaderPanel("pi_header_texture.png", "pi_army.png");
        this.playerTableView.getColumnModel().getColumn(4).setHeaderRenderer(new SSHeaderCellRenderer());
        this.playerTableView.getColumnModel().getColumn(4).setHeaderValue(panel);
        panel = new HeaderPanel("pi_header_texture.png", "pi_income.png");
        this.playerTableView.getColumnModel().getColumn(6).setHeaderRenderer(new SSHeaderCellRenderer());
        this.playerTableView.getColumnModel().getColumn(6).setHeaderValue(panel);
        this.playerTableView.getTableHeader().revalidate();
        ToolTipHeader header = new ToolTipHeader(this.playerTableView.getColumnModel());
        String[] toolTipStr = new String[]{Translator.getString("Color"), Translator.getString("Name"), Translator.getString("AItooltip"), Translator.getString("Countries"), Translator.getString("Armies"), Translator.getString("Cards") + " : " + Translator.getString("CashValueTooltip"), Translator.getString("Income")};
        header.setToolTipStrings(toolTipStr);
        header.setToolTipText("Default ToolTip TEXT");
        this.playerTableView.setTableHeader(header);
    }

    private void setHeaderIcons() {
        ImageIcon[] icons = new ImageIcon[]{new ImageIcon(GraphicsTool.getImageFromJAR("pi_army.png")), new ImageIcon(GraphicsTool.getImageFromJAR("pi_card.png")), new ImageIcon(GraphicsTool.getImageFromJAR("pi_country2.png")), new ImageIcon(GraphicsTool.getImageFromJAR("pi_income.png"))};
        SSTable table = this.playerTableView;
        JTableHeader header2 = table.getTableHeader();
        for (int i = 0; i < 4; ++i) {
            JLabel renderer = (JLabel)((Object)table.getColumnModel().getColumn(i).getHeaderRenderer());
            if (renderer == null) continue;
            renderer.setIcon(icons[i]);
        }
    }

    public void show(GameControllerGUI control, boolean userInitiated, boolean forSlaveMode) {
        this.control = control;
        this.slaveMode = forSlaveMode;
        this.numberRows = control.ops.playerNames.length;
        this.setCurrentPlayer(control.world.getCurrentPlayer());
        int height = SwingTool.TABLE_HEADER_HEIGHT + this.numberRows * this.playerTableView.getRowHeight();
        this.scrollpane.setPreferredSize(new Dimension(360, height));
        if (!forSlaveMode) {
            if (this.lastMap != control.ops.boardName()) {
                this.placeInGoodLocation();
            }
            this.lastMap = control.ops.boardName();
            if (this.playerInfoWindow.isVisible()) {
                if (userInitiated) {
                    this.playerInfoWindow.toFront();
                    this.playerInfoWindow.pack();
                }
            } else {
                this.playerInfoWindow.pack();
                this.playerInfoWindow.show();
                if (!userInitiated) {
                    if (System.getProperty("os.version").indexOf("10.2") != -1) {
                        EventThread.callMethod(control.boardWindow, "toFront");
                    } else {
                        control.boardWindow.toFront();
                    }
                }
            }
        } else {
            this.scrollpane.revalidate();
        }
        control.viewManager.addObserver(this);
    }

    public void placeInGoodLocation() {
        SS.debug("PI.placeInGoodLocation() " + this.control.ops.boardName());
        String pointString = Prefs.get("PIw_" + this.control.ops.boardName(), null);
        if (pointString != null) {
            Point p = GraphicsTool.pointFromString(pointString);
            this.playerInfoWindow.setLocation(p.x, p.y);
            return;
        }
        int xChoice = this.control.boardWindow.getLocation().x;
        int yChoice = this.control.boardWindow.getLocation().y + this.control.boardWindow.getSize().height;
        Rectangle usableRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension screen = usableRect.getSize();
        if (yChoice + this.playerInfoWindow.getSize().height > screen.height + 40) {
            yChoice = this.control.boardWindow.getLocation().y;
            xChoice = this.control.boardWindow.getLocation().x + this.control.boardWindow.getSize().width;
        }
        if (xChoice + this.playerInfoWindow.getSize().width > screen.width) {
            xChoice = screen.width - this.playerInfoWindow.getSize().width;
        }
        this.playerInfoWindow.setLocation(xChoice, yChoice);
    }

    boolean isActive() {
        return this.control != null;
    }

    public int getRowCount() {
        return this.numberRows;
    }

    public int getColumnCount() {
        return 7;
    }

    public Object getValueAt(int row, int col) {
        try {
            int player = row;
            if (this.playerPositions != null) {
                player = this.playerPositions[row];
            }
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Human".equals(this.control.ops.playerTypes[player]) ? this.control.ops.playerNames[player] : this.control.ops.playerNames[player];
                }
                case 2: {
                    return "Human".equals(this.control.ops.playerTypes[player]) ? (SS.isMacintosh || SS.isVista ? "\u265f" : " ") : this.control.ops.playerTypes[player];
                }
                case 3: {
                    return String.valueOf(this.control.stats.getOwned(player));
                }
                case 4: {
                    return String.valueOf(this.control.stats.getArmies(player));
                }
                case 5: {
                    return String.valueOf(this.control.stats.getCards(player));
                }
                case 6: {
                    return String.valueOf(this.control.stats.getIncome(player));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return " ";
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return " ";
            }
            case 1: {
                return Translator.getString("Name");
            }
            case 2: {
                return "AI";
            }
            case 3: {
                return "Land";
            }
            case 4: {
                return "Army";
            }
            case 5: {
                if (this.control != null && this.control.ops != null) {
                    return "C:" + this.control.ops.cardSequence.getNextCardSetValue();
                }
                return "Cards";
            }
            case 6: {
                return "Income";
            }
        }
        return " ";
    }

    public Class getColumnClass(int columnIndex) {
        try {
            return this.getValueAt(1, columnIndex).getClass();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    public void setCurrentPlayer(int player) {
        this.currentPlayer = player;
        this.reloadTableData();
    }

    public int getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCountryOwner(int countryCode, int ownerCode) {
        Integer p = new Integer(ownerCode);
        if (!this.playingPlayers.contains(p)) {
            this.playingPlayers.add(p);
        }
        this.reloadTableData();
    }

    public void setCountryArmies(int countryCode, int armies) {
        this.reloadTableData();
    }

    public void gotoPlayer(int player) {
        this.setCurrentPlayer(player);
        Integer p = new Integer(this.getCurrentPlayer());
        if (!this.playingPlayers.contains(p)) {
            this.playingPlayers.add(p);
        }
        this.reloadTableData();
    }

    public void cardsWereCashed() {
        this.resetCardsColumnHeader();
        this.reloadTableData();
    }

    public void resetCardsColumnHeader() {
        if (this.control == null) {
            return;
        }
        TableColumn tc = this.playerTableView.getColumnModel().getColumn(this.playerTableView.convertColumnIndexToView(5));
        tc.setHeaderValue("C:" + this.control.ops.cardSequence.getNextCardSetValue());
        this.scrollpane.repaint();
        if (this.control.ops.cardSequence.getNextCardSetValue() > 99 && this.control.ops.cardSequence.getNextCardSetValue() < 106) {
            this.columnsResizePI();
        }
    }

    public void nextPlayer() {
    }

    public void resetPlayer() {
        SS.debug("PI.resetPlayer");
    }

    public void selectCountry(int code) {
    }

    public void explode(int code) {
    }

    public void gameOver(String endText) {
    }

    public synchronized void reset() {
        this.deadPlayers = new Vector();
        this.playingPlayers = new Vector();
        this.alivePlayers = 0;
        this.playerPositions = null;
        this.resetCardsColumnHeader();
        this.columnsResizePI();
    }

    private synchronized void reloadTableData() {
        try {
            int i;
            if (this.playerPositions == null) {
                this.playerPositions = new int[this.control.ops.playerTypes.length];
                for (i = 0; i < this.playerPositions.length; ++i) {
                    this.playerPositions[i] = 0;
                }
            }
            if (this.control.world.gameRound > 0) {
                for (i = 0; i < this.getRowCount(); ++i) {
                    Integer integer = new Integer(i);
                    if (this.deadPlayers.contains(integer) || this.control.stats.getOwned(i) != 0 || !this.playingPlayers.contains(integer)) continue;
                    this.deadPlayers.add(integer);
                }
            }
            this.alivePlayers = this.getRowCount() - this.deadPlayers.size();
            int player = 0;
            if (this.deadPlayers.size() > 0) {
                for (int row = this.getRowCount() - 1; row >= 0; --row) {
                    if (this.getRowCount() - row > this.deadPlayers.size()) continue;
                    this.playerPositions[row] = player = ((Integer)this.deadPlayers.get(this.getRowCount() - row - 1)).intValue();
                }
            }
            int offset = 0;
            for (int i2 = 0; i2 < this.alivePlayers; ++i2) {
                player = (offset + this.getCurrentPlayer()) % this.getRowCount();
                while (this.deadPlayers.contains(new Integer(player))) {
                    player = (++offset + this.getCurrentPlayer()) % this.getRowCount();
                }
                this.playerPositions[i2] = player;
                ++offset;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableDataChanged();
    }

    void kill() {
        this.playerInfoWindow.hide();
        SwingTool.destroyMenu(this.playerInfoWindow.getJMenuBar());
        this.playerInfoWindow.setJMenuBar(null);
        this.playerInfoWindow.setMenuBar(null);
        this.playerInfoWindow.setContentPane(new JPanel());
        this.playerInfoWindow.removeWindowListener(this);
        this.playerInfoWindow.removeComponentListener(this);
        this.playerInfoWindow.dispose();
        this.playerInfoWindow = null;
        this.playerTableView.setDefaultRenderer(Object.class, null);
        this.playerTableView = null;
        this.control = null;
    }

    public void hide() {
        this.playerInfoWindow.hide();
        this.windowClosing(null);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.windowClosing(e);
    }

    public void windowClosing(WindowEvent e) {
        if (this.control != null && this.control.viewManager != null) {
            this.control.viewManager.removeObserver(this);
        }
        this.control = null;
        Prefs.putBoolean("playerInfoOpen", false);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public JComponent getViewAndEnterSlaveMode() {
        this.playerInfoWindow.hide();
        this.scrollpane.setFocusable(false);
        this.scrollpane.setVerticalScrollBarPolicy(21);
        this.playerTableView.setFocusable(false);
        this.playerTableView.setDragEnabled(false);
        this.playerTableView.setRowSelectionAllowed(false);
        this.playerTableView.setColumnSelectionAllowed(false);
        this.control.viewManager.addObserver(this);
        this.playerInfoWindow.setContentPane(new JPanel());
        if (!this.columsHaveBeenAutosized) {
            this.columsHaveBeenAutosized = true;
            this.playerTableView.setColumnWidth(0, 20);
            this.playerTableView.setColumnWidth(1, 65);
            this.playerTableView.setColumnWidth(2, 50);
            this.playerTableView.setColumnWidth(3, 20);
            this.playerTableView.setColumnWidth(4, 32);
            this.playerTableView.setColumnWidth(5, 35);
            this.playerTableView.setColumnWidth(6, 25);
        }
        this.scrollpane.setSize(284, SwingTool.TABLE_HEADER_HEIGHT + 16 * this.numberRows);
        this.slaveMode = true;
        return this.scrollpane;
    }

    public void exitSlaveMode() {
        this.playerInfoWindow.setContentPane(this.scrollpane);
        this.slaveMode = false;
    }

    public void mousePressed(MouseEvent e) {
        this.lastMouseDragPoint = this.pressedPoint = e.getPoint();
        Point loc_in_parent = this.scrollpane.getLocation();
        this.lastMouseDragPoint.translate(loc_in_parent.x, loc_in_parent.y);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            SS.debug("collapse the PI");
            this.control.toggleShowPlayerInfo();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        Point loc_in_parent = this.scrollpane.getLocation();
        e.translatePoint(loc_in_parent.x, loc_in_parent.y);
        int xoffset = e.getX() - this.lastMouseDragPoint.x;
        int yoffset = e.getY() - this.lastMouseDragPoint.y;
        this.control.luxView.moveInfoPanel(xoffset, yoffset);
        this.lastMouseDragPoint.setLocation(this.lastMouseDragPoint.getX() + (double)xoffset, this.lastMouseDragPoint.getY() + (double)yoffset);
    }

    public boolean isVisibleWindow() {
        return this.playerInfoWindow != null && this.playerInfoWindow.isVisible();
    }

    public boolean isFrontWindow() {
        SS.debug("isFrontWindow(): " + this.playerTableView.hasFocus() + "--" + this.scrollpane.hasFocus());
        return this.playerInfoWindow != null && (this.playerTableView.hasFocus() || this.scrollpane.hasFocus());
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
        SS.debug("PI.window.componentMoved " + e);
        Prefs.put("PIw_" + this.control.ops.boardName(), GraphicsTool.stringFromPoint(this.playerInfoWindow.getLocation()));
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        SS.debug("PI.window.componentShown " + e);
        this.resetCardsColumnHeader();
    }

    public void columnsResizePI() {
        int usewidth = this.playerTableView.getWidth();
        if (usewidth == 0 || this.slaveMode) {
            usewidth = 280;
        }
        new FitTableColumnsAction(this.playerTableView, usewidth).run();
    }
}

