/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.LuxWorld;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.PreferencesWindow;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.AquaButton;
import com.sillysoft.widgets.MusicEngine;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSLabel;
import com.sillysoft.widgets.SSSlider;
import com.sillysoft.widgets.SoundEffect;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MenuViewOptions
extends JPanel
implements MouseListener,
KeyListener {
    SSFrame boardWindow;
    Container oldContentPane;
    GameControllerGUI control;

    public MenuViewOptions(SSFrame window, GameControllerGUI control) {
        this.setBackground(Color.BLACK);
        this.boardWindow = window;
        this.control = control;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        int menuItems = 8;
        int buttonWidth = control.luxView.mapWidth - 200;
        int buttonHeight = (control.luxView.mapHeight - 300) / menuItems;
        int bufferHeight = 100;
        buttonPanel.add(Box.createVerticalStrut(bufferHeight));
        AquaButton button = new AquaButton(false, buttonWidth, buttonHeight, "Continue Game", 0, GameControllerGUI.buttonColor);
        button.setAlignmentX(0.5f);
        button.setIcon("/continue.png", "/continueHOT.png");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuViewOptions.this.continueGame();
                MenuViewOptions.this.cleanUp();
            }
        });
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalStrut(5));
        button = new AquaButton(false, buttonWidth, buttonHeight, "Auto-Advance Armies", Prefs.getInt("armyAdvancement", 0) == 1, 0, GameControllerGUI.buttonColor);
        button.setAlignmentX(0.5f);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Prefs.getInt("armyAdvancement", 0) == 0) {
                    Prefs.putInt("armyAdvancement", 1);
                } else {
                    Prefs.putInt("armyAdvancement", 0);
                }
            }
        });
        buttonPanel.add(button);
        JLabel tipLabel = new JLabel("     Hold SHIFT to change Auto-Advance on the fly.");
        tipLabel.setForeground(Color.WHITE);
        tipLabel.setFont(new Font(tipLabel.getFont().getName(), 1, tipLabel.getFont().getSize()));
        tipLabel.setAlignmentX(0.5f);
        buttonPanel.add(tipLabel);
        buttonPanel.add(Box.createVerticalStrut(5));
        button = new AquaButton(false, buttonWidth, buttonHeight, "Attack-Till-Dead", Prefs.getInt("perAttackClick", 0) == 2, 0, GameControllerGUI.buttonColor);
        button.setAlignmentX(0.5f);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (Prefs.getInt("perAttackClick", 0) == 2) {
                    Prefs.putInt("perAttackClick", 0);
                } else {
                    Prefs.putInt("perAttackClick", 2);
                }
            }
        });
        buttonPanel.add(button);
        tipLabel = new JLabel("     Hold CONTROL to change Attack-till-Dead on the fly.");
        tipLabel.setForeground(Color.WHITE);
        tipLabel.setFont(new Font(tipLabel.getFont().getName(), 1, tipLabel.getFont().getSize()));
        tipLabel.setAlignmentX(0.5f);
        buttonPanel.add(tipLabel);
        buttonPanel.add(Box.createVerticalStrut(5));
        button = new AquaButton(false, buttonWidth, buttonHeight, "Fullscreen", control.fullscreen, 0, GameControllerGUI.buttonColor);
        button.setAlignmentX(0.5f);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuViewOptions.this.toggleFullscreen();
            }
        });
        buttonPanel.add(button);
        int fontSize = (int)((double)buttonHeight * 0.8);
        final SSSlider musicVolume = new SSSlider(0, 180);
        musicVolume.setOpaque(false);
        musicVolume.setValue(Prefs.getInt("musicVolume", 70));
        musicVolume.setMaximumSize(new Dimension(330, 1000));
        musicVolume.setMajorTickSpacing(30);
        musicVolume.setMinorTickSpacing(10);
        musicVolume.setPaintTicks(true);
        musicVolume.setSnapToTicks(false);
        musicVolume.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        Hashtable<Integer, SSLabel> labelTable = new Hashtable<Integer, SSLabel>();
        labelTable.put(new Integer(musicVolume.getMinimum()), new SSLabel(Translator.getString("off"), Color.WHITE));
        labelTable.put(new Integer(musicVolume.getMaximum()), new SSLabel(Translator.getString("loud"), Color.WHITE));
        musicVolume.setLabelTable(labelTable);
        musicVolume.setPaintLabels(true);
        musicVolume.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Prefs.putInt("musicVolume", musicVolume.getValue());
                MusicEngine.setVolume();
            }
        });
        JLabel sliderLabel = new JLabel("Music:  ");
        sliderLabel.setForeground(GameControllerGUI.buttonColor);
        sliderLabel.setFont(AquaButton.getFontSized(fontSize));
        JPanel sliderPanel = new JPanel(new FlowLayout(0));
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 0));
        sliderPanel.setOpaque(false);
        sliderPanel.add(sliderLabel);
        sliderPanel.add(musicVolume);
        buttonPanel.add(sliderPanel);
        final SSSlider soundVolume = new SSSlider(0, 180);
        soundVolume.setOpaque(false);
        soundVolume.setValue(Prefs.getInt("volume", 100));
        soundVolume.setMaximumSize(new Dimension(330, 1000));
        soundVolume.setMajorTickSpacing(30);
        soundVolume.setMinorTickSpacing(10);
        soundVolume.setPaintTicks(true);
        soundVolume.setSnapToTicks(false);
        soundVolume.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        soundVolume.setAlignmentY(0.5f);
        labelTable = new Hashtable();
        labelTable.put(new Integer(soundVolume.getMinimum()), new SSLabel(Translator.getString("off"), Color.WHITE));
        labelTable.put(new Integer(soundVolume.getMaximum()), new SSLabel(Translator.getString("loud"), Color.WHITE));
        soundVolume.setLabelTable(labelTable);
        soundVolume.setPaintLabels(true);
        soundVolume.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SS.debug("Set sound effect volume to be " + (double)soundVolume.getValue() / 100.0);
                Prefs.putInt("volume", soundVolume.getValue());
                SoundEffect.setSoundVolume((double)soundVolume.getValue() / 100.0);
                PrefsCache.reloadStatics();
            }
        });
        sliderLabel = new JLabel("Sound:  ");
        sliderLabel.setForeground(GameControllerGUI.buttonColor);
        sliderLabel.setFont(AquaButton.getFontSized(fontSize));
        sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 0));
        sliderPanel.setOpaque(false);
        sliderPanel.add(sliderLabel);
        sliderPanel.add(soundVolume);
        sliderPanel.setAlignmentX(0.5f);
        buttonPanel.add(sliderPanel);
        buttonPanel.add(Box.createVerticalStrut(5));
        final SSSlider computerSpeed = new SSSlider(10, 1010);
        computerSpeed.setOpaque(false);
        computerSpeed.setValue(Prefs.getInt("agentDelay", 400));
        computerSpeed.setMaximumSize(new Dimension(330, 1000));
        computerSpeed.setMajorTickSpacing(150);
        computerSpeed.setMinorTickSpacing(50);
        computerSpeed.setPaintTicks(true);
        computerSpeed.setSnapToTicks(false);
        computerSpeed.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        labelTable = new Hashtable();
        labelTable.put(new Integer(computerSpeed.getMinimum()), new SSLabel(Translator.getString("fast"), Color.WHITE));
        labelTable.put(new Integer(computerSpeed.getMaximum()), new SSLabel(Translator.getString("slow"), Color.WHITE));
        computerSpeed.setLabelTable(labelTable);
        computerSpeed.setPaintLabels(true);
        computerSpeed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Prefs.putInt("agentDelay", computerSpeed.getValue());
                LuxWorld.setDelay(computerSpeed.getValue());
            }
        });
        sliderLabel = new JLabel("Speed:  ");
        sliderLabel.setForeground(GameControllerGUI.buttonColor);
        sliderLabel.setFont(AquaButton.getFontSized(fontSize));
        sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 0));
        sliderPanel.setOpaque(false);
        sliderPanel.add(sliderLabel);
        sliderPanel.add(computerSpeed);
        sliderPanel.setAlignmentX(0.5f);
        buttonPanel.add(sliderPanel);
        button = new AquaButton(false, buttonWidth, buttonHeight, Translator.getString("MoreOptions"), 0, GameControllerGUI.buttonColor);
        button.setAlignmentX(0.5f);
        button.setIcon("/options.png", "/optionsHOT.png");
        final GameControllerGUI controlF = control;
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!SS.isMacintosh && controlF.fullscreen) {
                    MenuViewOptions.this.toggleFullscreen();
                }
                PreferencesWindow.show();
            }
        });
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(Box.createVerticalStrut(bufferHeight));
        this.setLayout(new BoxLayout(this, 0));
        int bufferWidth = Math.max(0, (control.luxView.mapWidth - buttonWidth) / 2);
        this.add(Box.createHorizontalStrut(bufferWidth));
        this.add(buttonPanel);
        this.add(Box.createHorizontalStrut(bufferWidth));
        this.add(Box.createHorizontalGlue());
    }

    public void takeControl(Container oldContentPane) {
        this.oldContentPane = oldContentPane;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setMaximumSize(new Dimension(this.control.luxView.mapWidth, this.control.luxView.mapHeight));
        this.setPreferredSize(new Dimension(this.control.luxView.mapWidth, this.control.luxView.mapHeight));
        JPanel contentPane = new JPanel();
        contentPane.setBackground(Color.BLACK);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this);
        this.boardWindow.setContentPane(contentPane);
        this.boardWindow.validate();
        this.repaint();
        this.requestFocus();
    }

    public void continueGame() {
        this.boardWindow.setContentPane(this.oldContentPane);
        this.boardWindow.validate();
        this.control.luxView.requestFocus();
    }

    public void toggleFullscreen() {
        this.continueGame();
        this.control.toggleFullscreen();
        this.boardWindow = this.control.boardWindow;
        this.boardWindow.validate();
        new MenuViewOptions(this.boardWindow, this.control).takeControl(this.oldContentPane);
        this.cleanUp();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.continueGame();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void paintComponent(Graphics badg) {
        Graphics2D g = (Graphics2D)badg;
        this.control.luxView.paintComponent(g);
        g.setColor(new Color(0, 0, 0, 200));
        g.fill(g.getClipBounds());
    }

    private void cleanUp() {
        this.oldContentPane = null;
        this.boardWindow = null;
        this.control = null;
        this.removeKeyListener(this);
    }
}

