/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.widgets.AquaButton;
import com.sillysoft.widgets.SSFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

public class MenuViewHelp
extends JPanel
implements MouseListener,
KeyListener {
    SSFrame boardWindow;
    Container oldContentPane;
    GameControllerGUI control;
    private int pageNumber = 0;

    public MenuViewHelp(SSFrame window, GameControllerGUI control) {
        this.setBackground(Color.BLACK);
        this.boardWindow = window;
        this.control = control;
        int buttonWidth = 350;
        int buttonHeight = 50;
        AquaButton buttonContinue = new AquaButton(false, buttonWidth, buttonHeight, "Continue Game", 0, GameControllerGUI.buttonColor);
        buttonContinue.setAlignmentX(0.5f);
        buttonContinue.setIcon("/continue.png", "/continueHOT.png");
        buttonContinue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuViewHelp.this.continueGame();
                MenuViewHelp.this.cleanUp();
            }
        });
        AquaButton buttonNext = new AquaButton(false, buttonWidth, buttonHeight, "Next Page", 0, GameControllerGUI.buttonColor);
        buttonNext.setAlignmentX(0.5f);
        buttonNext.setIcon("/instructions.png", "/instructionsHOT.png");
        buttonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuViewHelp.this.pageForward();
                MenuViewHelp.this.repaint();
            }
        });
        this.setLayout(null);
        int midpoint = control.luxView.mapWidth / 2;
        buttonContinue.setLocation(midpoint - 350, 460);
        this.add(buttonContinue);
        buttonNext.setLocation(midpoint + 50, 460);
        this.add(buttonNext);
    }

    public void takeControl(Container oldContentPane) {
        this.oldContentPane = oldContentPane;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setMaximumSize(new Dimension(this.control.luxView.mapWidth, this.control.luxView.mapHeight));
        this.setSize(new Dimension(this.control.luxView.mapWidth, this.control.luxView.mapHeight));
        this.setPreferredSize(new Dimension(this.control.luxView.mapWidth, this.control.luxView.mapHeight));
        int screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.boardWindow.setContentPane(this);
        this.boardWindow.validate();
        this.repaint();
        this.requestFocus();
    }

    public void continueGame() {
        this.boardWindow.setContentPane(this.oldContentPane);
        this.boardWindow.validate();
        this.control.luxView.requestFocus();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.continueGame();
        } else if (e.getKeyCode() == 39) {
            this.pageForward();
            this.repaint();
        } else if (e.getKeyCode() == 37) {
            this.pageBack();
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void paintComponent(Graphics badg) {
        Graphics2D g = (Graphics2D)badg;
        this.control.luxView.paintComponent(g);
        g.setColor(new Color(0, 0, 0, 200));
        g.fill(g.getClipBounds());
        int x = this.control.luxView.mapWidth / 2 - 500;
        g.drawImage(GraphicsTool.getImageFromJAR("Instructions_P" + this.pageNumber + (this.pageNumber == 3 ? (SS.isMacintosh ? "MAC" : "WIN") : "") + ".png"), x, 0, null);
    }

    private void cleanUp() {
        this.oldContentPane = null;
        this.boardWindow = null;
        this.control = null;
        this.removeKeyListener(this);
    }

    private void pageForward() {
        this.pageNumber = (this.pageNumber + 1) % 4;
    }

    private void pageBack() {
        --this.pageNumber;
        if (this.pageNumber < 0) {
            this.pageNumber = 3;
        }
    }
}

