/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.MenuViewHelp;
import com.sillysoft.lux.gui.MenuViewOptions;
import com.sillysoft.tools.SS;
import com.sillysoft.widgets.AquaButton;
import com.sillysoft.widgets.SSFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class MenuView
extends JPanel
implements MouseListener,
KeyListener {
    SSFrame boardWindow;
    Container oldContentPane;
    GameControllerGUI control;
    private AquaButton saveButton;

    public MenuView(SSFrame window, GameControllerGUI control) {
        this.setBackground(Color.BLACK);
        this.boardWindow = window;
        this.control = control;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        int buttonWidth = control.luxView.mapWidth - 200;
        int menuItems = 8;
        int buttonHeight = (control.luxView.mapHeight - 100) / menuItems;
        int bufferHeight = 100;
        buttonPanel.add(Box.createVerticalStrut(bufferHeight));
        AquaButton button = new AquaButton(false, buttonWidth, buttonHeight, "Continue Game", 0, GameControllerGUI.buttonColor);
        button.setIcon("/continue.png", "/continueHOT.png");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuView.this.continueGame();
            }
        });
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalStrut(5));
        button = new AquaButton(false, buttonWidth, buttonHeight, "Restart Map", 0, GameControllerGUI.buttonColor);
        button.setIcon("/restart.png", "/restartHOT.png");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuView.this.restart();
                MenuView.this.cleanUp();
            }
        });
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalStrut(5));
        button = new AquaButton(false, buttonWidth, buttonHeight, "Instructions", 0, GameControllerGUI.buttonColor);
        button.setIcon("/instructions.png", "/instructionsHOT.png");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuView.this.showHelp();
                MenuView.this.cleanUp();
            }
        });
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalStrut(5));
        button = new AquaButton(false, buttonWidth, buttonHeight, "Save Game", 0, GameControllerGUI.buttonColor);
        button.setIcon("/save.png", "/saveHOT.png");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuView.this.saveGame();
            }
        });
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalStrut(5));
        this.saveButton = button;
        button = new AquaButton(false, buttonWidth, buttonHeight, "Exit Game", 0, GameControllerGUI.buttonColor);
        button.setIcon("/exit.png", "/exitHOT.png");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuView.this.exitGame();
                MenuView.this.cleanUp();
            }
        });
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalStrut(5));
        button = new AquaButton(false, buttonWidth, buttonHeight, "Options", 0, GameControllerGUI.buttonColor);
        button.setIcon("/options.png", "/optionsHOT.png");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuView.this.optionsMenu();
                MenuView.this.cleanUp();
            }
        });
        buttonPanel.add(button);
        buttonPanel.add(Box.createVerticalStrut(5));
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(Box.createVerticalStrut(bufferHeight));
        buttonPanel.add(Box.createVerticalGlue());
        this.setLayout(new BoxLayout(this, 0));
        int bufferWidth = Math.max(0, (control.luxView.mapWidth - buttonWidth) / 2);
        this.add(Box.createHorizontalStrut(bufferWidth));
        this.add(buttonPanel);
        this.add(Box.createHorizontalStrut(bufferWidth));
        this.setFocusable(true);
        this.addKeyListener(this);
    }

    public void takeControl() {
        this.oldContentPane = this.boardWindow.getContentPane();
        SS.debug("MenuView setting oldContentPane = " + this.oldContentPane);
        this.setMaximumSize(new Dimension(this.control.luxView.mapWidth, this.control.luxView.mapHeight));
        this.setPreferredSize(new Dimension(this.control.luxView.mapWidth, this.control.luxView.mapHeight));
        JPanel contentPane = new JPanel();
        contentPane.setBackground(Color.BLACK);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this);
        this.boardWindow.setContentPane(contentPane);
        this.boardWindow.validate();
        this.repaint();
        this.requestFocus();
    }

    public void continueGame() {
        this.boardWindow.setContentPane(this.oldContentPane);
        this.boardWindow.validate();
        this.control.luxView.requestFocus();
    }

    public void restart() {
        this.continueGame();
        this.control.clickReplayMap();
    }

    public void nextMap() {
        this.continueGame();
        this.control.clickNextMap();
    }

    public void saveGame() {
        if (this.control.saveGame()) {
            String title = this.control.ops.boardTitle();
            if (title.length() > 14) {
                title = title.substring(0, 14) + "..";
            }
            this.saveButton.setText("Saved as: " + title + " round " + this.control.world.gameRound);
            this.saveButton.revalidate();
            this.saveButton.repaint();
        }
    }

    public void exitGame() {
        this.control.kill(this.control);
    }

    public void toggleFullscreen() {
        this.continueGame();
        this.control.toggleFullscreen();
        this.control.showMenuInline();
    }

    public void showHelp() {
        new MenuViewHelp(this.boardWindow, this.control).takeControl(this.oldContentPane);
    }

    public void optionsMenu() {
        new MenuViewOptions(this.boardWindow, this.control).takeControl(this.oldContentPane);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.continueGame();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.continueGame();
        }
    }

    public boolean isFocusable() {
        return true;
    }

    public void paintComponent(Graphics badg) {
        Graphics2D g = (Graphics2D)badg;
        this.control.luxView.paintComponent(g);
        g.setColor(new Color(0, 0, 0, 200));
        g.fill(g.getClipBounds());
    }

    private void cleanUp() {
        this.oldContentPane = null;
        this.boardWindow = null;
        this.control = null;
        this.removeKeyListener(this);
    }
}

