/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.EnterCodeWindow;
import com.sillysoft.lux.gui.UpdateController;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class MarketingScreen {
    private SSFrame theFrame;
    private SSButton defaultButton = null;

    public static void show(String messageKey, String statsKey, SSApplicationGUI luxconBridge) {
        MarketingScreen.show(messageKey, statsKey, luxconBridge.getSharewareCount() > 9, luxconBridge);
    }

    public static void show(String messageKey, String statsKey, boolean defaultIsBuy, SSApplicationGUI luxconBridge) {
        if ("plugins".equals(messageKey)) {
            new MarketingScreen("marketing_plugins", 520, 380, statsKey, defaultIsBuy, luxconBridge);
        } else if ("online".equals(messageKey)) {
            new MarketingScreen("marketing_online", 700, 270, statsKey, defaultIsBuy, luxconBridge);
        } else if ("online_vox".equals(messageKey)) {
            new MarketingScreen("marketing_online", 500, 200, statsKey, defaultIsBuy, luxconBridge);
        }
    }

    private MarketingScreen(String htmlMessage, int width, int height, String statsKey, boolean defaultIsBuy, SSApplicationGUI luxconBridge) {
        SSButton middleButton;
        SSButton ignoreButton;
        SSButton registerButton;
        SSButton secondButton;
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        if (defaultIsBuy) {
            this.defaultButton = new SSButton(Translator.getString("RegisterLuxNow"));
            secondButton = new SSButton(Translator.getString("NoThanks"));
            registerButton = this.defaultButton;
            ignoreButton = secondButton;
            middleButton = new SSButton(Translator.getString("EnterCodeShort"));
        } else {
            this.defaultButton = new SSButton(Translator.getString("LetMePlay"));
            registerButton = secondButton = new SSButton(Translator.getString("RegisterLuxNow"));
            ignoreButton = this.defaultButton;
            middleButton = new SSButton(Translator.getString("EnterCodeShort"));
        }
        ignoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MarketingScreen.this.theFrame.hide();
            }
        });
        JPanel secondButtonPanel = new JPanel();
        secondButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 0));
        secondButtonPanel.add(secondButton);
        buttonPanel.add(secondButtonPanel);
        middleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EnterCodeWindow.show(SSApp.getInstance());
            }
        });
        JPanel middleButtonPanel = new JPanel();
        middleButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        middleButtonPanel.add(middleButton);
        buttonPanel.add(middleButtonPanel);
        final String finalStatsKey = statsKey;
        registerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.gotoBuy(finalStatsKey);
                MarketingScreen.this.theFrame.hide();
            }
        });
        JPanel defaultButtonPanel = new JPanel();
        defaultButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 20));
        defaultButtonPanel.add(this.defaultButton);
        buttonPanel.add(defaultButtonPanel);
        contentPanel.setBorder(null);
        buttonPanel.setBorder(null);
        contentPanel.add((Component)this.createEditorPane(htmlMessage, width, height), "North");
        contentPanel.add((Component)buttonPanel, "South");
        this.theFrame = new SSFrame(Translator.getString("UnlimitedFunAwaitsYou"));
        this.theFrame.setLocationID(htmlMessage);
        this.theFrame.setContentPane(contentPanel);
        this.theFrame.setDefaultCloseOperation(2);
        this.theFrame.setResizable(true);
        if (SS.isMacintosh) {
            this.theFrame.setJMenuBar(luxconBridge.makeCommonMenuBar(this.theFrame));
        }
        this.theFrame.pack();
        this.theFrame.show();
        this.theFrame.getRootPane().setDefaultButton(this.defaultButton);
    }

    private JEditorPane createEditorPane(String htmlMessage, int width, int height) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setFocusable(false);
        editorPane.setBorder(null);
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        editorPane.setPreferredSize(new Dimension(width, height));
        URL helpURL = MarketingScreen.class.getResource("/" + Translator.getString(htmlMessage + ".html"));
        if (helpURL != null) {
            try {
                editorPane.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
        } else {
            System.err.println("Couldn't find file: " + htmlMessage + ".html");
        }
        return editorPane;
    }
}

