/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.Biohazard;
import com.sillysoft.lux.Card;
import com.sillysoft.lux.LuxObserver;
import com.sillysoft.lux.gui.AnimationLoader;
import com.sillysoft.lux.gui.FlashTask;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.Tickable;
import com.sillysoft.lux.gui.Ticker;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.ExtraLine;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.AquaButton;
import com.sillysoft.widgets.MultiLineToolTip;
import com.sillysoft.widgets.SoundEffect;
import com.sillysoft.widgets.VisualsNotice;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class LuxView
extends JPanel
implements LuxObserver,
Tickable,
MouseListener,
MouseMotionListener,
KeyListener {
    public int mapWidth;
    public int mapHeight;
    private List notices;
    private static SoundEffect activeCountrySound;
    private static SoundEffect selectCountrySound;
    private static SoundEffect gameOverSound;
    private static SoundEffect[] explosionSounds;
    String helperText;
    private GeneralPath[] shapes;
    private Rectangle[] shapeBounds;
    private int[] contCodes;
    private int[] ownerCode;
    private int[] armies;
    private String[] countryNames;
    private Point[] armyLocation;
    private boolean[] redrawMemory;
    public static Font arial12;
    public static Font arial24;
    public static Font arial36;
    public static Font lucida13;
    public static Font sansSerifBold12;
    public static Font sansSerif24;
    GameControllerGUI control;
    private Image background;
    private Image foreground;
    private Image overground;
    private boolean customForeground;
    private Color linesColor;
    private String gameOverText;
    private boolean cardsMode;
    private Card[] cards;
    private String[] cardName;
    private Point[] cardPoint;
    private Rectangle[] cardRect;
    private boolean[] cardHighlight;
    private boolean[] wildCard;
    private boolean inCardsPhase;
    private Image[] normalCards;
    private Image[] hilightedCards;
    private static Dimension cardSize;
    private int selectedCountry;
    private Timer flashTimer;
    private int otherTime;
    private boolean flashingColorAlphaDescending;
    private float flashingColorAlpha = 0.0f;
    private Color flashingColor;
    private Color[] colors;
    private Image[] bubble1;
    private Image[] bubble2;
    private Image[] bubble3;
    private Image[] bubble4;
    private Image[] bubble5;
    private Image[] armyGuy1;
    private Image[] armyGuy2;
    private Image[] armyGuy3;
    private Image[] armyGuy4;
    private Image[] armyGuy5;
    private Image[] armyGuy6;
    private Image[] armyGuy7;
    private Image[] armyGuy8;
    private Image[] armyGuy9;
    private int currentArmySet = -1;
    private Color[] contColors;
    private Color contBorderColor;
    private Rectangle[] contBounds;
    private String[] contName;
    private Point[] contLabelLocation;
    private Vector lines;
    private Vector aboveLines;
    private String loadText;
    private Rectangle oneDigitRect;
    private Rectangle twoDigitRect;
    private Rectangle threeDigitRect;
    private int cardPlus;
    private float shapeAlpha = 0.71f;
    private float borderAlpha = 0.77f;
    private float outlineAlpha = 0.44f;
    private int borderWidth;
    private int outlineWidth;
    private ImageIcon[] fillerImages;
    private boolean placedFiller;
    private Point2D[] fillerPoints;
    private Random rand;
    private static String waitingForHost;
    public static SoundEffect turnExpiredSound;
    private static List luxViews;
    private static String[] preModifiers;
    private static String[] starts;
    private static String[] ends;
    private static String[] postModifiers;
    private static Image[][] explosionFramesArrays;
    private static int[] animationFrameNumber;
    private static Dimension[] animationFrameSize;
    private int explosionsLeft;
    private Point[] animationPoint;
    private int[] animationFrameCount;
    private int[] animationNumber;
    public static String bonusString;
    protected boolean hideBonusLabels = false;
    protected boolean hideTips = false;
    private String currentTheme;
    private String desiredTheme;
    Rectangle2D bigRect;
    private int framecount = 0;
    private Object dirtyRectLock = new Object();
    private Rectangle dirtyRect = null;
    private BufferedImage mapBackground;
    private BufferedImage mapBackgroundCards;
    boolean drawInfoPanel = false;
    JComponent infoPanel;
    public int currentFPS = 0;
    public int FPS = 0;
    public long startFPScounter = 0L;
    private boolean tutorialContinentMode = true;
    private boolean continentMode = false;
    public static String helpBegin;
    public static String helpEnd;
    private int scrollingState = 0;
    private int placingKey = 0;
    private int divisionTotalOriginal = 0;
    private int usedPlacedDividerKeyCount = 0;
    private boolean usedPlacedDividerKey = false;
    private int arrowFromCountry = -1;
    private int arrowToCountry = -1;
    private int[] arrowToCountryArray;
    private boolean arrowDoubleEnded = false;
    private boolean resizeOnLoad;
    protected double resizePercent = 1.0;
    StringBuffer keyPressedBuffer = new StringBuffer();
    private Hashtable keysDown = new Hashtable();
    private Point lastMousePoint;
    private int mouseOverCountry = -1;
    private int[] mouseOverCountryConnected;
    private Image winningImage;
    List flashContinents = new ArrayList();
    float flashContinentAlpha;
    int flashContinentOwner;
    private static Cursor arrowCursor;

    public LuxView(GameControllerGUI con) {
        this.setBackground(Color.BLACK);
        this.setLoadText(Translator.getString("CreatingTheGame"));
        this.control = con;
    }

    public void init() {
        this.setLayout(null);
        this.borderWidth = Prefs.getInt("countryBorderWidth", 7);
        this.outlineWidth = (int)((double)this.borderWidth * 1.4285714285714286);
        if (helpBegin == null) {
            this.setLoadText("loading static data");
            cardSize = new Dimension(170, 120);
            helpBegin = Translator.getString("sTurnBefore");
            helpEnd = Translator.getString("sTurn");
            waitingForHost = Translator.getString("waitingforhost");
            preModifiers = new String[]{"New ", "Old ", "Upper ", "Lower ", "Republic of ", "United ", "East ", "West ", "North ", "South ", "Free "};
            starts = new String[]{"Uz", "Cyp", "Can", "Lat", "Russ", "Mex", "Per", "Braz", "Slov", "Chin", "Jap", "Cauc", "Green", "Is", "Proc", "Ken", "Con", "Afr", "Aus", "Ore", "Ark", "Flon", "Vir", "Qu\u00e9b", "R\u00fct", "S\u00f8r", "Ital", "Spok", "Khaz", "Djib", "Chech", "Kol", "Mus", "Cthon", "Q", "El"};
            ends = new String[]{"ica", "aq", "ane", "\u00e9", "ubi", "go", "an", "a", "il", "land", "ya", "ia", "ico", "stan", "istan", "ada", "u", "us", "isis", "alia", "\u00f8n", "\u00fck", "egon", "ypt", "emnos", "\u00e9c"};
            postModifiers = new String[]{" Kingdom", " Duchy", " Proper", " Vale", " Valley", " Heights", " Minor", " Knell"};
            arial12 = new Font("Arial", 0, 12);
            arial24 = new Font("Arial", 0, 24);
            arial36 = new Font("Arial", 0, 36);
            sansSerifBold12 = new Font("SansSerif", 1, 12);
            sansSerif24 = new Font("SansSerif", 0, 24);
            if (SS.isMacintosh) {
                lucida13 = new Font("Lucida Grande", 0, 13);
            }
            this.setLoadText("loading explosions");
            AnimationLoader.blockTillLoaded();
            animationFrameNumber = AnimationLoader.getFrameCounts();
            animationFrameSize = AnimationLoader.getFrameDimensions();
            explosionFramesArrays = AnimationLoader.getFrameImages();
            AnimationLoader.tidy();
            this.setLoadText("loading sounds");
            gameOverSound = new SoundEffect("gameOver.wav");
            activeCountrySound = new SoundEffect("activeCountry.wav");
            selectCountrySound = new SoundEffect("selectCountry.wav");
            turnExpiredSound = new SoundEffect("timerCountdown.wav");
            explosionSounds = new SoundEffect[11];
            LuxView.explosionSounds[0] = new SoundEffect("attack1.wav");
            LuxView.explosionSounds[1] = new SoundEffect("attack2.wav");
            LuxView.explosionSounds[2] = new SoundEffect("attack_plane.wav");
            LuxView.explosionSounds[3] = new SoundEffect("attack1.wav");
            LuxView.explosionSounds[4] = new SoundEffect("attack2.wav");
            LuxView.explosionSounds[5] = new SoundEffect("attack_st2.wav");
            LuxView.explosionSounds[6] = new SoundEffect("attack3.wav");
            LuxView.explosionSounds[7] = new SoundEffect("attack1.wav");
            LuxView.explosionSounds[8] = new SoundEffect("attack2.wav");
            LuxView.explosionSounds[9] = new SoundEffect("attack1.wav");
            LuxView.explosionSounds[10] = new SoundEffect("attack2.wav");
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Point cursorHotSpot = new Point(0, 0);
            arrowCursor = toolkit.createCustomCursor(GraphicsTool.getImageFromJAR("cursor_arrow.png"), cursorHotSpot, "LD-Arrow");
            bonusString = Translator.getString("bonus");
        }
        this.setLoadText(Translator.getString("Initializing"));
        this.rand = new Random();
        this.setCursor(arrowCursor);
        this.selectedCountry = -1;
        this.flashingColorAlphaDescending = false;
        this.cardsMode = false;
        this.otherTime = 100;
        this.lines = new Vector();
        this.aboveLines = new Vector();
        this.oneDigitRect = new Rectangle(0, 0, 10, 13);
        this.twoDigitRect = new Rectangle(0, 0, 20, 13);
        this.threeDigitRect = new Rectangle(0, 0, 30, 13);
        this.linesColor = Color.WHITE;
        this.control.viewManager.addObserver(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.animationPoint = new Point[20];
        this.animationFrameCount = new int[this.animationPoint.length];
        this.animationNumber = new int[this.animationPoint.length];
        luxViews.add(this);
        if (this.control.netBoss != null) {
            this.control.netBoss.getChatView().chatField.setFocusTraversalKeysEnabled(false);
            this.control.netBoss.getChatView().chatField.requestFocus();
        } else {
            this.requestFocus();
        }
    }

    public void printNextFocusables(int number) {
        Container root;
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Container container = root = c == null ? null : c.getFocusCycleRootAncestor();
        if (root != null) {
            FocusTraversalPolicy policy = root.getFocusTraversalPolicy();
            Component nextFocus = c;
            for (int i = 0; i < number; ++i) {
                if ((nextFocus = policy.getComponentAfter(root, nextFocus)) == null) {
                    nextFocus = policy.getDefaultComponent(root);
                }
                SS.debug("nextFocusable: " + nextFocus);
            }
        }
    }

    public String getToolTipText(MouseEvent event) {
        int targetCode = this.getCountryCodeFromPoint(event.getPoint());
        if (targetCode != -1) {
            return this.shapeName(targetCode) + this.control.world.getToolTipForCountry(targetCode);
        }
        return null;
    }

    public String getTheme() {
        return this.currentTheme;
    }

    public void changeTheme(String newTheme) {
        if (this.currentTheme.equals(newTheme)) {
            return;
        }
        this.loadTheme(newTheme);
    }

    public static void reloadTheme(String theme) {
        int n = luxViews.size();
        for (int i = 0; i < n; ++i) {
            LuxView view = (LuxView)luxViews.get(i);
            SS.debug("reloadTheme(" + theme + ") desiredTheme=" + view.desiredTheme);
            if (!theme.equals(view.desiredTheme)) continue;
            view.desiredTheme = null;
            view.loadTheme(theme);
        }
    }

    public void loadTheme(String named) {
        this.debug("loadTheme: " + named);
        try {
            if (named == null) {
                named = Prefs.get("theme", "Ocean");
            }
            if (named.equals(this.currentTheme)) {
                // empty if block
            }
            this.currentTheme = named;
            this.background = null;
            this.foreground = null;
            this.overground = null;
            this.linesColor = Color.WHITE;
            Vector<ImageIcon> fillerPicts = new Vector<ImageIcon>();
            boolean foundTheme = false;
            File themeDir = new File(DesktopTool.supportFolderPath() + "Themes" + File.separator + named);
            if (named.startsWith("Biohazard_") && !themeDir.exists()) {
                SS.debug("creating on the fly BIO theme");
                this.setLoadText("creating biohazard theme");
                try {
                    String baseTheme = StringTool.stripTrailingNumbers(named.substring(10));
                    int seed = StringTool.captureTrailingNumbers(named);
                    String mapName = this.control.ops.boardName();
                    if (mapName.indexOf(" - BIO ") > 0) {
                        int pos = mapName.indexOf(" - BIO ");
                        mapName = mapName.substring(0, pos);
                    }
                    Biohazard.createTheme(baseTheme, seed, this.control.ops.biohazardLevel(), mapName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            try {
                if (themeDir != null && themeDir.isDirectory()) {
                    foundTheme = true;
                    File[] themeFiles = themeDir.listFiles();
                    for (int i = 0; i < themeFiles.length; ++i) {
                        String lowerName = themeFiles[i].getName().toLowerCase();
                        if (themeFiles[i].getName().equalsIgnoreCase("black.color")) {
                            this.linesColor = Color.BLACK;
                            continue;
                        }
                        if (lowerName.startsWith("background.")) {
                            this.background = new ImageIcon(themeFiles[i].getPath()).getImage();
                            continue;
                        }
                        if (lowerName.startsWith("foreground.")) {
                            this.foreground = new ImageIcon(themeFiles[i].getPath()).getImage();
                            this.customForeground = true;
                            this.mapBackground = null;
                            this.mapBackgroundCards = null;
                            continue;
                        }
                        if (lowerName.startsWith("overground.")) {
                            this.overground = new ImageIcon(themeFiles[i].getPath()).getImage();
                            continue;
                        }
                        try {
                            fillerPicts.add(new ImageIcon(themeFiles[i].getPath()));
                            continue;
                        }
                        catch (Throwable t) {
                            System.out.println(themeFiles[i].getName() + " could not be loaded as an image file");
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (!foundTheme) {
                this.debug("Lux -> Couldn't find the specified theme (" + named + "). Loading 'Ocean' instead.");
                this.desiredTheme = named;
                PluginManager.getInstance().lookForTheme(named, this.control.fullscreen ? null : this.control.boardWindow);
                if ("Ocean".equals(named)) {
                    return;
                }
                this.loadTheme("Ocean");
                return;
            }
            if (this.foreground == null) {
                this.setForeground();
            }
            this.fillerPoints = new Point2D.Double[fillerPicts.size()];
            this.fillerImages = new ImageIcon[fillerPicts.size()];
            for (int i = 0; i < fillerPicts.size(); ++i) {
                this.fillerImages[i] = (ImageIcon)fillerPicts.get(i);
                this.fillerPoints[i] = null;
            }
            this.placedFiller = false;
            if (this.loadText == null) {
                this.placeFillerImages();
                this.repaint();
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Prefs.put("theme", named);
    }

    public void setColors(String[] newColors) {
        this.colors = new Color[newColors.length];
        this.bubble1 = new Image[newColors.length];
        this.bubble2 = new Image[newColors.length];
        this.bubble3 = new Image[newColors.length];
        this.bubble4 = new Image[newColors.length];
        this.bubble5 = new Image[newColors.length];
        String cardString = "card_";
        boolean standardCards = true;
        this.currentArmySet = this.control.ops.boardFile.armySet();
        String armySetString = "guybw";
        switch (this.currentArmySet) {
            case 0: {
                break;
            }
            case 1: {
                armySetString = "guybw_ancient";
                cardString = "card_AN_";
                standardCards = false;
                break;
            }
            case 2: {
                armySetString = "guybw_ancient";
                cardString = "card_AN_";
                standardCards = false;
                break;
            }
            case 3: {
                armySetString = null;
                break;
            }
            case 4: {
                armySetString = "guybw_pm";
                cardString = "card_PM_";
                break;
            }
            case 5: {
                armySetString = "guybw_co";
                cardString = "card_CO_";
                standardCards = false;
                break;
            }
            case 6: {
                armySetString = "guybw_me";
                cardString = "card_ME_";
                standardCards = false;
                break;
            }
            case 7: {
                armySetString = "guybw_sp";
                cardString = "card_SP_";
                standardCards = false;
                break;
            }
            case 8: {
                armySetString = "guybw_fu";
                cardString = "card_FU_";
                standardCards = false;
            }
        }
        Image armyGuySource1 = GraphicsTool.getImageFromJAR(armySetString + "1.png");
        Image armyGuySource2 = GraphicsTool.getImageFromJAR(armySetString + "2.png");
        Image armyGuySource3 = GraphicsTool.getImageFromJAR(armySetString + "3.png");
        Image armyGuySource4 = GraphicsTool.getImageFromJAR(armySetString + "4.png");
        Image armyGuySource5 = GraphicsTool.getImageFromJAR(armySetString + "5.png");
        Image armyGuySource6 = GraphicsTool.getImageFromJAR(armySetString + "6.png");
        Image armyGuySource7 = GraphicsTool.getImageFromJAR(armySetString + "7.png");
        Image armyGuySource8 = GraphicsTool.getImageFromJAR(armySetString + "8.png");
        Image armyGuySource9 = null;
        armyGuySource9 = this.currentArmySet == 2 ? GraphicsTool.getImageFromJAR(armySetString + "9_2.png") : GraphicsTool.getImageFromJAR(armySetString + "9.png");
        this.armyGuy1 = new Image[newColors.length];
        this.armyGuy2 = new Image[newColors.length];
        this.armyGuy3 = new Image[newColors.length];
        this.armyGuy4 = new Image[newColors.length];
        this.armyGuy5 = new Image[newColors.length];
        this.armyGuy6 = new Image[newColors.length];
        this.armyGuy7 = new Image[newColors.length];
        this.armyGuy8 = new Image[newColors.length];
        this.armyGuy9 = new Image[newColors.length];
        Image bubblesSource1 = GraphicsTool.getImageFromJAR("bubbleSource1.png");
        Image bubblesSource2 = GraphicsTool.getImageFromJAR("bubbleSource2.png");
        Image bubblesSource3 = GraphicsTool.getImageFromJAR("bubbleSource3.png");
        Image bubblesSource4 = GraphicsTool.getImageFromJAR("bubbleSource4.png");
        Image bubblesSource5 = GraphicsTool.getImageFromJAR("bubbleSource5.png");
        for (int i = 0; i < newColors.length; ++i) {
            Color solidPlayerColor = GraphicsTool.colorFromString(newColors[i]);
            this.colors[i] = GraphicsTool.transparent(solidPlayerColor, this.shapeAlpha);
            Color paintColor = GraphicsTool.transparent(solidPlayerColor, 0.35f);
            this.bubble1[i] = this.colorArmyImage(27, 27, bubblesSource1, paintColor);
            this.bubble2[i] = this.colorArmyImage(26, 24, bubblesSource2, paintColor);
            this.bubble3[i] = this.colorArmyImage(34, 24, bubblesSource3, paintColor);
            this.bubble4[i] = this.colorArmyImage(44, 23, bubblesSource4, paintColor);
            this.bubble5[i] = this.colorArmyImage(54, 23, bubblesSource5, paintColor);
            paintColor = GraphicsTool.transparent(solidPlayerColor, 0.2f);
            if (this.currentArmySet == 0) {
                this.armyGuy1[i] = this.colorArmyImage(52, 42, armyGuySource1, paintColor);
                this.armyGuy2[i] = this.colorArmyImage(49, 38, armyGuySource2, paintColor);
                this.armyGuy3[i] = this.colorArmyImage(57, 44, armyGuySource3, paintColor);
                this.armyGuy4[i] = this.colorArmyImage(63, 50, armyGuySource4, paintColor);
                this.armyGuy5[i] = this.colorArmyImage(64, 50, armyGuySource5, paintColor);
                this.armyGuy6[i] = this.colorArmyImage(66, 52, armyGuySource6, paintColor);
                this.armyGuy7[i] = this.colorArmyImage(67, 32, armyGuySource7, paintColor);
                this.armyGuy8[i] = this.colorArmyImage(64, 43, armyGuySource8, paintColor);
                this.armyGuy9[i] = this.colorArmyImage(53, 53, armyGuySource9, paintColor);
                continue;
            }
            if (this.currentArmySet == 1 || this.currentArmySet == 2) {
                this.armyGuy1[i] = this.colorArmyImage(49, 38, armyGuySource1, paintColor);
                this.armyGuy2[i] = this.colorArmyImage(57, 44, armyGuySource2, paintColor);
                this.armyGuy3[i] = this.colorArmyImage(63, 50, armyGuySource3, paintColor);
                this.armyGuy4[i] = this.colorArmyImage(64, 50, armyGuySource4, paintColor);
                this.armyGuy5[i] = this.colorArmyImage(66, 52, armyGuySource5, paintColor);
                this.armyGuy6[i] = this.colorArmyImage(53, 53, armyGuySource6, paintColor);
                this.armyGuy7[i] = this.colorArmyImage(53, 53, armyGuySource7, paintColor);
                this.armyGuy8[i] = this.colorArmyImage(53, 53, armyGuySource8, paintColor);
                this.armyGuy9[i] = this.colorArmyImage(53, 53, armyGuySource9, paintColor);
                continue;
            }
            if (this.currentArmySet == 3) {
                this.armyGuy1[i] = null;
                this.armyGuy2[i] = null;
                this.armyGuy3[i] = null;
                this.armyGuy4[i] = null;
                this.armyGuy5[i] = null;
                this.armyGuy6[i] = null;
                this.armyGuy7[i] = null;
                this.armyGuy8[i] = null;
                this.armyGuy9[i] = null;
                continue;
            }
            if (this.currentArmySet == 7 || this.currentArmySet == 8) {
                this.armyGuy1[i] = this.colorArmyImage(54, 54, armyGuySource1, paintColor);
                this.armyGuy2[i] = this.colorArmyImage(54, 54, armyGuySource2, paintColor);
                this.armyGuy3[i] = this.colorArmyImage(54, 54, armyGuySource3, paintColor);
                this.armyGuy4[i] = this.colorArmyImage(54, 54, armyGuySource4, paintColor);
                this.armyGuy5[i] = this.colorArmyImage(54, 54, armyGuySource5, paintColor);
                this.armyGuy6[i] = this.colorArmyImage(54, 54, armyGuySource6, paintColor);
                this.armyGuy7[i] = this.colorArmyImage(54, 54, armyGuySource7, paintColor);
                this.armyGuy8[i] = this.colorArmyImage(54, 54, armyGuySource8, paintColor);
                this.armyGuy9[i] = this.colorArmyImage(54, 54, armyGuySource9, paintColor);
                continue;
            }
            this.armyGuy1[i] = this.colorArmyImage(55, 53, armyGuySource1, paintColor);
            this.armyGuy2[i] = this.colorArmyImage(53, 53, armyGuySource2, paintColor);
            this.armyGuy3[i] = this.colorArmyImage(53, 53, armyGuySource3, paintColor);
            this.armyGuy4[i] = this.colorArmyImage(53, 53, armyGuySource4, paintColor);
            this.armyGuy5[i] = this.colorArmyImage(53, 53, armyGuySource5, paintColor);
            this.armyGuy6[i] = this.colorArmyImage(53, 53, armyGuySource6, paintColor);
            this.armyGuy7[i] = this.colorArmyImage(53, 53, armyGuySource7, paintColor);
            this.armyGuy8[i] = this.colorArmyImage(53, 53, armyGuySource8, paintColor);
            this.armyGuy9[i] = this.colorArmyImage(53, 53, armyGuySource9, paintColor);
        }
        this.normalCards = new Image[4];
        this.hilightedCards = new Image[4];
        this.normalCards[0] = GraphicsTool.getImageFromJAR(cardString + "soldier.png");
        this.hilightedCards[0] = GraphicsTool.getImageFromJAR(cardString + "soldier_over.png");
        this.normalCards[1] = GraphicsTool.getImageFromJAR(cardString + "tank.png");
        this.hilightedCards[1] = GraphicsTool.getImageFromJAR(cardString + "tank_over.png");
        this.normalCards[2] = GraphicsTool.getImageFromJAR(cardString + "jet.png");
        this.hilightedCards[2] = GraphicsTool.getImageFromJAR(cardString + "jet_over.png");
        this.normalCards[3] = GraphicsTool.getImageFromJAR(cardString + "wild.png");
        this.hilightedCards[3] = GraphicsTool.getImageFromJAR(cardString + "wild_over.png");
        this.control.widthBar.setColors(this.colors);
    }

    private Image colorArmyImage(int width, int height, Image sourceImage, Color paintColor) {
        BufferedImage coloredImage = GraphicsTool.createBufferedImage(width, height, 3);
        Graphics2D imageG = coloredImage.createGraphics();
        imageG.drawImage(sourceImage, 0, 0, null);
        imageG.setComposite(AlphaComposite.SrcAtop);
        imageG.setColor(paintColor);
        imageG.fillRect(0, 0, width, height);
        imageG.dispose();
        return coloredImage;
    }

    public Color getColor(int player) {
        if (player >= this.colors.length) {
            return Color.BLACK;
        }
        return GraphicsTool.solid(this.colors[player]);
    }

    public void setCountryContinents(int[] codes) {
        this.contCodes = codes;
    }

    public void setNumContinents(int numContinents) {
        int choice;
        int i;
        this.contBorderColor = GraphicsTool.transparent(new Color(0, 50, 100), this.outlineAlpha);
        this.contColors = new Color[numContinents];
        this.contBounds = new Rectangle[numContinents];
        this.contName = new String[numContinents];
        this.contLabelLocation = new Point[numContinents];
        Color[] possibleContColors1 = new Color[]{new Color(0.5f, 0.0f, 0.0f, this.borderAlpha), new Color(0.0f, 0.5f, 0.0f, this.borderAlpha), new Color(0.0f, 0.0f, 0.5f, this.borderAlpha), new Color(1.0f, 1.0f, 0.0f, this.borderAlpha), new Color(1.0f, 0.0f, 0.75f, this.borderAlpha), new Color(0.0f, 0.75f, 1.0f, this.borderAlpha), new Color(0.5f, 0.0f, 0.5f, this.borderAlpha), new Color(1.0f, 0.5f, 0.0f, this.borderAlpha), new Color(0.0f, 0.0f, 0.0f, this.borderAlpha)};
        Color[] possibleContColors2 = new Color[]{new Color(1.0f, 0.0f, 0.0f, this.borderAlpha), new Color(0.0f, 1.0f, 0.0f, this.borderAlpha), new Color(0.0f, 0.0f, 1.0f, this.borderAlpha), GraphicsTool.transparent(Color.darkGray, this.borderAlpha), GraphicsTool.transparent(Color.lightGray, this.borderAlpha)};
        this.rand.setSeed(this.control.ops.boardNumber);
        for (i = 0; i < this.contColors.length && i < possibleContColors1.length; ++i) {
            while (possibleContColors1[choice = this.rand.nextInt(possibleContColors1.length)] == null) {
            }
            this.contColors[i] = possibleContColors1[choice];
            possibleContColors1[choice] = null;
        }
        while (i < this.contColors.length) {
            if (i >= possibleContColors1.length + possibleContColors2.length) {
                this.contColors[i] = GraphicsTool.transparent(Color.BLACK, this.borderAlpha);
                if (numContinents == 13) {
                    System.out.println("LuxView: not enough default continent colors. Black will be used if the map does not set the continent colors.");
                }
            } else {
                while (possibleContColors2[choice = this.rand.nextInt(possibleContColors2.length)] == null) {
                }
                this.contColors[i] = possibleContColors2[choice];
                possibleContColors2[choice] = null;
            }
            ++i;
        }
    }

    public void setContinentColor(int code, Color col) {
        if (col != null) {
            this.contColors[code] = col;
        }
    }

    public void setContinentLabelLocation(int cont, String loc) {
        if (loc == null) {
            return;
        }
        loc = GraphicsTool.flipPointStringY(loc, this.control.ops.height);
        int commaLoc = loc.indexOf(",");
        Point labelPoint = new Point(Integer.parseInt(loc.substring(0, commaLoc)), Integer.parseInt(loc.substring(commaLoc + 1)));
        if (this.resizeOnLoad) {
            labelPoint.setLocation((double)labelPoint.x * this.resizePercent, (double)labelPoint.y * this.resizePercent);
            if (this.contBounds != null) {
                this.contBounds[cont] = null;
            }
        }
        this.contLabelLocation[cont] = labelPoint;
    }

    public void setNumCountries(int n) {
        this.shapes = new GeneralPath[n];
        this.shapeBounds = new Rectangle[n];
        this.ownerCode = new int[n];
        this.armies = new int[n];
        this.countryNames = new String[n];
        this.armyLocation = new Point[n];
        this.redrawMemory = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.ownerCode[i] = -1;
            this.armies[i] = 1;
        }
        this.setToolTipText("tooltip");
        ToolTipManager.sharedInstance().setInitialDelay(Prefs.getInt("tooltipDelay", 200));
    }

    public void createBackgroundComposite() {
        if (this.background == null) {
            return;
        }
        this.setLoadText("creating background composite");
        if (PrefsCache.superfast) {
            return;
        }
        this.mapBackground = this.createBackgroundImage(null, false);
        new Thread("LuxView-cardsmode-composite"){

            public void run() {
                try {
                    this.setPriority(1);
                    Thread.sleep(15000L);
                }
                catch (Exception e) {
                    System.out.println("Sleeping cardsModeComposite Thread woken up");
                }
                if (LuxView.this.control == null) {
                    return;
                }
                try {
                    System.out.println("LuxView: creating the cardsmode composite in the background");
                    if (LuxView.this.mapBackgroundCards == null) {
                        LuxView.this.mapBackgroundCards = LuxView.this.createBackgroundImage(null, true);
                    }
                    System.out.println("LuxView: finished creating the cardsmode composite in the background");
                }
                catch (OutOfMemoryError memerr) {
                    memerr.printStackTrace();
                    LuxView.this.setLoadText("Out of Memory Error B - " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ", VM: " + System.getProperty("java.version") + " / " + System.getProperty("java.class.version") + ", maxmem " + Runtime.getRuntime().maxMemory() / 1000000L);
                }
            }
        }.start();
    }

    private BufferedImage createBackgroundImage(Graphics2D screenG, boolean forCards) {
        BufferedImage image;
        boolean setLoadText;
        boolean bl = setLoadText = screenG == null && !forCards;
        if (screenG == null) {
            if (this.control == null) {
                return null;
            }
            if (setLoadText) {
                this.setLoadText("creating image buffer");
            }
            if (this.control == null || this.mapWidth < 1 || this.mapHeight < 1) {
                return null;
            }
            image = GraphicsTool.createBufferedImage(this.mapWidth, this.mapHeight, 3);
        } else {
            GraphicsConfiguration gc = screenG.getDeviceConfiguration();
            image = gc.createCompatibleImage(this.mapWidth, this.mapHeight, 3);
        }
        Graphics2D backG = image.createGraphics();
        backG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (setLoadText) {
            this.setLoadText("rendering background");
        }
        if (this.background != null) {
            backG.drawImage(this.background, 0, 0, this.mapWidth, this.mapHeight, this);
        }
        if (setLoadText) {
            this.setLoadText("rendering foreground");
        }
        this.drawForeground2(backG);
        if (forCards && this.mapBackground != null) {
            this.background = null;
            this.foreground = null;
        }
        GraphicsTool.drawLines(backG, this.lines, this.linesColor);
        if (setLoadText) {
            this.setLoadText("rendering filler images");
        }
        if (this.fillerPoints != null) {
            if (!this.placedFiller) {
                this.placeFillerImages();
                this.placedFiller = true;
            }
            for (int f = 0; f < this.fillerPoints.length; ++f) {
                if (this.fillerPoints[f] == null) continue;
                backG.drawImage(this.fillerImages[f].getImage(), (int)this.fillerPoints[f].getX(), (int)this.fillerPoints[f].getY(), this);
            }
        }
        if (!forCards) {
            int i;
            if (setLoadText) {
                this.setLoadText("Vectorizing Shapes");
            }
            backG.setStroke(new BasicStroke(this.outlineWidth, 1, 1));
            backG.setColor(this.contBorderColor);
            for (i = 0; i < this.shapes.length; ++i) {
                backG.draw(this.shapes[i]);
            }
            backG.setStroke(new BasicStroke(this.borderWidth, 1, 1));
            for (i = 0; i < this.shapes.length; ++i) {
                backG.setColor(this.contColors[this.contCodes[i]]);
                backG.draw(this.shapes[i]);
            }
        } else {
            int i;
            float dimmedAlpha = 0.5f;
            backG.setStroke(new BasicStroke(this.outlineWidth, 1, 1));
            backG.setColor(GraphicsTool.transparent(this.contBorderColor, dimmedAlpha));
            for (i = 0; i < this.shapes.length; ++i) {
                backG.draw(this.shapes[i]);
            }
            backG.setStroke(new BasicStroke(this.borderWidth, 1, 1));
            for (i = 0; i < this.shapes.length; ++i) {
                backG.setColor(GraphicsTool.transparent(this.contColors[this.contCodes[i]], dimmedAlpha * 0.6f));
                backG.draw(this.shapes[i]);
            }
        }
        backG.dispose();
        return image;
    }

    public void reset() {
    }

    public void clearView() {
        this.lines = new Vector();
        this.aboveLines = new Vector();
        this.cardsMode = false;
        this.cardPlus = new Random().nextInt();
        this.gameOverText = null;
        this.placedFiller = false;
        this.helperText = null;
        this.selectCountry(-1);
        this.arrowFromCountry = -1;
        this.desiredTheme = null;
        this.clearNotices();
        this.control.widthBar.clearView();
        this.control.armySelector.clearView();
    }

    public void clearViewForReuse() {
        this.cardsMode = false;
        this.gameOverText = null;
        this.placedFiller = false;
        this.helperText = null;
        this.desiredTheme = null;
        this.clearNotices();
        this.repaint();
    }

    public void setShape(int j, GeneralPath shape) {
        this.shapes[j] = GraphicsTool.flipY(shape, this.control.ops.height);
        if (this.resizeOnLoad) {
            this.shapes[j] = GraphicsTool.resizeShape(this.shapes[j], this.resizePercent);
        }
        this.shapeBounds[j] = this.shapes[j].getBounds();
    }

    public void setArmyLocation(int code, String loc) {
        if (loc == null || loc.equals("")) {
            return;
        }
        int commaLoc = loc.indexOf(",");
        this.armyLocation[code] = new Point(Integer.parseInt(loc.substring(0, commaLoc)) - 2, this.control.ops.height - Integer.parseInt(loc.substring(commaLoc + 1)));
        if (this.resizeOnLoad && this.armyLocation[code] != null) {
            this.armyLocation[code].setLocation((double)this.armyLocation[code].x * this.resizePercent, (double)this.armyLocation[code].y * this.resizePercent);
        }
    }

    public void setLoadText(String text) {
        this.loadText = text;
        if (text == null) {
            Ticker.keepMeTicking(this);
        }
        this.repaint();
    }

    public synchronized void selectCountry(int country) {
        if (this.selectedCountry == country) {
            return;
        }
        if (this.selectedCountry != -1) {
            this.dirtyRect(this.shapeBounds[this.selectedCountry]);
        }
        this.selectedCountry = country;
        if (this.selectedCountry != -1) {
            if (PrefsCache.selectCountrySound) {
                selectCountrySound.play(true);
            }
            if (PrefsCache.activeCountrySound) {
                activeCountrySound.startLooping();
            }
            if (this.flashTimer == null) {
                this.flashTimer = new Timer();
                this.flashTimer.scheduleAtFixedRate((TimerTask)new FlashTask(this), 100L, 100L);
            }
        } else {
            activeCountrySound.stopLooping();
            this.flashingColorAlpha = 0.0f;
        }
        this.setProperCursor();
    }

    public synchronized void flash(String dummy) {
        if (this.selectedCountry != -1 && !this.cardsMode) {
            if ((double)this.flashingColorAlpha < 0.01) {
                this.flashingColorAlphaDescending = false;
            } else if ((double)this.flashingColorAlpha > 0.69) {
                this.flashingColorAlphaDescending = true;
            }
            this.flashingColorAlpha = this.flashingColorAlphaDescending ? (float)((double)this.flashingColorAlpha - 0.1) : (float)((double)this.flashingColorAlpha + 0.1);
            this.flashingColor = GraphicsTool.transparent(Color.WHITE, this.flashingColorAlpha);
            this.dirtyRect(this.shapeBounds[this.selectedCountry]);
        }
    }

    public void gotoPlayer(int player) {
        this.selectCountry(-1);
        if (PrefsCache.superfast) {
            return;
        }
        this.control.widthBar.gotoPlayer(player);
        if (this.arrowFromCountry != -1) {
            this.setArrowOnCountry(-1, -1);
        }
    }

    public void resetPlayer() {
        this.control.widthBar.resetPlayer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCountryOwner(int country, int owner) {
        if (PrefsCache.superfast) {
            return;
        }
        if (country < 0 || owner < -1 || country >= this.shapes.length || owner >= this.control.ops.playerNames.length) {
            System.out.println("Lux -> luxView.setCountryOwner(" + country + ", " + owner + ") bad call. " + this.control.ops.playerNames.length + " players and " + this.shapes.length + " countries.");
            return;
        }
        Object object = this.dirtyRectLock;
        synchronized (object) {
            this.ownerCode[country] = owner;
            this.dirtyRect(this.shapeBounds[country]);
            this.control.widthBar.repaint();
        }
    }

    public void setCountryArmies(int country, int newArmies) {
        if (PrefsCache.superfast) {
            return;
        }
        if (country < 0 || newArmies < 0 || country >= this.shapes.length) {
            System.out.println("Lux -> luxView.setCountryArmies(" + country + ", " + newArmies + ") bad call");
            return;
        }
        this.armies[country] = newArmies;
        this.dirtyRect(this.shapeBounds[country]);
        this.control.widthBar.repaint();
    }

    public void showCards(Card[] thecards, boolean inPhase, Card[] selected) {
        int i;
        this.inCardsPhase = inPhase;
        this.cards = thecards;
        this.cardRect = new Rectangle[this.cards.length];
        this.cardName = new String[this.cards.length];
        this.cardPoint = new Point[this.cards.length];
        this.cardHighlight = new boolean[this.cards.length];
        this.wildCard = new boolean[this.cards.length];
        for (i = 0; i < this.cards.length; ++i) {
            this.cardHighlight[i] = false;
            if (this.cards[i].getCode() == -1) {
                this.wildCard[i] = true;
                this.cardPoint[i] = null;
                this.cardName[i] = new String(Translator.getString("WildCard"));
                continue;
            }
            this.wildCard[i] = false;
            this.cardPoint[i] = new Point((int)(this.shapeBounds[this.cards[i].getCode()].getX() + this.shapeBounds[this.cards[i].getCode()].getWidth() / 2.0) - 85, (int)(this.shapeBounds[this.cards[i].getCode()].getY() + this.shapeBounds[this.cards[i].getCode()].getHeight() / 2.0) - 60);
            this.cardName[i] = new String(this.shapeName(this.cards[i].getCode()));
            this.cardRect[i] = new Rectangle((int)this.cardPoint[i].getX(), (int)this.cardPoint[i].getY(), (int)cardSize.getWidth(), (int)cardSize.getHeight());
        }
        for (i = 0; i < this.cards.length; ++i) {
            if (!this.wildCard[i]) continue;
            boolean placedCard = false;
            int tries = 0;
            while (!placedCard) {
                Rectangle placerRect = new Rectangle(this.rand.nextInt(this.mapWidth - 200), this.rand.nextInt(this.mapHeight - 150), (int)cardSize.getWidth(), (int)cardSize.getHeight());
                while (placerRect.getMaxX() < (double)this.mapWidth && placerRect.getMaxY() < (double)this.mapHeight && !placedCard) {
                    boolean conflicted = false;
                    for (int c = 0; c < this.cards.length; ++c) {
                        if (this.cardPoint[c] == null || !placerRect.intersects(this.cardRect[c])) continue;
                        placerRect = new Rectangle((int)(this.cardRect[c].getX() + this.cardRect[c].getWidth()), (int)placerRect.getX(), (int)placerRect.getWidth(), (int)placerRect.getHeight());
                        conflicted = true;
                    }
                    if (conflicted && tries <= 30) continue;
                    this.cardPoint[i] = new Point((int)placerRect.getX(), (int)placerRect.getY());
                    this.cardRect[i] = placerRect;
                    placedCard = true;
                }
                ++tries;
            }
        }
        if (inPhase && selected != null) {
            this.selectCardSet(selected);
        }
        for (i = 0; i < 30 && GraphicsTool.arrangeRects(this.cardRect, this.bounds(), 10, 25); ++i) {
        }
        this.clearNotices();
        this.cardsMode = true;
        this.repaint();
        this.control.armySelector.showCards(this.cards.length, this.control.world.getNextCardSetValue());
    }

    public void selectCardSet(Card[] selected) {
        if (this.cards == null) {
            return;
        }
        for (int i = 0; i < this.cards.length; ++i) {
            if (this.cards[i] != selected[0] && this.cards[i] != selected[1] && this.cards[i] != selected[2]) continue;
            this.cardHighlight[i] = true;
            if (this.cards[i].getCode() == -1) continue;
            this.cardName[i] = new String(this.shapeName(this.cards[i].getCode()));
        }
    }

    public void hideCards() {
        this.cardsMode = false;
        this.cards = null;
        this.cardRect = null;
        this.cardName = null;
        this.cardPoint = null;
        this.cardHighlight = null;
        this.clearNotices();
        this.repaint();
        this.control.armySelector.hideCards();
    }

    public Vector getSelectedCards() {
        Vector<Card> selected = new Vector<Card>();
        for (int i = 0; i < this.cards.length; ++i) {
            if (!this.cardHighlight[i]) continue;
            selected.add(this.cards[i]);
        }
        return selected;
    }

    public boolean cardsMode() {
        return this.cardsMode;
    }

    public void clearLines() {
        this.aboveLines = new Vector();
        this.lines = new Vector();
    }

    public void addLine(ExtraLine line) {
        line.flipY(this.control.ops.height);
        if (this.resizeOnLoad) {
            line.resize((float)this.resizePercent);
        }
        if (line.above) {
            this.aboveLines.add(line);
        } else {
            this.lines.add(line);
        }
    }

    public void setCountryName(int code, String name) {
        if (name == null) {
            return;
        }
        this.countryNames[code] = name;
    }

    private String continentName(int cont) {
        if (this.contName[cont] == null) {
            String name = null;
            int format = this.rand.nextInt(100);
            name = format < 50 ? preModifiers[this.rand.nextInt(preModifiers.length)] + starts[this.rand.nextInt(starts.length)] + ends[this.rand.nextInt(ends.length)] : starts[this.rand.nextInt(starts.length)] + ends[this.rand.nextInt(ends.length)];
            this.contName[cont] = name;
        }
        return this.contName[cont];
    }

    public void setContinentName(int cont, String name) {
        if (name != null) {
            this.contName[cont] = name;
        }
    }

    private String shapeName(int index) {
        if (index == -1) {
            return Translator.getString("WildCard");
        }
        if (this.countryNames[index] == null || "".equals(this.countryNames[index])) {
            Random rand = new Random(index + this.control.ops.boardName().hashCode());
            String name = null;
            int format = rand.nextInt(100);
            name = format < 30 ? preModifiers[rand.nextInt(preModifiers.length)] + starts[rand.nextInt(starts.length)] + ends[rand.nextInt(ends.length)] : (format < 45 ? starts[rand.nextInt(starts.length)] + ends[rand.nextInt(ends.length)] + postModifiers[rand.nextInt(postModifiers.length)] : starts[rand.nextInt(starts.length)] + ends[rand.nextInt(ends.length)]);
            this.countryNames[index] = name;
        }
        return this.countryNames[index];
    }

    private void placeFillerImages() {
        try {
            int y;
            int x;
            for (int f = 0; f < this.fillerImages.length; ++f) {
                this.fillerPoints[f] = null;
            }
            if (Prefs.getInt("usePictures", 1) == 0 || this.fillerImages.length == 0) {
                return;
            }
            int topX = this.mapWidth / 20;
            int topY = this.mapHeight / 20;
            boolean[][] free = new boolean[topX][topY];
            for (x = 0; x < topX; ++x) {
                for (y = 0; y < topY; ++y) {
                    free[x][y] = this.isInShapes(new Point2D.Double(x * 20, y * 20)) == -1;
                }
            }
            if (!Prefs.getBoolean("playerInfoSeperate", false)) {
                for (x = 0; x < 15; ++x) {
                    for (y = 0; y < 6; ++y) {
                        free[x][y] = false;
                    }
                }
            }
            int bigArea = 0;
            for (int x2 = 0; x2 < topX; ++x2) {
                for (int y2 = 0; y2 < topY; ++y2) {
                    if (!free[x2][y2]) continue;
                    int height = 0;
                    while (height + y2 + 1 < topY && free[x2][y2 + height + 1]) {
                        ++height;
                        int width = 0;
                        boolean stillGrowingWidth = true;
                        while (stillGrowingWidth && x2 + width < topX) {
                            for (int h = 0; h < height && stillGrowingWidth; ++h) {
                                if (free[x2 + width][y2 + h]) continue;
                                stillGrowingWidth = false;
                            }
                            if (!stillGrowingWidth) continue;
                            ++width;
                        }
                        int area = width * height * 20 * 20;
                        if (area <= bigArea || width > 2 * height || height > 2 * width) continue;
                        bigArea = area;
                        this.bigRect = new Rectangle2D.Double(x2 * 20, y2 * 20, width * 20, height * 20);
                    }
                }
            }
            if (this.bigRect == null) {
                return;
            }
            boolean placedImage = false;
            int start = this.rand.nextInt(this.fillerImages.length);
            for (int fi = 0; fi < this.fillerImages.length && !placedImage; ++fi) {
                Rectangle2D.Double fillerRect;
                int f = (fi + start) % this.fillerImages.length;
                if (this.fillerPoints[f] != null || !this.rectIsClearOfStuff(fillerRect = new Rectangle2D.Double(this.bigRect.getCenterX() - (double)(this.fillerImages[f].getIconWidth() / 2), this.bigRect.getCenterY() - (double)(this.fillerImages[f].getIconHeight() / 2), this.fillerImages[f].getIconWidth(), this.fillerImages[f].getIconHeight())) || !(((RectangularShape)fillerRect).getX() > 0.0) || !(((RectangularShape)fillerRect).getY() > 0.0)) continue;
                this.fillerPoints[f] = new Point2D.Double(((RectangularShape)fillerRect).getX(), ((RectangularShape)fillerRect).getY());
                placedImage = true;
            }
        }
        catch (Exception e) {
            SS.debug(e);
        }
    }

    private int isInShapes(Point2D p) {
        for (int i = 0; i < this.shapes.length; ++i) {
            if (!this.shapeBounds[i].contains(p) || !this.shapes[i].contains(p)) continue;
            return i;
        }
        return -1;
    }

    private boolean rectIsClearOfStuff(Rectangle2D r) {
        for (int i = 0; i < this.shapes.length; ++i) {
            if (!r.intersects(this.shapeBounds[i])) continue;
            return false;
        }
        for (int f = 0; f < this.fillerImages.length; ++f) {
            if (this.fillerPoints[f] == null || !r.intersects(new Rectangle2D.Double(this.fillerPoints[f].getX(), this.fillerPoints[f].getY(), this.fillerImages[f].getIconWidth(), this.fillerImages[f].getIconHeight()))) continue;
            return false;
        }
        return true;
    }

    private boolean conflictsWithFiller(Rectangle placerRect) {
        Rectangle2D.Double bufferRect = new Rectangle2D.Double(placerRect.getX() - placerRect.getWidth(), placerRect.getY() - placerRect.getHeight(), placerRect.getWidth() * 3.0, placerRect.getHeight() * 3.0);
        for (int f = 0; f < this.fillerImages.length; ++f) {
            if (this.fillerPoints[f] == null || !bufferRect.intersects(this.fillerPoints[f].getX(), this.fillerPoints[f].getY(), this.fillerImages[f].getIconWidth(), this.fillerImages[f].getIconHeight())) continue;
            return true;
        }
        return false;
    }

    public void lostServer() {
        this.gameOverText = "No connection to host";
        this.selectCountry(-1);
        this.repaint();
    }

    public void gameOver(String endText) {
        this.gameOverText = StringTool.wrapLines(endText, 50);
        this.repaint();
        this.selectCountry(-1);
        if (PrefsCache.useSound && Prefs.getBoolean("soundGameOver", true)) {
            gameOverSound.play();
        }
        if (PrefsCache.explosions > 0) {
            int millisHence = 0;
            this.explosionsLeft = 40;
            while (this.explosionsLeft > 0) {
                final int explosionDelay = millisHence;
                new Thread("LuxView-gameover-explosions"){

                    public void run() {
                        try {
                            Thread.sleep(explosionDelay);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                LuxView.this.randomExplosion(null);
                            }
                        });
                    }
                }.start();
                millisHence += 160;
                --this.explosionsLeft;
            }
        }
    }

    public void randomExplosion(Object dummy) {
        this.explode(this.rand.nextInt(this.shapes.length));
    }

    public void explode(int code) {
        if (PrefsCache.explosionSound) {
            this.explosionSound();
        }
        if (PrefsCache.explosions > 0) {
            switch (PrefsCache.explosions) {
                case 1: {
                    if (!this.rand.nextBoolean()) break;
                    this.orderExplosion(code);
                    break;
                }
                case 3: {
                    this.orderExplosion(code);
                    if (!this.rand.nextBoolean()) break;
                    this.orderExplosion(code);
                    break;
                }
                case 4: {
                    this.orderExplosion(code);
                    this.orderExplosion(code);
                    break;
                }
                default: {
                    this.orderExplosion(code);
                }
            }
        }
    }

    private void orderExplosion(int code) {
        Point loc = new Point((int)this.shapeBounds[code].getX() + this.rand.nextInt((int)this.shapeBounds[code].getWidth()), (int)this.shapeBounds[code].getY() + this.rand.nextInt((int)this.shapeBounds[code].getHeight()));
        this.orderExplosionAtPoint(loc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderExplosionAtPoint(Point loc) {
        Object object = this.dirtyRectLock;
        synchronized (object) {
            int start = this.rand.nextInt(this.animationPoint.length);
            for (int c = 0; c < this.animationPoint.length; ++c) {
                int aniChoice;
                int i = (start + c) % this.animationPoint.length;
                if (this.animationPoint[i] != null) continue;
                this.animationFrameCount[i] = 0;
                this.animationNumber[i] = aniChoice = this.rand.nextInt(explosionFramesArrays.length);
                this.animationPoint[i] = new Point(loc.x - LuxView.animationFrameSize[this.animationNumber[i]].width / 2, loc.y - LuxView.animationFrameSize[this.animationNumber[i]].height / 2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanceFrames() {
        ++this.framecount;
        if (this.framecount > 29) {
            this.framecount = 0;
        }
        Object object = this.dirtyRectLock;
        synchronized (object) {
            int i;
            Rectangle redrawArea = null;
            boolean fullExplosions = PrefsCache.fullExplosions;
            for (i = 0; i < this.animationPoint.length; ++i) {
                if (this.animationPoint[i] == null) continue;
                if (fullExplosions) {
                    int n = i;
                    this.animationFrameCount[n] = this.animationFrameCount[n] + 1;
                } else {
                    int n = i;
                    this.animationFrameCount[n] = this.animationFrameCount[n] + 2;
                }
                redrawArea = redrawArea == null ? new Rectangle(this.animationPoint[i], animationFrameSize[this.animationNumber[i]]) : redrawArea.union(new Rectangle(this.animationPoint[i], animationFrameSize[this.animationNumber[i]]));
                if (this.animationFrameCount[i] < animationFrameNumber[this.animationNumber[i]]) continue;
                this.animationPoint[i] = null;
            }
            if (this.flashContinents.size() > 0) {
                this.flashContinentAlpha -= 0.015f;
                if (this.contBounds != null) {
                    redrawArea = this.addFlashingContinentsToRedrawArea(redrawArea);
                }
                if (this.flashContinentAlpha < 0.0f) {
                    this.flashContinents.clear();
                }
            }
            if (this.notices != null) {
                for (i = 0; i < this.notices.size(); ++i) {
                    VisualsNotice n = (VisualsNotice)this.notices.get(i);
                    if (n.stillDrawing()) continue;
                    redrawArea = redrawArea == null ? n.getBounds(this.getNoticeFont()) : redrawArea.union(n.getBounds(this.getNoticeFont()));
                }
            }
            if (redrawArea != null) {
                this.dirtyRect = this.dirtyRect == null ? redrawArea : this.dirtyRect.union(redrawArea);
            }
            if (this.dirtyRect != null) {
                this.repaint(this.dirtyRect);
                this.dirtyRect = null;
            }
        }
        this.control.armySelector.tick();
    }

    private Rectangle addFlashingContinentsToRedrawArea(Rectangle redrawArea) {
        for (int i = 0; i < this.flashContinents.size(); ++i) {
            Rectangle continentRect = new Rectangle(this.continentBounds((Integer)this.flashContinents.get(i)));
            redrawArea = redrawArea == null ? continentRect : redrawArea.union(continentRect);
        }
        return redrawArea;
    }

    private Rectangle continentBounds(int cont) {
        if (this.contBounds[cont] == null) {
            RectangularShape result = null;
            for (int i = 0; i < this.contCodes.length; ++i) {
                if (this.contCodes[i] != cont) continue;
                result = null == result ? new Rectangle(this.shapeBounds[i]) : ((Rectangle)result).union(this.shapeBounds[i]);
            }
            if (this.contLabelLocation[cont] == null) {
                this.contLabelLocation[cont] = new Point((int)result.getCenterX(), (int)result.getCenterY());
            }
            String contTitle = this.continentName(cont) + (this.control.ops.shortContinentLabels() ? "" : "\n" + bonusString) + ": " + this.control.world.getBoard().getContinentBonus(cont);
            Rectangle labelRect = GraphicsTool.getBoxedStringRectangle(arial24, contTitle, this.contLabelLocation[cont].x, this.contLabelLocation[cont].y, 10, 2, null, null, 2, null);
            result = ((Rectangle)result).union(labelRect);
            this.contBounds[cont] = result;
        }
        return this.contBounds[cont];
    }

    private void explosionSound() {
        int offset = this.rand.nextInt(explosionSounds.length);
        for (int i = 0; i < explosionSounds.length; ++i) {
            if (explosionSounds[(offset + i) % explosionSounds.length].isActive()) continue;
            explosionSounds[(offset + i) % explosionSounds.length].play();
            return;
        }
    }

    void kill() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeKeyListener(this);
        try {
            this.control.viewManager.removeObserver(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.control = null;
        luxViews.remove(this);
        Ticker.stopMeTicking(this);
        if (this.flashTimer != null) {
            this.flashTimer.cancel();
            this.flashTimer = null;
        }
        this.mapBackground = null;
        this.contLabelLocation = null;
        this.contName = null;
        this.shapeBounds = null;
        this.shapes = null;
        this.background = null;
        this.foreground = null;
        this.overground = null;
        this.fillerImages = null;
        this.armies = null;
        this.colors = null;
        this.ownerCode = null;
        this.contCodes = null;
        activeCountrySound.stopLooping();
    }

    private void debug(Object text) {
        System.out.println("LuxView: " + text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dirtyRect(Rectangle r) {
        Object object = this.dirtyRectLock;
        synchronized (object) {
            this.dirtyRect = this.dirtyRect == null ? r : r.union(this.dirtyRect);
        }
    }

    public void repaint(Rectangle r) {
        r = new Rectangle(r);
        r.grow(30, 30);
        if (r.height < 40) {
            r.grow(0, 40 - r.height);
        }
        if (r.width < 40) {
            r.grow(40 - r.width, 0);
        }
        super.repaint(r);
    }

    public void paintComponent(Graphics badg) {
        int i;
        if (PrefsCache.superfast) {
            return;
        }
        Graphics2D g = (Graphics2D)badg;
        g.setColor(Color.BLACK);
        g.fill(g.getClipBounds());
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.loadText != null) {
            try {
                g.setFont(AquaButton.getFontSized(56));
                GraphicsTool.drawBoxedString(g, this.loadText, this.getWidth() / 2, this.getHeight() / 2, 0, 0, Color.BLACK, Color.BLACK, 0, new Color(100, 116, 235));
                return;
            }
            catch (Exception e) {
                this.debug("Lux -> quick change of loadText caught");
            }
        }
        if (!this.cardsMode) {
            if (this.mapBackground == null) {
                this.mapBackground = this.createBackgroundImage(g, false);
            }
            g.drawImage(this.mapBackground, 0, 0, this.mapWidth, this.mapHeight, null);
        } else {
            if (this.mapBackgroundCards == null) {
                this.mapBackgroundCards = this.createBackgroundImage(g, true);
            }
            g.drawImage(this.mapBackgroundCards, 0, 0, this.mapWidth, this.mapHeight, null);
        }
        for (i = 0; i < this.shapes.length; ++i) {
            this.redrawMemory[i] = g.hitClip(this.shapeBounds[i].x - 50, this.shapeBounds[i].y - 50, this.shapeBounds[i].width + 100, this.shapeBounds[i].height + 100);
        }
        if (this.cardsMode) {
            int code;
            this.dimmedShapes(g, 0.5f);
            for (i = 0; i < this.cards.length; ++i) {
                code = this.cards[i].getCode();
                if (code == -1) continue;
                g.setColor(this.contColors[this.contCodes[code]]);
                g.setStroke(new BasicStroke(this.borderWidth, 1, 1));
                g.draw(this.shapes[code]);
            }
            for (i = 0; i < this.cards.length; ++i) {
                code = this.cards[i].getCode();
                if (code == -1) continue;
                g.setColor(GraphicsTool.solid(this.colors[this.ownerCode[code]]));
                g.fill(this.shapes[code]);
            }
            this.drawOverground(g);
            for (i = 0; i < this.cards.length; ++i) {
                code = this.cards[i].getCode();
                int symbol = this.cards[i].getSymbol();
                if (symbol == -1) {
                    symbol = 3;
                }
                if (this.cardHighlight[i]) {
                    g.drawImage(this.hilightedCards[symbol], this.cardRect[i].x, this.cardRect[i].y, null);
                } else {
                    g.drawImage(this.normalCards[symbol], this.cardRect[i].x, this.cardRect[i].y, null);
                }
                String wrappedCardName = GraphicsTool.wrapString(this.cardName[i], (int)cardSize.getWidth() - 32, g.getFont());
                if (StringTool.countLines(wrappedCardName) < 2) {
                    GraphicsTool.drawEngravedString(g, GraphicsTool.wrapString(this.cardName[i], (int)cardSize.getWidth(), g.getFont()), this.cardRect[i].x + (int)cardSize.getWidth() / 2 - g.getFontMetrics().stringWidth(this.cardName[i]) / 2, this.cardRect[i].y + 34);
                    continue;
                }
                GraphicsTool.drawBoxedStringCorneredAt(g, wrappedCardName, this.cardRect[i].x + 20, this.cardRect[i].y + 20, 0, 0, new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), 0, Color.BLACK, true);
            }
            this.drawHelperText(g);
            this.drawExplosions(g);
            return;
        }
        for (i = 0; i < this.shapes.length; ++i) {
            if (!this.redrawMemory[i]) continue;
            if (this.continentMode) {
                g.setColor(GraphicsTool.transparent(this.contColors[this.contCodes[i]], 0.75f));
            } else if (this.ownerCode[i] == -1) {
                g.setColor(GraphicsTool.transparent(Color.WHITE, 0.75f));
            } else if (this.flashContinentOn(this.contCodes[i])) {
                g.setColor(this.colors[this.ownerCode[i]]);
                g.fill(this.shapes[i]);
                g.setColor(GraphicsTool.transparent(this.contColors[this.contCodes[i]], 0.75f * this.flashContinentAlpha));
            } else {
                g.setColor(this.colors[this.ownerCode[i]]);
            }
            g.fill(this.shapes[i]);
            if (i == this.selectedCountry && !this.continentMode) {
                g.setColor(this.flashingColor);
                g.fill(this.shapes[i]);
            }
            if (this.armyLocation[i] != null) continue;
            Point p2d = GraphicsTool.getCenterOfShape(this.shapes[i]);
            this.armyLocation[i] = new Point((int)((Point2D)p2d).getX(), (int)((Point2D)p2d).getY());
        }
        GraphicsTool.drawLines(g, this.aboveLines, this.linesColor);
        this.drawOverground(g);
        if (this.gameOverText != null) {
            g.setColor(new Color(50, 50, 50, 130));
            g.fill(g.getClipBounds());
            if (this.mapWidth > 1200) {
                g.setFont(new Font("Arial", 0, 56));
            } else if (this.mapWidth > 650) {
                g.setFont(arial36);
            } else {
                g.setFont(arial24);
            }
            int colorCode = this.ownerCode[0];
            Color borderColor = colorCode == -1 ? Color.BLACK : this.colors[this.ownerCode[0]];
            GraphicsTool.drawBoxedString(g, this.gameOverText, this.mapWidth / 2, this.mapHeight / 2, 20, borderColor, 4);
            if (this.winningImage != null) {
                g.drawImage(this.winningImage, this.mapWidth / 2 + 100, this.mapHeight / 2 - 100, null);
            }
            this.drawExplosions(g);
            return;
        }
        if (this.continentMode) {
            if (!this.hideBonusLabels) {
                if (this.control.ops.boardTitle().equalsIgnoreCase("The Dark Ages")) {
                    g.setFont(arial24);
                } else {
                    g.setFont(arial24);
                }
                for (int cont = 0; cont < this.contColors.length; ++cont) {
                    Color contrastingBase;
                    if (this.control.world.getBoard().getContinentBonus(cont) == 0) continue;
                    String contTitle = this.continentName(cont) + (this.control.ops.shortContinentLabels() ? "" : "\n" + bonusString) + ": " + this.control.world.getBoard().getContinentBonus(cont);
                    if (this.contLabelLocation[cont] == null) {
                        this.contLabelLocation[cont] = new Point((int)this.continentBounds(cont).getCenterX(), (int)this.continentBounds(cont).getCenterY());
                    }
                    Color contrastingBaseOpposite = (contrastingBase = GraphicsTool.getContrastingBase(this.contColors[cont])) == Color.BLACK ? Color.WHITE : Color.BLACK;
                    GraphicsTool.drawBoxedString(g, contTitle, this.contLabelLocation[cont].x, this.contLabelLocation[cont].y, 10, 2, GraphicsTool.transparent(contrastingBaseOpposite, 0.4f), this.contColors[cont], 2, contrastingBase);
                }
                this.drawHelperText(g);
                this.drawExplosions(g);
            }
            return;
        }
        if (PrefsCache.showArmyGraphics) {
            for (i = 0; i < this.shapes.length; ++i) {
                if (!this.redrawMemory[i] || this.armies[i] <= 1 && (this.armies[i] != 1 || PrefsCache.oneLessArmy || this.ownerCode[i] == -1)) continue;
                if (this.currentArmySet == 0) {
                    if ("water".equalsIgnoreCase(this.control.world.getBoard().getContinentName(this.control.world.countries[i].getContinent()))) {
                        g.drawImage(this.armyGuy9[this.ownerCode[i]], this.armyLocation[i].x - 27, this.armyLocation[i].y - 30, null);
                        continue;
                    }
                    if (this.armies[i] < 6) {
                        g.drawImage(this.armyGuy1[this.ownerCode[i]], this.armyLocation[i].x - 30, this.armyLocation[i].y - 26, null);
                        continue;
                    }
                    if (this.armies[i] < 11) {
                        g.drawImage(this.armyGuy2[this.ownerCode[i]], this.armyLocation[i].x - 29, this.armyLocation[i].y - 26, null);
                        continue;
                    }
                    if (this.armies[i] < 26) {
                        g.drawImage(this.armyGuy3[this.ownerCode[i]], this.armyLocation[i].x - 18, this.armyLocation[i].y - 31, null);
                        continue;
                    }
                    if (this.armies[i] < 51) {
                        g.drawImage(this.armyGuy4[this.ownerCode[i]], this.armyLocation[i].x - 27, this.armyLocation[i].y - 35, null);
                        continue;
                    }
                    if (this.armies[i] < 76) {
                        g.drawImage(this.armyGuy5[this.ownerCode[i]], this.armyLocation[i].x - 27, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    if (this.armies[i] < 101) {
                        g.drawImage(this.armyGuy6[this.ownerCode[i]], this.armyLocation[i].x - 15, this.armyLocation[i].y - 35, null);
                        continue;
                    }
                    if (this.armies[i] < 201) {
                        g.drawImage(this.armyGuy7[this.ownerCode[i]], this.armyLocation[i].x - 37, this.armyLocation[i].y - 25, null);
                        if (this.armies[i] <= 150) continue;
                        g.drawImage(this.armyGuy7[this.ownerCode[i]], this.armyLocation[i].x - 40, this.armyLocation[i].y - 14, null);
                        continue;
                    }
                    g.drawImage(this.armyGuy8[this.ownerCode[i]], this.armyLocation[i].x - 32, this.armyLocation[i].y - 40, null);
                    g.drawImage(this.armyGuy8[this.ownerCode[i]], this.armyLocation[i].x + 5, this.armyLocation[i].y - 40, null);
                    continue;
                }
                if (this.currentArmySet == 1 || this.currentArmySet == 2) {
                    if ("water".equalsIgnoreCase(this.control.world.getBoard().getContinentName(this.control.world.countries[i].getContinent()))) {
                        if (this.control.ops.boardFile.armySet() == 2) {
                            g.drawImage(this.armyGuy9[this.ownerCode[i]], this.armyLocation[i].x - 7, this.armyLocation[i].y - 30, null);
                            continue;
                        }
                        g.drawImage(this.armyGuy9[this.ownerCode[i]], this.armyLocation[i].x - 27, this.armyLocation[i].y - 30, null);
                        continue;
                    }
                    if (this.armies[i] < 11) {
                        g.drawImage(this.armyGuy1[this.ownerCode[i]], this.armyLocation[i].x - 27, this.armyLocation[i].y - 30, null);
                        continue;
                    }
                    if (this.armies[i] < 26) {
                        g.drawImage(this.armyGuy2[this.ownerCode[i]], this.armyLocation[i].x - 17, this.armyLocation[i].y - 35, null);
                        continue;
                    }
                    if (this.armies[i] < 51) {
                        g.drawImage(this.armyGuy3[this.ownerCode[i]], this.armyLocation[i].x - 20, this.armyLocation[i].y - 37, null);
                        continue;
                    }
                    if (this.armies[i] < 76) {
                        g.drawImage(this.armyGuy4[this.ownerCode[i]], this.armyLocation[i].x - 20, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    if (this.armies[i] < 101) {
                        g.drawImage(this.armyGuy5[this.ownerCode[i]], this.armyLocation[i].x - 18, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    if (this.armies[i] < 151) {
                        g.drawImage(this.armyGuy6[this.ownerCode[i]], this.armyLocation[i].x - 25, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    if (this.armies[i] < 201) {
                        g.drawImage(this.armyGuy7[this.ownerCode[i]], this.armyLocation[i].x - 28, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    g.drawImage(this.armyGuy8[this.ownerCode[i]], this.armyLocation[i].x - 28, this.armyLocation[i].y - 40, null);
                    continue;
                }
                if (this.currentArmySet == 7) {
                    if ("water".equalsIgnoreCase(this.control.world.getBoard().getContinentName(this.control.world.countries[i].getContinent()))) {
                        g.drawImage(this.armyGuy9[this.ownerCode[i]], this.armyLocation[i].x - 27, this.armyLocation[i].y - 30, null);
                        continue;
                    }
                    if (this.armies[i] < 11) {
                        g.drawImage(this.armyGuy1[this.ownerCode[i]], this.armyLocation[i].x - 28, this.armyLocation[i].y - 33, null);
                        continue;
                    }
                    if (this.armies[i] < 26) {
                        g.drawImage(this.armyGuy2[this.ownerCode[i]], this.armyLocation[i].x - 28, this.armyLocation[i].y - 30, null);
                        continue;
                    }
                    if (this.armies[i] < 51) {
                        g.drawImage(this.armyGuy3[this.ownerCode[i]], this.armyLocation[i].x - 25, this.armyLocation[i].y - 30, null);
                        continue;
                    }
                    if (this.armies[i] < 76) {
                        g.drawImage(this.armyGuy4[this.ownerCode[i]], this.armyLocation[i].x - 18, this.armyLocation[i].y - 24, null);
                        continue;
                    }
                    if (this.armies[i] < 101) {
                        g.drawImage(this.armyGuy5[this.ownerCode[i]], this.armyLocation[i].x - 28, this.armyLocation[i].y - 30, null);
                        continue;
                    }
                    if (this.armies[i] < 151) {
                        g.drawImage(this.armyGuy6[this.ownerCode[i]], this.armyLocation[i].x - 30, this.armyLocation[i].y - 30, null);
                        continue;
                    }
                    if (this.armies[i] < 201) {
                        g.drawImage(this.armyGuy7[this.ownerCode[i]], this.armyLocation[i].x - 6, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    g.drawImage(this.armyGuy8[this.ownerCode[i]], this.armyLocation[i].x - 25, this.armyLocation[i].y - 41, null);
                    continue;
                }
                if (this.currentArmySet == 8) {
                    if ("water".equalsIgnoreCase(this.control.world.getBoard().getContinentName(this.control.world.countries[i].getContinent()))) {
                        g.drawImage(this.armyGuy9[this.ownerCode[i]], this.armyLocation[i].x - 27, this.armyLocation[i].y - 30, null);
                        continue;
                    }
                    if (this.armies[i] < 11) {
                        g.drawImage(this.armyGuy1[this.ownerCode[i]], this.armyLocation[i].x - 14, this.armyLocation[i].y - 35, null);
                        continue;
                    }
                    if (this.armies[i] < 26) {
                        g.drawImage(this.armyGuy2[this.ownerCode[i]], this.armyLocation[i].x - 19, this.armyLocation[i].y - 35, null);
                        continue;
                    }
                    if (this.armies[i] < 51) {
                        g.drawImage(this.armyGuy3[this.ownerCode[i]], this.armyLocation[i].x - 20, this.armyLocation[i].y - 37, null);
                        continue;
                    }
                    if (this.armies[i] < 76) {
                        g.drawImage(this.armyGuy4[this.ownerCode[i]], this.armyLocation[i].x - 20, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    if (this.armies[i] < 101) {
                        g.drawImage(this.armyGuy5[this.ownerCode[i]], this.armyLocation[i].x - 18, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    if (this.armies[i] < 151) {
                        g.drawImage(this.armyGuy6[this.ownerCode[i]], this.armyLocation[i].x - 15, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    if (this.armies[i] < 201) {
                        g.drawImage(this.armyGuy7[this.ownerCode[i]], this.armyLocation[i].x - 28, this.armyLocation[i].y - 40, null);
                        continue;
                    }
                    g.drawImage(this.armyGuy8[this.ownerCode[i]], this.armyLocation[i].x - 28, this.armyLocation[i].y - 40, null);
                    continue;
                }
                if (this.currentArmySet == 3) continue;
                if ("water".equalsIgnoreCase(this.control.world.getBoard().getContinentName(this.control.world.countries[i].getContinent()))) {
                    g.drawImage(this.armyGuy9[this.ownerCode[i]], this.armyLocation[i].x - 27, this.armyLocation[i].y - 30, null);
                    continue;
                }
                if (this.armies[i] < 11) {
                    g.drawImage(this.armyGuy1[this.ownerCode[i]], this.armyLocation[i].x - 7, this.armyLocation[i].y - 35, null);
                    continue;
                }
                if (this.armies[i] < 26) {
                    g.drawImage(this.armyGuy2[this.ownerCode[i]], this.armyLocation[i].x - 23, this.armyLocation[i].y - 35, null);
                    continue;
                }
                if (this.armies[i] < 51) {
                    g.drawImage(this.armyGuy3[this.ownerCode[i]], this.armyLocation[i].x - 20, this.armyLocation[i].y - 37, null);
                    continue;
                }
                if (this.armies[i] < 76) {
                    g.drawImage(this.armyGuy4[this.ownerCode[i]], this.armyLocation[i].x - 20, this.armyLocation[i].y - 40, null);
                    continue;
                }
                if (this.armies[i] < 101) {
                    g.drawImage(this.armyGuy5[this.ownerCode[i]], this.armyLocation[i].x - 18, this.armyLocation[i].y - 40, null);
                    continue;
                }
                if (this.armies[i] < 151) {
                    g.drawImage(this.armyGuy6[this.ownerCode[i]], this.armyLocation[i].x - 15, this.armyLocation[i].y - 40, null);
                    continue;
                }
                if (this.armies[i] < 201) {
                    g.drawImage(this.armyGuy7[this.ownerCode[i]], this.armyLocation[i].x - 28, this.armyLocation[i].y - 40, null);
                    continue;
                }
                g.drawImage(this.armyGuy8[this.ownerCode[i]], this.armyLocation[i].x - 28, this.armyLocation[i].y - 40, null);
            }
        }
        if (this.arrowFromCountry != -1 && !this.continentMode) {
            g.setColor(new Color(190, 20, 20, 204));
            if (this.arrowToCountryArray == null) {
                GraphicsTool.drawArrowImageConnectingPoints(g, this.armyLocation[this.arrowFromCountry], this.armyLocation[this.arrowToCountry], this.arrowDoubleEnded);
            } else {
                for (i = 0; i < this.arrowToCountryArray.length; ++i) {
                    GraphicsTool.drawArrowImageConnectingPoints(g, this.armyLocation[this.arrowFromCountry], this.armyLocation[this.arrowToCountryArray[i]], this.arrowDoubleEnded);
                }
            }
        }
        if (this.mouseOverCountry != -1 && this.mouseOverCountry != this.arrowFromCountry && !this.continentMode) {
            g.setColor(Color.GRAY);
            for (i = 0; i < this.mouseOverCountryConnected.length; ++i) {
                GraphicsTool.drawArrowImageConnectingPoints(g, this.armyLocation[this.mouseOverCountry], this.armyLocation[this.mouseOverCountryConnected[i]], true);
            }
        }
        g.setFont(sansSerifBold12);
        for (i = 0; i < this.shapes.length; ++i) {
            if (!this.redrawMemory[i] || this.armies[i] <= 1 && (this.armies[i] != 1 || PrefsCache.oneLessArmy || this.ownerCode[i] == -1)) continue;
            int showNum = PrefsCache.oneLessArmy ? this.armies[i] - 1 : this.armies[i];
            if (showNum < 10) {
                g.drawImage(this.bubble1[this.ownerCode[i]], this.armyLocation[i].x - 8, this.armyLocation[i].y - 16, null);
            } else if (showNum < 100) {
                g.drawImage(this.bubble2[this.ownerCode[i]], this.armyLocation[i].x - 4, this.armyLocation[i].y - 14, null);
            } else if (showNum < 1000) {
                g.drawImage(this.bubble3[this.ownerCode[i]], this.armyLocation[i].x - 3, this.armyLocation[i].y - 14, null);
            } else if (showNum < 10000) {
                g.drawImage(this.bubble4[this.ownerCode[i]], this.armyLocation[i].x - 5, this.armyLocation[i].y - 14, null);
            } else if (showNum < 100000) {
                g.drawImage(this.bubble5[this.ownerCode[i]], this.armyLocation[i].x - 5, this.armyLocation[i].y - 14, null);
            } else if (showNum < 1000000) {
                g.drawImage(this.bubble4[this.ownerCode[i]], this.armyLocation[i].x - 3, this.armyLocation[i].y - 14, null);
            } else {
                g.drawImage(this.bubble5[this.ownerCode[i]], this.armyLocation[i].x - 4, this.armyLocation[i].y - 14, null);
            }
            g.setColor(GraphicsTool.getContrastingBase(this.colors[this.ownerCode[i]], 0.6f));
            if (showNum < 100000) {
                g.drawString(String.valueOf(showNum), this.armyLocation[i].x, this.armyLocation[i].y);
                continue;
            }
            if (showNum < 10000000) {
                g.drawString(String.valueOf(showNum / 1000) + "k", this.armyLocation[i].x, this.armyLocation[i].y);
                continue;
            }
            g.drawString(String.valueOf(showNum / 1000000) + "M", this.armyLocation[i].x, this.armyLocation[i].y);
        }
        for (i = 0; i < this.flashContinents.size(); ++i) {
            Color contrastingBase;
            int localFlashContinent = (Integer)this.flashContinents.get(i);
            float localFlashContinentAlpha = this.flashContinentAlpha;
            if (localFlashContinent <= -1 || !(localFlashContinentAlpha > 0.0f)) continue;
            g.setFont(arial24);
            String contTitle = this.continentName(localFlashContinent) + (this.control.ops.shortContinentLabels() ? "" : "\n" + bonusString) + ": " + this.control.world.getBoard().getContinentBonus(localFlashContinent);
            if (this.contLabelLocation[localFlashContinent] == null) {
                this.contLabelLocation[localFlashContinent] = new Point((int)this.continentBounds(localFlashContinent).getCenterX(), (int)this.continentBounds(localFlashContinent).getCenterY());
            }
            Color contrastingBaseOpposite = (contrastingBase = GraphicsTool.getContrastingBase(this.contColors[localFlashContinent])) == Color.BLACK ? Color.WHITE : Color.BLACK;
            GraphicsTool.drawBoxedString(g, contTitle, this.contLabelLocation[localFlashContinent].x, this.contLabelLocation[localFlashContinent].y, 10, 2, GraphicsTool.transparent(contrastingBaseOpposite, 0.4f * localFlashContinentAlpha), GraphicsTool.transparent(this.contColors[localFlashContinent], localFlashContinentAlpha), 2, GraphicsTool.transparent(contrastingBase, localFlashContinentAlpha));
        }
        this.drawHelperText(g);
        this.drawExplosions(g);
    }

    public void setContainsPlayerInfo(boolean drawInfoPanelNew) {
        if (drawInfoPanelNew) {
            Point p;
            this.infoPanel = this.control.getPlayerInfoViewForSlaveMode();
            String pointString = Prefs.get("PI_" + this.control.ops.boardName(), null);
            if ((pointString == null || "".equals(pointString)) && "".equals(pointString = this.control.ops.boardFile.playerInfoLocation())) {
                pointString = null;
            }
            if (!this.control.ops.customBoard && pointString == null) {
                pointString = Prefs.get("PIg_" + this.control.ops.generatorName(), null);
            }
            if (pointString != null && this.mapWidth != this.control.ops.width) {
                p = GraphicsTool.pointFromString(pointString);
                p.setLocation((double)(p.x + 140) * this.resizePercent - 140.0, (double)(p.y + 50) * this.resizePercent - 50.0);
                pointString = GraphicsTool.stringFromPoint(p);
            }
            if (pointString == null) {
                if (this.control.ops.customBoard) {
                    this.infoPanel.setLocation(-2, -2);
                }
            } else {
                p = GraphicsTool.pointFromString(pointString);
                if (p.x < -2) {
                    p.setLocation(-2, p.y);
                }
                if (p.y < -4) {
                    p.setLocation(p.x, -2);
                }
                if (p.x > this.mapWidth) {
                    p.setLocation(-2, p.y);
                }
                if (p.y > this.mapHeight) {
                    p.setLocation(p.x, -2);
                }
                this.infoPanel.setLocation(p);
            }
            this.add(this.infoPanel);
        } else if (this.infoPanel != null) {
            this.remove(this.infoPanel);
            this.infoPanel = null;
            this.control.playerInfo.exitSlaveMode();
        }
        this.drawInfoPanel = drawInfoPanelNew;
        this.repaint();
    }

    public int getFPS() {
        return this.FPS;
    }

    private void drawExplosions(Graphics2D g) {
        ++this.currentFPS;
        if (System.currentTimeMillis() - this.startFPScounter >= 1000L) {
            this.FPS = this.currentFPS;
            this.currentFPS = 0;
            this.startFPScounter = System.currentTimeMillis();
        }
        boolean drawFPS = false;
        try {
            for (int i = 0; i < this.animationPoint.length; ++i) {
                if (this.animationPoint[i] == null) continue;
                g.drawImage(explosionFramesArrays[this.animationNumber[i]][this.animationFrameCount[i]], this.animationPoint[i].x, this.animationPoint[i].y, null);
                if (!drawFPS) continue;
                drawFPS = false;
                GraphicsTool.drawBoxedString(g, "FPS: " + this.getFPS(), this.animationPoint[i].x, this.animationPoint[i].y, 0, 0, Color.BLACK, Color.BLACK, 0, Color.RED);
            }
        }
        catch (Exception e) {
            this.debug("Lux -> Exception caught in drawing the explosions");
        }
    }

    private void drawOverground(Graphics2D g) {
        try {
            if (this.overground != null) {
                g.drawImage(this.overground, 0, 0, this.mapWidth, this.mapHeight, null);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void drawForeground(Graphics2D g) {
        if (this.foreground != null) {
            Shape oldClip = g.getClip();
            for (int i = 0; i < this.shapes.length; ++i) {
                g.clip(this.shapes[i]);
                g.drawImage(this.foreground, 0, 0, this.mapWidth, this.mapHeight, null);
                g.setClip(oldClip);
            }
        }
    }

    private void drawForeground2(Graphics2D g) {
        if (this.foreground == null) {
            this.debug("LuxView: drawForeground2 called with foreground == null!");
            return;
        }
        Shape oldClip = g.getClip();
        g.setClip(null);
        for (int i = 0; i < this.shapes.length; ++i) {
            g.setClip(this.shapes[i]);
            g.drawImage(this.foreground, 0, 0, this.mapWidth, this.mapHeight, null);
        }
        g.setClip(oldClip);
    }

    private void drawForeground3(Graphics2D g) {
        if (this.foreground == null) {
            this.debug("LuxView: drawForeground3 called with foreground == null!");
            return;
        }
        GraphicsConfiguration gc = g.getDeviceConfiguration();
        BufferedImage bi = gc.createCompatibleImage(this.mapWidth, this.mapHeight, 1);
        Graphics2D tG2 = bi.createGraphics();
        tG2.drawImage(this.foreground, 0, 0, this.mapWidth, this.mapHeight, null);
        TexturePaint foregroundPaint = new TexturePaint(bi, new Rectangle(0, 0, this.mapWidth, this.mapHeight));
        g.setPaint(foregroundPaint);
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < this.shapes.length; ++i) {
            g.fill(this.shapes[i]);
        }
        foregroundPaint = null;
    }

    public void toggleContinentBonuses() {
        this.clearNotices();
        boolean bl = this.continentMode = !this.continentMode;
        if (this.continentMode) {
            this.tutorialContinentMode = false;
            if (this.control.ops.continentSequence.increases()) {
                this.showNotice(Translator.getString("Continentmodedescription") + "\n" + Translator.getString("Continentsgoup") + " " + this.control.ops.continentSequence.longString() + ".");
            } else {
                this.showNotice(Translator.getString("Continentmodedescription"));
            }
        } else {
            this.setHelperText(null);
        }
        this.repaint();
    }

    public void setHelperTextAfterName(String text) {
        if (text == null) {
            text = "";
        }
        if (!(text = helpBegin + (helpBegin.equals("") ? "" : " ") + this.control.ops.playerNames[this.control.world.currentPlayer] + (helpEnd.startsWith("'") ? "" : " ") + helpEnd + " - " + text).equals(this.helperText)) {
            this.helperText = text;
            this.repaint();
        }
    }

    public void setHelperText(String text) {
        if (text == null) {
            if (this.helperText == null) {
                return;
            }
            this.helperText = null;
            this.repaint(new Rectangle(10, this.mapHeight - 100, this.mapWidth, 100));
            return;
        }
        this.showNotice(text);
    }

    private void drawHelperText(Graphics2D g) {
        if (this.hideTips) {
            return;
        }
        this.drawNotices(g);
    }

    private void dimmedShapes(Graphics2D g, float dimmedAlpha) {
        for (int i = 0; i < this.shapes.length; ++i) {
            if (!this.redrawMemory[i]) continue;
            if (this.ownerCode[i] == -1) {
                g.setColor(GraphicsTool.transparent(Color.WHITE, dimmedAlpha));
            } else {
                g.setColor(GraphicsTool.transparent(this.colors[this.ownerCode[i]], dimmedAlpha));
            }
            g.fill(this.shapes[i]);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.mouseAction(e, e.isShiftDown() || e.getButton() == 2 || e.getButton() == 3);
        if (!this.control.ops.allowNetworkPlayers) {
            this.requestFocus();
        }
    }

    protected void setScrolling(int newState) {
        this.scrollingState = newState;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        Point exitPoint = SwingUtilities.convertPoint(this, e.getPoint(), this.getParent());
        if (exitPoint.getY() <= 0.0) {
            this.setScrolling(1);
        } else if (exitPoint.getX() <= 0.0) {
            this.setScrolling(3);
        } else if (exitPoint.getX() > (double)this.getParent().getWidth()) {
            this.setScrolling(4);
        }
    }

    public void mouseAction(MouseEvent e, boolean shiftPressed) {
        int targetCode;
        boolean flipTillDeath;
        if (this.loadText != null) {
            return;
        }
        if (this.continentMode) {
            this.control.toggleContinentBonuses();
            return;
        }
        Point loc = e.getPoint();
        if (this.cardsMode) {
            for (int i = this.cards.length - 1; i > -1; --i) {
                if (!this.cardRect[i].contains((Point2D)loc)) continue;
                this.cardHighlight[i] = !this.cardHighlight[i];
                this.cardName[i] = this.shapeName(this.cards[i].getCode());
                this.dirtyRect(this.cardRect[i]);
                return;
            }
            return;
        }
        int selectedArmies = this.control.armySelector.getNumberSelectedArmies();
        boolean bl = flipTillDeath = e.isAltDown() || e.isControlDown() || e.isMetaDown() && e.getButton() == 1;
        if (!shiftPressed) {
            if (e.isControlDown() || e.isMetaDown()) {
                selectedArmies = Math.min(5, this.control.armySelector.getFluxArmies());
            }
            if (e.isAltDown()) {
                selectedArmies = Math.min(10, this.control.armySelector.getFluxArmies());
            }
            if ((e.isControlDown() || e.isMetaDown()) && e.isAltDown()) {
                selectedArmies = Math.min(50, this.control.armySelector.getFluxArmies());
            }
            if (this.placingKey > 0 && selectedArmies < 2 && this.divisionTotalOriginal > 0) {
                this.usedPlacedDividerKey = true;
                ++this.usedPlacedDividerKeyCount;
                selectedArmies = Math.min(Math.round((float)this.divisionTotalOriginal / (float)this.placingKey), this.control.armySelector.getFluxArmies());
                if (this.usedPlacedDividerKeyCount >= this.placingKey && this.control.armySelector.getFluxArmies() - selectedArmies < this.placingKey) {
                    selectedArmies = this.control.armySelector.getFluxArmies();
                }
            } else {
                this.usedPlacedDividerKey = false;
                this.usedPlacedDividerKeyCount = 0;
            }
        }
        if ((targetCode = this.getCountryCodeFromPoint(loc)) != -1) {
            this.control.countryClicked(targetCode, shiftPressed, flipTillDeath, selectedArmies);
        }
    }

    public boolean usedPlacedDividerKey() {
        boolean wasValue = this.usedPlacedDividerKey;
        this.usedPlacedDividerKey = false;
        return wasValue;
    }

    public void setPlacingKey(int divisionFactor) {
        if (this.placingKey == divisionFactor) {
            if (this.placingKey <= 0) {
                this.control.world.setEmptyDefenders(false);
            }
            return;
        }
        if (divisionFactor == 99) {
            this.control.world.setEmptyDefenders(true);
            return;
        }
        this.control.world.setEmptyDefenders(false);
        this.placingKey = divisionFactor;
        this.divisionTotalOriginal = this.placingKey > 0 ? this.control.armySelector.getFluxArmies() : 0;
    }

    public void moveInfoPanel(int x, int y) {
        if (!this.drawInfoPanel) {
            return;
        }
        Point oldLocation = this.infoPanel.getLocation();
        int newX = Math.max(oldLocation.x + x, -200);
        newX = Math.min(newX, this.getWidth() - 50);
        int newY = Math.max(oldLocation.y + y, -50);
        newY = Math.min(newY, this.getHeight() - 50);
        this.infoPanel.setLocation(newX, newY);
        Point p = new Point(oldLocation.x + x, oldLocation.y + y);
        p.setLocation((double)p.x / this.resizePercent, (double)p.y / this.resizePercent);
        Prefs.put(this.control.ops.customBoard ? "PI_" + this.control.ops.boardName() : "PIg_" + this.control.ops.generatorName(), GraphicsTool.stringFromPoint(p));
    }

    private int getCountryCodeFromPoint(Point2D loc) {
        int closestShape = -1;
        boolean insideBoundingBoxCount = false;
        int closeShapeLimit = 15;
        double closestDistance = 1000000.0;
        if (Math.random() > 0.5) {
            for (int i = 0; i < this.shapes.length; ++i) {
                double distance;
                if (this.shapeBounds[i].contains(loc) && this.shapes[i].contains(loc)) {
                    return i;
                }
                if (!(GraphicsTool.distanceFromPointToRect(loc, this.shapeBounds[i]) < (double)closeShapeLimit) || !((distance = GraphicsTool.distanceFromPointToGeneralPath(loc, this.shapes[i])) < closestDistance)) continue;
                closestDistance = distance;
                closestShape = i;
            }
        } else {
            for (int i = this.shapes.length - 1; i > -1; --i) {
                double distance;
                if (this.shapeBounds[i].contains(loc) && this.shapes[i].contains(loc)) {
                    return i;
                }
                if (!(GraphicsTool.distanceFromPointToRect(loc, this.shapeBounds[i]) < (double)closeShapeLimit) || !((distance = GraphicsTool.distanceFromPointToGeneralPath(loc, this.shapes[i])) < closestDistance)) continue;
                closestDistance = distance;
                closestShape = i;
            }
        }
        if (closestShape != -1 && closestDistance < (double)closeShapeLimit) {
            return closestShape;
        }
        return -1;
    }

    public static void setBorderWidth(int width) {
        for (int i = 0; i < luxViews.size(); ++i) {
            ((LuxView)luxViews.get(i)).setBorderWidthNonStatic(width);
        }
    }

    public void setBorderWidthNonStatic(int width) {
        this.borderWidth = width;
        this.outlineWidth = (int)((double)width * 1.4285714285714286);
        if (this.control.ops.biohazardLevel() == 0) {
            this.loadTheme(this.currentTheme);
            this.mapBackground = null;
            this.mapBackgroundCards = null;
        }
        this.repaint();
    }

    private void setForeground() {
        int foregroundChoice = this.rand.nextInt(5) + 1;
        this.foreground = GraphicsTool.getImageFromJAR("land" + foregroundChoice + ".jpg");
        this.customForeground = false;
        this.mapBackground = null;
        this.mapBackgroundCards = null;
    }

    public void setArrowOnCountry(int countryFrom, int countryTo) {
        this.arrowFromCountry = countryFrom;
        this.arrowToCountry = countryTo;
        this.arrowToCountryArray = null;
        this.arrowDoubleEnded = true;
        this.repaint();
    }

    public void setArrowOnCountry(int countryFrom, int[] countryToArray) {
        this.setArrowOnCountry(countryFrom, countryToArray, true);
    }

    public void setArrowOnCountry(int countryFrom, int[] countryToArray, boolean doubleArrow) {
        this.arrowFromCountry = countryFrom;
        this.arrowToCountryArray = countryToArray;
        this.arrowDoubleEnded = doubleArrow;
        this.repaint();
    }

    public boolean isOpaque() {
        return true;
    }

    public void setBoardSize(int width, int height) {
        System.out.println("LuxView: setBoardSize (" + width + "," + height + ")");
        this.mapWidth = width;
        this.mapHeight = height;
        if (this.drawInfoPanel) {
            String pointString = Prefs.get("PI_" + this.control.ops.boardName(), null);
            if (pointString == null && !this.control.ops.customBoard) {
                pointString = Prefs.get("PIg_" + this.control.ops.generatorName(), null);
            }
            if (pointString != null) {
                this.infoPanel.setLocation(GraphicsTool.pointFromString(pointString));
            }
        }
    }

    public void doneLoading() {
        this.resizeOnLoad = false;
    }

    public void prepareToResizeMap(double percent) {
        int i;
        if (percent < 0.0) {
            SS.debug("LuxView.prepareToResizeMap(" + percent + ") LESS THAN ZERO !!!");
            Thread.dumpStack();
        }
        this.mapWidth = (int)((double)this.control.ops.width * percent);
        this.mapHeight = (int)((double)this.control.ops.height * percent);
        System.out.println("LuxView: prepare to resize from (" + this.control.ops.width + "," + this.control.ops.height + ") to (" + this.mapWidth + "," + this.mapHeight + ") by percent=" + percent);
        this.setMinimumSize(new Dimension(this.mapWidth, this.mapHeight));
        this.setPreferredSize(new Dimension(this.mapWidth, this.mapHeight));
        if (this.armyLocation != null) {
            for (i = 0; i < this.armyLocation.length; ++i) {
                this.armyLocation[i] = null;
            }
        }
        if (this.contLabelLocation != null) {
            for (i = 0; i < this.contLabelLocation.length; ++i) {
                this.contLabelLocation[i] = null;
                this.contBounds[i] = null;
            }
        }
        this.resizeOnLoad = true;
        this.resizePercent = percent;
    }

    public boolean containsPlayerInfo() {
        return this.drawInfoPanel;
    }

    public void keyPressed(KeyEvent e) {
        String stringTyped;
        if (e.getKeyCode() == 49) {
            this.setPlacingKey(1);
        } else if (e.getKeyCode() == 50) {
            this.setPlacingKey(2);
        } else if (e.getKeyCode() == 51) {
            this.setPlacingKey(3);
        } else if (e.getKeyCode() == 52) {
            this.setPlacingKey(4);
        } else if (e.getKeyCode() == 53) {
            this.setPlacingKey(5);
        } else if (e.getKeyCode() == 54) {
            this.setPlacingKey(6);
        } else if (e.getKeyCode() == 55) {
            this.setPlacingKey(7);
        } else if (e.getKeyCode() == 56) {
            this.setPlacingKey(8);
        } else if (e.getKeyCode() == 57) {
            this.setPlacingKey(9);
        } else if (e.getKeyCode() == 90) {
            this.setPlacingKey(99);
        }
        if (e.getKeyCode() == 27) {
            this.escapeKeyActions();
        }
        this.keyPressedBuffer.append(e.getKeyChar());
        if (this.keyPressedBuffer.length() > 10) {
            this.keyPressedBuffer.deleteCharAt(0);
        }
        if ((stringTyped = this.keyPressedBuffer.toString().toLowerCase()).endsWith("equal")) {
            // empty if block
        }
        if (stringTyped.endsWith("gamover")) {
            this.gameOverText = "Game Over Text enabled";
        }
        if (stringTyped.endsWith("nolab")) {
            this.hideBonusLabels = !this.hideBonusLabels;
            this.repaint();
        }
        if (stringTyped.endsWith("notips")) {
            this.hideTips = !this.hideTips;
            this.repaint();
        }
        if (e.getKeyCode() == 69 && e.isControlDown() && e.isShiftDown()) {
            this.orderExplosion(this.rand.nextInt(this.shapeBounds.length));
        }
        if (this.control.fullscreen) {
            if (e.getKeyCode() == 70 && e.isControlDown() && e.isShiftDown()) {
                e.consume();
                this.control.toggleFullscreen();
                return;
            }
            if (e.getKeyCode() == 73 && e.isControlDown()) {
                e.consume();
                this.control.actionPerformed(new ActionEvent(this.control, 1, "playerInfoToggle"));
                return;
            }
            if (e.getKeyCode() == 66 && e.isControlDown()) {
                e.consume();
                this.control.toggleContinentBonuses();
                return;
            }
            if (e.getKeyCode() == 68 && e.isControlDown()) {
                e.consume();
                this.control.clickCards();
                return;
            }
            if (e.getKeyCode() == 70 && e.isControlDown()) {
                e.consume();
                this.control.clickFortify();
                return;
            }
            if (e.getKeyCode() == 69 && e.isControlDown()) {
                e.consume();
                this.control.clickEndTurn();
                return;
            }
            if (e.getKeyCode() == 83 && e.isControlDown() && e.isAltDown()) {
                e.consume();
                this.control.actionPerformed(new ActionEvent(this.control, 1, "screenshot"));
                return;
            }
            if (e.getKeyCode() == 83 && e.isControlDown()) {
                e.consume();
                this.control.saveGame();
                return;
            }
            if (e.getKeyCode() == 78 && e.isControlDown() && e.isAltDown()) {
                e.consume();
                this.control.clickReplayMap();
                return;
            }
            if (e.getKeyCode() == 87 && e.isControlDown()) {
                e.consume();
                this.control.windowClosing(null);
                return;
            }
        }
        if (e.getKeyCode() == 10) {
            try {
                JButton defaultButton = this.control.boardWindow.getRootPane().getDefaultButton();
                if (defaultButton != null) {
                    e.consume();
                    defaultButton.doClick();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void escapeKeyActions() {
        if (this.cardsMode) {
            this.control.clickCards();
        } else if (this.continentMode) {
            this.control.toggleContinentBonuses();
        } else {
            this.control.showMenuInline();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.placingKey > 0) {
            this.setPlacingKey(0);
        }
        if (this.control != null && this.control.world != null) {
            this.control.world.setEmptyDefenders(false);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public boolean isFocusable() {
        return true;
    }

    public void mouseMoved(MouseEvent e) {
        this.lastMousePoint = e.getPoint();
        this.scrollingState = 0;
        if (SwingUtilities.convertPoint(this, e.getPoint(), this.getParent()).getX() < 2.0) {
            this.setScrolling(3);
        }
        this.setProperCursor();
    }

    public void mouseMoved(Point p) {
        int newMouseOverCountry = this.getCountryCodeFromPoint(p);
        if (newMouseOverCountry == this.mouseOverCountry) {
            return;
        }
        this.mouseOverCountry = newMouseOverCountry;
        this.mouseOverCountryConnected = (int[])(this.mouseOverCountry == -1 ? null : this.control.world.countries[this.mouseOverCountry].getAdjoiningCodeList());
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent(this);
        return tip;
    }

    public void setWinningImage(String iconURL) {
    }

    public void flashContinent(int cont) {
        if (this.flashContinentOwner != this.control.world.currentPlayer) {
            Rectangle redrawArea = this.addFlashingContinentsToRedrawArea(null);
            if (redrawArea != null) {
                this.repaint(redrawArea);
            }
            this.flashContinents.clear();
        }
        this.flashContinents.add(new Integer(cont));
        this.flashContinentAlpha = 1.0f;
        this.flashContinentOwner = this.control.world.currentPlayer;
    }

    private boolean flashContinentOn(int i) {
        return this.flashContinents.contains(new Integer(i));
    }

    protected void doBiohazardLineRemoval() {
        SS.debug("removing biohazard lines");
        for (int i = 0; i < this.lines.size(); ++i) {
            ExtraLine el = (ExtraLine)this.lines.get(i);
            int connectedSides = 0;
            Point from = el.from();
            Point to = el.to();
            if (this.isInShapes(from) != -1) {
                ++connectedSides;
            }
            if (this.isInShapes(to) != -1) {
                ++connectedSides;
            }
            if (connectedSides >= 2) continue;
            this.lines.remove(i);
            --i;
        }
    }

    public Font getNoticeFont() {
        if (SS.isMacintosh) {
            return lucida13;
        }
        return arial12;
    }

    public FontMetrics getNoticeFontMetrics() {
        return this.getFontMetrics(this.getNoticeFont());
    }

    public void showNoticeBottomRight(String text) {
        Dimension textSize = GraphicsTool.getDimensionOfText(text, this.getNoticeFontMetrics());
        this.showNotice(text, new Point(this.mapWidth - textSize.width / 2 - 36, this.mapHeight - textSize.height / 2 - 36), 12000L);
    }

    public void showNotice(String text) {
        int lineCount = StringTool.countLines(text);
        int y = this.mapHeight - this.getNoticeFontMetrics().getHeight() * lineCount / 2 - 36;
        this.showNotice(text, new Point(this.mapWidth / 2, y));
    }

    public void showNoticeOnCountry(String text, int countryID) {
        if (this.notices == null) {
            this.notices = new ArrayList();
        }
        Point p = new Point((int)this.shapeBounds[countryID].getCenterX(), (int)this.shapeBounds[countryID].getCenterY());
        VisualsNotice n = new VisualsNotice(text, p, 5000L, true);
        this.notices.add(n);
        this.repaint(n.getBounds(this.getNoticeFont()));
    }

    public void showNotice(String text, Point op) {
        this.showNotice(text, op, 10000L);
    }

    public void showNotice(String text, Point op, long length) {
        if (this.notices == null) {
            this.notices = new ArrayList();
        }
        Point p = new Point(Math.max(100, op.x), Math.max(70, op.y));
        VisualsNotice n = new VisualsNotice(text, p, length, false);
        this.notices.add(n);
        this.repaint(n.getBounds(this.getNoticeFont()));
    }

    public void drawNotices(Graphics2D g) {
        if (this.notices == null) {
            return;
        }
        g.setFont(this.getNoticeFont());
        for (int i = 0; i < this.notices.size(); ++i) {
            VisualsNotice n = (VisualsNotice)this.notices.get(i);
            boolean stillDrawing = n.draw(g);
            if (stillDrawing || this.cardsMode || this.continentMode) continue;
            this.notices.remove(n);
            this.repaint(n.getBounds(this.getNoticeFont()));
            --i;
        }
    }

    public void clearNotices() {
        this.notices = null;
    }

    public void setProperCursor() {
        this.setCursor(arrowCursor);
    }

    static {
        luxViews = new Vector();
    }
}

