/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.BoardFile;
import com.sillysoft.lux.CrossPlatformLuxController;
import com.sillysoft.lux.EsellerateWrapper;
import com.sillysoft.lux.Lux;
import com.sillysoft.lux.LuxMapGenerator;
import com.sillysoft.lux.LuxOptions;
import com.sillysoft.lux.editor.MapEditor;
import com.sillysoft.lux.gui.AboutWindow;
import com.sillysoft.lux.gui.AnimationLoader;
import com.sillysoft.lux.gui.EnterCodeWindow;
import com.sillysoft.lux.gui.GameControllerGUI;
import com.sillysoft.lux.gui.JoinGame;
import com.sillysoft.lux.gui.PluginWindow;
import com.sillysoft.lux.gui.PreferencesWindow;
import com.sillysoft.lux.gui.RankingController;
import com.sillysoft.lux.gui.UpdateController;
import com.sillysoft.lux.net.NetBoss;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.FolderLauncher;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.LogFile;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.RemoteImageFetcher;
import com.sillysoft.tools.RemoteImageListener;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.MusicEngine;
import com.sillysoft.widgets.Newsletter;
import com.sillysoft.widgets.RegisterNag;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSCheckBox;
import com.sillysoft.widgets.SSCheckBoxMenuItemAlwaysOn;
import com.sillysoft.widgets.SSCheckBoxMenuItemSet;
import com.sillysoft.widgets.SSColorChooser;
import com.sillysoft.widgets.SSColorWell;
import com.sillysoft.widgets.SSComboBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSLink;
import com.sillysoft.widgets.SSMenuItem;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSTextField;
import com.sillysoft.widgets.TexturedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;

public class LuxController
extends CrossPlatformLuxController
implements ActionListener,
WindowListener,
SSApplicationGUI,
RemoteImageListener {
    private List activeGames = new Vector();
    protected SSFrame newGameWindow;
    JMenuBar menuBar;
    private SSButton playButton;
    private SSButton enterCodeButton;
    private SSButton orderNowButton;
    JLabel registration;
    JLabel mapStartingPositionWords;
    private JLabel pluginImage;

    public LuxController() {
        SSApp.setInstance(this);
        sharedController = this;
        if (!PrefsCache.headless) {
            SSFrame.setDefaultIcon("globe.gif");
        }
        if (SS.isMacintosh) {
            this.copyInitialSupportFiles();
        }
        this.sharewareVersion = true;
        this.sharewareCount = Prefs.getInt("savedSelection", 0);
        if (EsellerateWrapper.validRegistration(Prefs.get("regName"), Prefs.get("regCode"))) {
            this.sharewareVersion = false;
        } else {
            this.setInitialSharewareCount();
            Prefs.put("regName", "");
            Prefs.put("regCode", "");
        }
        if (!PrefsCache.headless) {
            this.createNewGameWindow();
            this.newGameWindow.show();
            this.newGameWindow.getRootPane().setDefaultButton(this.playButton);
        }
        Prefs.putInt("launchCount", Prefs.getInt("launchCount", 0) + 1);
        if (this.sharewareVersion) {
            if (this.sharewareCount >= 2 && !PrefsCache.headless) {
                int nag_switcher = Prefs.getInt("nag_switcher", 0);
                if (nag_switcher == 0) {
                    new RegisterNag("Marketing_Plugins.jpg", "init");
                } else if (nag_switcher == 1) {
                    new RegisterNag("Marketing_Online.jpg", "init");
                } else if (nag_switcher == 2) {
                    new RegisterNag("Marketing_Closing.jpg", "init");
                } else if (nag_switcher == 3) {
                    PluginManager.getInstance().wakeUp();
                }
                Prefs.putInt("nag_switcher", (nag_switcher + 1) % 4);
            }
        } else if (!PrefsCache.superfast && !PrefsCache.headless) {
            if (!Prefs.getBoolean("newsletterAsked", false) && Prefs.getInt("launchCount") > 4) {
                Prefs.putBoolean("newsletterAsked", true);
                Newsletter.show(this.newGameWindow, "http://sillysoft.net/");
            } else if (Prefs.getInt("launchCount") > 3) {
                PluginManager.getInstance().wakeUp();
            }
        }
        if (PrefsCache.headless) {
            NetBoss netBoss = new NetBoss(this.internetPublic());
            netBoss.startGame();
        } else {
            UpdateController.checkForUpdateIfNeeded();
            AnimationLoader.loadAnimationsInBackground();
        }
    }

    public void upSharewareCount() {
        super.upSharewareCount();
        if (this.sharewareVersion) {
            this.registration.setText(Translator.getString("Demo") + ": " + Translator.getString("GameCountStart") + " " + this.sharewareCount + " " + Translator.getString("GameCountEnd"));
        }
    }

    private void createNewGameWindow() {
        this.newGameWindow = new SSFrame("Lux Delux: The Game of Universal Domination");
        this.newGameWindow.setAutoTracking(false);
        this.newGameWindow.addWindowListener(this);
        this.newGameWindow.setResizable(false);
        JPanel worldPanel = new JPanel();
        worldPanel.setLayout(new BoxLayout(worldPanel, 1));
        worldPanel.add(Box.createVerticalGlue());
        this.mapSelector = new SSComboBox();
        this.mapSelector.setMaximumRowCount(30);
        this.mapSelector.setOpaque(false);
        worldPanel.add(this.mapSelector);
        JPanel mapButtonPanel = new JPanel();
        mapButtonPanel.setLayout(new BoxLayout(mapButtonPanel, 0));
        SSButton button = new SSButton(" ", new ImageIcon(GraphicsTool.class.getResource("/arrow_plugin_left.png")));
        button.setOpaque(false);
        button.setPreferredWidth(60);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int next = LuxController.this.mapSelector.getSelectedIndex() - 1;
                if (next < 0) {
                    next = LuxController.this.mapSelector.getItemCount() - 1;
                }
                if (LuxController.this.mapSelector.getItemAt(next).equals(" \u221e " + Translator.getString("Getmoremaps"))) {
                    next -= 2;
                }
                LuxController.this.mapSelector.setSelectedIndex(next);
            }
        });
        button.putClientProperty("JButton.buttonType", "text");
        mapButtonPanel.add(button);
        String pluginButtonText = Translator.getString("PluginsButton");
        for (int i = pluginButtonText.length(); i < 18; i += 2) {
            pluginButtonText = " " + pluginButtonText + " ";
        }
        button = new SSButton(pluginButtonText);
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginWindow.show();
            }
        });
        mapButtonPanel.add(Box.createHorizontalGlue());
        mapButtonPanel.add(button);
        mapButtonPanel.add(Box.createHorizontalGlue());
        button = new SSButton(" ", new ImageIcon(GraphicsTool.class.getResource("/arrow_plugin_right.png")));
        button.setPreferredWidth(60);
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int next = LuxController.this.mapSelector.getSelectedIndex() + 1;
                if (LuxController.this.mapSelector.getItemAt(next).equals(" \u221e " + Translator.getString("GotoSavedBoards"))) {
                    next += 2;
                }
                if (next >= LuxController.this.mapSelector.getItemCount()) {
                    next = 0;
                }
                LuxController.this.mapSelector.setSelectedIndex(next);
            }
        });
        mapButtonPanel.add(button);
        mapButtonPanel.setOpaque(false);
        worldPanel.add(mapButtonPanel);
        JPanel panel = GraphicsTool.getNonOpaqueJPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createVerticalGlue());
        panel.add(new JLabel("    "));
        worldPanel.add(panel);
        Dimension preferredDimension = this.mapSelector.getPreferredSize();
        panel = GraphicsTool.getNonOpaqueJPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.mapStartingPositionWords = new JLabel(" " + Translator.getString("StartingPosition"));
        panel.add(this.mapStartingPositionWords);
        panel.add(Box.createHorizontalGlue());
        worldPanel.add(panel);
        if (!SS.isMacintosh) {
            worldPanel.add(Box.createVerticalStrut(1));
        }
        this.mapStartingPosition = new SSComboBox(new Object[]{Translator.getString("scenarioSwitch"), Translator.getString("random") + " " + Translator.getString("countries") + " / " + Translator.getString("even") + " " + Translator.getString("armies"), Translator.getString("random") + " " + Translator.getString("countries") + " / " + Translator.getString("placed") + " " + Translator.getString("armies"), Translator.getString("random") + " " + Translator.getString("countries") + " / " + Translator.getString("random") + " " + Translator.getString("armies"), Translator.getString("selected") + " " + Translator.getString("countries") + " / " + Translator.getString("even") + " " + Translator.getString("armies"), Translator.getString("selected") + " " + Translator.getString("countries") + " / " + Translator.getString("placed") + " " + Translator.getString("armies"), Translator.getString("selected") + " " + Translator.getString("countries") + " / " + Translator.getString("random") + " " + Translator.getString("armies")});
        this.mapStartingPosition.setOpaque(false);
        this.mapStartingPosition.setPreferredSize(preferredDimension);
        panel = GraphicsTool.getNonOpaqueJPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.mapStartingPosition);
        worldPanel.add(panel);
        String bio = "biohazard - ";
        this.bioLevel = new SSComboBox(new Object[]{bio + Translator.getString("off"), bio + Translator.getString("light"), bio + Translator.getString("mild"), bio + Translator.getString("medium"), bio + Translator.getString("heavy"), bio + Translator.getString("extreme"), bio + Translator.getString("apocalypse")});
        this.bioLevel.setOpaque(false);
        this.bioLevel.setPreferredSize(preferredDimension);
        panel = GraphicsTool.getNonOpaqueJPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.bioLevel);
        worldPanel.add(panel);
        worldPanel.add(Box.createVerticalGlue());
        GridBagLayout playerPanelLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        TexturedPanel playerPanel = new TexturedPanel("texture_network.jpg", playerPanelLayout);
        playerPanel.setOpaque(false);
        playerPanel.setBorder(SwingTool.getBorderForText(Translator.getString("ChooseTheCombatants")));
        this.playerNames = new SSTextField[6];
        this.playerTypes = new SSComboBox[6];
        this.playerColors = new SSColorWell[6];
        this.playerColors[0] = new SSColorWell(GraphicsTool.colorFromString(Prefs.get("PlayerColours1", "0.15/0.25/0.8")), this);
        this.playerColors[1] = new SSColorWell(GraphicsTool.colorFromString(Prefs.get("PlayerColours2", "0.6/0.0/0.0")), this);
        this.playerColors[2] = new SSColorWell(GraphicsTool.colorFromString(Prefs.get("PlayerColours3", "0.0/0.6/0.4")), this);
        this.playerColors[3] = new SSColorWell(GraphicsTool.colorFromString(Prefs.get("PlayerColours4", "1.0/0.5/0.0")), this);
        this.playerColors[4] = new SSColorWell(GraphicsTool.colorFromString(Prefs.get("PlayerColours5", "0.9/0.866/0.9")), this);
        this.playerColors[5] = new SSColorWell(GraphicsTool.colorFromString(Prefs.get("PlayerColours6", "0.06/0.0/0.06")), this);
        c.fill = 0;
        c.weightx = 1.0;
        c.ipady = SS.isMacintosh ? 5 : 0;
        for (int i = 0; i < this.playerTypes.length; ++i) {
            c.gridwidth = 1;
            this.playerNames[i] = new SSTextField(Translator.getString("player") + i, 10);
            this.playerNames[i].setAlignmentX(0.0f);
            this.playerNames[i].setHorizontalAlignment(2);
            this.playerTypes[i] = new SSComboBox();
            this.playerTypes[i].setMaximumRowCount(35);
            this.playerColors[i].setOpaque(false);
            playerPanelLayout.setConstraints(this.playerColors[i], c);
            playerPanel.add(this.playerColors[i]);
            JPanel playerNameBorderPanel = new JPanel(new FlowLayout(0, 4, 0));
            playerNameBorderPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
            playerNameBorderPanel.add(this.playerNames[i]);
            playerNameBorderPanel.setAlignmentX(0.0f);
            playerNameBorderPanel.setAlignmentY(0.0f);
            playerPanelLayout.setConstraints(playerNameBorderPanel, c);
            playerNameBorderPanel.setOpaque(false);
            playerPanel.add(playerNameBorderPanel);
            c.gridwidth = 0;
            JPanel playerTypeBorderPanel = new JPanel();
            if (SS.isMacintosh) {
                playerTypeBorderPanel.setLayout(new BorderLayout(0, 0));
            }
            playerTypeBorderPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            playerTypeBorderPanel.setAlignmentY(0.0f);
            playerTypeBorderPanel.add(this.playerTypes[i]);
            playerPanelLayout.setConstraints(playerTypeBorderPanel, c);
            this.playerTypes[i].setOpaque(false);
            playerTypeBorderPanel.setOpaque(false);
            playerPanel.add(playerTypeBorderPanel);
            SSMenuItem.addCutCopyPasteMenu(this.playerNames[i]);
        }
        this.fillPlayerTypes();
        if (this.playerTypes[0].getPreferredSize().getWidth() < this.playerTypes[this.playerTypes.length - 1].getPreferredSize().getWidth()) {
            Dimension dim2 = new Dimension((int)this.playerTypes[this.playerTypes.length - 1].getPreferredSize().getWidth(), (int)this.playerTypes[this.playerTypes.length - 1].getPreferredSize().getHeight());
            this.playerTypes[0].setPreferredSize(dim2);
            this.playerTypes[1].setPreferredSize(dim2);
        }
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        TexturedPanel networkOptionsPanel = new TexturedPanel("texture_network.jpg", new GridLayout(5, 1, 1, 0));
        networkOptionsPanel.setBorder(SwingTool.getBorderForText(Translator.getString("NetworkOptions")));
        networkOptionsPanel.setOpaque(false);
        JPanel joinButtonPanel = new JPanel();
        joinButtonPanel.setLayout(new BoxLayout(joinButtonPanel, 0));
        SSButton joinButton = new SSButton(Translator.getString("ShowNetworkGames"));
        joinButton.setPreferredWidth(250);
        joinButton.setActionCommand("showJoinWindow");
        joinButton.addActionListener(this);
        joinButtonPanel.add(Box.createHorizontalGlue());
        joinButtonPanel.add(joinButton);
        joinButtonPanel.add(Box.createHorizontalGlue());
        joinButton.setOpaque(false);
        joinButtonPanel.setOpaque(false);
        networkOptionsPanel.add(joinButtonPanel);
        this.internetPublic = new SSCheckBox(Translator.getString("InternetPublic") + "              ", true);
        this.allowNetworkPlayers = new SSCheckBox(Translator.getString("AllowNetworkPlayers"), true);
        this.allowNetworkPlayers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LuxController.this.allowNetworkPlayers.isSelected() && LuxController.this.sharewareVersion) {
                    new RegisterNag("Marketing_Online.jpg", "hosting");
                    LuxController.this.allowNetworkPlayers.setSelected(false);
                    return;
                }
                LuxController.this.internetPublic.setEnabled(LuxController.this.allowNetworkPlayers.isSelected());
            }
        });
        this.allowNetworkPlayers.setOpaque(false);
        this.internetPublic.setOpaque(false);
        networkOptionsPanel.add(this.allowNetworkPlayers);
        networkOptionsPanel.add(this.internetPublic);
        this.fullscreenCheckbox = new SSCheckBox(Translator.getString("Fullscreen") + "              ", false);
        this.fullscreenCheckbox.setOpaque(false);
        networkOptionsPanel.add(this.fullscreenCheckbox);
        JPanel optionsButtonPanel = new JPanel();
        optionsButtonPanel.setLayout(new BoxLayout(optionsButtonPanel, 0));
        SSButton optionsButton = new SSButton(Translator.getString("MoreOptions"));
        optionsButton.setPreferredWidth(250);
        optionsButton.setActionCommand("preferences");
        optionsButton.addActionListener(this);
        optionsButtonPanel.add(Box.createHorizontalGlue());
        optionsButtonPanel.add(optionsButton);
        optionsButtonPanel.add(Box.createHorizontalGlue());
        optionsButton.setOpaque(false);
        optionsButtonPanel.setOpaque(false);
        networkOptionsPanel.add(optionsButtonPanel);
        rightPanel.add((Component)networkOptionsPanel, "North");
        JPanel playButtonPanel = new JPanel();
        playButtonPanel.setLayout(new BoxLayout(playButtonPanel, 1));
        playButtonPanel.setOpaque(false);
        this.playButton = new SSButton(Translator.getString("PlayAGame"));
        this.playButton.setOpaque(false);
        this.playButton.setPreferredWidth(250);
        this.playButton.setActionCommand("startGame");
        this.playButton.addActionListener(this);
        this.playButton.setAlignmentX(0.5f);
        playButtonPanel.add(Box.createVerticalGlue());
        playButtonPanel.add(Box.createVerticalStrut(10));
        JPanel playBorderPanel = new JPanel();
        playBorderPanel.setOpaque(false);
        playBorderPanel.add(this.playButton);
        playButtonPanel.add(playBorderPanel);
        playButtonPanel.add(Box.createVerticalGlue());
        rightPanel.add((Component)playButtonPanel, "Center");
        JPanel registrationPanel = GraphicsTool.getNonOpaqueJPanel();
        registrationPanel.setLayout(new BoxLayout(registrationPanel, 1));
        this.registration = new JLabel(Translator.getString("Demo") + ": " + Translator.getString("GameCountStart") + " " + this.sharewareCount + " " + Translator.getString("GameCountEnd"), 0);
        this.registration.setFont(new Font(this.registration.getFont().getName(), 0, this.registration.getFont().getSize() - 2));
        if (this.sharewareVersion) {
            JPanel regButtonPanel = new JPanel(new FlowLayout(1, 0, 0));
            regButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            regButtonPanel.setOpaque(false);
            this.orderNowButton = new SSButton(Translator.getString("OrderNow"));
            this.orderNowButton.setOpaque(false);
            this.orderNowButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UpdateController.gotoBuy("newGameWindow");
                }
            });
            regButtonPanel.add(this.orderNowButton);
            regButtonPanel.add(Box.createHorizontalStrut(40));
            this.enterCodeButton = new SSButton(Translator.getString("EnterCodeShort"));
            this.enterCodeButton.setOpaque(false);
            this.enterCodeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EnterCodeWindow.show(LuxController.getInstance());
                }
            });
            regButtonPanel.add(this.enterCodeButton);
            registrationPanel.add(regButtonPanel);
        } else {
            this.registration.setText(Translator.getString("RegisteredTo") + ":  " + Prefs.get("regName"));
        }
        JPanel regLabelPanel = new JPanel(new FlowLayout(1, 0, 0));
        regLabelPanel.setOpaque(false);
        regLabelPanel.add(this.registration);
        registrationPanel.add(regLabelPanel);
        rightPanel.add((Component)registrationPanel, "South");
        TexturedPanel topRightPanel = new TexturedPanel("texture_network.jpg");
        topRightPanel.setLayout(new BoxLayout(topRightPanel, 0));
        topRightPanel.setBorder(SwingTool.getBorderForText(Translator.getString("ChooseTheWorld")));
        topRightPanel.setOpaque(false);
        worldPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        worldPanel.setOpaque(false);
        topRightPanel.add(worldPanel);
        topRightPanel.add(Box.createHorizontalStrut(10));
        this.pluginImage = new JLabel();
        this.pluginImage.setBorder(null);
        this.pluginImage.setIconTextGap(0);
        this.pluginImage.setMinimumSize(new Dimension(170, 140));
        this.pluginImage.setVerticalAlignment(1);
        this.pluginImage.setHorizontalAlignment(0);
        JPanel pluginImagePanel = new JPanel(new BorderLayout());
        pluginImagePanel.setLayout(new BoxLayout(pluginImagePanel, 1));
        pluginImagePanel.setOpaque(false);
        pluginImagePanel.add((Component)this.pluginImage, "North");
        pluginImagePanel.setBorder(null);
        pluginImagePanel.setMinimumSize(new Dimension(170, 140));
        pluginImagePanel.setPreferredSize(new Dimension(170, 140));
        topRightPanel.add(pluginImagePanel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
        JPanel topLeftPanel = new JPanel();
        topLeftPanel.setLayout(new BoxLayout(topLeftPanel, 1));
        topLeftPanel.setOpaque(false);
        topLeftPanel.add(Box.createRigidArea(new Dimension(215, 161)));
        if (Prefs.get("affiliateURL", null) == null) {
            SSLink sillysoftLink = new SSLink("Sillysoft.net");
            sillysoftLink.setOpaque(false);
            sillysoftLink.setAlignmentX(1.0f);
            JPanel linkPanel = new JPanel();
            linkPanel.setOpaque(false);
            linkPanel.setLayout(new BorderLayout(0, 0));
            linkPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 1, 20));
            linkPanel.add((Component)sillysoftLink, "East");
            topLeftPanel.add(linkPanel);
        }
        topPanel.add(topLeftPanel);
        topPanel.add(topRightPanel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 0));
        leftPanel.add(playerPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout(0, 0));
        bottomPanel.add((Component)leftPanel, "Center");
        bottomPanel.add((Component)rightPanel, "East");
        leftPanel.setOpaque(false);
        rightPanel.setOpaque(false);
        topPanel.setOpaque(false);
        bottomPanel.setOpaque(false);
        TexturedPanel contentPane = new TexturedPanel("texture_background.jpg", true, true, null);
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(topPanel);
        contentPane.add(bottomPanel);
        this.newGameWindow.setContentPane(contentPane);
        String username = Prefs.get("playerNames0", null);
        if (username == null) {
            username = System.getProperty("user.name").trim();
            int spacePos = username.indexOf(32);
            if (spacePos != -1) {
                username = username.substring(0, spacePos);
            }
            if (username.toLowerCase().trim().equals("default")) {
                username = "luxer";
            } else if (username.toLowerCase().trim().equals("administrator")) {
                username = "silly";
            }
            if (username.length() > 6) {
                username = username.substring(0, 6);
            }
            username = username + this.rand.nextInt(100);
        }
        this.playerNames[0].setText(username);
        this.playerNames[1].setText(Prefs.get("playerNames1", "Rowdy"));
        this.playerNames[2].setText(Prefs.get("playerNames2", "Unicron"));
        this.playerNames[3].setText(Prefs.get("playerNames3", "Meegan"));
        this.playerNames[4].setText(Prefs.get("playerNames4", "Zoodiac"));
        this.playerNames[5].setText(Prefs.get("playerNames5", "Lux Luthor"));
        this.playerTypes[0].setSelectedItem(Prefs.get("playerTypes0", "Human"));
        this.playerTypes[1].setSelectedItem(Prefs.get("playerTypes1", "Angry"));
        this.playerTypes[2].setSelectedItem(Prefs.get("playerTypes2", "Pixie"));
        this.playerTypes[3].setSelectedItem(Prefs.get("playerTypes3", "Cluster"));
        this.playerTypes[4].setSelectedItem(Prefs.get("playerTypes4", "Yakool"));
        this.playerTypes[5].setSelectedItem(Prefs.get("playerTypes5", "-- " + Translator.getString("Hard") + " --"));
        for (int i = 0; i < this.playerTypes.length; ++i) {
            this.playerTypes[i].setActionCommand("changePlayer");
            this.playerTypes[i].addActionListener(this);
        }
        this.mapSelector.setSelectedItem(Prefs.get("mapSelector", "Classic Widescreen"));
        int startingPosCode = Prefs.getInt("startingPosCode", -1);
        if (startingPosCode == -1) {
            String saved561initialCountryPrefs = Prefs.get("saved561initialCountryPrefs", null);
            startingPosCode = saved561initialCountryPrefs == null ? 2 : this.calcNewStartingPositionCodeFromOldPreferences(saved561initialCountryPrefs);
        }
        this.mapStartingPosition.setSelectedIndex(startingPosCode);
        this.allowNetworkPlayers.setSelected(Prefs.getBoolean("allowNetworkPlayers", false) && !this.sharewareVersion);
        this.internetPublic.setSelected(Prefs.getBoolean("internetPublic", true));
        this.internetPublic.setEnabled(this.allowNetworkPlayers.isSelected());
        this.fullscreenCheckbox.setSelected(Prefs.getBoolean("fullscreen", false));
        this.bioLevel.setSelectedIndex(Prefs.getInt("bioLevel", 0));
        PrefsCache.reloadStatics();
        this.fillMapSelector(Prefs.get("mapSelector", "Classic Widescreen"));
        this.mapSelector.addActionListener(new ActionListener(){
            private String lastItem = Prefs.get("mapSelector", "Classic Widescreen");

            public void actionPerformed(ActionEvent e) {
                if (LuxController.this.fillingMapSelector) {
                    return;
                }
                if ((" \u221e " + Translator.getString("Getmoremaps")).equals(LuxController.this.mapSelector.getSelectedItem())) {
                    PluginWindow.show();
                    if (this.lastItem != null) {
                        LuxController.this.mapSelector.setSelectedItem(this.lastItem);
                    }
                } else if ((" \u221e " + Translator.getString("GotoSavedBoards")).equals(LuxController.this.mapSelector.getSelectedItem())) {
                    FolderLauncher.openPath(DesktopTool.supportFolderPath() + "Boards" + File.separator + "Saved");
                    if (this.lastItem != null) {
                        LuxController.this.mapSelector.setSelectedItem(this.lastItem);
                    }
                } else {
                    LuxController.this.validateScenarioControls();
                    LuxController.this.setPreviewImage();
                }
                this.lastItem = LuxController.this.mapSelector.getSelectedString();
            }
        });
        this.mapStartingPosition.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LuxController.this.validateScenarioControls();
            }
        });
        this.validateScenarioControls();
        this.setPreviewImage();
        this.menuBar = this.makeCommonMenuBar(this.newGameWindow);
        this.newGameWindow.setJMenuBar(this.menuBar);
        this.newGameWindow.pack();
        this.newGameWindow.setLocationID("newGame");
        MusicEngine.setTracks(new String[]{"/LD_MainTheme.ogg", "/LD_Scenario1.ogg", "/LD_Scenario2.ogg", "/LD_Medieval.ogg", "/LD_GameOver.ogg"});
        MusicEngine.startTrackSequence(21);
    }

    private void setBioControls(boolean value) {
        this.bioLevel.setEnabled(value);
    }

    public int bioLevel() {
        if (Lux.bioParam != 0) {
            return Lux.bioParam;
        }
        if (this.bioLevel == null) {
            return 0;
        }
        return this.bioLevel.getSelectedIndex();
    }

    private int calcNewStartingPositionCodeFromOldPreferences(String saved561initialCountryPrefs) {
        if (Prefs.getBoolean("useScenario", false)) {
            return 0;
        }
        String armies = Prefs.get("initialArmies", Translator.getString("placed"));
        if (saved561initialCountryPrefs.equals(Translator.getString("random"))) {
            if (armies.equals(Translator.getString("even"))) {
                return 1;
            }
            if (armies.equals(Translator.getString("placed"))) {
                return 2;
            }
            return 3;
        }
        if (armies.equals(Translator.getString("even"))) {
            return 4;
        }
        if (armies.equals(Translator.getString("placed"))) {
            return 5;
        }
        return 6;
    }

    private void setPreviewImage() {
        try {
            Object foo = this.mapSelector.getSelectedItem();
            if (foo == null) {
                return;
            }
            String file = foo.toString();
            if ((file = file.substring(file.lastIndexOf(47) + 1)).equals(" -- " + Translator.getString("MapGenerators") + " -- ")) {
                file = "mapgen";
            } else {
                file = file.replaceAll(" ", "%20");
                file = file.replaceAll(",", "");
                file = file.replaceAll(";", "");
                file = file.replaceAll(":", "");
                file = file.replaceAll("!", "");
                file = file.replaceAll("/+", "");
                file = file.replaceAll("&", "");
            }
            RemoteImageFetcher.getImage("http://sillysoft.net/plugins/images/" + file + "_thumb.jpg", 0, LuxController.getInstance());
        }
        catch (Exception ex) {
            System.out.println("setPreviewImage: " + ex);
            ex.printStackTrace();
        }
    }

    public void imageReady(int row, Object imageIcon) {
        this.pluginImage.setIcon((Icon)imageIcon);
        this.pluginImage.repaint();
    }

    public boolean mapGeneratorSelected() {
        SS.debug("mapGeneratorSelected() - " + this.mapSelector.getSelectedIndex() + " - " + this.bioLevel());
        return this.mapSelector.getSelectedIndex() >= this.getMapGeneratorStartIndex() || this.bioLevel() > 0;
    }

    private void validateScenarioControls() {
        String selectedString = this.mapSelector.getSelectedString();
        if (selectedString == null || "".equals(selectedString.trim())) {
            return;
        }
        int scenarioPlayers = 0;
        boolean selected = this.useScenario();
        if (this.useScenario()) {
            if (this.mapSelector.getSelectedIndex() >= this.getMapGeneratorStartIndex()) {
                LuxMapGenerator mapgen = PluginManager.getInstance().getMapGeneratorForChoice(selectedString);
                scenarioPlayers = LuxController.getScenarioPlayersForMapGenerator(mapgen, selectedString);
            } else {
                try {
                    scenarioPlayers = new BoardFile(selectedString, true).getScenarioPlayersMinusEmpty();
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < 6; ++i) {
            this.playerColors[i].setEnabled(!selected || i < scenarioPlayers);
            this.playerNames[i].setEnabled(!selected || i < scenarioPlayers);
            this.playerTypes[i].setEnabled(!selected || i < scenarioPlayers);
            if (selected) {
                if (!this.playerTypes[i].hasItem("<" + Translator.getString("noplayer") + ">")) continue;
                if (this.playerTypes[i].getSelectedString().equals("<" + Translator.getString("noplayer") + ">")) {
                    this.playerTypes[i].setSelectedIndex(1);
                }
                this.playerTypes[i].removeItem("<" + Translator.getString("noplayer") + ">");
                continue;
            }
            if (i <= 1 || this.playerTypes[i].hasItem("<" + Translator.getString("noplayer") + ">")) continue;
            this.playerTypes[i].addItem("<" + Translator.getString("noplayer") + ">");
        }
    }

    private void setControlsToNonScenario() {
        for (int i = 0; i < 6; ++i) {
            this.playerColors[i].setEnabled(true);
            this.playerNames[i].setEnabled(true);
            this.playerTypes[i].setEnabled(true);
            if (i <= 1 || this.playerTypes[i].hasItem("<" + Translator.getString("noplayer") + ">")) continue;
            this.playerTypes[i].addItem("<" + Translator.getString("noplayer") + ">");
        }
    }

    public int getScenarioPlayersForSelection() {
        if (this.mapSelector.getSelectedIndex() == this.getMapGeneratorStartIndex()) {
            return 6;
        }
        if (this.mapSelector.getSelectedIndex() > this.getMapGeneratorStartIndex()) {
            String selectedString = this.mapSelector.getSelectedString();
            LuxMapGenerator mapgen = PluginManager.getInstance().getMapGeneratorForChoice(selectedString);
            return LuxController.getScenarioPlayersForMapGenerator(mapgen, selectedString);
        }
        try {
            return new BoardFile(this.mapSelector.getSelectedString(), true).getTotalScenarioPlayers();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int getScenarioPlayersForMapGenerator(LuxMapGenerator mapgen, String choice) {
        try {
            String scenarioPlayersString = mapgen.message("scenarioPlayerCount", choice);
            return Integer.parseInt(scenarioPlayersString);
        }
        catch (Exception exc) {
            SS.debug("getScenarioPlayersForMapGenerator exception: " + exc);
            return 0;
        }
    }

    private void copyInitialSupportFiles() {
        if (!Prefs.getBoolean("savedBoardCopied6.23", false)) {
            Prefs.putBoolean("savedBoardCopied6.23", true);
            try {
                FileTool.copyFolder(DesktopTool.bundleResourcesLocation() + "Boards", DesktopTool.supportFolderPath() + "Boards");
                FileTool.copyFolder(DesktopTool.bundleResourcesLocation() + "Cache", DesktopTool.supportFolderPath() + "Cache");
                FileTool.copyFolder(DesktopTool.bundleResourcesLocation() + "Themes", DesktopTool.supportFolderPath() + "Themes");
            }
            catch (Throwable t) {
                SS.debug("Lux -> error copying over initial mac os x install files: " + t);
                t.printStackTrace();
            }
        }
    }

    public static String getSharewareFilename() {
        return DesktopTool.supportFolderPath() + ".net.vul.62";
    }

    public int getSharewareCount() {
        return this.sharewareCount;
    }

    public boolean getSharewareVersion() {
        return this.sharewareVersion;
    }

    public JMenuBar makeCommonMenuBar(JFrame forWindow) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.makeFileMenu(forWindow));
        menuBar.add(this.makeEditMenu());
        menuBar.add(this.makeOnlineMenu());
        if (Prefs.getBoolean("radioMenu", false)) {
            menuBar.add(this.makeRadioMenu());
        }
        menuBar.add(this.makeHelpMenu());
        return menuBar;
    }

    public JMenu makeFileMenu(JFrame forWindow) {
        return this.makeFileMenu(forWindow, true);
    }

    public JMenu makeFileMenu(JFrame forWindow, boolean loadSavedMapShortcut) {
        return this.makeFileMenu(forWindow, loadSavedMapShortcut, false);
    }

    public JMenu makeFileMenu(JFrame forWindow, boolean loadSavedMapShortcut, boolean sendCloseToListeners) {
        JMenu menu = new JMenu(Translator.getString("File"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(70);
        }
        SSMenuItem menuItem = new SSMenuItem(Translator.getString("NewGame"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("showNewGameWindow");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("OpenSavedGame"));
        if (loadSavedMapShortcut) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        menuItem.setActionCommand("openSavedGame");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("JoinNetworkGame"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(74, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("showJoinWindow");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("PluginManager"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("plugins");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("Preferences"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("preferences");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("RecordBook"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("recordBook");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("MapEditor"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("mapEditor");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        if (this.sharewareVersion) {
            menuItem = new SSMenuItem(Translator.getString("EnterCode"));
            menuItem.setActionCommand("enterCode");
            menuItem.addActionListener(this);
            menu.add(menuItem);
            menuItem = new SSMenuItem(Translator.getString("RegisterOnline"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UpdateController.gotoBuy("luxmenu");
                }
            });
            menu.add(menuItem);
        } else {
            menuItem = new SSMenuItem(Translator.getString("ChangeRegistration"));
            menuItem.setActionCommand("enterCode");
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        if (forWindow != null) {
            menu.addSeparator();
            menuItem = new SSMenuItem(Translator.getString("Close"));
            menuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            final JFrame closeTarget = forWindow;
            final boolean useListeners = sendCloseToListeners;
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (useListeners) {
                        try {
                            WindowListener[] wls = closeTarget.getWindowListeners();
                            if (wls.length > 0) {
                                for (int i = 0; i < wls.length; ++i) {
                                    wls[i].windowClosing(null);
                                }
                                return;
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        closeTarget.hide();
                        closeTarget.dispose();
                    }
                }
            });
            menu.add(menuItem);
        }
        if (!SS.isMacintosh) {
            menuItem = new SSMenuItem(Translator.getString("ExitLux"));
            menuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            menuItem.setActionCommand("quit");
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        return menu;
    }

    public JMenu makeEditMenu() {
        JMenu menu = new JMenu(Translator.getString("Edit"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(69);
        }
        SSMenuItem menuItem = new SSMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText(Translator.getString("Cut"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(menuItem);
        menuItem = new SSMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText(Translator.getString("Copy"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(menuItem);
        menuItem = new SSMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText(Translator.getString("Paste"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(menuItem);
        return menu;
    }

    public JMenu makeOnlineMenu() {
        JMenu menu = new JMenu(Translator.getString("Online"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(79);
        }
        SSMenuItem menuItem = new SSMenuItem("Sillysoft Games");
        menuItem.setActionCommand("gotoSillysoft");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("UserForums"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("gotoForums");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("UserWiki"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("gotoWiki");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("WorldWideRankings"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("gotoRankings");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("ReportABug"));
        menuItem.setActionCommand("bugReport");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("RequestAFeature"));
        menuItem.setActionCommand("featureRequest");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("MakeYourOwnMap"));
        menuItem.setActionCommand("showMapNotes");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("CodeYourOwnAI"));
        menuItem.setActionCommand("showAINotes");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem("Facebook");
        menuItem.setActionCommand("gotoFacebook");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem("Twitter");
        menuItem.setActionCommand("gotoTwitter");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("SillysoftNewsletter"));
        menuItem.setActionCommand("newsletter");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("CheckForUpdate"));
        menuItem.setActionCommand("updateCheck");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menu;
    }

    public JMenu makeRadioMenu() {
        JMenuItem menuItem;
        JMenu radioMenu = new JMenu(Translator.getString("Radio"));
        if (!SS.isMacintosh) {
            radioMenu.setMnemonic(82);
        }
        String radioPref = Prefs.get("radioPreference", "WindowsMedia");
        if (SS.isMacintosh) {
            menuItem = new SSCheckBoxMenuItemAlwaysOn("iTunes");
            radioMenu.add(menuItem);
        } else if (SS.isWindows) {
            menuItem = new SSCheckBoxMenuItemSet("RealPlayer", "radioPreference", "RealPlayer", "WindowsMedia");
            radioMenu.add(menuItem);
            menuItem = new SSCheckBoxMenuItemSet("Windows Media Player", "radioPreference", "WindowsMedia", "WindowsMedia");
            radioMenu.add(menuItem);
            menuItem = new SSCheckBoxMenuItemSet("WinAmp", "radioPreference", "WinAmp", "WindowsMedia");
            radioMenu.add(menuItem);
        } else {
            menuItem = new SSCheckBoxMenuItemAlwaysOn("linuxradio.sh");
            radioMenu.add(menuItem);
        }
        radioMenu.addSeparator();
        menuItem = new SSMenuItem("Ambient Popsicle");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://popsicle.groovera.com/listen.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("BarStar Radio");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://barstar.kicks-ass.net:8080");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("Groove Salad");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://www.somafm.com/groovesalad.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("Indie Pop Rocks");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://www.somafm.com/indiepop.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("Jet City Lounge");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://jetcitylounge.groovera.com/listen.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("Low Mercury");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://lowmercury.groovera.com/listen.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("Mostly Classical");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://www.sky.fm/mp3/classical.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("Secret Agent");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://www.somafm.com/secretagent.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("Space Station Soma");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://somafm.com/spacestation.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("SmoothJazz.com");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://smoothjazz.com/streams/smoothjazz_128.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("The 80's Channel");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://club977.com/CLUB977HI.pls");
            }
        });
        radioMenu.add(menuItem);
        menuItem = new SSMenuItem("Vocal Trance");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpdateController.openRadio("http://www.di.fm/mp3/vocaltrance.pls");
            }
        });
        radioMenu.add(menuItem);
        return radioMenu;
    }

    public JMenu makeHelpMenu() {
        SSMenuItem menuItem;
        JMenu menu = new JMenu(Translator.getString("Help"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(72);
        }
        if (!SS.isMacintosh) {
            menuItem = new SSMenuItem(Translator.getString("AboutLux"));
            menuItem.setActionCommand("showAboutLux");
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        menuItem = new SSMenuItem(Translator.getString("TheRulesOfLux"));
        menuItem.setActionCommand("showRulesNotes");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("LuxGuide"));
        menuItem.setActionCommand("showLuxGuide");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("KeyboardShortcuts"));
        menuItem.setActionCommand("showKeyboardShortcuts");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("PreferencesExplanations"));
        menuItem.setActionCommand("showPrefsNotes");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("HostingTips"));
        menuItem.setActionCommand("showHostingNotes");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("RestartTutorial"));
        menuItem.setActionCommand("restartTutorial");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("Changelog"));
        menuItem.setActionCommand("showChangelog");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menu;
    }

    public void terminate() {
        MusicEngine.fadeOutBlocking();
        if (SS.isWindows) {
            try {
                FileTool.hideWindowsFile(LuxController.getSharewareFilename(), true);
            }
            catch (Exception e) {
                System.out.println("Hide n seek failed. No biggie.");
            }
        }
        System.exit(0);
    }

    public void saveSelectionsToDefs() {
        for (int i = 0; i < this.playerNames.length; ++i) {
            Prefs.put("playerNames" + i, this.playerNames[i].getText());
            Prefs.put("playerTypes" + i, this.playerTypes[i].getSelectedString());
            Prefs.put("PlayerColours" + (i + 1), GraphicsTool.stringFromColor(this.playerColors[i].getColor()));
        }
        Prefs.putInt("startingPosCode", this.mapStartingPosition.getSelectedIndex());
        Prefs.putInt("bioLevel", this.bioLevel.getSelectedIndex());
        Prefs.put("mapSelector", this.mapSelector.getSelectedString());
        Prefs.putBoolean("allowNetworkPlayers", this.allowNetworkPlayers.isSelected());
        Prefs.putBoolean("internetPublic", this.internetPublic.isSelected());
        Prefs.putBoolean("fullscreen", this.fullscreenCheckbox.isSelected());
        Prefs.sync();
    }

    public void showNewGameWindow() {
        if (this.newGameWindow.isVisible()) {
            this.newGameWindow.toFront();
        } else {
            this.newGameWindow.show();
            if (null == this.newGameWindow.getRootPane().getDefaultButton()) {
                this.newGameWindow.getRootPane().setDefaultButton(this.playButton);
            }
        }
    }

    public void hideNewGameWindow() {
        this.newGameWindow.hide();
    }

    public void showSharewareOverWindow() {
        new RegisterNag("Marketing_DemoOver.jpg", "demoOver", true, true, true);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            String command = event.getActionCommand();
            if ("startGame".equals(command)) {
                if (this.isSharewareLocked()) {
                    return;
                }
                if ((SS.isMacintosh || SS.isWindows) && Prefs.getInt("launchCount") > 3 && EsellerateWrapper.validRegistration("mapStart", "DE-222222-4444-5555-6666-7777-8888")) {
                    SSOptionPane.showMessageDialog("Corruption error 357.");
                    this.terminate();
                    return;
                }
                SSColorChooser.hideWindow();
                this.newGameWindow.hide();
                Prefs.putBoolean("fullscreen", this.fullscreenCheckbox.isSelected());
                if (this.allowNetworkPlayers()) {
                    NetBoss netBoss = new NetBoss(this.internetPublic());
                    netBoss.startGame();
                } else {
                    LuxOptions ops = this.currentOptions().ensureProperOrder();
                    ops.removeRemoteOnly();
                    GameControllerGUI game = new GameControllerGUI(ops, true, null);
                }
                this.saveSelectionsToDefs();
            } else if ("showNewGameWindow".equals(command)) {
                LuxController.getInstance().showNewGameWindow();
                this.saveSelectionsToDefs();
            } else if ("showJoinWindow".equals(command)) {
                JoinGame.show();
                this.newGameWindow.hide();
                this.saveSelectionsToDefs();
            } else if ("openSavedGame".equals(command)) {
                if (this.isSharewareLocked()) {
                    return;
                }
                FileDialog d = new FileDialog((Frame)this.newGameWindow, Translator.getEditorString("Selectaboardfile"), 0);
                d.setDirectory(DesktopTool.savedGameDir());
                d.pack();
                d.show();
                String dir = d.getDirectory();
                String file = d.getFile();
                d.dispose();
                if (dir != null && file != null) {
                    if ((SS.isMacintosh || SS.isWindows) && Prefs.getInt("launchCount") > 3 && EsellerateWrapper.validRegistration("mapStart", "DE-222222-4444-5555-6666-7777-8888")) {
                        SSOptionPane.showMessageDialog("Corruption error 357.");
                        this.terminate();
                        return;
                    }
                    SS.debug("Load saved game: " + dir + file);
                    this.newGameWindow.hide();
                    LuxOptions ops = new LuxOptions(file);
                    ops.savedGame = true;
                    ops.useScenario = true;
                    ops.allowNetworkPlayers = false;
                    new GameControllerGUI(ops, true, null);
                }
            } else if ("changePlayer".equals(command)) {
                SSComboBox source = (SSComboBox)event.getSource();
                int sourceID = -1;
                for (int i = 0; i < this.playerTypes.length; ++i) {
                    if (source != this.playerTypes[i]) continue;
                    sourceID = i;
                }
                if ((" \u221e " + Translator.getString("GetmoreAIs")).equals(source.getSelectedItem())) {
                    PluginWindow.showAI();
                    String lastItem = Prefs.get("playerTypes" + sourceID, sourceID == 0 ? "Human" : "Cluster");
                    if (lastItem != null) {
                        source.setSelectedItem(lastItem);
                    }
                    return;
                }
                if (!this.ignoreAllComputerCheck) {
                    if (!this.getHumanName().equals(source.getSelectedString())) {
                        boolean humansPlaying = false;
                        for (int i = 0; i < this.playerTypes.length && !humansPlaying; ++i) {
                            if (!this.playerTypes[i].getSelectedString().equals(this.getHumanName())) continue;
                            humansPlaying = true;
                        }
                        if (!humansPlaying && Prefs.get("playerTypes" + sourceID, "foobar").equals(this.getHumanName()) && SSOptionPane.showConfirmDialog(this.newGameWindow, Translator.getString("NoHumanWarning"), null, 0) == 0) {
                            source.setSelectedIndex(0);
                        }
                    }
                    Prefs.put("playerTypes" + sourceID, source.getSelectedString());
                }
            } else if ("quit".equals(command)) {
                this.quit();
            } else if ("recordBook".equals(command)) {
                RankingController.show();
            } else if ("mapEditor".equals(command)) {
                MapEditor ed = new MapEditor(this);
                this.newGameWindow.hide();
            } else if ("restartTutorial".equals(command)) {
                LuxController.getInstance().restartTutorial();
                SSOptionPane.showMessageDialog(Translator.getString("Tutorialturnedon"));
            } else if ("stopTutorial".equals(command)) {
                LuxController.getInstance().stopTutorial();
                SSOptionPane.showMessageDialog(Translator.getString("Tutorialturnedoff"));
            } else if ("showRulesNotes".equals(command)) {
                UpdateController.notesRules();
            } else if ("showLuxGuide".equals(command)) {
                UpdateController.gotoAppGuide();
            } else if ("showPrefsNotes".equals(command)) {
                UpdateController.notesPrefs();
            } else if ("showHostingNotes".equals(command)) {
                UpdateController.notesHosting();
            } else if ("showKeyboardShortcuts".equals(command)) {
                UpdateController.notesShortcuts();
            } else if ("showChangelog".equals(command)) {
                UpdateController.notesChangelog();
            } else if ("showAboutLux".equals(command)) {
                AboutWindow.show(6.23f, this);
            } else if ("showMapNotes".equals(command)) {
                BrowserLauncher.openURL("http://sillysoft.net/forums/viewtopic.php?t=9350");
            } else if ("showThemeNotes".equals(command)) {
                UpdateController.gotoThemes();
            } else if ("showAINotes".equals(command)) {
                UpdateController.gotoAI();
            } else if ("bugReport".equals(command)) {
                String input = JOptionPane.showInputDialog(this.newGameWindow, (Object)"This will send your log file to Sillysoft for analysis.\n\nPlease describe your bug report:");
                if (input != null) {
                    SSOptionPane.showMessageDialog(this.newGameWindow, "Your report has been sent to Sillysoft, thank you.", "", 1);
                    String logReport = "Lux GUI " + Prefs.get("playerNames0", "unknown") + " DEBUG: " + input + "\n" + ((LogFile)System.out).getLog() + "\n\n" + Prefs.exportSubtree() + "\n\n";
                    SSApp.alertSillysoft(logReport);
                }
            } else if ("featureRequest".equals(command)) {
                UpdateController.gotoFeatureRequest();
            } else if ("gotoForums".equals(command)) {
                UpdateController.gotoForums();
            } else if ("gotoWiki".equals(command)) {
                UpdateController.gotoWiki();
            } else if ("gotoRankings".equals(command)) {
                UpdateController.gotoRankings();
            } else if ("verifyOnlineAccount".equals(command)) {
                BrowserLauncher.openURL("http://sillysoft.net/lux/forum_reg.php?k=" + Prefs.getUserKey());
            } else if ("gotoFacebook".equals(command)) {
                BrowserLauncher.openURL("http://www.facebook.com/LuxDeluxGame");
            } else if ("gotoTwitter".equals(command)) {
                BrowserLauncher.openURL("http://twitter.com/LuxGame");
            } else if ("gotoSillysoft".equals(command)) {
                UpdateController.gotoSillysoftHomepage();
            } else if (command.equalsIgnoreCase("plugins")) {
                PluginWindow.show();
            } else if (command.equalsIgnoreCase("preferences")) {
                PreferencesWindow.show();
            } else if (command.equalsIgnoreCase("updateCheck")) {
                UpdateController.checkForUpdate(this);
            } else if (command.equalsIgnoreCase("newsletter")) {
                Newsletter.show(null, "http://sillysoft.net/");
            } else if ("enterCode".equals(command)) {
                EnterCodeWindow.show(this);
            } else {
                SS.debug("Lux -> Unimplemented action command: " + command);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (this.windows.size() == 0) {
            this.quit();
        }
    }

    public void windowClosing(WindowEvent e) {
        if (this.windows.size() == 0) {
            this.quit();
        } else {
            this.printActiveWindowList();
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public boolean registerCode(String name, String code) {
        if ("".equals(name.trim())) {
            name = "you";
        }
        if (EsellerateWrapper.validRegistration(name, code)) {
            this.sharewareVersion = false;
            Prefs.put("regCode", code);
            Prefs.put("regName", name);
            Prefs.sync();
            RegisterNag.hideAll();
            this.registration.setText(Translator.getString("RegisteredTo") + ":  " + Prefs.get("regName"));
            if (this.orderNowButton != null) {
                this.orderNowButton.getParent().remove(this.orderNowButton);
            }
            this.orderNowButton = null;
            if (this.enterCodeButton != null) {
                this.enterCodeButton.getParent().remove(this.enterCodeButton);
            }
            this.enterCodeButton = null;
            this.newGameWindow.pack();
            SS.debug("REGISTER: clearing out the plugin cache");
            PluginManager.deleteCache();
            return true;
        }
        return false;
    }

    public static String[] getAgentLocations() {
        return new String[]{DesktopTool.supportFolderPath() + "Agents"};
    }

    public boolean usingNetworkPlayerOnly() {
        int networkOnlyCount = 0;
        for (int i = 0; i < this.playerTypes.length; ++i) {
            String selectedString = this.playerTypes[i].getSelectedString();
            if (!selectedString.equals("<" + Translator.getString("networkplayeronly") + ">")) continue;
            ++networkOnlyCount;
        }
        return networkOnlyCount > 1;
    }

    public String getFirstAI() {
        for (int i = 0; i < this.playerTypes.length; ++i) {
            String selectedString = this.playerTypes[i].getSelectedString();
            if (this.playerTypes[i].getSelectedIndex() == 0 || selectedString.equals("<" + Translator.getString("noplayer") + ">") || selectedString.equals("<" + Translator.getString("networkplayeronly") + ">")) continue;
            if (selectedString.equals("<" + Translator.getString("random") + ">")) {
                return this.getRandomAI(0);
            }
            if (selectedString.equals("-- " + Translator.getString("Easy") + " --")) {
                return this.getRandomAI(1);
            }
            if (selectedString.equals("-- " + Translator.getString("Medium") + " --")) {
                return this.getRandomAI(3);
            }
            if (selectedString.equals("-- " + Translator.getString("Hard") + " --")) {
                return this.getRandomAI(5);
            }
            if (selectedString.equals("-- " + Translator.getString("Other") + " --")) {
                int ai = this.rand.nextInt(this.moreAgents.size());
                return (String)this.moreAgents.get(ai);
            }
            return selectedString;
        }
        return this.getRandomAI(0);
    }

    public void addGame(GameControllerGUI g) {
        if (!this.activeGames.contains(g)) {
            this.activeGames.add(g);
        }
    }

    public void killGame(GameControllerGUI g) {
        this.activeGames.remove(g);
    }

    public void quit() {
        this.killed = true;
        for (int i = this.activeGames.size() - 1; i > -1; --i) {
            ((GameControllerGUI)this.activeGames.get(i)).windowClosing(null);
        }
        if (this.activeGames.size() == 0) {
            super.quit();
        }
    }

    public void refreshGamePrefs() {
        for (int i = 0; i < this.activeGames.size(); ++i) {
            GameControllerGUI control = (GameControllerGUI)this.activeGames.get(i);
            if (control.netBoss != null) {
                if (Prefs.getBoolean("seperateChatWindow", false) && !control.netBoss.activeSoloWindow()) {
                    control.toggleChatWindow();
                } else if (!Prefs.getBoolean("seperateChatWindow", false) && control.netBoss.activeSoloWindow()) {
                    control.toggleChatWindow();
                }
            }
            if (!Prefs.getBoolean("playerInfoOpen", true)) continue;
            control.toggleShowPlayerInfo();
            control.toggleShowPlayerInfo();
            control.columnsResizePI();
        }
    }

    public boolean selectMap(String selection) {
        if (this.mapSelector == null) {
            String desiredMap = selection.toLowerCase();
            Vector mapList = PluginManager.getInstance().getMapList();
            for (int j = 0; j < mapList.size(); ++j) {
                String map = (String)mapList.get(j);
                if (!map.toLowerCase().equals(desiredMap)) continue;
                Prefs.put("mapSelector", map);
                return true;
            }
            return false;
        }
        int pos = this.mapSelector.getIndexOfItem(selection);
        if (pos == -1) {
            return false;
        }
        this.mapSelector.setSelectedIndex(pos);
        return true;
    }

    public String getPreviousMapName() {
        int selected = this.mapSelector.getSelectedIndex();
        if (selected == 0) {
            return null;
        }
        return (String)this.mapSelector.getItemAt(selected - 1);
    }

    public String shortName() {
        return "lux";
    }
}

