/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.JoinGame;
import com.sillysoft.widgets.SSTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class JoinTableCellRenderer
extends DefaultTableCellRenderer {
    private JoinGame parent;
    private Color greenHost = new Color(20, 255, 10);
    private Color yellowHost = new Color(200, 200, 10);
    private Color orangeHost = new Color(220, 80, 10);
    private Color redHost = new Color(205, 20, 10);

    public JoinTableCellRenderer(JoinGame theParent) {
        this.parent = theParent;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        cell.setForeground(isSelected ? Color.WHITE : Color.BLACK);
        if (column == 2 && value.toString().indexOf(this.parent.weeklyMap) != -1) {
            cell.setFont(new Font(cell.getFont().getName(), 1, cell.getFont().getSize()));
        } else if (column == 0) {
            try {
                Object ratingString = ((Object[])this.parent.rows.get(this.parent.getTranslatedRow(row)))[19];
                if (ratingString != null) {
                    float rating = Float.parseFloat((String)ratingString);
                    if ((double)rating >= 2.5) {
                        cell.setForeground(this.redHost);
                    } else if ((double)rating >= 2.2) {
                        cell.setForeground(this.orangeHost);
                    } else if ((double)rating >= 1.7) {
                        cell.setForeground(this.yellowHost);
                    } else if (isSelected) {
                        cell.setForeground(this.greenHost);
                        cell.setFont(new Font(cell.getFont().getName(), 1, cell.getFont().getSize()));
                    } else {
                        cell.setForeground(new Color(0, 200, 0));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!isSelected) {
            if (row % 2 == 0) {
                cell.setBackground(SSTable.ROW_COLOR_2);
            } else {
                cell.setBackground(Color.WHITE);
            }
        }
        return cell;
    }
}

