/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.lux.gui;

import com.sillysoft.lux.gui.EnterCodeWindow;
import com.sillysoft.lux.gui.UpdateController;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class InitNagWindow {
    private SSFrame theFrame;
    private static InitNagWindow instance;
    ActionListener registerOnlineListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            UpdateController.gotoBuy("initwindow");
            InitNagWindow.this.theFrame.hide();
        }
    };
    ActionListener enterCodeListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            EnterCodeWindow.show(luxconBridge);
        }
    };
    ActionListener letMePlayListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            InitNagWindow.this.theFrame.hide();
        }
    };
    private static SSApplicationGUI luxconBridge;

    public InitNagWindow(int sharewareCount) {
        instance = this;
        this.initGUI(sharewareCount);
    }

    private void initGUI(int sharewareCount) {
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel middlePanel = new JPanel();
        JLabel notificationLabel = new JLabel(Translator.getString("GameCountStart") + " " + sharewareCount + " " + Translator.getString("GameCountEnd"));
        middlePanel.add(notificationLabel);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        SSButton registerOnlineButton = new SSButton(Translator.getString("RegisterOnline"));
        registerOnlineButton.setPreferredWidth(150);
        registerOnlineButton.addActionListener(this.registerOnlineListener);
        JPanel registerOnlineButtonPanel = new JPanel();
        registerOnlineButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        registerOnlineButtonPanel.add(registerOnlineButton);
        buttonPanel.add(registerOnlineButtonPanel);
        SSButton enterCodeButton = new SSButton(Translator.getString("EnterCodeShort"));
        enterCodeButton.setPreferredWidth(150);
        enterCodeButton.addActionListener(this.enterCodeListener);
        JPanel enterCodeButtonPanel = new JPanel();
        enterCodeButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        enterCodeButtonPanel.add(enterCodeButton);
        buttonPanel.add(enterCodeButtonPanel);
        SSButton letMePlayButton = new SSButton(Translator.getString("LetMePlay"));
        letMePlayButton.setPreferredWidth(150);
        letMePlayButton.addActionListener(this.letMePlayListener);
        JPanel letMePlayButtonPanel = new JPanel();
        letMePlayButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        letMePlayButtonPanel.add(letMePlayButton);
        buttonPanel.add(letMePlayButtonPanel);
        contentPanel.add((Component)this.createEditorPane(), "North");
        contentPanel.add((Component)middlePanel, "Center");
        contentPanel.add((Component)buttonPanel, "South");
        this.theFrame = new SSFrame(Translator.getString("EnjoyYourLuxing"));
        this.theFrame.setLocationID("InitNag");
        this.theFrame.setContentPane(contentPanel);
        this.theFrame.setDefaultCloseOperation(2);
        this.theFrame.setResizable(false);
        if (SS.isMacintosh) {
            this.theFrame.setJMenuBar(luxconBridge.makeCommonMenuBar(this.theFrame));
        }
        this.theFrame.pack();
        this.theFrame.show();
        if (sharewareCount < 10) {
            this.theFrame.getRootPane().setDefaultButton(letMePlayButton);
        } else {
            this.theFrame.getRootPane().setDefaultButton(registerOnlineButton);
        }
    }

    private JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setFocusable(false);
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JEditorPane pane = (JEditorPane)e.getSource();
                    try {
                        BrowserLauncher.openURL(e.getURL().toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        editorPane.setPreferredSize(new Dimension(500, 200));
        URL helpURL = InitNagWindow.class.getResource("/" + Translator.getString("nag_init.html"));
        if (helpURL != null) {
            try {
                editorPane.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
        } else {
            System.err.println("Couldn't find file: nag_init.html");
        }
        return editorPane;
    }

    public static void show(int sharewareCount, SSApplicationGUI luxconBridge_set) {
        luxconBridge = luxconBridge_set;
        new InitNagWindow(sharewareCount);
    }

    public static void hide() {
        if (instance != null) {
            InitNagWindow.instance.theFrame.hide();
        }
    }
}

